/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;

public class SourceFileRewriter {
    private final AppView<?> appView;

    public SourceFileRewriter(AppView<?> appView) {
        this.appView = appView;
    }

    public void run() {
        ProguardConfiguration proguardConfiguration = this.appView.options().getProguardConfiguration();
        String renameSourceFile = proguardConfiguration.getRenameSourceFileAttribute();
        if (renameSourceFile == null && proguardConfiguration.getKeepAttributes().sourceFile) {
            return;
        }
        DexString dexRenameSourceFile = renameSourceFile == null ? this.appView.dexItemFactory().createString("") : this.appView.dexItemFactory().createString(renameSourceFile);
        for (DexClass dexClass : ((AppInfo)this.appView.appInfo()).classes()) {
            dexClass.sourceFile = dexRenameSourceFile;
            dexClass.forEachMethod(encodedMethod -> {
                if (encodedMethod.shouldNotHaveCode()) {
                    return;
                }
                Code code = encodedMethod.getCode();
                if (code == null) {
                    return;
                }
                if (code.isDexCode()) {
                    DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
                    if (dexDebugInfo == null) {
                        return;
                    }
                    dexDebugInfo.events = (DexDebugEvent[])Arrays.stream(dexDebugInfo.events).filter(dexDebugEvent -> !(dexDebugEvent instanceof DexDebugEvent.SetFile)).toArray(DexDebugEvent[]::new);
                } else assert (code.isCfCode());
            });
        }
    }
}

