/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataRewriter;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.FieldNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierMinifier;
import shadow.bundletool.com.android.tools.r8.naming.InternalNamingState;
import shadow.bundletool.com.android.tools.r8.naming.MemberNamingStrategy;
import shadow.bundletool.com.android.tools.r8.naming.MethodNameMinifier;
import shadow.bundletool.com.android.tools.r8.naming.MinifiedRenaming;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;
import shadow.bundletool.com.android.tools.r8.utils.SymbolGenerationUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class Minifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final Set<DexCallSite> desugaredCallSites;

    public Minifier(AppView<AppInfoWithLiveness> appView, Set<DexCallSite> desugaredCallSites) {
        this.appView = appView;
        this.desugaredCallSites = desugaredCallSites;
    }

    public NamingLens run(ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (this.appView.options().isMinifying());
        timing.begin("ComputeInterfaces");
        TreeSet<DexClass> interfaces = new TreeSet<DexClass>((a, b) -> a.type.slowCompareTo(b.type));
        interfaces.addAll(this.appView.appInfo().computeReachableInterfaces(this.desugaredCallSites));
        timing.end();
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new MinificationClassNamingStrategy(this.appView), new MinificationPackageNamingStrategy(this.appView), this.appView.appInfo().classesWithDeterministicOrder());
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, MethodNameMinifier.MethodRenaming.empty(), FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        MinifierMemberNamingStrategy minifyMembers = new MinifierMemberNamingStrategy(this.appView);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, minifyMembers).computeRenaming(interfaces, this.desugaredCallSites, timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, methodRenaming, FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, minifyMembers).computeRenaming(interfaces, timing);
        timing.end();
        MinifiedRenaming lens = new MinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming);
        assert (lens.verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run(executorService);
        timing.end();
        timing.begin("MinifyKotlinMetadata");
        new KotlinMetadataRewriter(this.appView, lens).run(executorService);
        timing.end();
        return lens;
    }

    static class MinifierMemberNamingStrategy
    extends BaseMinificationNamingStrategy
    implements MemberNamingStrategy {
        final AppView<?> appView;
        private final DexItemFactory factory;

        public MinifierMemberNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getObfuscationDictionary(), false);
            this.appView = appView;
            this.factory = appView.dexItemFactory();
        }

        @Override
        public DexString next(DexMethod method, InternalNamingState internalState, BiPredicate<DexString, DexMethod> isAvailable) {
            DexString candidate;
            boolean isDirectOrStatic;
            assert (this.checkAllowMemberRenaming(method.holder));
            DexEncodedMethod encodedMethod = this.appView.definitionFor(method);
            boolean bl = isDirectOrStatic = encodedMethod.isDirectMethod() || encodedMethod.isStatic();
            while (!isAvailable.test(candidate = this.getNextName(internalState, isDirectOrStatic), method)) {
            }
            return candidate;
        }

        @Override
        public DexString next(DexField field, InternalNamingState internalState, BiPredicate<DexString, DexField> isAvailable) {
            DexString candidate;
            assert (this.checkAllowMemberRenaming(field.holder));
            while (!isAvailable.test(candidate = this.getNextName(internalState, false), field)) {
            }
            return candidate;
        }

        private DexString getNextName(InternalNamingState internalState, boolean isDirectOrStatic) {
            return this.factory.createString(this.nextName(StringUtils.EMPTY_CHAR_ARRAY, internalState, isDirectOrStatic));
        }

        @Override
        public DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            if (!this.allowMemberRenaming(holder) || holder.accessFlags.isAnnotation() || method.accessFlags.isConstructor() || this.appView.rootSet().mayNotBeMinified(method.method, this.appView)) {
                return method.method.name;
            }
            return null;
        }

        @Override
        public DexString getReservedName(DexEncodedField field, DexClass holder) {
            if (holder.isLibraryClass() || this.appView.rootSet().mayNotBeMinified(field.field, this.appView)) {
                return field.field.name;
            }
            return null;
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return holder.isProgramClass();
        }

        public boolean checkAllowMemberRenaming(DexType holder) {
            DexClass clazz = this.appView.definitionFor(holder);
            assert (clazz != null && this.allowMemberRenaming(clazz));
            return true;
        }
    }

    static class MinificationPackageNamingStrategy
    extends BaseMinificationNamingStrategy
    implements ClassNameMinifier.PackageNamingStrategy {
        MinificationPackageNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getPackageObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
        }

        @Override
        public String next(char[] packagePrefix, InternalNamingState state, Predicate<String> isUsed) {
            String nextPackageName;
            while (isUsed.test(nextPackageName = this.nextName(packagePrefix, state, false).substring(1))) {
            }
            return nextPackageName;
        }
    }

    static class MinificationClassNamingStrategy
    extends BaseMinificationNamingStrategy
    implements ClassNameMinifier.ClassNamingStrategy {
        final AppView<?> appView;
        final DexItemFactory factory;

        MinificationClassNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getClassObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
            this.appView = appView;
            this.factory = appView.dexItemFactory();
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state, Predicate<DexString> isUsed) {
            DexString candidate = null;
            String lastName = null;
            do {
                String newName;
                if ((newName = this.nextName(packagePrefix, state, false) + ";").equals(lastName)) {
                    throw new CompilationError("Generating same name '" + newName + "' when given a new minified name to '" + type.toString() + "'.");
                }
                lastName = newName;
                if (newName.endsWith("LR;") || newName.endsWith("/R;")) continue;
                candidate = this.factory.createString(newName);
            } while (candidate == null || isUsed.test(candidate));
            return candidate;
        }

        @Override
        public DexString reservedDescriptor(DexType type) {
            if (this.appView.rootSet().mayNotBeMinified(type, this.appView)) {
                return type.descriptor;
            }
            return null;
        }

        @Override
        public boolean isRenamedByApplyMapping(DexType type) {
            return false;
        }
    }

    static abstract class BaseMinificationNamingStrategy {
        private final List<String> obfuscationDictionary;
        private final Set<String> obfuscationDictionaryForLookup;
        private final SymbolGenerationUtils.MixedCasing mixedCasing;

        BaseMinificationNamingStrategy(List<String> obfuscationDictionary, boolean dontUseMixedCasing) {
            this.obfuscationDictionary = obfuscationDictionary;
            this.obfuscationDictionaryForLookup = new HashSet<String>(this.obfuscationDictionary);
            SymbolGenerationUtils.MixedCasing mixedCasing = this.mixedCasing = dontUseMixedCasing ? SymbolGenerationUtils.MixedCasing.DONT_USE_MIXED_CASE : SymbolGenerationUtils.MixedCasing.USE_MIXED_CASE;
            assert (obfuscationDictionary != null);
        }

        String nextName(char[] packagePrefix, InternalNamingState state, boolean isDirectMethodCall) {
            String nextString;
            StringBuilder nextName = new StringBuilder();
            nextName.append(packagePrefix);
            do {
                if (state.getDictionaryIndex() < this.obfuscationDictionary.size()) {
                    nextString = this.obfuscationDictionary.get(state.incrementDictionaryIndex());
                    continue;
                }
                while (this.obfuscationDictionaryForLookup.contains(nextString = SymbolGenerationUtils.numberToIdentifier(state.incrementNameIndex(isDirectMethodCall), this.mixedCasing))) {
                }
            } while (SymbolGenerationUtils.PRIMITIVE_TYPE_NAMES.contains(nextString));
            nextName.append(nextString);
            return nextName.toString();
        }
    }
}

