/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.logging;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;

public class Log {
    public static final boolean ENABLED = System.getProperty("shadow.bundletool.com.android.tools.r8.logging.Log.ENABLED") != null;
    private static final boolean VERBOSE_ENABLED = false;
    private static final boolean INFO_ENABLED = true;
    private static final boolean DEBUG_ENABLED = true;
    private static final boolean WARN_ENABLED = true;
    public static final Set<Class<?>> CLASS_FILTER = Log.getClassFilter();

    public static void verbose(Class<?> from, String message, Object ... arguments) {
        if (Log.isLoggingEnabledFor(from)) {
            // empty if block
        }
    }

    public static void info(Class<?> from, String message, Object ... arguments) {
        if (Log.isLoggingEnabledFor(from)) {
            Log.log("INFO", from, message, arguments);
        }
    }

    public static void debug(Class<?> from, String message, Object ... arguments) {
        if (Log.isLoggingEnabledFor(from)) {
            Log.log("DBG", from, message, arguments);
        }
    }

    public static void warn(Class<?> from, String message, Object ... arguments) {
        if (Log.isLoggingEnabledFor(from)) {
            Log.log("WARN", from, message, arguments);
        }
    }

    public static boolean isLoggingEnabledFor(Class<?> clazz) {
        return ENABLED && (CLASS_FILTER == null || CLASS_FILTER.contains(clazz));
    }

    private static synchronized void log(String kind, Class<?> from, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        System.out.println("[" + kind + "] {" + from.getSimpleName() + "}: " + message);
    }

    private static Set<Class<?>> getClassFilter() {
        String property = System.getProperty("shadow.bundletool.com.android.tools.r8.logging.Log.CLASS_FILTER");
        if (property != null) {
            try {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (String className : property.split(";")) {
                    builder.add(Class.forName(className));
                }
                return builder.build();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

