/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes;

import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Load;
import shadow.bundletool.com.android.tools.r8.ir.code.Store;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Match;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import shadow.bundletool.com.android.tools.r8.ir.optimize.peepholes.Point;

public class StoreLoadPeephole
implements BasicBlockPeephole {
    private final Point storeExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isStore));
    private final Point loadExp = new Point(Instruction::isLoad);
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.loadExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Store store = this.storeExp.get(match).asStore();
        Load load = this.loadExp.get(match).asLoad();
        if (load.src() != store.outValue() || store.outValue().numberOfAllUsers() != 1) {
            return false;
        }
        load.outValue().replaceUsers(store.src());
        store.src().removeUser(store);
        load.src().removeUser(load);
        it.removeOrReplaceByDebugLocalRead();
        it.next();
        it.removeOrReplaceByDebugLocalRead();
        PeepholeHelper.resetNext(it, 1);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

