/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.code.Format22c;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.code.InvokeDirectRange;
import shadow.bundletool.com.android.tools.r8.code.Iput;
import shadow.bundletool.com.android.tools.r8.code.IputBoolean;
import shadow.bundletool.com.android.tools.r8.code.IputByte;
import shadow.bundletool.com.android.tools.r8.code.IputChar;
import shadow.bundletool.com.android.tools.r8.code.IputObject;
import shadow.bundletool.com.android.tools.r8.code.IputShort;
import shadow.bundletool.com.android.tools.r8.code.IputWide;
import shadow.bundletool.com.android.tools.r8.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.code.ReturnVoid;
import shadow.bundletool.com.android.tools.r8.code.SputObject;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroup;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;

abstract class KotlinLambdaClassValidator
implements ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> {
    static final String LAMBDA_INIT_CODE_VERIFICATION_FAILED = "instance initializer code verification failed";
    private static final String LAMBDA_CLINIT_CODE_VERIFICATION_FAILED = "static initializer code verification failed";
    final Kotlin kotlin;
    private final KotlinLambdaGroup group;
    private final AppInfoWithSubtyping appInfo;

    KotlinLambdaClassValidator(Kotlin kotlin, KotlinLambdaGroup group, AppInfoWithSubtyping appInfo) {
        this.kotlin = kotlin;
        this.group = group;
        this.appInfo = appInfo;
    }

    final LambdaGroup.LambdaStructureError structureError(String s) {
        return new LambdaGroup.LambdaStructureError(s, false);
    }

    @Override
    public void accept(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        if (!CaptureSignature.getCaptureSignature(lambda2.instanceFields()).equals(this.group.id().capture)) {
            throw this.structureError("capture signature was modified");
        }
        DexEncodedMethod classInitializer = null;
        DexEncodedMethod instanceInitializer = null;
        for (DexEncodedMethod method : lambda2.directMethods()) {
            Code code;
            if (method.isClassInitializer()) {
                code = method.getCode();
                if (!this.group.isStateless() || !this.group.isSingletonLambda(lambda2.type)) {
                    throw this.structureError("static initializer on non-singleton lambda");
                }
                if (classInitializer != null || code == null || !code.isDexCode()) {
                    throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
                }
                this.validateStatelessLambdaClassInitializer(lambda2, code.asDexCode());
                classInitializer = method;
                continue;
            }
            if (!method.isInstanceInitializer()) continue;
            code = method.getCode();
            if (instanceInitializer != null || code == null || !code.isDexCode()) {
                throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
            }
            this.validateInstanceInitializer(lambda2, code.asDexCode());
            instanceInitializer = method;
        }
        if (this.group.isStateless() && this.group.isSingletonLambda(lambda2.type) && classInitializer == null) {
            throw this.structureError("missing static initializer on singleton lambda");
        }
        DexType fakeLambdaGroupType = this.kotlin.factory.createType("L" + this.group.getTypePackage() + "-$$LambdaGroup$XXXX;");
        NopWhyAreYouNotInliningReporter whyAreYouNotInliningReporter = NopWhyAreYouNotInliningReporter.getInstance();
        for (DexEncodedMethod method : lambda2.virtualMethods()) {
            if (method.isInliningCandidate(fakeLambdaGroupType, Inliner.Reason.SIMPLE, this.appInfo, (WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter)) continue;
            throw this.structureError("method " + method.method.toSourceString() + " is not inline-able into lambda group class");
        }
    }

    abstract int getInstanceInitializerSize(List<DexEncodedField> var1);

    abstract int validateInstanceInitializerEpilogue(Instruction[] var1, int var2) throws LambdaGroup.LambdaStructureError;

    private void validateInstanceInitializer(DexClass lambda2, Code code) throws LambdaGroup.LambdaStructureError {
        List<DexEncodedField> captures = lambda2.instanceFields();
        Instruction[] instructions = code.asDexCode().instructions;
        int index = 0;
        if (instructions.length != this.getInstanceInitializerSize(captures)) {
            throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
        }
        index = this.validateInstanceInitializerParameterMapping(captures, instructions, index);
        index = this.validateInstanceInitializerEpilogue(instructions, index);
        assert (index == instructions.length);
    }

    private int validateInstanceInitializerParameterMapping(List<DexEncodedField> captures, Instruction[] instructions, int index) throws LambdaGroup.LambdaStructureError {
        int wideFieldsSeen = 0;
        for (DexEncodedField field : captures) {
            switch (field.field.type.toShorty()) {
                case 'Z': {
                    if (instructions[index] instanceof IputBoolean && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                case 'B': {
                    if (instructions[index] instanceof IputByte && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                case 'S': {
                    if (instructions[index] instanceof IputShort && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                case 'C': {
                    if (instructions[index] instanceof IputChar && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                case 'F': 
                case 'I': {
                    if (instructions[index] instanceof Iput && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                case 'D': 
                case 'J': {
                    if (!(instructions[index] instanceof IputWide) || instructions[index].getField() != field.field || ((Format22c)instructions[index]).A != index + 1 + wideFieldsSeen) {
                        throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                    }
                    ++wideFieldsSeen;
                    break;
                }
                case 'L': {
                    if (instructions[index] instanceof IputObject && instructions[index].getField() == field.field && ((Format22c)instructions[index]).A == index + 1 + wideFieldsSeen) break;
                    throw this.structureError(LAMBDA_INIT_CODE_VERIFICATION_FAILED);
                }
                default: {
                    throw new Unreachable();
                }
            }
            ++index;
        }
        return index;
    }

    private void validateStatelessLambdaClassInitializer(DexClass lambda2, Code code) throws LambdaGroup.LambdaStructureError {
        assert (this.group.isStateless() && this.group.isSingletonLambda(lambda2.type));
        Instruction[] instructions = code.asDexCode().instructions;
        if (instructions.length != 4) {
            throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
        }
        if (!(instructions[0] instanceof NewInstance) || ((NewInstance)instructions[0]).getType() != lambda2.type) {
            throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
        }
        if (!(instructions[1] instanceof InvokeDirect) && !(instructions[1] instanceof InvokeDirectRange) || !this.isLambdaInitializerMethod(lambda2, instructions[1].getMethod())) {
            throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
        }
        if (!(instructions[2] instanceof SputObject) || !this.isLambdaSingletonField(lambda2, instructions[2].getField())) {
            throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
        }
        if (!(instructions[3] instanceof ReturnVoid)) {
            throw this.structureError(LAMBDA_CLINIT_CODE_VERIFICATION_FAILED);
        }
    }

    private boolean isLambdaSingletonField(DexClass lambda2, DexField field) {
        return field.type == lambda2.type && field.holder == lambda2.type && field.name == this.kotlin.functional.kotlinStyleLambdaInstanceName;
    }

    private boolean isLambdaInitializerMethod(DexClass holder, DexMethod method) {
        return method.holder == holder.type && method.name == this.kotlin.factory.constructorMethodName && method.proto.parameters.isEmpty() && method.proto.returnType == this.kotlin.factory.voidType;
    }
}

