/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer;

import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.DefaultInstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;

public final class NonTrivialInstanceInitializerInfo
extends InstanceInitializerInfo {
    private static final int INSTANCE_FIELD_INITIALIZATION_INDEPENDENT_OF_ENVIRONMENT = 1;
    private static final int NO_OTHER_SIDE_EFFECTS_THAN_INSTANCE_FIELD_ASSIGNMENTS = 2;
    private static final int RECEIVER_NEVER_ESCAPE_OUTSIDE_CONSTRUCTOR_CHAIN = 4;
    private final int data;
    private final AbstractFieldSet readSet;
    private final DexMethod parent;

    private NonTrivialInstanceInitializerInfo(int data2, AbstractFieldSet readSet, DexMethod parent) {
        assert (NonTrivialInstanceInitializerInfo.verifyNoUnknownBits(data2));
        this.data = data2;
        this.readSet = readSet;
        this.parent = parent;
    }

    private static boolean verifyNoUnknownBits(int data2) {
        int knownBits = 7;
        assert ((data2 & ~knownBits) == 0);
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DexMethod getParent() {
        return this.parent;
    }

    @Override
    public AbstractFieldSet readSet() {
        return this.readSet;
    }

    @Override
    public boolean instanceFieldInitializationMayDependOnEnvironment() {
        return (this.data & 1) == 0;
    }

    @Override
    public boolean mayHaveOtherSideEffectsThanInstanceFieldAssignments() {
        return (this.data & 2) == 0;
    }

    @Override
    public boolean receiverNeverEscapesOutsideConstructorChain() {
        return (this.data & 4) != 0;
    }

    public static class Builder {
        private int data = 7;
        private AbstractFieldSet readSet = EmptyFieldSet.getInstance();
        private DexMethod parent;

        private boolean isTrivial() {
            return this.data == 0 && this.readSet.isTop() && this.parent == null;
        }

        public Builder markFieldAsRead(DexEncodedField field) {
            if (this.readSet.isKnownFieldSet()) {
                if (this.readSet.isBottom()) {
                    this.readSet = new ConcreteMutableFieldSet(field);
                } else {
                    this.readSet.asConcreteFieldSet().add(field);
                }
            }
            assert (this.readSet.contains(field));
            return this;
        }

        public Builder markFieldsAsRead(AbstractFieldSet otherReadSet) {
            if (this.readSet.isTop() || otherReadSet.isBottom()) {
                return this;
            }
            if (otherReadSet.isTop()) {
                return this.markAllFieldsAsRead();
            }
            ConcreteMutableFieldSet otherConcreteReadSet = otherReadSet.asConcreteFieldSet();
            if (this.readSet.isBottom()) {
                this.readSet = new ConcreteMutableFieldSet().addAll(otherConcreteReadSet);
            } else {
                this.readSet.asConcreteFieldSet().addAll(otherConcreteReadSet);
            }
            return this;
        }

        public Builder markAllFieldsAsRead() {
            this.readSet = UnknownFieldSet.getInstance();
            return this;
        }

        public Builder merge(InstanceInitializerInfo instanceInitializerInfo) {
            this.markFieldsAsRead(instanceInitializerInfo.readSet());
            if (instanceInitializerInfo.instanceFieldInitializationMayDependOnEnvironment()) {
                this.setInstanceFieldInitializationMayDependOnEnvironment();
            }
            if (instanceInitializerInfo.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
                this.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
            }
            if (instanceInitializerInfo.receiverMayEscapeOutsideConstructorChain()) {
                this.setReceiverMayEscapeOutsideConstructorChain();
            }
            return this;
        }

        public Builder setInstanceFieldInitializationMayDependOnEnvironment() {
            this.data &= 0xFFFFFFFE;
            return this;
        }

        public boolean mayHaveOtherSideEffectsThanInstanceFieldAssignments() {
            return (this.data & 0xFFFFFFFD) == 0;
        }

        public Builder setMayHaveOtherSideEffectsThanInstanceFieldAssignments() {
            this.data &= 0xFFFFFFFD;
            return this;
        }

        public Builder setReceiverMayEscapeOutsideConstructorChain() {
            this.data &= 0xFFFFFFFB;
            return this;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public Builder setParent(DexMethod parent) {
            assert (!this.hasParent());
            this.parent = parent;
            return this;
        }

        public InstanceInitializerInfo build() {
            return this.isTrivial() ? DefaultInstanceInitializerInfo.getInstance() : new NonTrivialInstanceInitializerInfo(this.data, this.readSet, this.parent);
        }
    }
}

