/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerEligibilityInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ParameterUsagesInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.UpdatableMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.IteratorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class OptimizationFeedbackDelayed
extends OptimizationFeedback {
    private final Map<DexEncodedField, MutableFieldOptimizationInfo> fieldOptimizationInfos = new IdentityHashMap<DexEncodedField, MutableFieldOptimizationInfo>();
    private final Map<DexEncodedMethod, UpdatableMethodOptimizationInfo> methodOptimizationInfos = new IdentityHashMap<DexEncodedMethod, UpdatableMethodOptimizationInfo>();
    private final Map<DexEncodedMethod, Inliner.ConstraintWithTarget> processed = new IdentityHashMap<DexEncodedMethod, Inliner.ConstraintWithTarget>();

    private synchronized MutableFieldOptimizationInfo getFieldOptimizationInfoForUpdating(DexEncodedField field) {
        MutableFieldOptimizationInfo info = this.fieldOptimizationInfos.get(field);
        if (info != null) {
            return info;
        }
        info = field.getOptimizationInfo().mutableCopy();
        this.fieldOptimizationInfos.put(field, info);
        return info;
    }

    private synchronized UpdatableMethodOptimizationInfo getMethodOptimizationInfoForUpdating(DexEncodedMethod method) {
        UpdatableMethodOptimizationInfo info = this.methodOptimizationInfos.get(method);
        if (info != null) {
            return info;
        }
        info = method.getOptimizationInfo().mutableCopy();
        this.methodOptimizationInfos.put(method, info);
        return info;
    }

    @Override
    public void fixupOptimizationInfos(AppView<?> appView, ExecutorService executorService, OptimizationFeedback.OptimizationInfoFixer fixer) throws ExecutionException {
        this.updateVisibleOptimizationInfo();
        super.fixupOptimizationInfos(appView, executorService, fixer);
    }

    public void updateVisibleOptimizationInfo() {
        IteratorUtils.removeIf(this.methodOptimizationInfos.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        IteratorUtils.removeIf(this.processed.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        this.fieldOptimizationInfos.forEach(DexEncodedField::setOptimizationInfo);
        this.fieldOptimizationInfos.clear();
        this.methodOptimizationInfos.forEach(DexEncodedMethod::setOptimizationInfo);
        this.methodOptimizationInfos.clear();
        this.processed.forEach(DexEncodedMethod::markProcessed);
        this.processed.clear();
    }

    public boolean noUpdatesLeft() {
        assert (this.fieldOptimizationInfos.isEmpty()) : StringUtils.join(this.fieldOptimizationInfos.keySet(), ", ");
        assert (this.methodOptimizationInfos.isEmpty()) : StringUtils.join(this.methodOptimizationInfos.keySet(), ", ");
        assert (this.processed.isEmpty()) : StringUtils.join(this.processed.keySet(), ", ");
        return true;
    }

    @Override
    public void markFieldCannotBeKept(DexEncodedField field) {
        this.getFieldOptimizationInfoForUpdating(field).cannotBeKept();
    }

    @Override
    public void markFieldAsPropagated(DexEncodedField field) {
        this.getFieldOptimizationInfoForUpdating(field).markAsPropagated();
    }

    @Override
    public void markFieldHasDynamicLowerBoundType(DexEncodedField field, ClassTypeLatticeElement type) {
        this.getFieldOptimizationInfoForUpdating(field).setDynamicLowerBoundType(type);
    }

    @Override
    public void markFieldHasDynamicUpperBoundType(DexEncodedField field, TypeLatticeElement type) {
        this.getFieldOptimizationInfoForUpdating(field).setDynamicUpperBoundType(type);
    }

    @Override
    public void markFieldBitsRead(DexEncodedField field, int bitsRead) {
        this.getFieldOptimizationInfoForUpdating(field).joinReadBits(bitsRead);
    }

    @Override
    public void recordFieldHasAbstractValue(DexEncodedField field, AppView<AppInfoWithLiveness> appView, AbstractValue abstractValue) {
        if (appView.appInfo().mayPropagateValueFor(field.field)) {
            this.getFieldOptimizationInfoForUpdating(field).setAbstractValue(abstractValue);
        }
    }

    @Override
    public void markForceInline(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markForceInline();
    }

    @Override
    public synchronized void markInlinedIntoSingleCallSite(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markInlinedIntoSingleCallSite();
    }

    @Override
    public void markMethodCannotBeKept(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).cannotBeKept();
    }

    @Override
    public synchronized void methodInitializesClassesOnNormalExit(DexEncodedMethod method, Set<DexType> initializedClasses) {
        this.getMethodOptimizationInfoForUpdating(method).markInitializesClassesOnNormalExit(initializedClasses);
    }

    @Override
    public synchronized void methodReturnsArgument(DexEncodedMethod method, int argument) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnsArgument(argument);
    }

    @Override
    public synchronized void methodReturnsAbstractValue(DexEncodedMethod method, AppView<AppInfoWithLiveness> appView, AbstractValue value) {
        if (appView.appInfo().mayPropagateValueFor(method.method)) {
            this.getMethodOptimizationInfoForUpdating(method).markReturnsAbstractValue(value);
        }
    }

    @Override
    public synchronized void methodReturnsObjectWithUpperBoundType(DexEncodedMethod method, AppView<?> appView, TypeLatticeElement type) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnsObjectWithUpperBoundType(appView, type);
    }

    @Override
    public synchronized void methodReturnsObjectWithLowerBoundType(DexEncodedMethod method, ClassTypeLatticeElement type) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnsObjectWithLowerBoundType(type);
    }

    @Override
    public synchronized void methodNeverReturnsNull(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markNeverReturnsNull();
    }

    @Override
    public synchronized void methodNeverReturnsNormally(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markNeverReturnsNormally();
    }

    @Override
    public synchronized void methodMayNotHaveSideEffects(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markMayNotHaveSideEffects();
    }

    @Override
    public synchronized void methodReturnValueOnlyDependsOnArguments(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnValueOnlyDependsOnArguments();
    }

    @Override
    public synchronized void markAsPropagated(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markAsPropagated();
    }

    @Override
    public synchronized void markProcessed(DexEncodedMethod method, Inliner.ConstraintWithTarget state) {
        this.processed.put(method, state);
    }

    @Override
    public synchronized void markUseIdentifierNameString(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markUseIdentifierNameString();
    }

    @Override
    public synchronized void markCheckNullReceiverBeforeAnySideEffect(DexEncodedMethod method, boolean mark) {
        this.getMethodOptimizationInfoForUpdating(method).markCheckNullReceiverBeforeAnySideEffect(mark);
    }

    @Override
    public synchronized void markTriggerClassInitBeforeAnySideEffect(DexEncodedMethod method, boolean mark) {
        this.getMethodOptimizationInfoForUpdating(method).markTriggerClassInitBeforeAnySideEffect(mark);
    }

    @Override
    public synchronized void setClassInlinerEligibility(DexEncodedMethod method, ClassInlinerEligibilityInfo eligibility) {
        this.getMethodOptimizationInfoForUpdating(method).setClassInlinerEligibility(eligibility);
    }

    @Override
    public synchronized void setInstanceInitializerInfo(DexEncodedMethod method, InstanceInitializerInfo instanceInitializerInfo) {
        this.getMethodOptimizationInfoForUpdating(method).setInstanceInitializerInfo(instanceInitializerInfo);
    }

    @Override
    public synchronized void setInitializerEnablingJavaAssertions(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).setInitializerEnablingJavaAssertions();
    }

    @Override
    public synchronized void setParameterUsages(DexEncodedMethod method, ParameterUsagesInfo parameterUsagesInfo) {
        this.getMethodOptimizationInfoForUpdating(method).setParameterUsages(parameterUsagesInfo);
    }

    @Override
    public synchronized void setNonNullParamOrThrow(DexEncodedMethod method, BitSet facts) {
        this.getMethodOptimizationInfoForUpdating(method).setNonNullParamOrThrow(facts);
    }

    @Override
    public synchronized void setNonNullParamOnNormalExits(DexEncodedMethod method, BitSet facts) {
        this.getMethodOptimizationInfoForUpdating(method).setNonNullParamOnNormalExits(facts);
    }

    @Override
    public synchronized void classInitializerMayBePostponed(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markClassInitializerMayBePostponed();
    }
}

