/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info;

import java.util.List;
import java.util.Objects;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ParameterUsagesInfo;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;

public class ConcreteCallSiteOptimizationInfo
extends CallSiteOptimizationInfo {
    private final int size;
    private final Int2ReferenceMap<TypeLatticeElement> dynamicUpperBoundTypes;
    private final Int2ReferenceMap<AbstractValue> constants;

    private ConcreteCallSiteOptimizationInfo(DexEncodedMethod encodedMethod, boolean allowConstantPropagation) {
        this(encodedMethod.method.getArity() + (encodedMethod.isStatic() ? 0 : 1), allowConstantPropagation);
    }

    private ConcreteCallSiteOptimizationInfo(int size, boolean allowConstantPropagation) {
        assert (size > 0);
        this.size = size;
        this.dynamicUpperBoundTypes = new Int2ReferenceArrayMap<TypeLatticeElement>(size);
        this.constants = allowConstantPropagation ? new Int2ReferenceArrayMap(size) : null;
    }

    CallSiteOptimizationInfo join(ConcreteCallSiteOptimizationInfo other, AppView<?> appView, DexEncodedMethod encodedMethod) {
        assert (this.size == other.size);
        boolean allowConstantPropagation = appView.options().enablePropagationOfConstantsAtCallSites;
        ConcreteCallSiteOptimizationInfo result = new ConcreteCallSiteOptimizationInfo(this.size, allowConstantPropagation);
        assert (result.dynamicUpperBoundTypes != null);
        for (int i = 0; i < result.size; ++i) {
            TypeLatticeElement thisUpperBoundType;
            if (allowConstantPropagation) {
                assert (result.constants != null);
                AbstractValue abstractValue = this.getAbstractArgumentValue(i).join(other.getAbstractArgumentValue(i));
                if (abstractValue.isNonTrivial()) {
                    result.constants.put(i, abstractValue);
                }
            }
            if ((thisUpperBoundType = this.getDynamicUpperBoundType(i)) == null) {
                assert (other.getDynamicUpperBoundType(i) == null);
                continue;
            }
            assert (thisUpperBoundType.isReference());
            TypeLatticeElement otherUpperBoundType = other.getDynamicUpperBoundType(i);
            assert (otherUpperBoundType != null && otherUpperBoundType.isReference());
            result.dynamicUpperBoundTypes.put(i, thisUpperBoundType.join(otherUpperBoundType, appView));
        }
        if (result.hasUsefulOptimizationInfo(appView, encodedMethod)) {
            return result;
        }
        return TOP;
    }

    private TypeLatticeElement[] getStaticTypes(AppView<?> appView, DexEncodedMethod encodedMethod) {
        int argOffset = encodedMethod.isStatic() ? 0 : 1;
        int size = encodedMethod.method.getArity() + argOffset;
        TypeLatticeElement[] staticTypes = new TypeLatticeElement[size];
        if (!encodedMethod.isStatic()) {
            staticTypes[0] = TypeLatticeElement.fromDexType(encodedMethod.method.holder, Nullability.definitelyNotNull(), appView);
        }
        for (int i = 0; i < encodedMethod.method.getArity(); ++i) {
            staticTypes[i + argOffset] = TypeLatticeElement.fromDexType(encodedMethod.method.proto.parameters.values[i], Nullability.maybeNull(), appView);
        }
        return staticTypes;
    }

    @Override
    public boolean hasUsefulOptimizationInfo(AppView<?> appView, DexEncodedMethod encodedMethod) {
        TypeLatticeElement[] staticTypes = this.getStaticTypes(appView, encodedMethod);
        for (int i = 0; i < this.size; ++i) {
            TypeLatticeElement dynamicUpperBoundType;
            ParameterUsagesInfo.ParameterUsage parameterUsage = encodedMethod.getOptimizationInfo().getParameterUsages(i);
            if (parameterUsage != null && parameterUsage.notUsed()) continue;
            AbstractValue abstractValue = this.getAbstractArgumentValue(i);
            if (abstractValue.isNonTrivial()) {
                assert (appView.options().enablePropagationOfConstantsAtCallSites);
                return true;
            }
            if (!staticTypes[i].isReference() || (dynamicUpperBoundType = this.getDynamicUpperBoundType(i)) == null) continue;
            assert (appView.options().enablePropagationOfDynamicTypesAtCallSites);
            Nullability nullability = dynamicUpperBoundType.nullability();
            if (nullability.isDefinitelyNull()) {
                return true;
            }
            if (!dynamicUpperBoundType.strictlyLessThan(staticTypes[i], appView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeLatticeElement getDynamicUpperBoundType(int argIndex) {
        assert (0 <= argIndex && argIndex < this.size);
        assert (this.dynamicUpperBoundTypes != null);
        return this.dynamicUpperBoundTypes.getOrDefault(argIndex, null);
    }

    @Override
    public AbstractValue getAbstractArgumentValue(int argIndex) {
        assert (0 <= argIndex && argIndex < this.size);
        if (this.constants == null) {
            return UnknownValue.getInstance();
        }
        return this.constants.getOrDefault(argIndex, UnknownValue.getInstance());
    }

    public static CallSiteOptimizationInfo fromArguments(AppView<? extends AppInfoWithSubtyping> appView, DexEncodedMethod method, List<Value> inValues) {
        boolean allowConstantPropagation = appView.options().enablePropagationOfConstantsAtCallSites;
        ConcreteCallSiteOptimizationInfo newCallSiteInfo = new ConcreteCallSiteOptimizationInfo(method, allowConstantPropagation);
        assert (newCallSiteInfo.size == inValues.size());
        assert (newCallSiteInfo.dynamicUpperBoundTypes != null);
        for (int i = 0; i < newCallSiteInfo.size; ++i) {
            Value arg = inValues.get(i);
            if (allowConstantPropagation) {
                AbstractValue abstractValue;
                assert (newCallSiteInfo.constants != null);
                Value aliasedValue = arg.getAliasedValue();
                if (!aliasedValue.isPhi() && (abstractValue = aliasedValue.definition.getAbstractValue(appView, method.method.holder)).isNonTrivial()) {
                    newCallSiteInfo.constants.put(i, abstractValue);
                }
            }
            if (arg.getTypeLattice().isPrimitive()) continue;
            assert (arg.getTypeLattice().isReference());
            newCallSiteInfo.dynamicUpperBoundTypes.put(i, arg.getDynamicUpperBoundType(appView));
        }
        if (newCallSiteInfo.hasUsefulOptimizationInfo(appView, method)) {
            return newCallSiteInfo;
        }
        return TOP;
    }

    @Override
    public boolean isConcreteCallSiteOptimizationInfo() {
        return true;
    }

    @Override
    public ConcreteCallSiteOptimizationInfo asConcreteCallSiteOptimizationInfo() {
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConcreteCallSiteOptimizationInfo)) {
            return false;
        }
        ConcreteCallSiteOptimizationInfo otherInfo = (ConcreteCallSiteOptimizationInfo)other;
        return Objects.equals(this.dynamicUpperBoundTypes, otherInfo.dynamicUpperBoundTypes) && Objects.equals(this.constants, otherInfo.constants);
    }

    public int hashCode() {
        assert (this.dynamicUpperBoundTypes != null);
        return System.identityHashCode(this.dynamicUpperBoundTypes) * 7 + System.identityHashCode(this.constants);
    }

    public String toString() {
        return this.dynamicUpperBoundTypes.toString() + (this.constants == null ? "" : System.lineSeparator() + this.constants.toString());
    }
}

