/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.BooleanLatticeElement;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;

public class ClassInlinerReceiverAnalysis {
    private final AppView<?> appView;
    private final DexEncodedMethod method;
    private final IRCode code;
    private final Value receiver;
    private final Map<Value, OptionalBool> isReceiverAliasCache = new IdentityHashMap<Value, OptionalBool>();

    public ClassInlinerReceiverAnalysis(AppView<?> appView, DexEncodedMethod method, IRCode code) {
        this.appView = appView;
        this.method = method;
        this.code = code;
        this.receiver = code.getThis();
        assert (!this.receiver.hasAliasedValue());
        assert (this.receiver.getTypeLattice().isClassType());
    }

    public OptionalBool computeReturnsReceiver() {
        if (this.method.method.proto.returnType.isVoidType()) {
            return OptionalBool.FALSE;
        }
        List<BasicBlock> normalExitBlocks = this.code.computeNormalExitBlocks();
        if (normalExitBlocks.isEmpty()) {
            return OptionalBool.FALSE;
        }
        BooleanLatticeElement result = OptionalBool.BOTTOM;
        for (BasicBlock block : normalExitBlocks) {
            Value returnValue = block.exit().asReturn().returnValue();
            if (!(result = result.join(this.getOrComputeIsReceiverAlias(returnValue))).isUnknown()) continue;
            return OptionalBool.UNKNOWN;
        }
        assert (!result.isBottom());
        return result.asOptionalBool();
    }

    private OptionalBool getOrComputeIsReceiverAlias(Value value) {
        Value root = value.getAliasedValue();
        return this.isReceiverAliasCache.computeIfAbsent(root, this::computeIsReceiverAlias);
    }

    private OptionalBool computeIsReceiverAlias(Value value) {
        assert (!value.hasAliasedValue());
        if (value == this.receiver) {
            return OptionalBool.TRUE;
        }
        ClassTypeLatticeElement valueType = value.getTypeLattice().asClassTypeLatticeElement();
        if (valueType == null) {
            return OptionalBool.FALSE;
        }
        ClassTypeLatticeElement receiverType = this.receiver.getTypeLattice().asClassTypeLatticeElement();
        if (!valueType.isRelatedTo(receiverType, this.appView)) {
            return OptionalBool.FALSE;
        }
        if (value.isPhi()) {
            return OptionalBool.UNKNOWN;
        }
        Instruction definition = value.definition;
        if (definition.isArrayGet() || definition.isFieldGet()) {
            return OptionalBool.FALSE;
        }
        if (definition.isConstInstruction() || definition.isCreatingInstanceOrArray()) {
            return OptionalBool.FALSE;
        }
        if (definition.isInvokeMethod()) {
            InvokeMethod invoke = definition.asInvokeMethod();
            for (Value argument : invoke.arguments()) {
                if (!this.getOrComputeIsReceiverAlias(argument).isPossiblyTrue()) continue;
                return OptionalBool.UNKNOWN;
            }
            return OptionalBool.FALSE;
        }
        return OptionalBool.UNKNOWN;
    }
}

