/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

class ClassInlinerCostAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final InliningIRProvider inliningIRProvider;
    private final Set<Value> definiteReceiverAliases;
    private int estimatedCost = 0;

    ClassInlinerCostAnalysis(AppView<AppInfoWithLiveness> appView, InliningIRProvider inliningIRProvider, Set<Value> definiteReceiverAliases) {
        this.appView = appView;
        this.inliningIRProvider = inliningIRProvider;
        this.definiteReceiverAliases = definiteReceiverAliases;
    }

    boolean willExceedInstructionBudget(IRCode code, DexProgramClass eligibleClass, Map<InvokeMethod, DexEncodedMethod> directInlinees, List<DexEncodedMethod> indirectInlinees) {
        if (this.appView.appInfo().alwaysClassInline.contains(eligibleClass.type)) {
            return false;
        }
        for (DexEncodedMethod inlinee : indirectInlinees) {
            int increment = inlinee.getCode().estimatedSizeForInlining();
            if (!this.exceedsInstructionBudgetAfterIncrement(increment)) continue;
            return true;
        }
        int numberOfSeenDirectInlinees = 0;
        int numberOfDirectInlinees = directInlinees.size();
        for (InvokeMethod invoke : code.instructions(Instruction::isInvokeMethod)) {
            DexEncodedMethod inlinee = directInlinees.get(invoke);
            if (inlinee == null) continue;
            IRCode inliningIR = this.inliningIRProvider.getAndCacheInliningIR(invoke, inlinee);
            int increment = inlinee.getCode().estimatedSizeForInlining() - this.estimateNumberOfNonMaterializingInstructions(invoke, inliningIR);
            assert (increment >= 0);
            if (this.exceedsInstructionBudgetAfterIncrement(increment)) {
                return true;
            }
            if (++numberOfSeenDirectInlinees != numberOfDirectInlinees) continue;
            break;
        }
        assert (numberOfSeenDirectInlinees == numberOfDirectInlinees);
        return false;
    }

    private boolean exceedsInstructionBudgetAfterIncrement(int increment) {
        this.estimatedCost += increment;
        return this.estimatedCost > this.appView.options().classInliningInstructionAllowance;
    }

    private int estimateNumberOfNonMaterializingInstructions(InvokeMethod invoke, IRCode inlinee) {
        int result = 0;
        Set<Value> receiverAliasesInInlinee = null;
        for (Instruction instruction : inlinee.instructions()) {
            switch (instruction.opcode()) {
                case 5: {
                    break;
                }
                case 27: 
                case 29: {
                    Value object = instruction.isInstanceGet() ? instruction.asInstanceGet().object() : instruction.asInstancePut().object();
                    Value root = object.getAliasedValue();
                    if (receiverAliasesInInlinee == null) {
                        receiverAliasesInInlinee = this.getReceiverAliasesInInlinee(invoke, inlinee);
                    }
                    if (!receiverAliasesInInlinee.contains(root)) break;
                    ++result;
                    break;
                }
                case 54: {
                    ++result;
                    break;
                }
            }
        }
        return result;
    }

    private Set<Value> getReceiverAliasesInInlinee(InvokeMethod invoke, IRCode inlinee) {
        List<Value> arguments = inlinee.collectArguments();
        Set<Value> receiverAliasesInInlinee = Sets.newIdentityHashSet();
        for (int i = 0; i < invoke.inValues().size(); ++i) {
            Value inValue = invoke.inValues().get(i);
            if (this.definiteReceiverAliases.contains(inValue)) {
                receiverAliasesInInlinee.add(arguments.get(i));
                continue;
            }
            assert (!this.definiteReceiverAliases.contains(inValue.getAliasedValue()));
        }
        return receiverAliasesInInlinee;
    }
}

