/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.desugar.ServiceLoaderSourceCode;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class ServiceLoaderRewriter {
    public static final String SERVICE_LOADER_CLASS_NAME = "$$ServiceLoaderMethods";
    private static final String SERVICE_LOADER_METHOD_PREFIX_NAME = "$load";
    private DexProgramClass synthesizedClass;
    private ConcurrentHashMap<DexType, DexEncodedMethod> synthesizedServiceLoaders = new ConcurrentHashMap();
    private final AppView<? extends AppInfoWithLiveness> appView;

    public ServiceLoaderRewriter(AppView<? extends AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public DexProgramClass getSynthesizedClass() {
        return this.synthesizedClass;
    }

    public void rewrite(IRCode code) {
        DexItemFactory factory = this.appView.dexItemFactory();
        InstructionListIterator instructionIterator = code.instructionListIterator();
        while (instructionIterator.hasNext()) {
            boolean isGetClassLoaderOnConstClassOrNull;
            Value argument;
            InvokeStatic serviceLoaderLoad;
            Value serviceLoaderLoadOut;
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!instruction.isInvokeStatic() || instruction.asInvokeStatic().getInvokedMethod() != factory.serviceLoaderMethods.loadWithClassLoader || (serviceLoaderLoadOut = (serviceLoaderLoad = instruction.asInvokeStatic()).outValue()).numberOfAllUsers() != 1 || serviceLoaderLoadOut.hasPhiUsers() || !serviceLoaderLoadOut.singleUniqueUser().isInvokeVirtual() || serviceLoaderLoadOut.singleUniqueUser().asInvokeVirtual().getInvokedMethod() != factory.serviceLoaderMethods.iterator || (argument = serviceLoaderLoad.inValues().get(0).getAliasedValue()).isPhi() || !argument.definition.isConstClass()) continue;
            ConstClass constClass = argument.getConstInstruction().asConstClass();
            if (this.appView.appInfo().isPinned(constClass.getValue()) || !this.appView.appServices().allServiceTypes().contains(constClass.getValue())) continue;
            InvokeVirtual classLoaderInvoke = serviceLoaderLoad.inValues().get((int)1).definition.asInvokeVirtual();
            boolean bl = isGetClassLoaderOnConstClassOrNull = serviceLoaderLoad.inValues().get(1).getTypeLattice().isNullType() || classLoaderInvoke != null && classLoaderInvoke.inValues().size() == 1 && classLoaderInvoke.getReceiver().getAliasedValue().isConstClass() && classLoaderInvoke.getReceiver().getAliasedValue().getConstInstruction().asConstClass().getValue() == constClass.getValue();
            if (!isGetClassLoaderOnConstClassOrNull) continue;
            List<DexType> dexTypes = this.appView.appServices().serviceImplementationsFor(constClass.getValue());
            ArrayList<DexClass> classes = new ArrayList<DexClass>(dexTypes.size());
            boolean seenNull = false;
            for (DexType serviceImpl : dexTypes) {
                DexClass serviceImplClazz = this.appView.definitionFor(serviceImpl);
                if (serviceImplClazz == null) {
                    seenNull = true;
                }
                classes.add(serviceImplClazz);
            }
            if (seenNull) continue;
            DexEncodedMethod synthesizedMethod = this.synthesizedServiceLoaders.computeIfAbsent(constClass.getValue(), service -> {
                DexEncodedMethod addedMethod = this.createSynthesizedMethod((DexType)service, (List<DexClass>)classes);
                if (this.appView.options().isGeneratingClassFiles()) {
                    addedMethod.upgradeClassFileVersion(code.method.getClassFileVersion());
                }
                return addedMethod;
            });
            new Rewriter(code, instructionIterator, serviceLoaderLoad).perform(classLoaderInvoke, synthesizedMethod.method);
        }
    }

    private DexEncodedMethod createSynthesizedMethod(DexType serviceType, List<DexClass> classes) {
        DexType serviceLoaderType = this.appView.dexItemFactory().createType("L$$ServiceLoaderMethods;");
        if (this.synthesizedClass == null) {
            assert (!this.appView.options().encodeChecksums);
            DexProgramClass.ChecksumSupplier checksumSupplier = DexProgramClass::invalidChecksumRequest;
            this.synthesizedClass = new DexProgramClass(serviceLoaderType, null, new SynthesizedOrigin("Service Loader desugaring", this.getClass()), ClassAccessFlags.fromDexAccessFlags(4113), this.appView.dexItemFactory().objectType, DexTypeList.empty(), this.appView.dexItemFactory().createString("ServiceLoader"), null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, this.appView.dexItemFactory().getSkipNameValidationForTesting(), checksumSupplier);
            this.appView.appInfo().addSynthesizedClass(this.synthesizedClass);
        }
        DexProto proto = this.appView.dexItemFactory().createProto(this.appView.dexItemFactory().iteratorType, new DexType[0]);
        DexMethod method = this.appView.dexItemFactory().createMethod(serviceLoaderType, proto, SERVICE_LOADER_METHOD_PREFIX_NAME + this.synthesizedServiceLoaders.size());
        MethodAccessFlags methodAccess = MethodAccessFlags.fromSharedAccessFlags(9, false);
        DexEncodedMethod encodedMethod = new DexEncodedMethod(method, methodAccess, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)ServiceLoaderSourceCode.generate(serviceType, classes, this.appView.dexItemFactory()), true);
        this.synthesizedClass.addDirectMethod(encodedMethod);
        return encodedMethod;
    }

    private static class Rewriter {
        private final IRCode code;
        private final InvokeStatic serviceLoaderLoad;
        private InstructionListIterator iterator;

        Rewriter(IRCode code, InstructionListIterator iterator2, InvokeStatic serviceLoaderLoad) {
            this.iterator = iterator2;
            this.code = code;
            this.serviceLoaderLoad = serviceLoaderLoad;
        }

        public void perform(InvokeVirtual classLoaderInvoke, DexMethod method) {
            if (classLoaderInvoke != null) {
                this.clearGetClassLoader(classLoaderInvoke);
                this.iterator.nextUntil(i -> i == this.serviceLoaderLoad);
            }
            InvokeVirtual serviceLoaderIterator = this.serviceLoaderLoad.outValue().singleUniqueUser().asInvokeVirtual();
            this.iterator.replaceCurrentInstruction(this.code.createConstNull());
            this.iterator.nextUntil(x -> x == serviceLoaderIterator);
            InvokeStatic synthesizedInvoke = new InvokeStatic(method, serviceLoaderIterator.outValue(), ImmutableList.of());
            this.iterator.replaceCurrentInstruction(synthesizedInvoke);
        }

        private void clearGetClassLoader(InvokeVirtual classLoaderInvoke) {
            while (this.iterator.hasPrevious()) {
                Instruction instruction = (Instruction)this.iterator.previous();
                if (instruction != classLoaderInvoke) continue;
                this.iterator.replaceCurrentInstruction(this.code.createConstNull());
                break;
            }
        }
    }
}

