/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ListIterator;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.IRMetadata;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class MemberValuePropagation {
    private static final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final Reporter reporter;
    private final Set<DexField> warnedFields = Sets.newIdentityHashSet();

    public MemberValuePropagation(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.reporter = appView.options().reporter;
    }

    private boolean mayPropagateValueFor(DexEncodedField field) {
        if (field.isProgramField(this.appView)) {
            return this.appView.appInfo().mayPropagateValueFor(field.field);
        }
        return this.appView.appInfo().assumedValues.containsKey(field.field) || this.appView.appInfo().noSideEffects.containsKey(field.field);
    }

    private boolean mayPropagateValueFor(DexEncodedMethod method) {
        if (method.isProgramMethod(this.appView)) {
            return this.appView.appInfo().mayPropagateValueFor(method.method);
        }
        return this.appView.appInfo().assumedValues.containsKey(method.method) || this.appView.appInfo().noSideEffects.containsKey(method.method);
    }

    private ProguardMemberRuleLookup lookupMemberRule(DexDefinition definition) {
        if (definition == null) {
            return null;
        }
        DexReference reference = definition.toReference();
        ProguardMemberRule rule = this.appView.appInfo().noSideEffects.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_NO_SIDE_EFFECTS, rule);
        }
        rule = this.appView.appInfo().assumedValues.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_VALUES, rule);
        }
        return null;
    }

    private Instruction constantReplacementFromProguardRule(ProguardMemberRule rule, IRCode code, Instruction instruction) {
        if (rule == null || !rule.hasReturnValue()) {
            return null;
        }
        ProguardMemberRuleReturnValue returnValueRule = rule.getReturnValue();
        if (returnValueRule.isSingleValue()) {
            return this.appView.abstractValueFactory().createSingleNumberValue(returnValueRule.getSingleValue()).createMaterializingInstruction(this.appView, code, instruction);
        }
        TypeLatticeElement typeLattice = instruction.outValue().getTypeLattice();
        if (returnValueRule.isField()) {
            DexField field = returnValueRule.getField();
            assert (typeLattice == TypeLatticeElement.fromDexType(field.type, Nullability.maybeNull(), this.appView));
            DexEncodedField staticField = this.appView.appInfo().lookupStaticTarget(field.holder, field);
            if (staticField == null) {
                if (this.warnedFields.add(field)) {
                    this.reporter.warning(new StringDiagnostic("Field `" + field.toSourceString() + "` is used in an -assumevalues rule but does not exist.", code.origin));
                }
                return null;
            }
            Instruction replacement = staticField.valueAsConstInstruction(code, instruction.getLocalInfo(), this.appView);
            if (replacement == null) {
                this.reporter.warning(new StringDiagnostic("Unable to apply the rule `" + returnValueRule.toString() + "`: Could not determine the value of field `" + field.toSourceString() + "`", code.origin));
                return null;
            }
            return replacement;
        }
        return null;
    }

    private void setValueRangeFromProguardRule(ProguardMemberRule rule, Value value) {
        if (rule.hasReturnValue() && rule.getReturnValue().isValueRange()) {
            assert (!rule.getReturnValue().isSingleValue());
            value.setValueRange(rule.getReturnValue().getValueRange());
        }
    }

    private boolean tryConstantReplacementFromProguard(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, Instruction current, ProguardMemberRuleLookup lookup) {
        Instruction replacement = this.constantReplacementFromProguardRule(lookup.rule, code, current);
        if (replacement == null) {
            this.setValueRangeFromProguardRule(lookup.rule, current.outValue());
            return false;
        }
        affectedValues.addAll(current.outValue().affectedValues());
        if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS) {
            iterator2.replaceCurrentInstruction(replacement);
        } else {
            assert (lookup.type == RuleType.ASSUME_VALUES);
            if (current.outValue() != null) {
                assert (replacement.outValue() != null);
                current.outValue().replaceUsers(replacement.outValue());
            }
            replacement.setPosition(current.getPosition());
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator(code).add(replacement);
            } else {
                iterator2.add(replacement);
            }
        }
        return true;
    }

    private void rewriteInvokeMethodWithConstantValues(IRCode code, DexType callingContext, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod current) {
        SingleValue singleReturnValue;
        DexMethod invokedMethod = current.getInvokedMethod();
        DexType invokedHolder = invokedMethod.holder;
        if (!invokedHolder.isClassType()) {
            return;
        }
        DexEncodedMethod target = current.lookupSingleTarget(this.appView, callingContext);
        if (target != null && target.isInstanceInitializer()) {
            return;
        }
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(target);
        if (lookup == null) {
            DexEncodedMethod resolutionTarget = this.appView.appInfo().resolveMethod(invokedHolder, invokedMethod).getSingleTarget();
            lookup = this.lookupMemberRule(resolutionTarget);
        }
        boolean invokeReplaced = false;
        if (lookup != null) {
            ProguardMemberRule rule;
            boolean hasUsedOutValue;
            boolean bl = hasUsedOutValue = current.hasOutValue() && current.outValue().isUsed();
            if (!hasUsedOutValue) {
                if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                }
                return;
            }
            if (target != null && lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS && !lookup.rule.hasReturnValue() && (rule = this.appView.appInfo().assumedValues.get(target.toReference())) != null) {
                lookup = new ProguardMemberRuleLookup(RuleType.ASSUME_VALUES, rule);
            }
            invokeReplaced = this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup);
        }
        if (invokeReplaced || !current.hasOutValue()) {
            return;
        }
        if (target == null || !this.mayPropagateValueFor(target)) {
            return;
        }
        AbstractValue abstractReturnValue = target.getOptimizationInfo().getAbstractReturnValue();
        if (abstractReturnValue.isSingleValue() && (singleReturnValue = abstractReturnValue.asSingleValue()).isMaterializableInContext(this.appView, callingContext)) {
            Instruction replacement = singleReturnValue.createMaterializingInstruction(this.appView, code, current);
            affectedValues.addAll(current.outValue().affectedValues());
            current.outValue().replaceUsers(replacement.outValue());
            current.setOutValue(null);
            replacement.setPosition(current.getPosition());
            current.moveDebugValues(replacement);
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator(code).add(replacement);
            } else {
                iterator2.add(replacement);
            }
            target.getMutableOptimizationInfo().markAsPropagated();
        }
    }

    private void rewriteStaticGetWithConstantValues(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, StaticGet current) {
        DexField field = current.getField();
        DexEncodedField target = this.appView.appInfo().lookupStaticTarget(field.holder, field);
        if (target == null) {
            boolean replaceCurrentInstructionWithConstNull = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.wasRemoved(field), false);
            if (replaceCurrentInstructionWithConstNull) {
                iterator2.replaceCurrentInstruction(code.createConstNull());
            }
            return;
        }
        if (!this.mayPropagateValueFor(target)) {
            return;
        }
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(target);
        if (lookup != null && this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup)) {
            return;
        }
        if (this.appView.appInfo().isPinned(target.field)) {
            return;
        }
        Instruction replacement = target.valueAsConstInstruction(code, current.outValue().getLocalInfo(), this.appView);
        if (replacement != null) {
            affectedValues.addAll(current.outValue().affectedValues());
            if (target.mayTriggerClassInitializationSideEffects(this.appView, code.method.method.holder)) {
                replacement.setPosition(current.getPosition());
                current.outValue().replaceUsers(replacement.outValue());
                if (current.getBlock().hasCatchHandlers()) {
                    iterator2.split(code, blocks).listIterator(code).add(replacement);
                } else {
                    iterator2.add(replacement);
                }
            } else {
                iterator2.replaceCurrentInstruction(replacement);
            }
            feedback.markFieldAsPropagated(target);
        }
    }

    private void rewriteInstanceGetWithConstantValues(IRCode code, Set<Value> affectedValues, InstructionListIterator iterator2, InstanceGet current) {
        if (current.object().getTypeLattice().isNullable()) {
            return;
        }
        DexField field = current.getField();
        DexEncodedField target = this.appView.appInfo().lookupInstanceTarget(field.holder, field);
        if (target == null || !this.mayPropagateValueFor(target)) {
            return;
        }
        Instruction replacement = target.valueAsConstInstruction(code, current.outValue().getLocalInfo(), this.appView);
        if (replacement != null) {
            affectedValues.add(replacement.outValue());
            iterator2.replaceCurrentInstruction(replacement);
            if (replacement.isDexItemBasedConstString()) {
                code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
            }
            feedback.markFieldAsPropagated(target);
        }
    }

    public void rewriteWithConstantValues(IRCode code, DexType callingContext) {
        IRMetadata metadata = code.metadata();
        if (!metadata.mayHaveFieldGet() && !metadata.mayHaveInvokeMethod()) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod()) {
                    this.rewriteInvokeMethodWithConstantValues(code, callingContext, affectedValues, blocks, iterator2, current.asInvokeMethod());
                    continue;
                }
                if (current.isStaticGet()) {
                    this.rewriteStaticGetWithConstantValues(code, affectedValues, blocks, iterator2, current.asStaticGet());
                    continue;
                }
                if (!current.isInstanceGet()) continue;
                this.rewriteInstanceGetWithConstantValues(code, affectedValues, iterator2, current.asInstanceGet());
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    private static class ProguardMemberRuleLookup {
        final RuleType type;
        final ProguardMemberRule rule;

        ProguardMemberRuleLookup(RuleType type, ProguardMemberRule rule) {
            this.type = type;
            this.rule = rule;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProguardMemberRuleLookup)) {
                return false;
            }
            ProguardMemberRuleLookup otherLookup = (ProguardMemberRuleLookup)other;
            return this.type == otherLookup.type && this.rule == otherLookup.rule;
        }

        public int hashCode() {
            return this.type.ordinal() * 31 + this.rule.hashCode();
        }
    }

    private static enum RuleType {
        NONE,
        ASSUME_NO_SIDE_EFFECTS,
        ASSUME_VALUES;

    }
}

