/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;

public class InstructionEquivalence
extends Equivalence<Instruction> {
    private final RegisterAllocator allocator;

    InstructionEquivalence(RegisterAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    protected boolean doEquivalent(Instruction a, Instruction b) {
        return a.identicalAfterRegisterAllocation(b, this.allocator) && a.getBlock().getCatchHandlers().equals(b.getBlock().getCatchHandlers());
    }

    @Override
    protected int doHash(Instruction instruction) {
        int hash = 0;
        if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
            hash += this.allocator.getRegisterForValue(instruction.outValue(), instruction.getNumber());
        }
        for (Value inValue : instruction.inValues()) {
            hash <<= 4;
            if (!inValue.needsRegister()) continue;
            hash += this.allocator.getRegisterForValue(inValue, instruction.getNumber());
        }
        hash = hash * 37 + instruction.getBlock().getCatchHandlers().hashCode();
        return hash;
    }
}

