/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.MoveException;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Throw;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CodeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.conversion.LensCodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PostOptimization;
import shadow.bundletool.com.android.tools.r8.ir.desugar.TwrCloseResourceRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AssumeDynamicTypeRemover;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.ForcedInliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningStrategy;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NestUtils;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.IteratorUtils;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;

public class Inliner
implements PostOptimization {
    protected final AppView<AppInfoWithLiveness> appView;
    private final Set<DexMethod> blacklist;
    private final LambdaMerger lambdaMerger;
    private final LensCodeRewriter lensCodeRewriter;
    final MainDexClasses mainDexClasses;
    private boolean applyDoubleInlining = false;
    private final Set<DexEncodedMethod> doubleInlineCallers = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> doubleInlineSelectedTargets = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> doubleInlineeCandidates = new HashMap<DexEncodedMethod, DexEncodedMethod>();

    public Inliner(AppView<AppInfoWithLiveness> appView, MainDexClasses mainDexClasses, LambdaMerger lambdaMerger, LensCodeRewriter lensCodeRewriter) {
        Kotlin.Intrinsics intrinsics = appView.dexItemFactory().kotlin.intrinsics;
        this.appView = appView;
        this.blacklist = appView.options().kotlinOptimizationOptions().disableKotlinSpecificOptimizations ? ImmutableSet.of() : ImmutableSet.of(intrinsics.throwNpe, intrinsics.throwParameterIsNullException);
        this.lambdaMerger = lambdaMerger;
        this.lensCodeRewriter = lensCodeRewriter;
        this.mainDexClasses = mainDexClasses;
    }

    boolean isBlacklisted(DexEncodedMethod encodedMethod, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        DexMethod method = encodedMethod.method;
        if (encodedMethod.getOptimizationInfo().forceInline() && this.appView.appInfo().neverInline.contains(method)) {
            throw new Unreachable();
        }
        if (this.appView.appInfo().isPinned(method)) {
            whyAreYouNotInliningReporter.reportPinned();
            return true;
        }
        if (this.blacklist.contains(this.appView.graphLense().getOriginalMethodSignature(method)) || TwrCloseResourceRewriter.isSynthesizedCloseResourceMethod(method, this.appView)) {
            whyAreYouNotInliningReporter.reportBlacklisted();
            return true;
        }
        if (this.appView.appInfo().neverInline.contains(method)) {
            whyAreYouNotInliningReporter.reportMarkedAsNeverInline();
            return true;
        }
        return false;
    }

    boolean isDoubleInliningEnabled() {
        return this.applyDoubleInlining;
    }

    private ConstraintWithTarget instructionAllowedForInlining(Instruction instruction, InliningConstraints inliningConstraints, DexType invocationContext) {
        ConstraintWithTarget result = instruction.inliningConstraint(inliningConstraints, invocationContext);
        if (result == ConstraintWithTarget.NEVER && instruction.isDebugInstruction()) {
            return ConstraintWithTarget.ALWAYS;
        }
        return result;
    }

    public ConstraintWithTarget computeInliningConstraint(IRCode code, DexEncodedMethod method) {
        if (this.appView.options().canHaveDalvikCatchHandlerVerificationBug() && this.useReflectiveOperationExceptionOrUnknownClassInCatch(code)) {
            return ConstraintWithTarget.NEVER;
        }
        if (this.appView.options().canHaveDalvikIntUsedAsNonIntPrimitiveTypeBug() && this.returnsIntAsBoolean(code, method)) {
            return ConstraintWithTarget.NEVER;
        }
        ConstraintWithTarget result = ConstraintWithTarget.ALWAYS;
        InliningConstraints inliningConstraints = new InliningConstraints(this.appView, GraphLense.getIdentityLense());
        for (Instruction instruction : code.instructions()) {
            ConstraintWithTarget state = this.instructionAllowedForInlining(instruction, inliningConstraints, method.method.holder);
            if (state == ConstraintWithTarget.NEVER) {
                result = state;
                break;
            }
            result = ConstraintWithTarget.meet(result, state, this.appView);
        }
        return result;
    }

    private boolean returnsIntAsBoolean(IRCode code, DexEncodedMethod method) {
        DexType returnType = method.method.proto.returnType;
        for (BasicBlock basicBlock : code.blocks) {
            InstructionIterator instructionIterator = basicBlock.iterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = instructionIterator.nextUntil(Instruction::isReturn);
                if (instruction == null || !returnType.isBooleanType() || instruction.inValues().get(0).knownToBeBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasInliningAccess(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.isVisibleWithFlags(target.method.holder, method.method.holder, target.accessFlags)) {
            return false;
        }
        DexClass targetClass = this.appView.definitionFor(target.method.holder);
        return this.isVisibleWithFlags(target.method.holder, method.method.holder, targetClass.accessFlags);
    }

    private boolean isVisibleWithFlags(DexType target, DexType context, AccessFlags flags) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPrivate()) {
            return NestUtils.sameNest(target, context, this.appView);
        }
        if (flags.isProtected()) {
            return this.appView.appInfo().isSubtype(context, target) || target.isSamePackage(context);
        }
        return target.isSamePackage(context);
    }

    public synchronized boolean isDoubleInlineSelectedTarget(DexEncodedMethod method) {
        return this.doubleInlineSelectedTargets.contains(method);
    }

    synchronized boolean satisfiesRequirementsForDoubleInlining(DexEncodedMethod method, DexEncodedMethod target) {
        if (this.applyDoubleInlining) {
            return this.doubleInlineSelectedTargets.contains(target);
        }
        this.recordDoubleInliningCandidate(method, target);
        return false;
    }

    synchronized void recordDoubleInliningCandidate(DexEncodedMethod method, DexEncodedMethod target) {
        if (this.applyDoubleInlining) {
            return;
        }
        if (this.doubleInlineeCandidates.containsKey(target)) {
            this.doubleInlineCallers.add(this.doubleInlineeCandidates.get(target));
            this.doubleInlineCallers.add(method);
            this.doubleInlineSelectedTargets.add(target);
        } else {
            this.doubleInlineeCandidates.put(target, method);
        }
    }

    @Override
    public Set<DexEncodedMethod> methodsToRevisit() {
        this.applyDoubleInlining = true;
        return this.doubleInlineCallers;
    }

    @Override
    public Collection<CodeOptimization> codeOptimizationsForPostProcessing() {
        return null;
    }

    static int numberOfInstructions(IRCode code) {
        int numberOfInstructions = 0;
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                assert (!instruction.isDebugInstruction());
                if (instruction.isArgument() || instruction.isAssume() || instruction.isGoto() && instruction.asGoto().getTarget().getPredecessors().size() == 1 || instruction.isReturn()) continue;
                ++numberOfInstructions;
            }
        }
        return numberOfInstructions;
    }

    public void performForcedInlining(DexEncodedMethod method, IRCode code, Map<? extends InvokeMethod, InliningInfo> invokesToInline) {
        this.performForcedInlining(method, code, invokesToInline, new InliningIRProvider(this.appView, method, code));
    }

    public void performForcedInlining(DexEncodedMethod method, IRCode code, Map<? extends InvokeMethod, InliningInfo> invokesToInline, InliningIRProvider inliningIRProvider) {
        ForcedInliningOracle oracle = new ForcedInliningOracle(this.appView, method, invokesToInline);
        this.performInliningImpl(oracle, oracle, method, code, OptimizationFeedbackIgnore.getInstance(), inliningIRProvider);
    }

    public void performInlining(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        InternalOptions options = this.appView.options();
        DefaultInliningOracle oracle = this.createDefaultOracle(method, code, methodProcessor, options.inliningInstructionLimit, options.inliningInstructionAllowance - Inliner.numberOfInstructions(code));
        InliningIRProvider inliningIRProvider = new InliningIRProvider(this.appView, method, code);
        assert (inliningIRProvider.verifyIRCacheIsEmpty());
        this.performInliningImpl(oracle, oracle, method, code, feedback, inliningIRProvider);
    }

    public DefaultInliningOracle createDefaultOracle(DexEncodedMethod method, IRCode code, MethodProcessor methodProcessor, int inliningInstructionLimit, int inliningInstructionAllowance) {
        return new DefaultInliningOracle(this.appView, this, method, code, methodProcessor, inliningInstructionLimit, inliningInstructionAllowance);
    }

    private void performInliningImpl(InliningStrategy strategy, InliningOracle oracle, DexEncodedMethod context, IRCode code, OptimizationFeedback feedback, InliningIRProvider inliningIRProvider) {
        AssumeDynamicTypeRemover assumeDynamicTypeRemover = new AssumeDynamicTypeRemover(this.appView, code);
        Set<BasicBlock> blocksToRemove = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        ClassInitializationAnalysis classInitializationAnalysis = new ClassInitializationAnalysis(this.appView, code);
        ArrayDeque<BasicBlock> inlineeStack = new ArrayDeque<BasicBlock>();
        InternalOptions options = this.appView.options();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!inlineeStack.isEmpty() && inlineeStack.peekFirst() == block) {
                inlineeStack.pop();
            }
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod()) {
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexEncodedMethod singleTarget = oracle.lookupSingleTarget(invoke, context.method.holder);
                    if (singleTarget == null) {
                        WhyAreYouNotInliningReporter.handleInvokeWithUnknownTarget(invoke, this.appView, context);
                        continue;
                    }
                    WhyAreYouNotInliningReporter whyAreYouNotInliningReporter = oracle.isForcedInliningOracle() ? NopWhyAreYouNotInliningReporter.getInstance() : WhyAreYouNotInliningReporter.createFor(singleTarget, this.appView, context);
                    InlineAction action = oracle.computeInlining(invoke, singleTarget, classInitializationAnalysis, whyAreYouNotInliningReporter);
                    if (action == null) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    if (!inlineeStack.isEmpty() && !strategy.allowInliningOfInvokeInInlinee(action, inlineeStack.size(), whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    if (!strategy.stillHasBudget(action, whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    InlineeWithReason inlinee = action.buildInliningIR(this.appView, invoke, context, inliningIRProvider, this.lambdaMerger, this.lensCodeRewriter);
                    if (strategy.willExceedBudget(code, invoke, inlinee, block, whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    strategy.ensureMethodProcessed(singleTarget, inlinee.code, feedback);
                    assert (!singleTarget.isClassInitializer());
                    if (singleTarget.isInstanceInitializer() && !strategy.canInlineInstanceInitializer(inlinee.code, whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    Value outValue = invoke.outValue();
                    if (outValue != null) {
                        assumeDynamicTypeRemover.markUsersForRemoval(outValue);
                    }
                    boolean inlineeMayHaveInvokeMethod = inlinee.code.metadata().mayHaveInvokeMethod();
                    iterator2.previous();
                    strategy.markInlined(inlinee);
                    iterator2.inlineInvoke(this.appView, code, inlinee.code, blockIterator, blocksToRemove, this.getDowncastTypeIfNeeded(strategy, invoke, singleTarget));
                    if (inlinee.reason == Reason.SINGLE_CALLER) {
                        feedback.markInlinedIntoSingleCallSite(singleTarget);
                    }
                    classInitializationAnalysis.notifyCodeHasChanged();
                    strategy.updateTypeInformationIfNeeded(inlinee.code, blockIterator, block);
                    if (context.accessFlags.isBridge() && !inlinee.code.method.accessFlags.isBridge()) {
                        context.accessFlags.unsetBridge();
                    }
                    if (context.accessFlags.isSynthetic() && !inlinee.code.method.accessFlags.isSynthetic()) {
                        context.accessFlags.unsetSynthetic();
                    }
                    context.copyMetadata(singleTarget);
                    if (!inlineeMayHaveInvokeMethod || !options.applyInliningToInlinee || inlineeStack.size() + 1 > options.applyInliningToInlineeMaxDepth && this.appView.appInfo().alwaysInline.isEmpty() && this.appView.appInfo().forceInline.isEmpty()) continue;
                    BasicBlock inlineeEnd = IteratorUtils.peekNext(blockIterator);
                    inlineeStack.push(inlineeEnd);
                    IteratorUtils.previousUntil(blockIterator, previous -> previous == block);
                    blockIterator.next();
                    continue;
                }
                if (!current.isAssumeDynamicType()) continue;
                assumeDynamicTypeRemover.removeIfMarked(current.asAssumeDynamicType(), iterator2);
            }
        }
        assert (inlineeStack.isEmpty());
        assumeDynamicTypeRemover.removeMarkedInstructions(blocksToRemove);
        assumeDynamicTypeRemover.finish();
        classInitializationAnalysis.finish();
        code.removeBlocks(blocksToRemove);
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private boolean useReflectiveOperationExceptionOrUnknownClassInCatch(IRCode code) {
        for (BasicBlock block : code.blocks) {
            for (CatchHandlers.CatchHandler<BasicBlock> catchHandler : block.getCatchHandlers()) {
                if (catchHandler.guard == this.appView.dexItemFactory().reflectiveOperationExceptionType) {
                    return true;
                }
                if (this.appView.definitionFor(catchHandler.guard) != null) continue;
                return true;
            }
        }
        return false;
    }

    private DexType getDowncastTypeIfNeeded(InliningStrategy strategy, InvokeMethod invoke, DexEncodedMethod target) {
        if (invoke.isInvokeMethodWithReceiver()) {
            DexType receiverType = strategy.getReceiverTypeIfKnown(invoke);
            if (receiverType == null) {
                receiverType = invoke.getInvokedMethod().holder;
            }
            if (!this.appView.appInfo().isSubtype(receiverType, target.method.holder)) {
                return target.method.holder;
            }
        }
        return null;
    }

    public static boolean verifyNoMethodsInlinedDueToSingleCallSite(AppView<?> appView) {
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classes()) {
            for (DexEncodedMethod method : clazz.methods()) {
                assert (!method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite());
            }
        }
        return true;
    }

    public static class InliningInfo {
        public final DexEncodedMethod target;
        public final DexType receiverType;

        public InliningInfo(DexEncodedMethod target, DexType receiverType) {
            this.target = target;
            this.receiverType = receiverType;
        }
    }

    static class InlineeWithReason {
        final Reason reason;
        final IRCode code;

        InlineeWithReason(IRCode code, Reason reason) {
            this.code = code;
            this.reason = reason;
        }
    }

    public static class InlineAction {
        public final DexEncodedMethod target;
        public final Invoke invoke;
        final Reason reason;
        private boolean shouldSynthesizeNullCheckForReceiver;

        InlineAction(DexEncodedMethod target, Invoke invoke, Reason reason) {
            this.target = target;
            this.invoke = invoke;
            this.reason = reason;
        }

        void setShouldSynthesizeNullCheckForReceiver() {
            this.shouldSynthesizeNullCheckForReceiver = true;
        }

        InlineeWithReason buildInliningIR(AppView<? extends AppInfoWithSubtyping> appView, InvokeMethod invoke, DexEncodedMethod context, InliningIRProvider inliningIRProvider, LambdaMerger lambdaMerger, LensCodeRewriter lensCodeRewriter) {
            boolean isSynthesizingNullCheckForReceiverUsingMonitorEnter;
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            InternalOptions options = appView.options();
            IRCode code = inliningIRProvider.getInliningIR(invoke, this.target);
            boolean shouldSynthesizeMonitorEnterExit = this.target.accessFlags.isSynchronized() && options.isGeneratingClassFiles();
            boolean bl = isSynthesizingNullCheckForReceiverUsingMonitorEnter = shouldSynthesizeMonitorEnterExit && !this.target.isStatic();
            if (this.shouldSynthesizeNullCheckForReceiver && !isSynthesizingNullCheckForReceiverUsingMonitorEnter) {
                List<Value> arguments = code.collectArguments();
                if (!arguments.isEmpty()) {
                    Value receiver = arguments.get(0);
                    assert (receiver.isThis());
                    BasicBlock entryBlock = code.entryBlock();
                    BasicBlock throwBlock = entryBlock.listIterator(code, arguments.size()).split(code, 0, null);
                    assert (!throwBlock.hasCatchHandlers());
                    BasicBlock continuationBlock = throwBlock.unlinkSingleSuccessor();
                    entryBlock.link(continuationBlock);
                    If ifInstruction = new If(If.Type.EQ, receiver);
                    entryBlock.replaceLastInstruction(ifInstruction, code);
                    assert (ifInstruction.getTrueTarget() == throwBlock);
                    assert (ifInstruction.fallthroughBlock() == continuationBlock);
                    InstructionListIterator iterator2 = throwBlock.listIterator(code);
                    Value nullValue = iterator2.insertConstNullInstruction(code, appView.options());
                    iterator2.next();
                    iterator2.replaceCurrentInstruction(new Throw(nullValue));
                } else assert (false) : "Unable to synthesize a null check for the receiver";
            }
            if (shouldSynthesizeMonitorEnterExit) {
                Value lockValue;
                Value exceptionValue;
                TypeLatticeElement throwableType = TypeLatticeElement.fromDexType(dexItemFactory.throwableType, Nullability.definitelyNotNull(), appView);
                code.prepareBlocksForCatchHandlers();
                int nextBlockNumber = code.getHighestBlockNumber() + 1;
                BasicBlock monitorExitBlock = new BasicBlock();
                monitorExitBlock.setNumber(nextBlockNumber++);
                ArrayList<BasicBlock> moveExceptionBlocks = new ArrayList<BasicBlock>();
                for (BasicBlock block2 : code.blocks) {
                    if (!block2.canThrow() || block2.hasCatchHandlers() && block2.getCatchHandlersWithSuccessorIndexes().hasCatchAll(dexItemFactory)) continue;
                    BasicBlock moveExceptionBlock = BasicBlock.createGotoBlock(nextBlockNumber++, Position.none(), code.metadata(), monitorExitBlock);
                    InstructionListIterator moveExceptionBlockIterator = moveExceptionBlock.listIterator(code);
                    moveExceptionBlockIterator.setInsertionPosition(Position.syntheticNone());
                    moveExceptionBlockIterator.add(new MoveException(code.createValue(throwableType), dexItemFactory.throwableType, options));
                    block2.appendCatchHandler(moveExceptionBlock, dexItemFactory.throwableType);
                    moveExceptionBlocks.add(moveExceptionBlock);
                }
                if (moveExceptionBlocks.size() == 1) {
                    exceptionValue = ((BasicBlock)ListUtils.first(moveExceptionBlocks)).getInstructions().getFirst().outValue();
                } else {
                    Phi phi = code.createPhi(monitorExitBlock, throwableType);
                    List<Value> operands = ListUtils.map(moveExceptionBlocks, block -> block.getInstructions().getFirst().outValue());
                    phi.addOperands(operands);
                    exceptionValue = phi;
                }
                InstructionListIterator monitorExitBlockIterator = monitorExitBlock.listIterator(code);
                monitorExitBlockIterator.setInsertionPosition(Position.syntheticNone());
                monitorExitBlockIterator.add(new Throw(exceptionValue));
                monitorExitBlock.getMutablePredecessors().addAll(moveExceptionBlocks);
                code.blocks.addAll(moveExceptionBlocks);
                code.blocks.add(monitorExitBlock);
                BasicBlock entryBlock = code.entryBlock();
                InstructionListIterator entryBlockIterator = entryBlock.listIterator(code);
                entryBlockIterator.nextUntil(Predicates.not(Instruction::isArgument));
                entryBlockIterator.previous();
                BasicBlock monitorEnterBlock = entryBlockIterator.split(code, 0, null);
                assert (!monitorEnterBlock.hasCatchHandlers());
                InstructionListIterator monitorEnterBlockIterator = monitorEnterBlock.listIterator(code);
                monitorEnterBlockIterator.setInsertionPosition(Position.syntheticNone());
                if (this.target.isStatic()) {
                    lockValue = code.createValue(TypeLatticeElement.fromDexType(dexItemFactory.objectType, Nullability.definitelyNotNull(), appView));
                    monitorEnterBlockIterator.add(new ConstClass(lockValue, this.target.method.holder));
                } else {
                    lockValue = entryBlock.getInstructions().getFirst().asArgument().outValue();
                }
                monitorEnterBlockIterator.add(new Monitor(Monitor.Type.ENTER, lockValue));
                monitorExitBlockIterator.previous();
                monitorExitBlockIterator.add(new Monitor(Monitor.Type.EXIT, lockValue));
                monitorExitBlock.close(null);
                for (BasicBlock block3 : code.blocks) {
                    if (!block3.exit().isReturn()) continue;
                    assert (!block3.canThrow());
                    InstructionListIterator instructionIterator = block3.listIterator(code, block3.getInstructions().size() - 1);
                    instructionIterator.setInsertionPosition(Position.syntheticNone());
                    instructionIterator.add(new Monitor(Monitor.Type.EXIT, lockValue));
                }
            }
            if (!this.target.isProcessed()) {
                lensCodeRewriter.rewrite(code, this.target);
            }
            if (lambdaMerger != null) {
                lambdaMerger.rewriteCodeForInlining(this.target, code, context);
            }
            assert (code.isConsistentSSA());
            return new InlineeWithReason(code, this.reason);
        }
    }

    public static enum Reason {
        FORCE,
        ALWAYS,
        SINGLE_CALLER,
        DUAL_CALLER,
        SIMPLE,
        NEVER;


        public boolean mustBeInlined() {
            return this == FORCE || this == ALWAYS;
        }
    }

    public static class ConstraintWithTarget {
        public final Constraint constraint;
        final DexType targetHolder;
        public static final ConstraintWithTarget NEVER = new ConstraintWithTarget(Constraint.NEVER);
        public static final ConstraintWithTarget ALWAYS = new ConstraintWithTarget(Constraint.ALWAYS);

        private ConstraintWithTarget(Constraint constraint) {
            assert (constraint == Constraint.NEVER || constraint == Constraint.ALWAYS);
            this.constraint = constraint;
            this.targetHolder = null;
        }

        ConstraintWithTarget(Constraint constraint, DexType targetHolder) {
            assert (constraint != Constraint.NEVER && constraint != Constraint.ALWAYS);
            assert (targetHolder != null);
            this.constraint = constraint;
            this.targetHolder = targetHolder;
        }

        public int hashCode() {
            if (this.targetHolder == null) {
                return this.constraint.ordinal();
            }
            return this.constraint.ordinal() * this.targetHolder.computeHashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ConstraintWithTarget)) {
                return false;
            }
            ConstraintWithTarget o = (ConstraintWithTarget)other;
            return this.constraint.ordinal() == o.constraint.ordinal() && this.targetHolder == o.targetHolder;
        }

        public static ConstraintWithTarget deriveConstraint(DexType contextHolder, DexType targetHolder, AccessFlags flags, AppView<?> appView) {
            if (flags.isPublic()) {
                return ALWAYS;
            }
            if (flags.isPrivate()) {
                DexClass contextHolderClass = appView.definitionFor(contextHolder);
                assert (contextHolderClass != null);
                if (contextHolderClass.isInANest()) {
                    return NestUtils.sameNest(contextHolder, targetHolder, appView) ? new ConstraintWithTarget(Constraint.SAMENEST, targetHolder) : NEVER;
                }
                return targetHolder == contextHolder ? new ConstraintWithTarget(Constraint.SAMECLASS, targetHolder) : NEVER;
            }
            if (flags.isProtected()) {
                if (targetHolder.isSamePackage(contextHolder)) {
                    return new ConstraintWithTarget(Constraint.PACKAGE, targetHolder);
                }
                if (appView.isSubtype(contextHolder, targetHolder).isTrue()) {
                    return new ConstraintWithTarget(Constraint.SUBCLASS, targetHolder);
                }
                return NEVER;
            }
            return targetHolder.isSamePackage(contextHolder) ? new ConstraintWithTarget(Constraint.PACKAGE, targetHolder) : NEVER;
        }

        public static ConstraintWithTarget classIsVisible(DexType context, DexType clazz, AppView<?> appView) {
            if (clazz.isArrayType()) {
                return ConstraintWithTarget.classIsVisible(context, clazz.toArrayElementType(appView.dexItemFactory()), appView);
            }
            if (clazz.isPrimitiveType()) {
                return ALWAYS;
            }
            DexClass definition = appView.definitionFor(clazz);
            return definition == null ? NEVER : ConstraintWithTarget.deriveConstraint(context, clazz, definition.accessFlags, appView);
        }

        public static ConstraintWithTarget meet(ConstraintWithTarget one, ConstraintWithTarget other, AppView<?> appView) {
            if (one.equals(other)) {
                return one;
            }
            if (other.constraint.ordinal() < one.constraint.ordinal()) {
                return ConstraintWithTarget.meet(other, one, appView);
            }
            if (one == NEVER) {
                return NEVER;
            }
            if (other == ALWAYS) {
                return one;
            }
            int constraint = one.constraint.value | other.constraint.value;
            assert (!Constraint.NEVER.isSet(constraint));
            assert (!Constraint.ALWAYS.isSet(constraint));
            if (Constraint.SAMECLASS.isSet(constraint)) {
                assert (one.constraint == Constraint.SAMECLASS);
                if (other.constraint == Constraint.SAMECLASS) {
                    assert (one.targetHolder != other.targetHolder);
                    return NEVER;
                }
                if (other.constraint == Constraint.SAMENEST) {
                    if (NestUtils.sameNest(one.targetHolder, other.targetHolder, appView)) {
                        return one;
                    }
                    return NEVER;
                }
                if (other.constraint == Constraint.PACKAGE) {
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                    return one;
                }
                return NEVER;
            }
            if (Constraint.SAMENEST.isSet(constraint)) {
                assert (one.constraint == Constraint.SAMENEST);
                if (other.constraint == Constraint.SAMENEST) {
                    if (NestUtils.sameNest(one.targetHolder, other.targetHolder, appView)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (ConstraintWithTarget.verifyAllNestInSamePackage(one.targetHolder, appView));
                if (other.constraint == Constraint.PACKAGE) {
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (ConstraintWithTarget.allNestMembersSubtypeOf(one.targetHolder, other.targetHolder, appView)) {
                    return one;
                }
                return NEVER;
            }
            if (Constraint.PACKAGE.isSet(constraint)) {
                assert (one.constraint == Constraint.PACKAGE);
                if (other.constraint == Constraint.PACKAGE) {
                    assert (one.targetHolder != other.targetHolder);
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (other.targetHolder.isSamePackage(one.targetHolder)) {
                    return one;
                }
                if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                    return new ConstraintWithTarget(Constraint.SAMECLASS, one.targetHolder);
                }
                return NEVER;
            }
            assert (Constraint.SUBCLASS.isSet(constraint));
            assert (one.constraint == other.constraint);
            assert (one.targetHolder != other.targetHolder);
            if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                return one;
            }
            if (appView.isSubtype(other.targetHolder, one.targetHolder).isTrue()) {
                return other;
            }
            return NEVER;
        }

        private static boolean allNestMembersSubtypeOf(DexType nestType, DexType superType, AppView<?> appView) {
            DexClass nestHost;
            DexClass dexClass = appView.definitionFor(nestType);
            if (dexClass == null) {
                assert (false);
                return false;
            }
            if (!dexClass.isInANest()) {
                return appView.isSubtype(dexClass.type, superType).isTrue();
            }
            DexClass dexClass2 = nestHost = dexClass.isNestHost() ? dexClass : appView.definitionFor(dexClass.getNestHost());
            if (nestHost == null) {
                assert (false);
                return false;
            }
            for (NestMemberClassAttribute member : nestHost.getNestMembersClassAttributes()) {
                if (appView.isSubtype(member.getNestMember(), superType).isTrue()) continue;
                return false;
            }
            return true;
        }

        private static boolean verifyAllNestInSamePackage(DexType type, AppView<?> appView) {
            DexClass nestHost;
            String descr = type.getPackageDescriptor();
            DexClass dexClass = appView.definitionFor(type);
            assert (dexClass != null);
            if (!dexClass.isInANest()) {
                return true;
            }
            DexClass dexClass2 = nestHost = dexClass.isNestHost() ? dexClass : appView.definitionFor(dexClass.getNestHost());
            assert (nestHost != null);
            for (NestMemberClassAttribute member : nestHost.getNestMembersClassAttributes()) {
                assert (member.getNestMember().getPackageDescriptor().equals(descr));
            }
            return true;
        }
    }

    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint NEVER = new Constraint(1);
        public static final /* enum */ Constraint SAMECLASS = new Constraint(2);
        public static final /* enum */ Constraint SAMENEST = new Constraint(4);
        public static final /* enum */ Constraint PACKAGE = new Constraint(8);
        public static final /* enum */ Constraint SUBCLASS = new Constraint(16);
        public static final /* enum */ Constraint ALWAYS = new Constraint(32);
        int value;
        private static final /* synthetic */ Constraint[] $VALUES;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String name) {
            return Enum.valueOf(Constraint.class, name);
        }

        private Constraint(int value) {
            this.value = value;
        }

        boolean isSet(int value) {
            return (this.value & value) != 0;
        }

        static {
            $VALUES = new Constraint[]{NEVER, SAMECLASS, SAMENEST, PACKAGE, SUBCLASS, ALWAYS};
            assert (NEVER.ordinal() < SAMECLASS.ordinal());
            assert (SAMECLASS.ordinal() < SAMENEST.ordinal());
            assert (SAMENEST.ordinal() < PACKAGE.ordinal());
            assert (PACKAGE.ordinal() < SUBCLASS.ordinal());
            assert (SUBCLASS.ordinal() < ALWAYS.ordinal());
        }
    }
}

