/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class EnumInfoMapCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexType, Map<DexField, AppInfoWithLiveness.EnumValueInfo>> valueInfoMaps = new IdentityHashMap<DexType, Map<DexField, AppInfoWithLiveness.EnumValueInfo>>();

    public EnumInfoMapCollector(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public AppInfoWithLiveness run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.processClasses(clazz);
        }
        if (!this.valueInfoMaps.isEmpty()) {
            return this.appView.appInfo().addEnumValueInfoMaps(this.valueInfoMaps);
        }
        return this.appView.appInfo();
    }

    private void processClasses(DexProgramClass clazz) {
        if (!clazz.accessFlags.isEnum() || clazz.isNotProgramClass() || !clazz.hasClassInitializer()) {
            return;
        }
        DexEncodedMethod initializer = clazz.getClassInitializer();
        IRCode code = initializer.getCode().buildIR(initializer, this.appView, clazz.origin);
        IdentityHashMap<DexField, AppInfoWithLiveness.EnumValueInfo> valueInfoMap = new IdentityHashMap<DexField, AppInfoWithLiveness.EnumValueInfo>();
        for (Instruction insn : code.instructions()) {
            Instruction newInstance;
            if (!insn.isStaticPut()) continue;
            StaticPut staticPut = insn.asStaticPut();
            if (staticPut.getField().type != clazz.type || (newInstance = staticPut.value().definition) == null || !newInstance.isNewInstance()) continue;
            Instruction ordinal = null;
            DexType type = null;
            for (Instruction ctorCall : newInstance.outValue().uniqueUsers()) {
                if (!ctorCall.isInvokeDirect()) continue;
                InvokeDirect invoke = ctorCall.asInvokeDirect();
                if (!this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) || invoke.arguments().size() < 3) continue;
                ordinal = invoke.arguments().get((int)2).definition;
                type = invoke.getInvokedMethod().holder;
                break;
            }
            if (ordinal == null || !ordinal.isConstNumber() || type == null) {
                return;
            }
            AppInfoWithLiveness.EnumValueInfo info = new AppInfoWithLiveness.EnumValueInfo(type, ordinal.asConstNumber().getIntValue());
            if (valueInfoMap.put(staticPut.getField(), info) == null) continue;
            return;
        }
        this.valueInfoMaps.put(clazz.type, valueInfoMap);
    }
}

