/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class ConstantCanonicalizer {
    private static final int MAX_CANONICALIZED_CONSTANT = 22;
    private int numberOfConstNumberCanonicalization = 0;
    private int numberOfConstStringCanonicalization = 0;
    private int numberOfDexItemBasedConstStringCanonicalization = 0;
    private int numberOfConstClassCanonicalization = 0;
    private int numberOfEnumCanonicalization = 0;
    private final Object2IntMap<Long> histogramOfCanonicalizationCandidatesPerMethod = Log.ENABLED ? new Object2IntArrayMap<Long>() : null;

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# const-number canonicalization: %s", this.numberOfConstNumberCanonicalization);
        Log.info(this.getClass(), "# const-string canonicalization: %s", this.numberOfConstStringCanonicalization);
        Log.info(this.getClass(), "# item-based const-string canonicalization: %s", this.numberOfDexItemBasedConstStringCanonicalization);
        Log.info(this.getClass(), "# const-class canonicalization: %s", this.numberOfConstClassCanonicalization);
        Log.info(this.getClass(), "# enum canonicalization: %s", this.numberOfEnumCanonicalization);
        assert (this.histogramOfCanonicalizationCandidatesPerMethod != null);
        Log.info(this.getClass(), "------ histogram of constant canonicalization candidates ------", new Object[0]);
        this.histogramOfCanonicalizationCandidatesPerMethod.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void canonicalize(AppView<?> appView, IRCode code) {
        DexType context = code.method.method.holder;
        Object2ObjectLinkedOpenCustomHashMap<Instruction, List> valuesDefinedByConstant = new Object2ObjectLinkedOpenCustomHashMap<Instruction, List>(new Hash.Strategy<Instruction>(){

            @Override
            public int hashCode(Instruction candidate) {
                assert (candidate.instructionTypeCanBeCanonicalized());
                switch (candidate.opcode()) {
                    case 12: {
                        return candidate.asConstClass().getValue().hashCode();
                    }
                    case 15: {
                        return Long.hashCode(candidate.asConstNumber().getRawValue()) + 13 * candidate.outType().hashCode();
                    }
                    case 16: {
                        return candidate.asConstString().getValue().hashCode();
                    }
                    case 20: {
                        return candidate.asDexItemBasedConstString().getItem().hashCode();
                    }
                    case 57: {
                        return candidate.asStaticGet().getField().hashCode();
                    }
                }
                throw new Unreachable();
            }

            @Override
            public boolean equals(Instruction a, Instruction b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b);
            }
        });
        for (Instruction current : code.instructions()) {
            if (!current.instructionTypeCanBeCanonicalized() || current.isConstClass() && current.instructionMayHaveSideEffects(appView, context) || (current.isConstString() || current.isDexItemBasedConstString()) && code.metadata().mayHaveMonitorInstruction() || current.isStaticGet() && (!current.outValue().getAbstractValue(appView, context).isSingleEnumValue() || current.instructionMayHaveSideEffects(appView, context)) || current.outValue().hasLocalInfo() || ConstantCanonicalizer.constantUsedByInvokeRange(current)) continue;
            List oldValuesDefinedByConstant = valuesDefinedByConstant.computeIfAbsent(current, k -> new ArrayList());
            oldValuesDefinedByConstant.add(current.outValue());
        }
        if (valuesDefinedByConstant.isEmpty()) {
            return;
        }
        assert (!code.entryBlock().hasCatchHandlers());
        Position firstNonNonePosition = code.findFirstNonNonePosition(Position.syntheticNone());
        ObjectSortedSet entries = valuesDefinedByConstant.object2ObjectEntrySet();
        if (Log.ENABLED && Log.isLoggingEnabledFor(ConstantCanonicalizer.class)) {
            Long numOfCandidates = entries.stream().filter(a -> ((List)a.getValue()).size() > 1).count();
            Object2IntMap<Long> object2IntMap = this.histogramOfCanonicalizationCandidatesPerMethod;
            synchronized (object2IntMap) {
                int count = this.histogramOfCanonicalizationCandidatesPerMethod.getOrDefault(numOfCandidates, 0);
                this.histogramOfCanonicalizationCandidatesPerMethod.put(numOfCandidates, count + 1);
            }
        }
        entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(22L).forEach(entry -> {
            Instruction newConst;
            Instruction canonicalizedConstant = (Instruction)entry.getKey();
            assert (canonicalizedConstant.instructionTypeCanBeCanonicalized());
            switch (canonicalizedConstant.opcode()) {
                case 12: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstClassCanonicalization;
                    }
                    newConst = ConstClass.copyOf(code, canonicalizedConstant.asConstClass());
                    break;
                }
                case 15: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstNumberCanonicalization;
                    }
                    newConst = ConstNumber.copyOf(code, canonicalizedConstant.asConstNumber());
                    break;
                }
                case 16: {
                    if (Log.ENABLED) {
                        ++this.numberOfConstStringCanonicalization;
                    }
                    newConst = ConstString.copyOf(code, canonicalizedConstant.asConstString());
                    break;
                }
                case 20: {
                    if (Log.ENABLED) {
                        ++this.numberOfDexItemBasedConstStringCanonicalization;
                    }
                    newConst = DexItemBasedConstString.copyOf(code, canonicalizedConstant.asDexItemBasedConstString());
                    break;
                }
                case 57: {
                    if (Log.ENABLED) {
                        ++this.numberOfEnumCanonicalization;
                    }
                    newConst = StaticGet.copyOf(code, canonicalizedConstant.asStaticGet());
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
            newConst.setPosition(firstNonNonePosition);
            ConstantCanonicalizer.insertCanonicalizedConstant(code, newConst);
            for (Value outValue : (List)entry.getValue()) {
                outValue.replaceUsers(newConst.outValue());
            }
        });
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private static void insertCanonicalizedConstant(IRCode code, Instruction canonicalizedConstant) {
        BasicBlock entryBlock = code.entryBlock();
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedConstant);
    }

    private static boolean constantUsedByInvokeRange(Instruction constant) {
        for (Instruction user : constant.outValue().uniqueUsers()) {
            if (!user.isInvoke() || user.asInvoke().requiredArgumentRegisters() <= 5) continue;
            return true;
        }
        return false;
    }
}

