/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Supplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Suppliers;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.equivalence.BasicBlockBehavioralSubsumption;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.code.AlwaysMaterializingNop;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayLength;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.Binop;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DebugLocalWrite;
import shadow.bundletool.com.android.tools.r8.ir.code.DebugLocalsChange;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.IRMetadata;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceOf;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionOrPhi;
import shadow.bundletool.com.android.tools.r8.ir.code.IntSwitch;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Move;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayFilledData;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Switch;
import shadow.bundletool.com.android.tools.r8.ir.code.Throw;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.code.Xor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AssumeDynamicTypeRemover;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.SwitchCaseEliminator;
import shadow.bundletool.com.android.tools.r8.ir.optimize.SwitchUtils;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.InternalOutputMode;
import shadow.bundletool.com.android.tools.r8.utils.LongInterval;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class CodeRewriter {
    private static final int MAX_FILL_ARRAY_SIZE = 8192;
    private static final int STOP_SHARED_CONSTANT_THRESHOLD = 50;
    private static final int SELF_RECURSION_LIMIT = 4;
    public final IRConverter converter;
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;

    public CodeRewriter(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        this.options = appView.options();
        this.dexItemFactory = appView.dexItemFactory();
    }

    public static void insertAssumeInstructions(IRCode code, Collection<Assumer> assumers) {
        for (Assumer assumer : assumers) {
            assumer.insertAssumeInstructions(code);
            assert (code.isConsistentSSA());
        }
    }

    public static void removeAssumeInstructions(AppView<?> appView, IRCode code) {
        Set<Value> valuesThatRequireWidening = Sets.newIdentityHashSet();
        InstructionListIterator it = code.instructionListIterator();
        boolean needToCheckTrivialPhis = false;
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isAssume()) continue;
            Assume<?> assumeInstruction = instruction.asAssume();
            Value src = assumeInstruction.src();
            Value dest = assumeInstruction.outValue();
            valuesThatRequireWidening.addAll(dest.affectedValues());
            needToCheckTrivialPhis |= dest.numberOfPhiUsers() > 0;
            dest.replaceUsers(src);
            it.remove();
        }
        if (needToCheckTrivialPhis) {
            code.removeAllTrivialPhis(valuesThatRequireWidening);
        }
        if (!valuesThatRequireWidening.isEmpty()) {
            new TypeAnalysis(appView).widening(valuesThatRequireWidening);
        }
        assert (Streams.stream(code.instructions()).noneMatch(Instruction::isAssume));
    }

    private static boolean removedTrivialGotos(IRCode code) {
        BasicBlock nextBlock;
        ListIterator<BasicBlock> iterator2 = code.listIterator();
        assert (iterator2.hasNext());
        BasicBlock block = iterator2.next();
        do {
            nextBlock = iterator2.hasNext() ? iterator2.next() : null;
            BasicBlock blk = block;
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() == block || code.entryBlock() == block || block.getPredecessors().stream().anyMatch(b -> b.exit().fallthroughBlock() == blk));
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() != nextBlock);
        } while ((block = nextBlock) != null);
        return true;
    }

    public void rewriteThrowNullPointerException(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction instruction3;
                InvokeDirect invokeDirect;
                Instruction instruction2;
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != this.dexItemFactory.npeType || instruction.outValue().numberOfAllUsers() != 2 || instruction.outValue().hasLocalInfo() || !instruction.getDebugValues().isEmpty() || !it.hasNext() || !(instruction2 = (Instruction)it.next()).isInvokeDirect() || !instruction2.getDebugValues().isEmpty() || (invokeDirect = instruction2.asInvokeDirect()).getInvokedMethod() != this.dexItemFactory.npeMethods.init || invokeDirect.getReceiver() != instruction.outValue() || invokeDirect.arguments().size() != 1 || invokeDirect.getPosition() != instruction.getPosition() || !it.hasNext() || !(instruction3 = (Instruction)it.next()).isThrow() || instruction3.asThrow().exception() != instruction.outValue()) continue;
                ConstNumber nullPointer = code.createConstNull();
                Throw throwInstruction = new Throw(nullPointer.outValue());
                assert (instruction.getPosition() == instruction2.getPosition());
                nullPointer.setPosition(instruction.getPosition());
                throwInstruction.setPosition(instruction3.getPosition());
                instruction3.moveDebugValues(throwInstruction);
                it.remove();
                it.previous();
                it.remove();
                it.previous();
                it.remove();
                it.add(nullPointer);
                it.add(throwInstruction);
            }
        }
        assert (code.isConsistentSSA());
    }

    public static boolean isFallthroughBlock(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }

    private static void collapseTrivialGoto(IRCode code, BasicBlock block, BasicBlock nextBlock, List<BasicBlock> blocksToRemove) {
        if (block.exit().asGoto().getTarget() == block) {
            return;
        }
        BasicBlock target = block.endOfGotoChain();
        boolean needed = false;
        if (target == null) {
            target = block.exit().asGoto().getTarget();
        }
        if (target != nextBlock) {
            boolean bl = needed = code.entryBlock() == block || CodeRewriter.isFallthroughBlock(block);
        }
        if (!needed) {
            blocksToRemove.add(block);
            CodeRewriter.unlinkTrivialGotoBlock(block, target);
        }
    }

    public static void unlinkTrivialGotoBlock(BasicBlock block, BasicBlock target) {
        assert (block.isTrivialGoto());
        for (BasicBlock pred : block.getPredecessors()) {
            pred.replaceSuccessor(block, target);
        }
        for (BasicBlock succ : block.getSuccessors()) {
            succ.getMutablePredecessors().remove(block);
        }
        for (BasicBlock pred : block.getPredecessors()) {
            if (target.getPredecessors().contains(pred)) continue;
            target.getMutablePredecessors().add(pred);
        }
    }

    private static void collapseIfTrueTarget(BasicBlock block) {
        If insn = block.exit().asIf();
        BasicBlock target = insn.getTrueTarget();
        BasicBlock newTarget = target.endOfGotoChain();
        BasicBlock fallthrough = insn.fallthroughBlock();
        BasicBlock newFallthrough = fallthrough.endOfGotoChain();
        if (newTarget != null && target != newTarget) {
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getMutablePredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getMutablePredecessors().add(block);
            }
        }
        if (block.exit().isIf() && (insn = block.exit().asIf()).getTrueTarget() == newFallthrough) {
            block.replaceSuccessor(insn.getTrueTarget(), fallthrough);
            assert (block.exit().isGoto());
            assert (block.exit().asGoto().getTarget() == fallthrough);
        }
    }

    private static void collapseNonFallthroughSwitchTargets(BasicBlock block) {
        Switch insn = block.exit().asSwitch();
        BasicBlock fallthroughBlock = insn.fallthroughBlock();
        HashSet<BasicBlock> replacedBlocks = new HashSet<BasicBlock>();
        for (int j = 0; j < insn.targetBlockIndices().length; ++j) {
            BasicBlock newTarget;
            BasicBlock target = insn.targetBlock(j);
            if (target == fallthroughBlock || (newTarget = target.endOfGotoChain()) == null || target == newTarget || replacedBlocks.contains(target)) continue;
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getMutablePredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getMutablePredecessors().add(block);
            }
            replacedBlocks.add(target);
        }
    }

    public static void disableDex2OatInliningForSelfRecursiveMethods(AppView<?> appView, IRCode code) {
        if (!appView.options().canHaveDex2OatInliningIssue() || code.hasCatchHandlers()) {
            return;
        }
        int selfRecursionFanOut = 0;
        Instruction lastSelfRecursiveCall = null;
        for (Instruction i : code.instructions()) {
            if (!i.isInvokeMethod() || i.asInvokeMethod().getInvokedMethod() != code.method.method) continue;
            ++selfRecursionFanOut;
            lastSelfRecursiveCall = i;
        }
        if (selfRecursionFanOut > 4) {
            assert (lastSelfRecursiveCall != null);
            InstructionListIterator splitIterator = lastSelfRecursiveCall.getBlock().listIterator(code, lastSelfRecursiveCall);
            splitIterator.previous();
            BasicBlock newBlock = splitIterator.split(code, 1);
            DexType guard = appView.dexItemFactory().throwableType;
            BasicBlock rethrowBlock = BasicBlock.createRethrowBlock(code, lastSelfRecursiveCall.getPosition(), guard, appView);
            code.blocks.add(rethrowBlock);
            newBlock.appendCatchHandler(rethrowBlock, guard);
        }
    }

    private void convertSwitchToSwitchAndIfs(IRCode code, ListIterator<BasicBlock> blocksIterator, BasicBlock originalBlock, InstructionListIterator iterator2, IntSwitch theSwitch, List<IntList> switches, IntList keysToRemove) {
        int i;
        Position position = theSwitch.getPosition();
        Int2ReferenceSortedMap<BasicBlock> keyToTarget = theSwitch.getKeyToTargetMap();
        BasicBlock fallthroughBlock = theSwitch.fallthroughBlock();
        iterator2.previous();
        BasicBlock originalSwitchBlock = iterator2.split(code, blocksIterator);
        assert (!originalSwitchBlock.hasCatchHandlers());
        assert (originalSwitchBlock.getInstructions().size() == 1);
        assert (originalBlock.exit().isGoto());
        theSwitch.moveDebugValues(originalBlock.exit());
        blocksIterator.remove();
        theSwitch.getBlock().detachAllSuccessors();
        BasicBlock block = theSwitch.getBlock().unlinkSinglePredecessor();
        assert (theSwitch.getBlock().getPredecessors().size() == 0);
        assert (theSwitch.getBlock().getSuccessors().size() == 0);
        assert (block == originalBlock);
        int nextBlockNumber = code.getHighestBlockNumber() + 1;
        LinkedList<BasicBlock> newBlocks = new LinkedList<BasicBlock>();
        for (i = switches.size() - 1; i >= 0; --i) {
            SwitchBuilder switchBuilder = new SwitchBuilder(position);
            switchBuilder.setValue(theSwitch.value());
            IntList keys2 = switches.get(i);
            for (int j = 0; j < keys2.size(); ++j) {
                int key = keys2.getInt(j);
                switchBuilder.addKeyAndTarget(key, (BasicBlock)keyToTarget.get(key));
            }
            switchBuilder.setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock newSwitchBlock = switchBuilder.build(code.metadata());
            newBlocks.addFirst(newSwitchBlock);
            fallthroughBlock = newSwitchBlock;
        }
        for (i = keysToRemove.size() - 1; i >= 0; --i) {
            int key = keysToRemove.getInt(i);
            BasicBlock peeledOffTarget = (BasicBlock)keyToTarget.get(key);
            IfBuilder ifBuilder = new IfBuilder(position, code);
            ifBuilder.setLeft(theSwitch.value()).setRight(key).setTarget(peeledOffTarget).setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock ifBlock = ifBuilder.build();
            newBlocks.addFirst(ifBlock);
            fallthroughBlock = ifBlock;
        }
        originalBlock.link(fallthroughBlock);
        newBlocks.forEach(blocksIterator::add);
    }

    private Interval combineOrAddInterval(List<Interval> intervals, Interval previous, Interval current) {
        int penalty;
        InternalOutputMode mode = this.options.getInternalOutputMode();
        int n = penalty = mode.isGeneratingClassFiles() ? 4 : 0;
        if (previous == null) {
            intervals.add(current);
            return current;
        }
        Interval combined = new Interval(previous.keys, current.keys);
        long packedSavings = combined.packedSavings(mode);
        if (packedSavings <= 0L || packedSavings < previous.estimatedSize(mode) + current.estimatedSize(mode) - (long)penalty) {
            intervals.add(current);
            return current;
        }
        intervals.set(intervals.size() - 1, combined);
        return combined;
    }

    private void tryAddToBiggestSavings(Set<Interval> biggestPackedSet, PriorityQueue<Interval> intervals, Interval toAdd, int maximumNumberOfSwitches) {
        assert (!biggestPackedSet.contains(toAdd));
        long savings = toAdd.packedSavings(this.options.getInternalOutputMode());
        if (savings <= 0L) {
            return;
        }
        if (intervals.size() < maximumNumberOfSwitches) {
            intervals.add(toAdd);
            biggestPackedSet.add(toAdd);
        } else if (savings > intervals.peek().packedSavings(this.options.getInternalOutputMode())) {
            intervals.add(toAdd);
            biggestPackedSet.add(toAdd);
            biggestPackedSet.remove(intervals.poll());
        }
    }

    private int sizeForKeysWrittenAsIfs(ValueType type, Collection<Integer> keys2) {
        int ifsSize = If.estimatedSize(this.options.getInternalOutputMode()) * keys2.size();
        if (this.options.getInternalOutputMode().isGeneratingClassFiles()) {
            ifsSize += keys2.size() * 4;
        }
        for (int k : keys2) {
            if (k == 0) continue;
            ifsSize += ConstNumber.estimatedSize(this.options.getInternalOutputMode(), type, k);
        }
        return ifsSize;
    }

    private int codeUnitMargin() {
        return this.options.getInternalOutputMode().isGeneratingClassFiles() ? 3 : 1;
    }

    private int findIfsForCandidates(List<Interval> newSwitches, IntSwitch theSwitch, IntList outliers) {
        HashSet<Interval> switchesToRemove = new HashSet<Interval>();
        InternalOutputMode mode = this.options.getInternalOutputMode();
        int outliersAsIfSize = 0;
        for (Interval candidate : newSwitches) {
            int maxIfBudget = 10;
            long switchSize = candidate.estimatedSize(mode);
            int sizeOfAllKeysAsIf = this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), candidate.keys);
            if (candidate.keys.size() <= maxIfBudget && (long)sizeOfAllKeysAsIf < switchSize - (long)this.codeUnitMargin()) {
                outliersAsIfSize += sizeOfAllKeysAsIf;
                switchesToRemove.add(candidate);
                outliers.addAll(candidate.keys);
                continue;
            }
            IntList candidateKeys = candidate.keys;
            int smallestPosition = -1;
            long smallest = Long.MAX_VALUE;
            for (int i = 0; i < candidateKeys.size(); ++i) {
                long current = Math.abs((long)candidateKeys.getInt(i));
                if (current >= smallest) continue;
                smallestPosition = i;
                smallest = current;
            }
            IntArrayList ifKeys = new IntArrayList();
            ifKeys.add(candidateKeys.getInt(smallestPosition));
            long previousSavings = 0L;
            long currentSavings = switchSize - (long)this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys) - IntSwitch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            int minIndex = smallestPosition - 1;
            int maxIndex = smallestPosition + 1;
            while (ifKeys.size() < maxIfBudget && currentSavings > previousSavings) {
                if (minIndex >= 0 && maxIndex < candidateKeys.size()) {
                    long valMin = Math.abs((long)candidateKeys.getInt(minIndex));
                    int valMax = Math.abs(candidateKeys.getInt(maxIndex));
                    if ((long)valMax <= valMin) {
                        ifKeys.add(candidateKeys.getInt(maxIndex++));
                    } else {
                        ifKeys.add(candidateKeys.getInt(minIndex--));
                    }
                } else if (minIndex >= 0) {
                    ifKeys.add(candidateKeys.getInt(minIndex--));
                } else {
                    if (maxIndex >= candidateKeys.size()) break;
                    ifKeys.add(candidateKeys.getInt(maxIndex++));
                }
                previousSavings = currentSavings;
                currentSavings = switchSize - (long)this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys) - IntSwitch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            }
            if (previousSavings >= currentSavings) {
                int lastKey = ifKeys.getInt(ifKeys.size() - 1);
                ifKeys.removeInt(ifKeys.size() - 1);
                if (lastKey == candidateKeys.getInt(minIndex + 1)) {
                    ++minIndex;
                } else {
                    --maxIndex;
                }
            }
            ++minIndex;
            --maxIndex;
            if (ifKeys.size() <= 0) continue;
            int ifsSize = this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys);
            long newSwitchSize = IntSwitch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            if (newSwitchSize + (long)ifsSize + (long)this.codeUnitMargin() >= switchSize) continue;
            candidateKeys.removeElements(minIndex, maxIndex);
            outliers.addAll(ifKeys);
            outliersAsIfSize += ifsSize;
        }
        newSwitches.removeAll(switchesToRemove);
        return outliersAsIfSize;
    }

    private boolean rewriteSwitch(IRCode code) {
        Set<Object> affectedValues;
        if (!code.metadata().mayHaveIntSwitch()) {
            return false;
        }
        boolean needToRemoveUnreachableBlocks = false;
        ListIterator<BasicBlock> blocksIterator = code.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = blocksIterator.next();
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                SwitchCaseEliminator eliminator;
                Instruction instruction = (Instruction)iterator2.next();
                if (!instruction.isIntSwitch()) continue;
                IntSwitch theSwitch = instruction.asIntSwitch();
                if (this.options.testing.enableDeadSwitchCaseElimination && (eliminator = this.removeUnnecessarySwitchCases(code, theSwitch, iterator2)) != null) {
                    if (eliminator.mayHaveIntroducedUnreachableBlocks()) {
                        needToRemoveUnreachableBlocks = true;
                    }
                    iterator2.previous();
                    instruction = (Instruction)iterator2.next();
                    if (instruction.isGoto()) continue;
                    assert (instruction.isIntSwitch());
                    theSwitch = instruction.asIntSwitch();
                }
                if (theSwitch.numberOfKeys() == 1) {
                    int caseBlockIndex;
                    int fallthroughBlockIndex = theSwitch.getFallthroughBlockIndex();
                    if (fallthroughBlockIndex < (caseBlockIndex = theSwitch.targetBlockIndices()[0])) {
                        block.swapSuccessorsByIndex(fallthroughBlockIndex, caseBlockIndex);
                    }
                    if (theSwitch.getFirstKey() == 0) {
                        iterator2.replaceCurrentInstruction(new If(If.Type.EQ, theSwitch.value()));
                        continue;
                    }
                    ConstNumber labelConst = code.createIntConstant(theSwitch.getFirstKey());
                    labelConst.setPosition(theSwitch.getPosition());
                    iterator2.previous();
                    iterator2.add(labelConst);
                    Instruction dummy = (Instruction)iterator2.next();
                    assert (dummy == theSwitch);
                    If theIf = new If(If.Type.EQ, ImmutableList.of(theSwitch.value(), labelConst.dest()));
                    iterator2.replaceCurrentInstruction(theIf);
                    continue;
                }
                InternalOutputMode mode = this.options.getInternalOutputMode();
                int[] keys2 = theSwitch.getKeys();
                int maxNumberOfIfsOrSwitches = 10;
                PriorityQueue<Interval> biggestPackedSavings = new PriorityQueue<Interval>((x, y) -> Long.compare(y.packedSavings(mode), x.packedSavings(mode)));
                HashSet<Interval> biggestPackedSet = new HashSet<Interval>();
                ArrayList<Interval> intervals = new ArrayList<Interval>();
                int previousKey = keys2[0];
                IntArrayList currentKeys = new IntArrayList();
                currentKeys.add(previousKey);
                Interval previousInterval = null;
                for (int i = 1; i < keys2.length; ++i) {
                    int key = keys2[i];
                    if ((long)key - (long)previousKey > 1L) {
                        Interval current = new Interval(currentKeys);
                        Interval added = this.combineOrAddInterval(intervals, previousInterval, current);
                        if (added != current && biggestPackedSet.contains(previousInterval)) {
                            biggestPackedSet.remove(previousInterval);
                            biggestPackedSavings.remove(previousInterval);
                        }
                        this.tryAddToBiggestSavings(biggestPackedSet, biggestPackedSavings, added, maxNumberOfIfsOrSwitches);
                        previousInterval = added;
                        currentKeys = new IntArrayList();
                    }
                    currentKeys.add(key);
                    previousKey = key;
                }
                Interval current = new Interval(currentKeys);
                Interval added = this.combineOrAddInterval(intervals, previousInterval, current);
                if (added != current && biggestPackedSet.contains(previousInterval)) {
                    biggestPackedSet.remove(previousInterval);
                    biggestPackedSavings.remove(previousInterval);
                }
                this.tryAddToBiggestSavings(biggestPackedSet, biggestPackedSavings, added, maxNumberOfIfsOrSwitches);
                if (biggestPackedSet.size() == maxNumberOfIfsOrSwitches && maxNumberOfIfsOrSwitches < intervals.size()) {
                    biggestPackedSet.remove(biggestPackedSavings.poll());
                }
                Interval sparse = null;
                ArrayList<Interval> newSwitches = new ArrayList<Interval>(maxNumberOfIfsOrSwitches);
                for (int i = 0; i < intervals.size(); ++i) {
                    Interval interval = (Interval)intervals.get(i);
                    if (biggestPackedSet.contains(interval)) {
                        newSwitches.add(interval);
                        continue;
                    }
                    if (sparse == null) {
                        sparse = interval;
                        newSwitches.add(sparse);
                        continue;
                    }
                    sparse.addInterval(interval);
                }
                IntArrayList outliers = new IntArrayList();
                int outliersAsIfSize = this.appView.options().testing.enableSwitchToIfRewriting ? this.findIfsForCandidates(newSwitches, theSwitch, outliers) : 0;
                long newSwitchesSize = 0L;
                ArrayList<IntList> newSwitchSequences = new ArrayList<IntList>(newSwitches.size());
                for (Interval interval : newSwitches) {
                    newSwitchesSize += interval.estimatedSize(mode);
                    newSwitchSequences.add(interval.keys);
                }
                long currentSize = IntSwitch.estimatedSize(mode, theSwitch.getKeys());
                if (newSwitchesSize + (long)outliersAsIfSize + (long)this.codeUnitMargin() >= currentSize) continue;
                this.convertSwitchToSwitchAndIfs(code, blocksIterator, block, iterator2, theSwitch, newSwitchSequences, outliers);
            }
        }
        code.splitCriticalEdges();
        Set<Object> set = affectedValues = needToRemoveUnreachableBlocks ? code.removeUnreachableBlocks() : ImmutableSet.of();
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
        return !affectedValues.isEmpty();
    }

    private SwitchCaseEliminator removeUnnecessarySwitchCases(IRCode code, IntSwitch theSwitch, InstructionListIterator iterator2) {
        BasicBlock defaultTarget = theSwitch.fallthroughBlock();
        SwitchCaseEliminator eliminator = null;
        BasicBlockBehavioralSubsumption behavioralSubsumption = new BasicBlockBehavioralSubsumption(this.appView, code.method.method.holder);
        for (int i = 0; i < theSwitch.numberOfKeys(); ++i) {
            BasicBlock targetBlock = theSwitch.targetBlock(i);
            if (!this.switchCaseIsUnreachable(theSwitch, i) && !behavioralSubsumption.isSubsumedBy(targetBlock, defaultTarget)) continue;
            if (eliminator == null) {
                eliminator = new SwitchCaseEliminator(theSwitch, iterator2);
            }
            eliminator.markSwitchCaseForRemoval(i);
        }
        if (eliminator != null) {
            eliminator.optimize();
        }
        return eliminator;
    }

    private boolean switchCaseIsUnreachable(IntSwitch theSwitch, int index) {
        Value switchValue = theSwitch.value();
        return switchValue.hasValueRange() && !switchValue.getValueRange().containsValue(theSwitch.getKey(index));
    }

    public void removeSwitchMaps(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Instruction staticGet;
            IntSwitch switchInsn;
            SwitchUtils.EnumSwitchInfo info;
            JumpInstruction exit = block.exit();
            if (!exit.isIntSwitch() || (info = SwitchUtils.analyzeSwitchOverEnum(switchInsn = exit.asIntSwitch(), this.appView.withLiveness())) == null) continue;
            Int2IntArrayMap targetMap = new Int2IntArrayMap();
            for (int i = 0; i < switchInsn.numberOfKeys(); ++i) {
                assert (switchInsn.targetBlockIndices()[i] != switchInsn.getFallthroughBlockIndex());
                AppInfoWithLiveness.EnumValueInfo valueInfo = info.valueInfoMap.get(info.indexMap.get(switchInsn.getKey(i)));
                targetMap.put(valueInfo.ordinal, switchInsn.targetBlockIndices()[i]);
            }
            int[] keys2 = targetMap.keySet().toIntArray();
            Arrays.sort(keys2);
            int[] targets = new int[keys2.length];
            for (int i = 0; i < keys2.length; ++i) {
                targets[i] = targetMap.get(keys2[i]);
            }
            IntSwitch newSwitch = new IntSwitch(info.ordinalInvoke.outValue(), keys2, targets, switchInsn.getFallthroughBlockIndex());
            exit.replace(newSwitch, code);
            Instruction arrayGet = info.arrayGet;
            if (!arrayGet.outValue().hasUsers()) {
                arrayGet.inValues().forEach(v -> v.removeUser(arrayGet));
                arrayGet.getBlock().removeInstruction(arrayGet);
            }
            if ((staticGet = info.staticGet).outValue().hasUsers()) continue;
            assert (staticGet.inValues().isEmpty());
            staticGet.getBlock().removeInstruction(staticGet);
        }
    }

    public static void collapseTrivialGotos(IRCode code) {
        BasicBlock nextBlock;
        assert (code.isConsistentGraph());
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> iterator2 = code.listIterator();
        assert (iterator2.hasNext());
        BasicBlock block = iterator2.next();
        do {
            BasicBlock basicBlock = nextBlock = iterator2.hasNext() ? iterator2.next() : null;
            if (block.isTrivialGoto()) {
                CodeRewriter.collapseTrivialGoto(code, block, nextBlock, blocksToRemove);
            }
            if (block.exit().isIf()) {
                CodeRewriter.collapseIfTrueTarget(block);
            }
            if (block.exit().isSwitch()) {
                CodeRewriter.collapseNonFallthroughSwitchTargets(block);
            }
            block = nextBlock;
        } while (nextBlock != null);
        code.removeBlocks(blocksToRemove);
        while (!blocksToRemove.isEmpty()) {
            blocksToRemove = new ArrayList();
            iterator2 = code.listIterator();
            block = iterator2.next();
            do {
                BasicBlock basicBlock = nextBlock = iterator2.hasNext() ? iterator2.next() : null;
                if (!block.isTrivialGoto()) continue;
                CodeRewriter.collapseTrivialGoto(code, block, nextBlock, blocksToRemove);
            } while ((block = nextBlock) != null);
            code.removeBlocks(blocksToRemove);
        }
        assert (CodeRewriter.removedTrivialGotos(code));
        assert (code.isConsistentGraph());
    }

    private boolean checkArgumentType(InvokeMethod invoke, int argumentIndex) {
        TypeLatticeElement returnType = TypeLatticeElement.fromDexType(invoke.getInvokedMethod().proto.returnType, Nullability.maybeNull(), this.appView);
        TypeLatticeElement argumentType = TypeLatticeElement.fromDexType(this.getArgumentType(invoke, argumentIndex), Nullability.maybeNull(), this.appView);
        return this.appView.enableWholeProgramOptimizations() ? argumentType.lessThanOrEqual(returnType, this.appView) : argumentType.equals(returnType);
    }

    private DexType getArgumentType(InvokeMethod invoke, int argumentIndex) {
        if (invoke.isInvokeStatic()) {
            return invoke.getInvokedMethod().proto.parameters.values[argumentIndex];
        }
        if (argumentIndex == 0) {
            return invoke.getInvokedMethod().holder;
        }
        return invoke.getInvokedMethod().proto.parameters.values[argumentIndex - 1];
    }

    public void rewriteMoveResult(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        AssumeDynamicTypeRemover assumeDynamicTypeRemover = new AssumeDynamicTypeRemover(this.appView, code);
        boolean mayHaveRemovedTrivialPhi = false;
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        Set<BasicBlock> blocksToBeRemoved = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocksToBeRemoved.contains(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                int argumentIndex;
                DexEncodedMethod target;
                Instruction current = (Instruction)iterator2.next();
                if (!current.isInvokeMethod()) continue;
                InvokeMethod invoke = current.asInvokeMethod();
                Value outValue = invoke.outValue();
                if (invoke.getInvokedMethod() == this.dexItemFactory.objectsMethods.requireNonNull) {
                    Value obj = invoke.arguments().get(0);
                    if (outValue == null && obj.hasLocalInfo() || outValue != null && !obj.hasSameOrNoLocal(outValue)) continue;
                    Nullability nullability = obj.getTypeLattice().nullability();
                    if (nullability.isDefinitelyNotNull()) {
                        if (outValue != null) {
                            affectedValues.addAll(outValue.affectedValues());
                            mayHaveRemovedTrivialPhi |= outValue.numberOfPhiUsers() > 0;
                            outValue.replaceUsers(obj);
                        }
                        iterator2.removeOrReplaceByDebugLocalRead();
                        continue;
                    }
                    if (!obj.isAlwaysNull(this.appView) || !((AppInfo)this.appView.appInfo()).hasSubtyping()) continue;
                    iterator2.replaceCurrentInstructionWithThrowNull(this.appView.withSubtyping(), code, blockIterator, blocksToBeRemoved, affectedValues);
                    continue;
                }
                if (outValue == null || outValue.hasLocalInfo()) continue;
                if (this.appView.dexItemFactory().libraryMethodsReturningReceiver.contains(invoke.getInvokedMethod())) {
                    if (!this.checkArgumentType(invoke, 0)) continue;
                    affectedValues.addAll(outValue.affectedValues());
                    assumeDynamicTypeRemover.markUsersForRemoval(invoke.outValue());
                    mayHaveRemovedTrivialPhi |= outValue.numberOfPhiUsers() > 0;
                    outValue.replaceUsers(invoke.arguments().get(0));
                    invoke.setOutValue(null);
                    continue;
                }
                if (!((AppInfo)this.appView.appInfo()).hasLiveness() || (target = invoke.lookupSingleTarget(this.appView.withLiveness(), code.method.method.holder)) == null || !target.getOptimizationInfo().returnsArgument() || (argumentIndex = target.getOptimizationInfo().getReturnedArgument()) < 0 || !this.checkArgumentType(invoke, argumentIndex)) continue;
                Value argument = invoke.arguments().get(argumentIndex);
                assert (outValue.verifyCompatible(argument.outType()));
                if (!argument.getTypeLattice().lessThanOrEqual(outValue.getTypeLattice(), this.appView)) continue;
                affectedValues.addAll(outValue.affectedValues());
                assumeDynamicTypeRemover.markUsersForRemoval(outValue);
                mayHaveRemovedTrivialPhi |= outValue.numberOfPhiUsers() > 0;
                outValue.replaceUsers(argument);
                invoke.setOutValue(null);
            }
        }
        assumeDynamicTypeRemover.removeMarkedInstructions(blocksToBeRemoved);
        assumeDynamicTypeRemover.finish();
        if (!blocksToBeRemoved.isEmpty()) {
            code.removeBlocks(blocksToBeRemoved);
            code.removeAllTrivialPhis(affectedValues);
            assert (code.getUnreachableBlocks().isEmpty());
        } else if (mayHaveRemovedTrivialPhi || assumeDynamicTypeRemover.mayHaveIntroducedTrivialPhi()) {
            code.removeAllTrivialPhis(affectedValues);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    public void removeTrivialCheckCastAndInstanceOfInstructions(IRCode code) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            return;
        }
        if (!this.appView.options().testing.enableCheckCastAndInstanceOfRemoval) {
            return;
        }
        IRMetadata metadata = code.metadata();
        if (!metadata.mayHaveCheckCast() && !metadata.mayHaveInstanceOf()) {
            return;
        }
        TypeAnalysis typeAnalysis = new TypeAnalysis(this.appView);
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator it = code.instructionListIterator();
        boolean needToRemoveTrivialPhis = false;
        while (it.hasNext()) {
            boolean hasPhiUsers;
            Instruction current = (Instruction)it.next();
            if (current.isCheckCast()) {
                hasPhiUsers = current.outValue().hasPhiUsers();
                RemoveCheckCastInstructionIfTrivialResult removeResult = this.removeCheckCastInstructionIfTrivial(current.asCheckCast(), it, code, affectedValues);
                if (removeResult == RemoveCheckCastInstructionIfTrivialResult.NO_REMOVALS) continue;
                assert (removeResult == RemoveCheckCastInstructionIfTrivialResult.REMOVED_CAST_DO_NARROW);
                needToRemoveTrivialPhis |= hasPhiUsers;
                typeAnalysis.narrowing(affectedValues);
                affectedValues.clear();
                continue;
            }
            if (!current.isInstanceOf()) continue;
            hasPhiUsers = current.outValue().hasPhiUsers();
            if (!this.removeInstanceOfInstructionIfTrivial(current.asInstanceOf(), it, code)) continue;
            needToRemoveTrivialPhis |= hasPhiUsers;
        }
        if (needToRemoveTrivialPhis) {
            code.removeAllTrivialPhis(affectedValues);
            if (!affectedValues.isEmpty()) {
                typeAnalysis.narrowing(affectedValues);
            }
        }
        assert (code.isConsistentSSA());
    }

    private RemoveCheckCastInstructionIfTrivialResult removeCheckCastInstructionIfTrivial(CheckCast checkCast, InstructionListIterator it, IRCode code, Set<Value> affectedValues) {
        Value inValue = checkCast.object();
        Value outValue = checkCast.outValue();
        DexType castType = checkCast.getType();
        if (!MemberRebindingAnalysis.isTypeVisibleFromContext(this.appView, code.method.method.holder, castType)) {
            return RemoveCheckCastInstructionIfTrivialResult.NO_REMOVALS;
        }
        if (this.options.canHaveArtCheckCastVerifierBug() && inValue.getTypeLattice().isNullType() && castType.isArrayType() && castType.toBaseType(this.dexItemFactory).isFloatType()) {
            return RemoveCheckCastInstructionIfTrivialResult.NO_REMOVALS;
        }
        TypeLatticeElement inTypeLattice = inValue.getTypeLattice();
        TypeLatticeElement outTypeLattice = outValue.getTypeLattice();
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, inTypeLattice.nullability(), this.appView);
        assert (inTypeLattice.nullability().lessThanOrEqual(outTypeLattice.nullability()));
        if (inTypeLattice.lessThanOrEqual(castTypeLattice, this.appView)) {
            assert (inTypeLattice.lessThanOrEqual(outTypeLattice, this.appView));
            CodeRewriter.removeOrReplaceByDebugLocalWrite(checkCast, it, inValue, outValue);
            affectedValues.addAll(inValue.affectedValues());
            return RemoveCheckCastInstructionIfTrivialResult.REMOVED_CAST_DO_NARROW;
        }
        assert (!inTypeLattice.isDefinitelyNull());
        assert (outTypeLattice.equalUpToNullability(castTypeLattice));
        return RemoveCheckCastInstructionIfTrivialResult.NO_REMOVALS;
    }

    private boolean removeInstanceOfInstructionIfTrivial(InstanceOf instanceOf, InstructionListIterator it, IRCode code) {
        if (!MemberRebindingAnalysis.isTypeVisibleFromContext(this.appView, code.method.method.holder, instanceOf.type())) {
            return false;
        }
        Value inValue = instanceOf.value();
        TypeLatticeElement inType = inValue.getTypeLattice();
        TypeLatticeElement instanceOfType = TypeLatticeElement.fromDexType(instanceOf.type(), inType.nullability(), this.appView);
        Value aliasValue = inValue.getAliasedValue();
        InstanceOfResult result = InstanceOfResult.UNKNOWN;
        if (inType.isDefinitelyNull()) {
            result = InstanceOfResult.FALSE;
        } else if (inType.lessThanOrEqual(instanceOfType, this.appView) && !inType.isNullable()) {
            result = InstanceOfResult.TRUE;
        } else if (!aliasValue.isPhi() && aliasValue.definition.isCreatingInstanceOrArray() && instanceOfType.strictlyLessThan(inType, this.appView)) {
            result = InstanceOfResult.FALSE;
        } else if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
            Value aliasedValue;
            if (instanceOf.type().isClassType() && this.isNeverInstantiatedDirectlyOrIndirectly(instanceOf.type())) {
                result = InstanceOfResult.FALSE;
            }
            if (result == InstanceOfResult.UNKNOWN && inType.isClassType() && this.isNeverInstantiatedDirectlyOrIndirectly(inType.asClassTypeLatticeElement().getClassType())) {
                result = InstanceOfResult.FALSE;
            }
            if (result == InstanceOfResult.UNKNOWN && (aliasedValue = inValue.getSpecificAliasedValue(value -> !value.isPhi() && value.definition.isAssumeDynamicType())) != null) {
                TypeLatticeElement dynamicType = aliasedValue.definition.asAssumeDynamicType().getAssumption().getDynamicUpperBoundType();
                if (dynamicType.isDefinitelyNull()) {
                    result = InstanceOfResult.FALSE;
                } else if (!(!dynamicType.lessThanOrEqual(instanceOfType, this.appView) || inType.isNullable() && dynamicType.isNullable())) {
                    result = InstanceOfResult.TRUE;
                }
            }
        }
        if (result != InstanceOfResult.UNKNOWN) {
            ConstNumber newInstruction = new ConstNumber(new Value(code.valueNumberGenerator.next(), TypeLatticeElement.INT, instanceOf.outValue().getLocalInfo()), result == InstanceOfResult.TRUE ? 1L : 0L);
            it.replaceCurrentInstruction(newInstruction);
            return true;
        }
        return false;
    }

    private boolean isNeverInstantiatedDirectlyOrIndirectly(DexType type) {
        assert (((AppInfo)this.appView.appInfo()).hasLiveness());
        assert (type.isClassType());
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(type));
        return clazz != null && !((AppInfo)this.appView.appInfo()).withLiveness().isInstantiatedDirectlyOrIndirectly(clazz);
    }

    public static void removeOrReplaceByDebugLocalWrite(Instruction currentInstruction, InstructionListIterator it, Value inValue, Value outValue) {
        if (outValue.hasLocalInfo() && outValue.getLocalInfo() != inValue.getLocalInfo()) {
            DebugLocalWrite debugLocalWrite = new DebugLocalWrite(outValue, inValue);
            it.replaceCurrentInstruction(debugLocalWrite);
        } else {
            if (outValue.hasLocalInfo()) {
                assert (outValue.getLocalInfo() == inValue.getLocalInfo());
                currentInstruction.removeDebugValue(outValue.getLocalInfo());
            }
            outValue.replaceUsers(inValue);
            it.removeOrReplaceByDebugLocalRead();
        }
    }

    public void splitRangeInvokeConstants(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isInvoke() || current.asInvoke().requiredArgumentRegisters() <= 5) continue;
                Invoke invoke = current.asInvoke();
                it.previous();
                IdentityHashMap<ConstNumber, ConstNumber> oldToNew = new IdentityHashMap<ConstNumber, ConstNumber>();
                for (int i = 0; i < invoke.inValues().size(); ++i) {
                    Value value = invoke.inValues().get(i);
                    if (!value.isConstNumber() || value.numberOfUsers() <= 1) continue;
                    ConstNumber definition = value.getConstInstruction().asConstNumber();
                    Value originalValue = definition.outValue();
                    ConstNumber newNumber = (ConstNumber)oldToNew.get(definition);
                    if (newNumber == null) {
                        newNumber = ConstNumber.copyOf(code, definition);
                        it.add(newNumber);
                        newNumber.setPosition(current.getPosition());
                        oldToNew.put(definition, newNumber);
                    }
                    invoke.inValues().set(i, newNumber.outValue());
                    originalValue.removeUser(invoke);
                    newNumber.outValue().addUser(invoke);
                }
                it.next();
            }
        }
        assert (code.isConsistentSSA());
    }

    public void useDedicatedConstantForLitInstruction(IRCode code) {
        if (!code.metadata().mayHaveArithmeticOrLogicalBinop()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            Instruction currentInstruction;
            InstructionListIterator instructionIterator = block.listIterator(code);
            Set<Value> binopsWithLit8OrLit16NonConstantValues = Sets.newIdentityHashSet();
            while (instructionIterator.hasNext()) {
                Instruction currentInstruction2 = (Instruction)instructionIterator.next();
                if (!CodeRewriter.isBinopWithLit8OrLit16(currentInstruction2)) continue;
                Value value = CodeRewriter.binopWithLit8OrLit16NonConstant(currentInstruction2.asBinop());
                assert (value != null);
                binopsWithLit8OrLit16NonConstantValues.add(value);
            }
            if (binopsWithLit8OrLit16NonConstantValues.isEmpty()) continue;
            Reference2IntOpenHashMap<Value> lastUseOfBinopsWithLit8OrLit16NonConstantValues = new Reference2IntOpenHashMap<Value>();
            lastUseOfBinopsWithLit8OrLit16NonConstantValues.defaultReturnValue(-1);
            int currentInstructionNumber = block.getInstructions().size();
            while (instructionIterator.hasPrevious()) {
                currentInstruction = (Instruction)instructionIterator.previous();
                --currentInstructionNumber;
                for (Value value : Iterables.concat(currentInstruction.inValues(), currentInstruction.getDebugValues())) {
                    if (!binopsWithLit8OrLit16NonConstantValues.contains(value) || lastUseOfBinopsWithLit8OrLit16NonConstantValues.containsKey(value)) continue;
                    lastUseOfBinopsWithLit8OrLit16NonConstantValues.put(value, currentInstructionNumber);
                }
            }
            assert (--currentInstructionNumber == -1);
            while (instructionIterator.hasNext()) {
                Value constValue;
                Binop binop;
                currentInstruction = (Instruction)instructionIterator.next();
                if (!CodeRewriter.isBinopWithLit8OrLit16(currentInstruction) || CodeRewriter.canBe2AddrInstruction(binop = currentInstruction.asBinop(), ++currentInstructionNumber, lastUseOfBinopsWithLit8OrLit16NonConstantValues) || (constValue = CodeRewriter.binopWithLit8OrLit16Constant(currentInstruction)).numberOfAllUsers() <= 1) continue;
                ConstNumber newConstant = ConstNumber.copyOf(code, constValue.definition.asConstNumber());
                newConstant.setPosition(currentInstruction.getPosition());
                newConstant.setBlock(currentInstruction.getBlock());
                currentInstruction.replaceValue(constValue, newConstant.outValue());
                constValue.removeUser(currentInstruction);
                instructionIterator.previous();
                instructionIterator.add(newConstant);
                instructionIterator.next();
            }
        }
        assert (code.isConsistentSSA());
    }

    private static boolean isBinopWithLit8OrLit16(Instruction instruction) {
        boolean result;
        if (!instruction.isArithmeticBinop() && !instruction.isLogicalBinop()) {
            return false;
        }
        Binop binop = instruction.asBinop();
        boolean bl = result = !binop.needsValueInRegister(binop.leftValue()) || !binop.needsValueInRegister(binop.rightValue());
        assert (!result || binop.leftValue().isConstNumber() || binop.rightValue().isConstNumber());
        return result;
    }

    private static Value binopWithLit8OrLit16Constant(Instruction instruction) {
        assert (CodeRewriter.isBinopWithLit8OrLit16(instruction));
        Binop binop = instruction.asBinop();
        if (binop.leftValue().isConstNumber()) {
            return binop.leftValue();
        }
        if (binop.rightValue().isConstNumber()) {
            return binop.rightValue();
        }
        throw new Unreachable();
    }

    private static Value binopWithLit8OrLit16NonConstant(Binop binop) {
        if (binop.leftValue().isConstNumber()) {
            return binop.rightValue();
        }
        if (binop.rightValue().isConstNumber()) {
            return binop.leftValue();
        }
        throw new Unreachable();
    }

    private static boolean canBe2AddrInstruction(Binop binop, int binopInstructionNumber, Reference2IntMap<Value> lastUseOfRelevantValue) {
        Value value = CodeRewriter.binopWithLit8OrLit16NonConstant(binop);
        assert (value != null);
        int lastUseInstructionNumber = lastUseOfRelevantValue.getInt(value);
        assert (lastUseInstructionNumber != -1);
        if (lastUseInstructionNumber > binopInstructionNumber) {
            return false;
        }
        Set<BasicBlock> noPathTo = Sets.newIdentityHashSet();
        BasicBlock binopBlock = binop.getBlock();
        Iterable<Phi> users = value.debugUsers() != null ? Iterables.concat(value.uniqueUsers(), value.debugUsers(), value.uniquePhiUsers()) : Iterables.concat(value.uniqueUsers(), value.uniquePhiUsers());
        for (InstructionOrPhi instructionOrPhi : users) {
            BasicBlock userBlock = instructionOrPhi.getBlock();
            if (userBlock == binopBlock || noPathTo.contains(userBlock)) continue;
            if (binopBlock.hasPathTo(userBlock)) {
                return false;
            }
            noPathTo.add(userBlock);
        }
        return true;
    }

    public void shortenLiveRanges(IRCode code) {
        Supplier<DominatorTree> dominatorTreeMemoization = Suppliers.memoize(() -> new DominatorTree(code));
        IdentityHashMap<BasicBlock, Map<Value, Instruction>> addConstantInBlock = new IdentityHashMap<BasicBlock, Map<Value, Instruction>>();
        LinkedList<BasicBlock> blocks = code.blocks;
        for (BasicBlock block : blocks) {
            if (block == blocks.getFirst()) {
                this.shortenLiveRangesInsideBlock(code, block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstNumber() && insn.outValue().hasAnyUsers() || insn.isConstString() && insn.outValue().hasAnyUsers());
                continue;
            }
            this.shortenLiveRangesInsideBlock(code, block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstString() && insn.outValue().numberOfAllUsers() == 1);
        }
        for (BasicBlock block : blocks) {
            Instruction instruction;
            Map constants = (Map)addConstantInBlock.get(block);
            if (constants == null) continue;
            Set alreadyMoved = SetUtils.newIdentityHashSet(constants.size());
            if (block != blocks.getFirst() && constants.size() > 50) {
                assert (constants instanceof LinkedHashMap);
                for (Instruction constantInstruction : constants.values()) {
                    if (constantInstruction.outValue().hasPhiUsers() || constantInstruction.isConstString()) continue;
                    assert (constantInstruction.isConstNumber());
                    ConstNumber constNumber = constantInstruction.asConstNumber();
                    Value constantValue = constantInstruction.outValue();
                    assert (constantValue.hasUsers());
                    assert (constantValue.numberOfUsers() == constantValue.numberOfAllUsers());
                    for (Instruction user : constantValue.uniqueUsers()) {
                        ConstNumber newCstNum = ConstNumber.copyOf(code, constNumber);
                        newCstNum.setPosition(user.getPosition());
                        InstructionListIterator iterator2 = user.getBlock().listIterator(code, user);
                        iterator2.previous();
                        iterator2.add(newCstNum);
                        user.replaceValue(constantValue, newCstNum.outValue());
                    }
                    constantValue.clearUsers();
                    alreadyMoved.add(constantInstruction.outValue());
                }
            }
            boolean hasCatchHandlers = block.hasCatchHandlers();
            InstructionListIterator it = block.listIterator(code);
            while (!(!it.hasNext() || (instruction = (Instruction)it.next()).isJumpInstruction() || hasCatchHandlers && instruction.instructionTypeCanThrow() || this.options.canHaveCmpIfFloatBug() && instruction.isCmp())) {
                this.forEachUse(instruction, use -> {
                    Instruction constantInstruction = (Instruction)constants.get(use);
                    if (constantInstruction != null && !alreadyMoved.contains(use)) {
                        it.previous();
                        constantInstruction.setPosition(instruction.getPosition());
                        it.add(constantInstruction);
                        it.next();
                        alreadyMoved.add(use);
                    }
                });
            }
            Instruction next = (Instruction)it.previous();
            for (Instruction constantInstruction : constants.values()) {
                if (alreadyMoved.contains(constantInstruction.outValue())) continue;
                constantInstruction.setPosition(next.getPosition());
                it.add(constantInstruction);
            }
        }
        assert (code.isConsistentSSA());
    }

    private void forEachUse(Instruction instruction, Consumer<Value> fn) {
        instruction.inValues().forEach(fn);
        instruction.getDebugValues().forEach(fn);
    }

    private void shortenLiveRangesInsideBlock(IRCode code, BasicBlock block, Supplier<DominatorTree> dominatorTreeMemoization, Map<BasicBlock, Map<Value, Instruction>> addConstantInBlock, Predicate<ConstInstruction> selector) {
        InstructionListIterator iterator2 = block.listIterator(code);
        while (iterator2.hasNext()) {
            ConstInstruction instruction;
            Instruction next = (Instruction)iterator2.next();
            if (!next.isConstInstruction() || !selector.test(instruction = next.asConstInstruction()) || instruction.outValue().hasLocalInfo()) continue;
            Set<Instruction> uniqueUsers = instruction.outValue().uniqueUsers();
            if (uniqueUsers.size() == 1 && instruction.outValue().uniquePhiUsers().size() == 0) {
                Instruction uniqueUse = uniqueUsers.iterator().next();
                if (iterator2.hasNext()) {
                    Set<Instruction> uniqueUsersNext;
                    Instruction nextNext = (Instruction)iterator2.next();
                    if (uniqueUse == nextNext && nextNext.isArrayPut()) {
                        assert (!uniqueUse.isConstInstruction());
                        continue;
                    }
                    if (nextNext.isConstInstruction() && (uniqueUsersNext = nextNext.outValue().uniqueUsers()).size() == 1 && nextNext.outValue().uniquePhiUsers().size() == 0 && iterator2.hasNext()) {
                        Instruction nextNextNext = iterator2.peekNext();
                        Instruction uniqueUseNext = uniqueUsersNext.iterator().next();
                        if (uniqueUse == nextNextNext && uniqueUseNext == nextNextNext && nextNextNext.isArrayPut()) continue;
                    }
                    iterator2.previous();
                }
            }
            LinkedList<BasicBlock> userBlocks = new LinkedList<BasicBlock>();
            for (Instruction user : uniqueUsers) {
                userBlocks.add(user.getBlock());
            }
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                userBlocks.add(phi.getBlock());
            }
            DominatorTree dominatorTree = dominatorTreeMemoization.get();
            BasicBlock dominator = dominatorTree.closestDominator(userBlocks);
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                if (phi.getBlock() != dominator) continue;
                if (instruction.outValue().numberOfAllUsers() == 1 && phi.usesValueOneTime(instruction.outValue())) {
                    int predIndex = phi.getOperands().indexOf(instruction.outValue());
                    dominator = dominator.getPredecessors().get(predIndex);
                    break;
                }
                dominator = dominatorTree.immediateDominator(dominator);
                break;
            }
            if (instruction.instructionTypeCanThrow() && (block.hasCatchHandlers() || dominator.hasCatchHandlers())) continue;
            Map csts = addConstantInBlock.computeIfAbsent(dominator, k -> new LinkedHashMap());
            ConstInstruction copy = instruction.isConstNumber() ? ConstNumber.copyOf(code, instruction.asConstNumber()) : ConstString.copyOf(code, instruction.asConstString());
            instruction.outValue().replaceUsers(copy.outValue());
            csts.put(copy.outValue(), copy);
        }
    }

    private short[] computeArrayFilledData(ConstInstruction[] values2, int size, int elementSize) {
        if (values2 == null) {
            return null;
        }
        if (elementSize == 1) {
            short[] result = new short[(size + 1) / 2];
            for (int i = 0; i < size; i += 2) {
                short value = (short)(values2[i].asConstNumber().getIntValue() & 0xFF);
                if (i + 1 < size) {
                    value = (short)(value | (short)((values2[i + 1].asConstNumber().getIntValue() & 0xFF) << 8));
                }
                result[i / 2] = value;
            }
            return result;
        }
        assert (elementSize == 2 || elementSize == 4 || elementSize == 8);
        int shortsPerConstant = elementSize / 2;
        short[] result = new short[size * shortsPerConstant];
        for (int i = 0; i < size; ++i) {
            long value = values2[i].asConstNumber().getRawValue();
            for (int part = 0; part < shortsPerConstant; ++part) {
                result[i * shortsPerConstant + part] = (short)(value >> 16 * part & 0xFFFFL);
            }
        }
        return result;
    }

    private ConstInstruction[] computeConstantArrayValues(NewArrayEmpty newArray, BasicBlock block, int size) {
        BasicBlock nextBlock;
        if (size > 8192) {
            return null;
        }
        ConstInstruction[] values2 = new ConstInstruction[size];
        int remaining = size;
        Set<Instruction> users = newArray.outValue().uniqueUsers();
        Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
        InstructionIterator it = block.iterator();
        it.nextUntil(i -> i == newArray);
        do {
            visitedBlocks.add(block);
            while (it.hasNext()) {
                ConstInstruction value;
                Instruction instruction = (Instruction)it.next();
                if (block.hasCatchHandlers() && instruction.instructionInstanceCanThrow()) {
                    return null;
                }
                if (!users.contains(instruction)) continue;
                if (!instruction.isArrayPut()) {
                    return null;
                }
                ArrayPut arrayPut = instruction.asArrayPut();
                if (!arrayPut.value().isConstant() || !arrayPut.index().isConstNumber()) {
                    return null;
                }
                int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                if (index < 0 || index >= values2.length) {
                    return null;
                }
                if (values2[index] != null) {
                    return null;
                }
                values2[index] = value = arrayPut.value().getConstInstruction();
                if (--remaining != 0) continue;
                return values2;
            }
        } while ((it = (block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null ? block.iterator() : null) != null);
        return null;
    }

    private boolean allowNewFilledArrayConstruction(Instruction instruction) {
        if (!(instruction instanceof NewArrayEmpty)) {
            return false;
        }
        NewArrayEmpty newArray = instruction.asNewArrayEmpty();
        if (!newArray.size().isConstant()) {
            return false;
        }
        assert (newArray.size().isConstNumber());
        int size = newArray.size().getConstInstruction().asConstNumber().getIntValue();
        if (size < 1) {
            return false;
        }
        if (newArray.type.isPrimitiveArrayType()) {
            return true;
        }
        return newArray.type == this.dexItemFactory.stringArrayType && this.options.canUseFilledNewArrayOfObjects();
    }

    public void simplifyArrayConstruction(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            BasicBlock nextBlock;
            HashMap<Value, InvokeNewArray> instructionToInsertForArray = new HashMap<Value, InvokeNewArray>();
            HashMap<Value, Integer> storesToRemoveForArray = new HashMap<Value, Integer>();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                int elementSize;
                short[] contents;
                int size;
                NewArrayEmpty newArray;
                ConstInstruction[] values2;
                Instruction instruction = (Instruction)it.next();
                if (instruction.getLocalInfo() != null || !this.allowNewFilledArrayConstruction(instruction) || (values2 = this.computeConstantArrayValues(newArray = instruction.asNewArrayEmpty(), block, size = newArray.size().getConstInstruction().asConstNumber().getIntValue())) == null) continue;
                if (newArray.type == this.dexItemFactory.stringArrayType) {
                    if (size > 200) continue;
                    ArrayList<Value> stringValues = new ArrayList<Value>(size);
                    for (ConstInstruction constInstruction : values2) {
                        stringValues.add(constInstruction.outValue());
                    }
                    Value invokeValue = code.createValue(newArray.outValue().getTypeLattice(), newArray.getLocalInfo());
                    InvokeNewArray invoke = new InvokeNewArray(this.dexItemFactory.stringArrayType, invokeValue, stringValues);
                    for (Value value : newArray.inValues()) {
                        value.removeUser(newArray);
                    }
                    newArray.outValue().replaceUsers(invokeValue);
                    it.removeOrReplaceByDebugLocalRead();
                    instructionToInsertForArray.put(invokeValue, invoke);
                    storesToRemoveForArray.put(invokeValue, size);
                    continue;
                }
                if (size == 1 || (contents = this.computeArrayFilledData(values2, size, elementSize = newArray.type.elementSizeForPrimitiveArrayType())) == null || block.hasCatchHandlers()) continue;
                int arraySize = newArray.size().getConstInstruction().asConstNumber().getIntValue();
                NewArrayFilledData fillArray = new NewArrayFilledData(newArray.outValue(), elementSize, arraySize, contents);
                fillArray.setPosition(newArray.getPosition());
                it.add(fillArray);
                storesToRemoveForArray.put(newArray.outValue(), size);
            }
            if (storesToRemoveForArray.isEmpty()) continue;
            Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
            do {
                visitedBlocks.add(block);
                it = block.listIterator(code);
                while (it.hasNext()) {
                    Value array;
                    Integer toRemoveCount;
                    Instruction instruction = (Instruction)it.next();
                    if (!instruction.isArrayPut() || (toRemoveCount = (Integer)storesToRemoveForArray.get(array = instruction.asArrayPut().array())) == null) continue;
                    if (toRemoveCount > 0) {
                        toRemoveCount = toRemoveCount - 1;
                        storesToRemoveForArray.put(array, toRemoveCount);
                        it.remove();
                    }
                    if (toRemoveCount != 0) continue;
                    toRemoveCount = toRemoveCount - 1;
                    storesToRemoveForArray.put(array, toRemoveCount);
                    Instruction construction = (Instruction)instructionToInsertForArray.get(array);
                    if (construction == null) continue;
                    construction.setPosition(instruction.getPosition());
                    it.add(construction);
                }
            } while ((block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null);
        }
        assert (code.isConsistentSSA());
    }

    private static boolean hasLocalOrLineChangeBetween(Instruction from, Instruction to, DexString localVar) {
        if (from.getBlock() != to.getBlock()) {
            return true;
        }
        if (from.getPosition().isSome() && to.getPosition().isSome() && !from.getPosition().equals(to.getPosition())) {
            return true;
        }
        Position position = null;
        for (Instruction instruction : from.getBlock().instructionsAfter(from)) {
            if (position == null) {
                if (instruction.getPosition().isSome()) {
                    position = instruction.getPosition();
                }
            } else if (instruction.getPosition().isSome() && !position.equals(instruction.getPosition())) {
                return true;
            }
            if (instruction == to) {
                return false;
            }
            if (instruction.outValue() == null || !instruction.outValue().hasLocalInfo() || instruction.outValue().getLocalInfo().name != localVar) continue;
            return true;
        }
        throw new Unreachable();
    }

    public void simplifyDebugLocals(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Instruction instruction;
            for (Phi phi : block.getPhis()) {
                if (phi.hasLocalInfo() || phi.numberOfUsers() != 1 || phi.numberOfAllUsers() != 1 || !(instruction = phi.singleUniqueUser()).isDebugLocalWrite()) continue;
                this.removeDebugWriteOfPhi(code, phi, instruction.asDebugLocalWrite());
            }
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction prevInstruction = iterator2.peekPrevious();
                instruction = (Instruction)iterator2.next();
                if (!instruction.isDebugLocalWrite()) continue;
                assert (instruction.inValues().size() == 1);
                Value inValue = instruction.inValues().get(0);
                DebugLocalInfo localInfo = instruction.outValue().getLocalInfo();
                DexString localName = localInfo.name;
                if (inValue.hasLocalInfo() || inValue.numberOfAllUsers() != 1 || inValue.definition == null || CodeRewriter.hasLocalOrLineChangeBetween(inValue.definition, instruction, localName)) continue;
                inValue.setLocalInfo(localInfo);
                instruction.outValue().replaceUsers(inValue);
                Value overwrittenLocal = instruction.removeDebugValue(localInfo);
                if (overwrittenLocal != null) {
                    inValue.definition.addDebugValue(overwrittenLocal);
                    overwrittenLocal.addDebugLocalEnd(inValue.definition);
                }
                if (!(prevInstruction == null || prevInstruction.outValue() != null && prevInstruction.outValue().hasLocalInfo() && instruction.getDebugValues().contains(prevInstruction.outValue()))) {
                    instruction.moveDebugValues(prevInstruction);
                }
                iterator2.removeOrReplaceByDebugLocalRead();
            }
        }
    }

    private void removeDebugWriteOfPhi(IRCode code, Phi phi, DebugLocalWrite write) {
        assert (write.src() == phi);
        InstructionListIterator iterator2 = phi.getBlock().listIterator(code);
        while (iterator2.hasNext()) {
            Instruction next = (Instruction)iterator2.next();
            if (!next.isDebugLocalWrite()) {
                return;
            }
            if (next == write) {
                phi.setLocalInfo(write.getLocalInfo());
                write.outValue().replaceUsers(phi);
                iterator2.removeOrReplaceByDebugLocalRead();
                return;
            }
            assert (next.getLocalInfo().name != write.getLocalInfo().name);
        }
    }

    private boolean shareCatchHandlers(Instruction i0, Instruction i1) {
        if (!i0.instructionTypeCanThrow()) {
            assert (!i1.instructionTypeCanThrow());
            return true;
        }
        assert (i1.instructionTypeCanThrow());
        CatchHandlers<BasicBlock> ch0 = i0.getBlock().getCatchHandlers();
        CatchHandlers<BasicBlock> ch1 = i1.getBlock().getCatchHandlers();
        return ch0.equals(ch1);
    }

    private boolean isCSEInstructionCandidate(Instruction instruction) {
        return (instruction.isBinop() || instruction.isUnop() || instruction.isInstanceOf() || instruction.isCheckCast()) && instruction.getLocalInfo() == null && !instruction.hasInValueWithLocalInfo();
    }

    private boolean hasCSECandidate(IRCode code, int noCandidate) {
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                if (!this.isCSEInstructionCandidate(instruction)) continue;
                return true;
            }
            block.mark(noCandidate);
        }
        return false;
    }

    public void commonSubexpressionElimination(IRCode code) {
        int noCandidate = code.reserveMarkingColor();
        if (this.hasCSECandidate(code, noCandidate)) {
            ArrayListMultimap<Equivalence.Wrapper<Instruction>, Value> instructionToValue = ArrayListMultimap.create();
            CSEExpressionEquivalence equivalence = new CSEExpressionEquivalence(this.options);
            DominatorTree dominatorTree = new DominatorTree(code);
            for (int i = 0; i < dominatorTree.getSortedBlocks().length; ++i) {
                BasicBlock block = dominatorTree.getSortedBlocks()[i];
                if (block.isMarked(noCandidate)) continue;
                InstructionListIterator iterator2 = block.listIterator(code);
                while (iterator2.hasNext()) {
                    Instruction instruction = (Instruction)iterator2.next();
                    if (!this.isCSEInstructionCandidate(instruction)) continue;
                    Collection candidates = instructionToValue.get((Object)equivalence.wrap(instruction));
                    boolean eliminated = false;
                    if (candidates.size() > 0) {
                        for (Value candidate : candidates) {
                            if (!dominatorTree.dominatedBy(block, candidate.definition.getBlock()) || !this.shareCatchHandlers(instruction, candidate.definition)) continue;
                            instruction.outValue().replaceUsers(candidate);
                            eliminated = true;
                            iterator2.removeOrReplaceByDebugLocalRead();
                            break;
                        }
                    }
                    if (eliminated) continue;
                    instructionToValue.put(equivalence.wrap(instruction), instruction.outValue());
                }
            }
        }
        code.returnMarkingColor(noCandidate);
        assert (code.isConsistentSSA());
    }

    public boolean simplifyControlFlow(IRCode code) {
        boolean anyAffectedValues = this.rewriteSwitch(code);
        return anyAffectedValues |= this.simplifyIf(code);
    }

    private boolean simplifyIf(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Value rhs;
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty() || !block.exit().isIf()) continue;
            this.flipIfBranchesIfNeeded(code, block);
            this.rewriteIfWithConstZero(code, block);
            if (this.simplifyKnownBooleanCondition(code, block)) continue;
            If theIf = block.exit().asIf();
            Value lhs = theIf.lhs();
            Value value = rhs = theIf.isZeroTest() ? null : theIf.rhs();
            if (lhs.isConstNumber() && (theIf.isZeroTest() || rhs.isConstNumber())) {
                if (theIf.isZeroTest()) {
                    ConstNumber cond = lhs.getConstInstruction().asConstNumber();
                    BasicBlock target = theIf.targetFromCondition(cond);
                    this.simplifyIfWithKnownCondition(code, block, theIf, target);
                    continue;
                }
                ConstNumber left = lhs.getConstInstruction().asConstNumber();
                ConstNumber right = rhs.getConstInstruction().asConstNumber();
                BasicBlock target = theIf.targetFromCondition(left, right);
                this.simplifyIfWithKnownCondition(code, block, theIf, target);
                continue;
            }
            if (lhs.hasValueRange() && (theIf.isZeroTest() || rhs.hasValueRange())) {
                LongInterval rightRange;
                if (theIf.isZeroTest()) {
                    LongInterval interval = lhs.getValueRange();
                    if (!interval.containsValue(0L)) {
                        int sign = Long.signum(interval.getMin());
                        this.simplifyIfWithKnownCondition(code, block, theIf, sign);
                        continue;
                    }
                    switch (theIf.getType()) {
                        case GE: 
                        case LT: {
                            if (interval.getMin() != 0L) break;
                            this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                            break;
                        }
                        case LE: 
                        case GT: {
                            if (interval.getMax() != 0L) break;
                            this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                            break;
                        }
                        case EQ: 
                        case NE: {
                            assert (!interval.isSingleValue());
                            break;
                        }
                    }
                    continue;
                }
                LongInterval leftRange = lhs.getValueRange();
                if (!leftRange.overlapsWith(rightRange = rhs.getValueRange())) {
                    int cond = Long.signum(leftRange.getMin() - rightRange.getMin());
                    this.simplifyIfWithKnownCondition(code, block, theIf, cond);
                    continue;
                }
                switch (theIf.getType()) {
                    case GE: 
                    case LT: {
                        if (leftRange.getMin() != rightRange.getMax()) break;
                        this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                        break;
                    }
                    case LE: 
                    case GT: {
                        if (leftRange.getMax() != rightRange.getMin()) break;
                        this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                        break;
                    }
                }
                continue;
            }
            if (theIf.getType() != If.Type.EQ && theIf.getType() != If.Type.NE) continue;
            if (theIf.isZeroTest()) {
                if (lhs.isConstNumber()) continue;
                TypeLatticeElement l = lhs.getTypeLattice();
                if (l.isReference() && lhs.isNeverNull()) {
                    this.simplifyIfWithKnownCondition(code, block, theIf, 1);
                    continue;
                }
                if (l.isPrimitive() || l.isNullable()) continue;
                this.simplifyIfWithKnownCondition(code, block, theIf, 1);
                continue;
            }
            DexType context = code.method.method.holder;
            AbstractValue abstractValue = lhs.getAbstractValue(this.appView, context);
            if (!abstractValue.isSingleEnumValue()) continue;
            AbstractValue otherAbstractValue = rhs.getAbstractValue(this.appView, context);
            if (abstractValue == otherAbstractValue) {
                this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                continue;
            }
            if (!otherAbstractValue.isSingleEnumValue()) continue;
            this.simplifyIfWithKnownCondition(code, block, theIf, 1);
        }
        Set<Value> affectedValues = code.removeUnreachableBlocks();
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
        return !affectedValues.isEmpty();
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, BasicBlock target) {
        BasicBlock deadTarget = target == theIf.getTrueTarget() ? theIf.fallthroughBlock() : theIf.getTrueTarget();
        this.rewriteIfToGoto(code, block, theIf, target, deadTarget);
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, int cond) {
        this.simplifyIfWithKnownCondition(code, block, theIf, theIf.targetFromCondition(cond));
    }

    public void redundantConstNumberRemoval(IRCode code) {
        if (this.appView.options().canHaveDalvikIntUsedAsNonIntPrimitiveTypeBug() && !this.appView.options().testing.forceRedundantConstNumberRemoval) {
            return;
        }
        if (!code.metadata().mayHaveConstNumber()) {
            return;
        }
        Supplier<Long2ReferenceMap<List<ConstNumber>>> constantsByValue = Suppliers.memoize(() -> CodeRewriter.getConstantsByValue(code));
        Supplier<DominatorTree> dominatorTree = Suppliers.memoize(() -> new DominatorTree(code));
        boolean changed = false;
        for (BasicBlock block : code.blocks) {
            BasicBlock falseTarget;
            BasicBlock trueTarget;
            Value rhs;
            Instruction lastInstruction = block.getInstructions().getLast();
            if (!lastInstruction.isIf()) continue;
            If ifInstruction = lastInstruction.asIf();
            If.Type type = ifInstruction.getType();
            Value lhs = ifInstruction.inValues().get(0);
            Value value = rhs = !ifInstruction.isZeroTest() ? ifInstruction.inValues().get(1) : null;
            if (!ifInstruction.isZeroTest() && !lhs.isConstNumber() && !rhs.isConstNumber() || type != If.Type.EQ && type != If.Type.NE) continue;
            if (type == If.Type.EQ) {
                trueTarget = ifInstruction.getTrueTarget();
                falseTarget = ifInstruction.fallthroughBlock();
            } else {
                falseTarget = ifInstruction.getTrueTarget();
                trueTarget = ifInstruction.fallthroughBlock();
            }
            if (ifInstruction.isZeroTest()) {
                changed |= this.replaceDominatedConstNumbers(0L, lhs, trueTarget, constantsByValue, code, dominatorTree);
                if (lhs.knownToBeBoolean()) {
                    changed |= this.replaceDominatedConstNumbers(1L, lhs, falseTarget, constantsByValue, code, dominatorTree);
                }
            } else {
                assert (rhs != null);
                if (lhs.isConstNumber()) {
                    ConstNumber lhsAsNumber = lhs.getConstInstruction().asConstNumber();
                    changed |= this.replaceDominatedConstNumbers(lhsAsNumber.getRawValue(), rhs, trueTarget, constantsByValue, code, dominatorTree);
                    if (lhs.knownToBeBoolean() && rhs.knownToBeBoolean()) {
                        changed |= this.replaceDominatedConstNumbers(CodeRewriter.negateBoolean(lhsAsNumber), rhs, falseTarget, constantsByValue, code, dominatorTree);
                    }
                } else {
                    assert (rhs.isConstNumber());
                    ConstNumber rhsAsNumber = rhs.getConstInstruction().asConstNumber();
                    changed |= this.replaceDominatedConstNumbers(rhsAsNumber.getRawValue(), lhs, trueTarget, constantsByValue, code, dominatorTree);
                    if (lhs.knownToBeBoolean() && rhs.knownToBeBoolean()) {
                        changed |= this.replaceDominatedConstNumbers(CodeRewriter.negateBoolean(rhsAsNumber), lhs, falseTarget, constantsByValue, code, dominatorTree);
                    }
                }
            }
            if (!constantsByValue.get().isEmpty()) continue;
            break;
        }
        if (changed) {
            code.removeAllTrivialPhis();
        }
        assert (code.isConsistentSSA());
    }

    private static Long2ReferenceMap<List<ConstNumber>> getConstantsByValue(IRCode code) {
        Long2ReferenceOpenHashMap<List<ConstNumber>> constantsByValue = new Long2ReferenceOpenHashMap<List<ConstNumber>>();
        for (Instruction instruction : code.instructions()) {
            ConstNumber constNumber;
            if (!instruction.isConstNumber() || (constNumber = instruction.asConstNumber()).outValue().hasLocalInfo()) continue;
            long rawValue = constNumber.getRawValue();
            if (constantsByValue.containsKey(rawValue)) {
                ((List)constantsByValue.get(rawValue)).add(constNumber);
                continue;
            }
            ArrayList<ConstNumber> list = new ArrayList<ConstNumber>();
            list.add(constNumber);
            constantsByValue.put(rawValue, (List<ConstNumber>)list);
        }
        return constantsByValue;
    }

    private static int negateBoolean(ConstNumber number) {
        assert (number.outValue().knownToBeBoolean());
        return number.getRawValue() == 0L ? 1 : 0;
    }

    private boolean replaceDominatedConstNumbers(long withValue, Value newValue, BasicBlock dominator, Supplier<Long2ReferenceMap<List<ConstNumber>>> constantsByValueSupplier, IRCode code, Supplier<DominatorTree> dominatorTree) {
        if (newValue.hasLocalInfo()) {
            return false;
        }
        Long2ReferenceMap<List<ConstNumber>> constantsByValue = constantsByValueSupplier.get();
        List constantsWithValue = (List)constantsByValue.get(withValue);
        if (constantsWithValue == null || constantsWithValue.isEmpty()) {
            return false;
        }
        boolean changed = false;
        ListIterator constantWithValueIterator = constantsWithValue.listIterator();
        while (constantWithValueIterator.hasNext()) {
            ConstNumber constNumber = (ConstNumber)constantWithValueIterator.next();
            Value value = constNumber.outValue();
            assert (!value.hasLocalInfo());
            assert (constNumber.getRawValue() == withValue);
            BasicBlock block = constNumber.getBlock();
            if (block == dominator && block.getPredecessors().size() != 1) {
                assert (false);
                continue;
            }
            if (value.knownToBeBoolean() && !newValue.knownToBeBoolean() || !dominatorTree.get().dominatedBy(block, dominator)) continue;
            if (newValue.getTypeLattice().lessThanOrEqual(value.getTypeLattice(), this.appView)) {
                value.replaceUsers(newValue);
                block.listIterator(code, constNumber).removeOrReplaceByDebugLocalRead();
                constantWithValueIterator.remove();
                changed = true;
                continue;
            }
            if (!value.getTypeLattice().isNullType()) continue;
        }
        if (constantsWithValue.isEmpty()) {
            constantsByValue.remove(withValue);
        }
        return changed;
    }

    public void processMethodsNeverReturningNormally(IRCode code) {
        if (!((AppInfo)this.appView.appInfo()).hasLiveness()) {
            return;
        }
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty()) continue;
            InstructionListIterator insnIterator = block.listIterator(code);
            while (insnIterator.hasNext()) {
                InvokeMethod invoke;
                DexEncodedMethod singleTarget;
                Instruction insn = (Instruction)insnIterator.next();
                if (!insn.isInvokeMethod() || (singleTarget = (invoke = insn.asInvokeMethod()).lookupSingleTarget(this.appView.withLiveness(), code.method.method.holder)) == null || !singleTarget.getOptimizationInfo().neverReturnsNormally()) continue;
                BasicBlock newBlock = insnIterator.split(code, blockIterator);
                assert (!insnIterator.hasNext());
                blockIterator.previous();
                newBlock.unlinkSinglePredecessorSiblingsAllowed();
                Instruction gotoInsn = (Instruction)insnIterator.previous();
                assert (gotoInsn.isGoto());
                assert (insnIterator.hasNext());
                BasicBlock throwNullBlock = insnIterator.split(code, blockIterator);
                InstructionListIterator throwNullInsnIterator = throwNullBlock.listIterator(code);
                ConstNumber nullConstant = code.createConstNull(gotoInsn.getLocalInfo());
                nullConstant.setPosition(invoke.getPosition());
                throwNullInsnIterator.add(nullConstant);
                Throw notReachableThrow = new Throw(nullConstant.outValue());
                Instruction insnGoto = (Instruction)throwNullInsnIterator.next();
                assert (insnGoto.isGoto());
                throwNullInsnIterator.replaceCurrentInstruction(notReachableThrow);
            }
        }
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    private boolean simplifyKnownBooleanCondition(IRCode code, BasicBlock block) {
        If theIf = block.exit().asIf();
        Value testValue = theIf.inValues().get(0);
        if (theIf.isZeroTest() && testValue.knownToBeBoolean()) {
            BasicBlock targetBlock;
            BasicBlock trueBlock = theIf.getTrueTarget();
            BasicBlock falseBlock = theIf.fallthroughBlock();
            if (this.isBlockSupportedBySimplifyKnownBooleanCondition(trueBlock) && this.isBlockSupportedBySimplifyKnownBooleanCondition(falseBlock) && trueBlock.getSuccessors().get(0) == falseBlock.getSuccessors().get(0) && (targetBlock = trueBlock.getSuccessors().get(0)).getPredecessors().size() == 2) {
                int trueIndex = targetBlock.getPredecessors().indexOf(trueBlock);
                int falseIndex = trueIndex == 0 ? 1 : 0;
                int deadPhis = 0;
                for (Phi phi : targetBlock.getPhis()) {
                    Value trueValue = phi.getOperand(trueIndex);
                    Value falseValue = phi.getOperand(falseIndex);
                    if (!trueValue.isConstNumber() || !falseValue.isConstNumber()) continue;
                    ConstNumber trueNumber = trueValue.getConstInstruction().asConstNumber();
                    ConstNumber falseNumber = falseValue.getConstInstruction().asConstNumber();
                    if (theIf.getType() == If.Type.EQ && trueNumber.isIntegerZero() && falseNumber.isIntegerOne() || theIf.getType() == If.Type.NE && trueNumber.isIntegerOne() && falseNumber.isIntegerZero()) {
                        phi.replaceUsers(testValue);
                        ++deadPhis;
                        continue;
                    }
                    if ((theIf.getType() != If.Type.NE || !trueNumber.isIntegerZero() || !falseNumber.isIntegerOne()) && (theIf.getType() != If.Type.EQ || !trueNumber.isIntegerOne() || !falseNumber.isIntegerZero())) continue;
                    Value newOutValue = code.createValue(phi.getTypeLattice(), phi.getLocalInfo());
                    ConstNumber cstToUse = trueNumber.isIntegerOne() ? trueNumber : falseNumber;
                    BasicBlock phiBlock = phi.getBlock();
                    Position phiPosition = phiBlock.getPosition();
                    int insertIndex = 0;
                    if (cstToUse.getBlock() == trueBlock || cstToUse.getBlock() == falseBlock) {
                        cstToUse = ConstNumber.copyOf(code, cstToUse);
                        cstToUse.setBlock(phiBlock);
                        cstToUse.setPosition(phiPosition);
                        phiBlock.getInstructions().add(insertIndex++, cstToUse);
                    }
                    phi.replaceUsers(newOutValue);
                    Xor newInstruction = new Xor(NumericType.INT, newOutValue, testValue, cstToUse.outValue());
                    newInstruction.setBlock(phiBlock);
                    newInstruction.setPosition(phiPosition);
                    phiBlock.listIterator(code, insertIndex).add(newInstruction);
                    ++deadPhis;
                }
                if (deadPhis == targetBlock.getPhis().size()) {
                    this.rewriteIfToGoto(code, block, theIf, trueBlock, falseBlock);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isBlockSupportedBySimplifyKnownBooleanCondition(BasicBlock b) {
        Instruction constInstruction;
        if (b.isTrivialGoto()) {
            return true;
        }
        int instructionSize = b.getInstructions().size();
        if (b.exit().isGoto() && (instructionSize == 2 || instructionSize == 3) && (constInstruction = b.getInstructions().get(instructionSize - 2)).isConstNumber()) {
            if (!constInstruction.asConstNumber().isIntegerOne() && !constInstruction.asConstNumber().isIntegerZero()) {
                return false;
            }
            if (instructionSize == 2) {
                return true;
            }
            Instruction firstInstruction = b.getInstructions().getFirst();
            if (firstInstruction.isDebugPosition()) {
                assert (b.getPredecessors().size() == 1);
                BasicBlock predecessorBlock = b.getPredecessors().get(0);
                InstructionIterator it = predecessorBlock.iterator(predecessorBlock.exit());
                Instruction previousPosition = null;
                while (it.hasPrevious() && !(previousPosition = it.previous()).isDebugPosition()) {
                }
                if (previousPosition != null) {
                    return previousPosition.getPosition() == firstInstruction.getPosition();
                }
            }
        }
        return false;
    }

    private void rewriteIfToGoto(IRCode code, BasicBlock block, If theIf, BasicBlock target, BasicBlock deadTarget) {
        deadTarget.unlinkSinglePredecessorSiblingsAllowed();
        assert (theIf == block.exit());
        block.replaceLastInstruction(new Goto(), code);
        assert (block.exit().isGoto());
        assert (block.exit().asGoto().getTarget() == target);
    }

    private void rewriteIfWithConstZero(IRCode code, BasicBlock block) {
        If theIf = block.exit().asIf();
        if (theIf.isZeroTest()) {
            return;
        }
        List<Value> inValues = theIf.inValues();
        Value leftValue = inValues.get(0);
        Value rightValue = inValues.get(1);
        if (leftValue.isConstNumber() || rightValue.isConstNumber()) {
            if (leftValue.isConstNumber()) {
                if (leftValue.getConstInstruction().asConstNumber().isZero()) {
                    If ifz = new If(theIf.getType().forSwappedOperands(), rightValue);
                    block.replaceLastInstruction(ifz, code);
                    assert (block.exit() == ifz);
                }
            } else if (rightValue.getConstInstruction().asConstNumber().isZero()) {
                If ifz = new If(theIf.getType(), leftValue);
                block.replaceLastInstruction(ifz, code);
                assert (block.exit() == ifz);
            }
        }
    }

    private boolean flipIfBranchesIfNeeded(IRCode code, BasicBlock block) {
        If theIf = block.exit().asIf();
        BasicBlock trueTarget = theIf.getTrueTarget();
        BasicBlock fallthrough = theIf.fallthroughBlock();
        assert (trueTarget != fallthrough);
        if (!fallthrough.isSimpleAlwaysThrowingPath() || trueTarget.isSimpleAlwaysThrowingPath()) {
            return false;
        }
        List<Value> inValues = theIf.inValues();
        If newIf = new If(theIf.getType().inverted(), inValues);
        block.replaceLastInstruction(newIf, code);
        block.swapSuccessors(trueTarget, fallthrough);
        return true;
    }

    public void rewriteConstantEnumMethodCalls(IRCode code) {
        if (!code.metadata().mayHaveInvokeMethodWithReceiver()) {
            return;
        }
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            AppInfoWithLiveness.EnumValueInfo valueInfo;
            Instruction definition;
            Value receiver;
            boolean isToStringInvoke;
            Instruction current = (Instruction)iterator2.next();
            if (!current.isInvokeMethodWithReceiver()) continue;
            InvokeMethodWithReceiver methodWithReceiver = current.asInvokeMethodWithReceiver();
            DexMethod invokedMethod = methodWithReceiver.getInvokedMethod();
            boolean isOrdinalInvoke = invokedMethod == this.dexItemFactory.enumMethods.ordinal;
            boolean isNameInvoke = invokedMethod == this.dexItemFactory.enumMethods.name;
            boolean bl = isToStringInvoke = invokedMethod == this.dexItemFactory.enumMethods.toString;
            if (!isOrdinalInvoke && !isNameInvoke && !isToStringInvoke || (receiver = methodWithReceiver.getReceiver().getAliasedValue()).isPhi() || !(definition = receiver.getDefinition()).isStaticGet()) continue;
            DexField enumField = definition.asStaticGet().getField();
            Map<DexField, AppInfoWithLiveness.EnumValueInfo> valueInfoMap = ((AppInfo)this.appView.appInfo()).withLiveness().getEnumValueInfoMapFor(enumField.type);
            if (valueInfoMap == null || (valueInfo = valueInfoMap.get(enumField)) == null) continue;
            Value outValue = methodWithReceiver.outValue();
            if (isOrdinalInvoke) {
                iterator2.replaceCurrentInstruction(new ConstNumber(outValue, valueInfo.ordinal));
                continue;
            }
            if (isNameInvoke) {
                iterator2.replaceCurrentInstruction(new ConstString(outValue, enumField.name, BasicBlock.ThrowingInfo.NO_THROW));
                continue;
            }
            assert (isToStringInvoke);
            DexClass enumClazz = ((AppInfo)this.appView.appInfo()).definitionFor(enumField.type);
            if (!enumClazz.accessFlags.isFinal() || ((AppInfo)this.appView.appInfo()).resolveMethodOnClass((DexType)valueInfo.type, (DexMethod)this.dexItemFactory.objectMethods.toString).getSingleTarget().method != this.dexItemFactory.enumMethods.toString) continue;
            iterator2.replaceCurrentInstruction(new ConstString(outValue, enumField.name, BasicBlock.ThrowingInfo.NO_THROW));
        }
        assert (code.isConsistentSSA());
    }

    public void rewriteKnownArrayLengthCalls(IRCode code) {
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            Value array;
            ArrayLength arrayLength;
            Instruction current = (Instruction)iterator2.next();
            if (!current.isArrayLength() || (arrayLength = current.asArrayLength()).hasOutValue() && arrayLength.outValue().hasLocalInfo() || (array = arrayLength.array().getAliasedValue()).isPhi() || !array.isNeverNull() || array.hasLocalInfo()) continue;
            Instruction arrayDefinition = array.getDefinition();
            assert (arrayDefinition != null);
            if (arrayDefinition.isNewArrayEmpty()) {
                Value size = arrayDefinition.asNewArrayEmpty().size();
                arrayLength.outValue().replaceUsers(size);
                iterator2.removeOrReplaceByDebugLocalRead();
                continue;
            }
            if (!arrayDefinition.isNewArrayFilledData()) continue;
            int size = (int)arrayDefinition.asNewArrayFilledData().size;
            ConstNumber constSize = code.createIntConstant(size);
            iterator2.replaceCurrentInstruction(constSize);
        }
        assert (code.isConsistentSSA());
    }

    public void rewriteAssertionErrorTwoArgumentConstructor(IRCode code, InternalOptions options) {
        if (options.canUseAssertionErrorTwoArgumentConstructor()) {
            return;
        }
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            InstructionListIterator insnIterator = block.listIterator(code);
            while (insnIterator.hasNext()) {
                DexMethod invokedMethod;
                Instruction current = (Instruction)insnIterator.next();
                if (!current.isInvokeMethod() || (invokedMethod = current.asInvokeMethod().getInvokedMethod()) != this.dexItemFactory.assertionErrorMethods.initMessageAndCause) continue;
                List<Value> inValues = current.inValues();
                assert (inValues.size() == 3);
                List<Value> newInitInValues = inValues.subList(0, 2);
                insnIterator.replaceCurrentInstruction(new InvokeDirect(this.dexItemFactory.assertionErrorMethods.initMessage, null, newInitInValues));
                if (!options.canInitCauseAfterAssertionErrorObjectConstructor()) continue;
                if (block.hasCatchHandlers()) {
                    insnIterator = insnIterator.split(code, blockIterator).listIterator(code);
                }
                List<Value> initCauseArguments = Arrays.asList(inValues.get(0), inValues.get(2));
                InvokeVirtual initCause = new InvokeVirtual(this.dexItemFactory.throwableMethods.initCause, code.createValue(TypeLatticeElement.fromDexType(this.dexItemFactory.throwableType, Nullability.maybeNull(), this.appView)), initCauseArguments);
                initCause.setPosition(current.getPosition());
                insnIterator.add(initCause);
            }
        }
        assert (code.isConsistentSSA());
    }

    public static void removeUnneededMovesOnExitingPaths(IRCode code, LinearScanRegisterAllocator allocator) {
        if (!allocator.options().debug) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            Set<Move> unneededMoves;
            Instruction instruction;
            Int2ReferenceMap<DebugLocalInfo> localsAtEntry;
            if (!block.getSuccessors().isEmpty() || (localsAtEntry = block.getLocalsAtEntry()) == null || localsAtEntry.isEmpty()) continue;
            DebugLocalsChange postSpillLocalsChange = null;
            Iterator iterator2 = block.getInstructions().iterator();
            while (iterator2.hasNext() && (instruction = (Instruction)iterator2.next()).getNumber() == -1 && postSpillLocalsChange == null) {
                postSpillLocalsChange = instruction.asDebugLocalsChange();
            }
            if (postSpillLocalsChange == null || !postSpillLocalsChange.apply(new Int2ReferenceOpenHashMap<DebugLocalInfo>(localsAtEntry)) || (unneededMoves = CodeRewriter.computeUnneededMoves(block, postSpillLocalsChange, allocator)).isEmpty()) continue;
            Int2IntOpenHashMap previousMapping = new Int2IntOpenHashMap();
            Int2IntOpenHashMap mapping = new Int2IntOpenHashMap();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction instruction2 = (Instruction)it.next();
                if (instruction2.isMove()) {
                    Move move = instruction2.asMove();
                    if (!unneededMoves.contains(move)) continue;
                    int dst = allocator.getRegisterForValue(move.dest(), move.getNumber());
                    int src = allocator.getRegisterForValue(move.src(), move.getNumber());
                    int mappedSrc = mapping.getOrDefault(src, src);
                    mapping.put(dst, mappedSrc);
                    it.removeInstructionIgnoreOutValue();
                    continue;
                }
                if (!instruction2.isDebugLocalsChange()) continue;
                DebugLocalsChange change = instruction2.asDebugLocalsChange();
                CodeRewriter.updateDebugLocalsRegisterMap(previousMapping, change.getEnding());
                CodeRewriter.updateDebugLocalsRegisterMap(mapping, change.getStarting());
                previousMapping = mapping;
                mapping = new Int2IntOpenHashMap(previousMapping);
            }
        }
    }

    private static Set<Move> computeUnneededMoves(BasicBlock block, DebugLocalsChange postSpillLocalsChange, LinearScanRegisterAllocator allocator) {
        Set<Move> unneededMoves = Sets.newIdentityHashSet();
        IntOpenHashSet usedRegisters = new IntOpenHashSet();
        IntOpenHashSet clobberedRegisters = new IntOpenHashSet();
        boolean inEntrySpillMoves = false;
        InstructionIterator it = block.iterator(block.getInstructions().size());
        while (it.hasPrevious()) {
            Instruction instruction = it.previous();
            if (instruction == postSpillLocalsChange) {
                inEntrySpillMoves = true;
            }
            if (inEntrySpillMoves && instruction.isMove()) {
                Move move = instruction.asMove();
                int dst = allocator.getRegisterForValue(move.dest(), move.getNumber());
                int src = allocator.getRegisterForValue(move.src(), move.getNumber());
                if (!usedRegisters.contains(dst) && !clobberedRegisters.contains(src)) {
                    unneededMoves.add(move);
                    continue;
                }
            }
            if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
                int register = allocator.getRegisterForValue(instruction.outValue(), instruction.getNumber());
                usedRegisters.remove(register);
                clobberedRegisters.add(register);
            }
            if (instruction.inValues().isEmpty()) continue;
            for (Value inValue : instruction.inValues()) {
                if (!inValue.needsRegister()) continue;
                int register = allocator.getRegisterForValue(inValue, instruction.getNumber());
                usedRegisters.add(register);
            }
        }
        return unneededMoves;
    }

    private static void updateDebugLocalsRegisterMap(Int2IntMap mapping, Int2ReferenceMap<DebugLocalInfo> locals) {
        if (mapping.isEmpty()) {
            return;
        }
        Int2ReferenceOpenHashMap<DebugLocalInfo> copy = new Int2ReferenceOpenHashMap<DebugLocalInfo>(locals);
        locals.clear();
        for (Int2ReferenceMap.Entry entry : copy.int2ReferenceEntrySet()) {
            int oldRegister = entry.getIntKey();
            int newRegister = mapping.getOrDefault(oldRegister, oldRegister);
            locals.put(newRegister, (DebugLocalInfo)entry.getValue());
        }
    }

    public void rewriteThrowableAddAndGetSuppressed(IRCode code) {
        DexItemFactory.ThrowableMethods throwableMethods = this.dexItemFactory.throwableMethods;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (!current.isInvokeMethod()) continue;
                DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
                if (this.matchesMethodOfThrowable(invokedMethod, throwableMethods.addSuppressed)) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (!this.matchesMethodOfThrowable(invokedMethod, throwableMethods.getSuppressed)) continue;
                Value destValue = current.outValue();
                if (destValue == null) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                ConstNumber zero = code.createIntConstant(0);
                zero.setPosition(current.getPosition());
                assert (iterator2.hasPrevious());
                iterator2.previous();
                iterator2.add(zero);
                Instruction next = (Instruction)iterator2.next();
                assert (current == next);
                NewArrayEmpty newArray = new NewArrayEmpty(destValue, zero.outValue(), this.dexItemFactory.createType(this.dexItemFactory.throwableArrayDescriptor));
                iterator2.replaceCurrentInstruction(newArray);
            }
        }
        assert (code.isConsistentSSA());
    }

    private boolean matchesMethodOfThrowable(DexMethod invoked, DexMethod expected) {
        return invoked.name == expected.name && invoked.proto == expected.proto && this.isSubtypeOfThrowable(invoked.holder);
    }

    private boolean isSubtypeOfThrowable(DexType type) {
        while (type != null && type != this.dexItemFactory.objectType) {
            if (type == this.dexItemFactory.throwableType) {
                return true;
            }
            DexClass dexClass = this.appView.definitionFor(type);
            if (dexClass == null) {
                throw new CompilationError("Class or interface " + type.toSourceString() + " required for desugaring of try-with-resources is not found.");
            }
            type = dexClass.superType;
        }
        return false;
    }

    private Value addConstString(IRCode code, InstructionListIterator iterator2, String s) {
        ClassTypeLatticeElement typeLattice = TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull());
        Value value = code.createValue(typeLattice);
        BasicBlock.ThrowingInfo throwingInfo = this.options.isGeneratingClassFiles() ? BasicBlock.ThrowingInfo.NO_THROW : BasicBlock.ThrowingInfo.CAN_THROW;
        iterator2.add(new ConstString(value, this.dexItemFactory.createString(s), throwingInfo));
        return value;
    }

    public void logArgumentTypes(DexEncodedMethod method, IRCode code) {
        List<Value> arguments = code.collectArguments();
        BasicBlock block = code.entryBlock();
        InstructionListIterator iterator2 = block.listIterator(code);
        Position position = Position.synthetic(1, method.method, null);
        iterator2.setInsertionPosition(position);
        iterator2.nextUntil(instruction -> !instruction.isArgument());
        iterator2.previous();
        iterator2.split(code);
        iterator2.previous();
        assert (!block.hasCatchHandlers());
        DexType javaLangSystemType = this.dexItemFactory.createType("Ljava/lang/System;");
        DexType javaIoPrintStreamType = this.dexItemFactory.createType("Ljava/io/PrintStream;");
        Value out = code.createValue(TypeLatticeElement.fromDexType(javaIoPrintStreamType, Nullability.definitelyNotNull(), this.appView));
        DexProto proto = this.dexItemFactory.createProto(this.dexItemFactory.voidType, this.dexItemFactory.objectType);
        DexMethod print = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "print");
        DexMethod printLn = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "println");
        iterator2.add(new StaticGet(out, this.dexItemFactory.createField(javaLangSystemType, javaIoPrintStreamType, "out")));
        Value value = this.addConstString(code, iterator2, "INVOKE ");
        iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        value = this.addConstString(code, iterator2, method.method.qualifiedName());
        iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        Value openParenthesis = this.addConstString(code, iterator2, "(");
        Value comma = this.addConstString(code, iterator2, ",");
        Value closeParenthesis = this.addConstString(code, iterator2, ")");
        Value indent = this.addConstString(code, iterator2, "  ");
        Value nul = this.addConstString(code, iterator2, "(null)");
        Value primitive = this.addConstString(code, iterator2, "(primitive)");
        Value empty = this.addConstString(code, iterator2, "");
        iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, openParenthesis)));
        for (int i = 0; i < arguments.size(); ++i) {
            iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, indent)));
            BasicBlock eol = BasicBlock.createGotoBlock(code.blocks.size(), position, code.metadata());
            code.blocks.add(eol);
            BasicBlock successor = block.unlinkSingleSuccessor();
            block.link(eol);
            eol.link(successor);
            Value argument = arguments.get(i);
            if (!argument.getTypeLattice().isReference()) {
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, primitive)));
            } else {
                successor = block.unlinkSingleSuccessor();
                If theIf = new If(If.Type.NE, argument);
                theIf.setPosition(position);
                BasicBlock ifBlock = BasicBlock.createIfBlock(code.blocks.size(), theIf, code.metadata());
                code.blocks.add(ifBlock);
                BasicBlock isNullBlock = BasicBlock.createGotoBlock(code.blocks.size(), position, code.metadata());
                code.blocks.add(isNullBlock);
                BasicBlock isNotNullBlock = BasicBlock.createGotoBlock(code.blocks.size(), position, code.metadata());
                code.blocks.add(isNotNullBlock);
                block.link(ifBlock);
                ifBlock.link(isNotNullBlock);
                ifBlock.link(isNullBlock);
                isNotNullBlock.link(successor);
                isNullBlock.link(successor);
                iterator2 = isNullBlock.listIterator(code);
                iterator2.setInsertionPosition(position);
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, nul)));
                iterator2 = isNotNullBlock.listIterator(code);
                iterator2.setInsertionPosition(position);
                value = code.createValue(TypeLatticeElement.classClassType(this.appView, Nullability.definitelyNotNull()));
                iterator2.add(new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, value, ImmutableList.of(arguments.get(i))));
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
            }
            iterator2 = eol.listIterator(code);
            iterator2.setInsertionPosition(position);
            if (i == arguments.size() - 1) {
                iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, closeParenthesis)));
            } else {
                iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, comma)));
            }
            block = eol;
        }
        iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, empty)));
    }

    public static void ensureDirectStringNewToInit(IRCode code, DexItemFactory dexItemFactory) {
        for (Instruction instruction : code.instructions()) {
            InvokeDirect invoke;
            DexMethod method;
            if (!instruction.isInvokeDirect() || !dexItemFactory.isConstructor(method = (invoke = instruction.asInvokeDirect()).getInvokedMethod()) || method.holder != dexItemFactory.stringType || !invoke.getReceiver().isPhi()) continue;
            NewInstance newInstance = CodeRewriter.findNewInstance(invoke.getReceiver().asPhi());
            CodeRewriter.replaceTrivialNewInstancePhis(newInstance.outValue());
            if (invoke.getReceiver().isPhi()) {
                throw new CompilationError("Failed to remove trivial phis between new-instance and <init>");
            }
            newInstance.markNoSpilling();
        }
    }

    private static NewInstance findNewInstance(Phi phi) {
        Set<Phi> seen = Sets.newIdentityHashSet();
        Set<Value> values2 = Sets.newIdentityHashSet();
        CodeRewriter.recursiveAddOperands(phi, seen, values2);
        if (values2.size() != 1) {
            throw new CompilationError("Failed to identify unique new-instance for <init>");
        }
        Value newInstanceValue = values2.iterator().next();
        if (newInstanceValue.definition == null || !newInstanceValue.definition.isNewInstance()) {
            throw new CompilationError("Invalid defining value for call to <init>");
        }
        return newInstanceValue.definition.asNewInstance();
    }

    private static void recursiveAddOperands(Phi phi, Set<Phi> seen, Set<Value> values2) {
        for (Value operand : phi.getOperands()) {
            if (!operand.isPhi()) {
                values2.add(operand);
                continue;
            }
            Phi phiOp = operand.asPhi();
            if (!seen.add(phiOp)) continue;
            CodeRewriter.recursiveAddOperands(phiOp, seen, values2);
        }
    }

    private static void replaceTrivialNewInstancePhis(Value newInstanceValue) {
        List<Set<Value>> components = new SCC().computeSCC(newInstanceValue);
        for (int i = components.size() - 1; i >= 0; --i) {
            Set<Value> component = components.get(i);
            if (component.size() == 1 && component.iterator().next() == newInstanceValue) continue;
            Set<Phi> trivialPhis = Sets.newIdentityHashSet();
            for (Value value : component) {
                boolean isTrivial = true;
                Phi p = value.asPhi();
                for (Value op : p.getOperands()) {
                    if (op == newInstanceValue || component.contains(op)) continue;
                    isTrivial = false;
                    break;
                }
                if (!isTrivial) continue;
                trivialPhis.add(p);
            }
            for (Phi trivialPhi : trivialPhis) {
                for (Value op : trivialPhi.getOperands()) {
                    op.removePhiUser(trivialPhi);
                }
                trivialPhi.replaceUsers(newInstanceValue);
                trivialPhi.getBlock().removePhi(trivialPhi);
            }
        }
    }

    public void workaroundNumberConversionRegisterAllocationBug(IRCode code) {
        Supplier<DexMethod> javaLangDoubleisNaN = Suppliers.memoize(() -> this.dexItemFactory.createMethod(this.dexItemFactory.createString("Ljava/lang/Double;"), this.dexItemFactory.createString("isNaN"), this.dexItemFactory.booleanDescriptor, new DexString[]{this.dexItemFactory.doubleDescriptor}));
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isArithmeticBinop() && !instruction.isNeg()) continue;
                for (Value value : instruction.inValues()) {
                    BasicBlock blockWithInvokeNaN;
                    if (value.isPhi() || !value.definition.isNumberConversion() || value.definition.asNumberConversion().to != NumericType.DOUBLE) continue;
                    InvokeStatic invokeIsNaN = new InvokeStatic(javaLangDoubleisNaN.get(), null, ImmutableList.of(value));
                    invokeIsNaN.setPosition(instruction.getPosition());
                    it.previous();
                    BasicBlock basicBlock = blockWithInvokeNaN = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithInvokeNaN != block) {
                        it = block.listIterator(code, block.getInstructions().size());
                        it.previous();
                        it.add(invokeIsNaN);
                        block = blockWithInvokeNaN;
                        it = block.listIterator(code);
                    } else {
                        it.add(invokeIsNaN);
                    }
                    Instruction temp = (Instruction)it.next();
                    assert (temp == instruction);
                }
            }
        }
    }

    public void workaroundExceptionTargetingLoopHeaderBug(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                BasicBlock target = handler.endOfGotoChain();
                if (target == null || target.getPredecessors().size() <= 1 || target.getNormalPredecessors().size() <= 1 || target.getNormalSuccessors().size() <= 1) continue;
                AlwaysMaterializingNop fixit = new AlwaysMaterializingNop();
                fixit.setBlock(handler);
                fixit.setPosition(handler.getPosition());
                handler.getInstructions().addFirst(fixit);
            }
        }
    }

    private static class SCC {
        private int currentTime = 0;
        private final Reference2IntMap<Value> discoverTime = new Reference2IntOpenHashMap<Value>();
        private final Set<Value> unassignedSet = Sets.newIdentityHashSet();
        private final Deque<Value> unassignedStack = new ArrayDeque<Value>();
        private final Deque<Value> preorderStack = new ArrayDeque<Value>();
        private final List<Set<Value>> components = new ArrayList<Set<Value>>();

        private SCC() {
        }

        public List<Set<Value>> computeSCC(Value v) {
            assert (this.currentTime == 0);
            this.dfs(v);
            return this.components;
        }

        private void dfs(Value value) {
            this.discoverTime.put(value, this.currentTime++);
            this.unassignedSet.add(value);
            this.unassignedStack.push(value);
            this.preorderStack.push(value);
            for (Phi phi : value.uniquePhiUsers()) {
                if (!this.discoverTime.containsKey(phi)) {
                    this.dfs(phi);
                    continue;
                }
                if (!this.unassignedSet.contains(phi)) continue;
                int discoverTimeOfPhi = this.discoverTime.getInt(phi);
                while (discoverTimeOfPhi < this.discoverTime.getInt(this.preorderStack.peek())) {
                    this.preorderStack.pop();
                }
            }
            if (this.preorderStack.peek() == value) {
                Value member;
                Set component = SetUtils.newIdentityHashSet(this.unassignedStack.size());
                do {
                    member = this.unassignedStack.pop();
                    this.unassignedSet.remove(member);
                    component.add(member);
                } while (member != value);
                this.components.add(component);
                this.preorderStack.pop();
            }
        }
    }

    private static class CSEExpressionEquivalence
    extends Equivalence<Instruction> {
        private final InternalOptions options;

        private CSEExpressionEquivalence(InternalOptions options) {
            this.options = options;
        }

        @Override
        protected boolean doEquivalent(Instruction a, Instruction b) {
            if (a.isCmp() && this.options.canHaveCmpLongBug()) {
                return false;
            }
            if (!a.identicalNonValueNonPositionParts(b)) {
                return false;
            }
            if (a.isBinop() && a.asBinop().isCommutative()) {
                Value a0 = a.inValues().get(0);
                Value a1 = a.inValues().get(1);
                Value b0 = b.inValues().get(0);
                Value b1 = b.inValues().get(1);
                return CSEExpressionEquivalence.identicalValue(a0, b0) && CSEExpressionEquivalence.identicalValue(a1, b1) || CSEExpressionEquivalence.identicalValue(a0, b1) && CSEExpressionEquivalence.identicalValue(a1, b0);
            }
            assert (a.inValues().size() == b.inValues().size());
            for (int i = 0; i < a.inValues().size(); ++i) {
                if (CSEExpressionEquivalence.identicalValue(a.inValues().get(i), b.inValues().get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int doHash(Instruction instruction) {
            int prime = 29;
            int hash = instruction.getClass().hashCode();
            if (instruction.isBinop()) {
                Binop binop = instruction.asBinop();
                Value in0 = instruction.inValues().get(0);
                Value in1 = instruction.inValues().get(1);
                if (binop.isCommutative()) {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0) * CSEExpressionEquivalence.getHashCode(in1);
                } else {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0);
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in1);
                }
                return hash;
            }
            for (Value value : instruction.inValues()) {
                hash += hash * 29 + CSEExpressionEquivalence.getHashCode(value);
            }
            return hash;
        }

        private static boolean identicalValue(Value a, Value b) {
            if (a.equals(b)) {
                return true;
            }
            if (a.isConstNumber() && b.isConstNumber()) {
                return a.definition.identicalNonValueNonPositionParts(b.definition);
            }
            return false;
        }

        private static int getHashCode(Value a) {
            if (a.isConstNumber()) {
                return Long.hashCode(a.definition.asConstNumber().getRawValue());
            }
            return a.hashCode();
        }
    }

    static enum RemoveCheckCastInstructionIfTrivialResult {
        NO_REMOVALS,
        REMOVED_CAST_DO_NARROW;

    }

    private static class Interval {
        private final IntList keys = new IntArrayList();

        public Interval(IntList ... allKeys) {
            assert (allKeys.length > 0);
            for (IntList keys2 : allKeys) {
                assert (keys2.size() > 0);
                this.keys.addAll(keys2);
            }
        }

        public int getMin() {
            return this.keys.getInt(0);
        }

        public int getMax() {
            return this.keys.getInt(this.keys.size() - 1);
        }

        public void addInterval(Interval other) {
            assert (this.getMax() < other.getMin());
            this.keys.addAll(other.keys);
        }

        public long packedSavings(InternalOutputMode mode) {
            long packedTargets = (long)this.getMax() - (long)this.getMin() + 1L;
            if (!IntSwitch.canBePacked(mode, packedTargets)) {
                return -9223372036854775807L;
            }
            long sparseCost = (long)IntSwitch.baseSparseSize(mode) + IntSwitch.sparsePayloadSize(mode, this.keys.size());
            long packedCost = (long)IntSwitch.basePackedSize(mode) + IntSwitch.packedPayloadSize(mode, packedTargets);
            return sparseCost - packedCost;
        }

        public long estimatedSize(InternalOutputMode mode) {
            return IntSwitch.estimatedSize(mode, this.keys.toIntArray());
        }
    }

    public static class IfBuilder
    extends InstructionBuilder<IfBuilder> {
        private final IRCode code;
        private Value left;
        private int right;
        private BasicBlock target;
        private BasicBlock fallthrough;

        public IfBuilder(Position position, IRCode code) {
            super(position);
            this.code = code;
        }

        @Override
        public IfBuilder self() {
            return this;
        }

        public IfBuilder setLeft(Value left) {
            this.left = left;
            return this;
        }

        public IfBuilder setRight(int right) {
            this.right = right;
            return this;
        }

        public IfBuilder setTarget(BasicBlock target) {
            this.target = target;
            return this;
        }

        public IfBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build() {
            BasicBlock ifBlock;
            If newIf;
            assert (this.target != null);
            assert (this.fallthrough != null);
            if (this.right != 0) {
                ConstNumber rightConst = this.code.createIntConstant(this.right);
                rightConst.setPosition(this.position);
                newIf = new If(If.Type.EQ, ImmutableList.of(this.left, rightConst.dest()));
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf, this.code.metadata(), rightConst);
            } else {
                newIf = new If(If.Type.EQ, this.left);
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf, this.code.metadata());
            }
            newIf.setPosition(this.position);
            ifBlock.link(this.target);
            ifBlock.link(this.fallthrough);
            return ifBlock;
        }
    }

    public static class SwitchBuilder
    extends InstructionBuilder<SwitchBuilder> {
        private Value value;
        private final Int2ReferenceSortedMap<BasicBlock> keyToTarget = new Int2ReferenceAVLTreeMap<BasicBlock>();
        private BasicBlock fallthrough;

        public SwitchBuilder(Position position) {
            super(position);
        }

        @Override
        public SwitchBuilder self() {
            return this;
        }

        public SwitchBuilder setValue(Value value) {
            this.value = value;
            return this;
        }

        public SwitchBuilder addKeyAndTarget(int key, BasicBlock target) {
            this.keyToTarget.put(key, target);
            return this;
        }

        public SwitchBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build(IRMetadata metadata) {
            int NOT_FOUND = -1;
            Object2IntLinkedOpenHashMap<BasicBlock> targetToSuccessorIndex = new Object2IntLinkedOpenHashMap<BasicBlock>();
            targetToSuccessorIndex.defaultReturnValue(-1);
            int[] keys2 = new int[this.keyToTarget.size()];
            int[] targetBlockIndices = new int[this.keyToTarget.size()];
            int count = 0;
            IntBidirectionalIterator iter = this.keyToTarget.keySet().iterator();
            while (iter.hasNext()) {
                int key = iter.nextInt();
                BasicBlock target = (BasicBlock)this.keyToTarget.get(key);
                Integer targetIndex = targetToSuccessorIndex.computeIfAbsent(target, b -> targetToSuccessorIndex.size());
                keys2[count] = key;
                targetBlockIndices[count] = targetIndex;
                ++count;
            }
            Integer fallthroughIndex = targetToSuccessorIndex.computeIfAbsent(this.fallthrough, b -> targetToSuccessorIndex.size());
            IntSwitch newSwitch = new IntSwitch(this.value, keys2, targetBlockIndices, fallthroughIndex);
            newSwitch.setPosition(this.position);
            BasicBlock newSwitchBlock = BasicBlock.createSwitchBlock(this.blockNumber, newSwitch, metadata);
            for (BasicBlock successor : targetToSuccessorIndex.keySet()) {
                newSwitchBlock.link(successor);
            }
            return newSwitchBlock;
        }
    }

    public static abstract class InstructionBuilder<T> {
        protected int blockNumber;
        protected final Position position;

        protected InstructionBuilder(Position position) {
            this.position = position;
        }

        public abstract T self();

        public T setBlockNumber(int blockNumber) {
            this.blockNumber = blockNumber;
            return this.self();
        }
    }

    private static enum InstanceOfResult {
        UNKNOWN,
        TRUE,
        FALSE;

    }
}

