/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ValueMayDependOnEnvironmentAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.ClassNameComputationInfo;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.Action;
import shadow.bundletool.com.android.tools.r8.utils.IteratorUtils;

public class ClassInitializerDefaultsOptimization {
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexItemFactory dexItemFactory;
    private WaveDoneAction waveDoneAction = null;

    public ClassInitializerDefaultsOptimization(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        this.dexItemFactory = appView.dexItemFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(DexEncodedMethod method, IRCode code) {
        if (!method.isClassInitializer()) {
            return;
        }
        DexClass clazz = this.appView.definitionFor(method.method.holder);
        if (clazz == null) {
            return;
        }
        Set<StaticPut> unnecessaryStaticPuts = Sets.newIdentityHashSet();
        Collection<StaticPut> finalFieldPuts = this.findFinalFieldPutsWhileCollectingUnnecessaryStaticPuts(code, clazz, unnecessaryStaticPuts);
        if (finalFieldPuts.isEmpty()) {
            assert (unnecessaryStaticPuts.isEmpty());
            return;
        }
        IdentityHashMap<DexEncodedField, DexValue> fieldsWithStaticValues = new IdentityHashMap<DexEncodedField, DexValue>();
        for (StaticPut put : finalFieldPuts) {
            DexEncodedField field2 = ((AppInfo)this.appView.appInfo()).resolveField(put.getField());
            DexType fieldType = field2.field.type;
            Value value = put.value();
            if (!unnecessaryStaticPuts.contains(put)) continue;
            if (fieldType == this.dexItemFactory.stringType) {
                fieldsWithStaticValues.put(field2, this.getDexStringValue(value, method.method.holder));
                continue;
            }
            if (fieldType.isClassType() || fieldType.isArrayType()) {
                if (value.isZero()) {
                    fieldsWithStaticValues.put(field2, DexValue.DexValueNull.NULL);
                    continue;
                }
                throw new Unreachable("Unexpected default value for field type " + fieldType + ".");
            }
            ConstNumber cnst = value.getConstInstruction().asConstNumber();
            if (fieldType == this.dexItemFactory.booleanType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueBoolean.create(cnst.getBooleanValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.byteType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueByte.create((byte)cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.shortType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueShort.create((short)cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.intType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueInt.create(cnst.getIntValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.longType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueLong.create(cnst.getLongValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.floatType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueFloat.create(cnst.getFloatValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.doubleType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueDouble.create(cnst.getDoubleValue()));
                continue;
            }
            if (fieldType == this.dexItemFactory.charType) {
                fieldsWithStaticValues.put(field2, DexValue.DexValueChar.create((char)cnst.getIntValue()));
                continue;
            }
            throw new Unreachable("Unexpected field type " + fieldType + ".");
        }
        if (!unnecessaryStaticPuts.isEmpty()) {
            Set<Instruction> unnecessaryInstructions = Sets.newIdentityHashSet();
            InstructionListIterator instructionIterator = code.instructionListIterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (!instruction.isStaticPut() || !unnecessaryStaticPuts.contains(instruction.asStaticPut())) continue;
                Value inValue = instruction.asStaticPut().value();
                instructionIterator.removeOrReplaceByDebugLocalRead();
                if (inValue.numberOfAllUsers() > 0) continue;
                if (inValue.isConstString()) {
                    unnecessaryInstructions.add(inValue.definition);
                    continue;
                }
                if (inValue.isPhi() || !inValue.definition.isInvokeVirtual()) continue;
                unnecessaryInstructions.add(inValue.definition);
            }
            if (unnecessaryInstructions.size() > 0) {
                IteratorUtils.removeIf(code.instructionListIterator(), unnecessaryInstructions::contains);
            }
        }
        if (this.appView.enableWholeProgramOptimizations() && this.converter.isInWave()) {
            if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
                AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
                AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
                Set<DexField> candidates = finalFieldPuts.stream().filter(unnecessaryStaticPuts::contains).map(FieldInstruction::getField).map(appInfoWithLiveness::resolveField).filter(appInfoWithLiveness::isStaticFieldWrittenOnlyInEnclosingStaticInitializer).map(field -> field.field).collect(Collectors.toSet());
                for (Instruction instruction : code.instructions()) {
                    StaticPut staticPutInstruction;
                    DexField field3;
                    DexEncodedField encodedField;
                    if (!instruction.isStaticPut() || (encodedField = appInfoWithLiveness.resolveField(field3 = (staticPutInstruction = instruction.asStaticPut()).getField())) == null) continue;
                    candidates.remove(encodedField.field);
                }
                ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization = this;
                synchronized (classInitializerDefaultsOptimization) {
                    if (this.waveDoneAction == null) {
                        this.waveDoneAction = new WaveDoneAction(fieldsWithStaticValues, candidates);
                        this.converter.addWaveDoneAction(() -> {
                            this.waveDoneAction.execute();
                            this.waveDoneAction = null;
                        });
                    } else {
                        this.waveDoneAction.join(fieldsWithStaticValues, candidates);
                    }
                }
            } else assert (false);
        } else {
            fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
    }

    private DexValue getDexStringValue(Value inValue, DexType holder) {
        if (inValue.isPhi()) {
            return null;
        }
        if (inValue.isConstant()) {
            if (inValue.isConstNumber()) {
                assert (inValue.isZero());
                return DexValue.DexValueNull.NULL;
            }
            if (inValue.isConstString()) {
                ConstString cnst = inValue.getConstInstruction().asConstString();
                return new DexValue.DexValueString(cnst.getValue());
            }
            if (inValue.isDexItemBasedConstString()) {
                DexItemBasedConstString cnst = inValue.getConstInstruction().asDexItemBasedConstString();
                assert (!cnst.getNameComputationInfo().needsToComputeName());
                return new DexValue.DexItemBasedValueString(cnst.getItem(), cnst.getNameComputationInfo());
            }
            assert (false);
            return null;
        }
        InvokeVirtual invoke = inValue.getAliasedValue().definition.asInvokeVirtual();
        return this.getDexStringValueForInvoke(invoke.getInvokedMethod(), holder);
    }

    private DexValue getDexStringValueForInvoke(DexMethod invokedMethod, DexType holder) {
        DexClass clazz = this.appView.definitionFor(holder);
        if (clazz == null) {
            assert (false);
            return null;
        }
        if (this.appView.options().isMinifying() && this.appView.rootSet().mayBeMinified(holder, this.appView)) {
            if (invokedMethod == this.dexItemFactory.classMethods.getName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
                // empty if block
            }
            assert (false);
            return null;
        }
        ClassNameComputationInfo.ClassNameMapping mapping = null;
        if (invokedMethod == this.dexItemFactory.classMethods.getName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
            // empty if block
        }
        if (mapping != null) {
            return new DexValue.DexValueString(mapping.map(holder.toDescriptorString(), clazz, this.dexItemFactory));
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<StaticPut> findFinalFieldPutsWhileCollectingUnnecessaryStaticPuts(IRCode code, DexClass clazz, Set<StaticPut> unnecessaryStaticPuts) {
        ValueMayDependOnEnvironmentAnalysis environmentAnalysis = new ValueMayDependOnEnvironmentAnalysis(this.appView, code);
        IdentityHashMap<DexField, StaticPut> finalFieldPuts = Maps.newIdentityHashMap();
        IdentityHashMap<DexField, Set<StaticPut>> isWrittenBefore = Maps.newIdentityHashMap();
        Set<DexField> isReadBefore = Sets.newIdentityHashSet();
        int color = code.reserveMarkingColor();
        try {
            BasicBlock block = code.entryBlock();
            while (!block.isMarked(color) && block.getPredecessors().size() <= 1) {
                block.mark(color);
                for (Instruction instruction : block.getInstructions()) {
                    Value outValue;
                    Object put;
                    Object field;
                    Collection<StaticPut> collection;
                    if (instruction.isArrayPut()) {
                        ArrayPut arrayPut = instruction.asArrayPut();
                        if (!arrayPut.instructionInstanceCanThrow(this.appView, clazz.type).isThrowing()) continue;
                        collection = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                        return collection;
                    }
                    if (instruction.isStaticGet()) {
                        StaticGet get = instruction.asStaticGet();
                        field = ((AppInfo)this.appView.appInfo()).resolveField(get.getField());
                        if (field != null && ((DexEncodedField)field).field.holder == clazz.type) {
                            isReadBefore.add(((DexEncodedField)field).field);
                            continue;
                        }
                        if (!instruction.instructionMayHaveSideEffects(this.appView, clazz.type)) continue;
                        Collection<StaticPut> collection2 = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                        return collection2;
                    }
                    if (instruction.isStaticPut()) {
                        put = instruction.asStaticPut();
                        if (((FieldInstruction)put).getField().holder != clazz.type) {
                            field = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                            return field;
                        }
                        field = ((FieldInstruction)put).getField();
                        Value value = ((StaticPut)put).value();
                        TypeLatticeElement valueType = value.getTypeLattice();
                        if (clazz.definesStaticField((DexField)field)) {
                            if (isReadBefore.contains(field) || value.isDexItemBasedConstStringThatNeedsToComputeClassName()) continue;
                            if (value.isConstant()) {
                                if (((DexField)field).type.isReferenceType() && value.isZero()) {
                                    finalFieldPuts.put((DexField)field, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(field)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(field));
                                    isWrittenBefore.remove(field);
                                    continue;
                                }
                                if (((DexField)field).type.isPrimitiveType() || ((DexField)field).type == this.dexItemFactory.stringType) {
                                    finalFieldPuts.put((DexField)field, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(field)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(field));
                                    isWrittenBefore.remove(field);
                                    continue;
                                }
                            } else {
                                if (this.isClassNameConstantOf(clazz, (StaticPut)put)) {
                                    finalFieldPuts.put((DexField)field, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(field)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(field));
                                    isWrittenBefore.remove(field);
                                    continue;
                                }
                                if (valueType.isReference() && valueType.isDefinitelyNotNull()) {
                                    finalFieldPuts.put((DexField)field, (StaticPut)put);
                                    continue;
                                }
                            }
                        } else {
                            Collection<StaticPut> collection3 = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                            return collection3;
                        }
                        isWrittenBefore.computeIfAbsent((DexField)field, ignore -> Sets.newIdentityHashSet()).add(put);
                        continue;
                    }
                    if (instruction.instructionMayHaveSideEffects(this.appView, clazz.type)) {
                        put = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                        return put;
                    }
                    if (this.isClassNameConstantOf(clazz, instruction)) continue;
                    if (!instruction.isInvoke() || !instruction.hasOutValue() || (outValue = instruction.outValue()).numberOfAllUsers() <= 0) continue;
                    if (instruction.isInvokeNewArray() && environmentAnalysis.isConstantArrayThroughoutMethod(outValue)) continue;
                    collection = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                    return collection;
                }
                if (!block.exit().isGoto()) continue;
                block = block.exit().asGoto().getTarget();
            }
        }
        finally {
            code.returnMarkingColor(color);
        }
        return this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
    }

    private Collection<StaticPut> validateFinalFieldPuts(Map<DexField, StaticPut> finalFieldPuts, Map<DexField, Set<StaticPut>> isWrittenBefore) {
        isWrittenBefore.keySet().forEach(finalFieldPuts::remove);
        return finalFieldPuts.values();
    }

    private boolean isClassNameConstantOf(DexClass clazz, StaticPut put) {
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        Value value = put.value().getAliasedValue();
        if (value.isPhi()) {
            return false;
        }
        return this.isClassNameConstantOf(clazz, value.definition);
    }

    private boolean isClassNameConstantOf(DexClass clazz, Instruction instruction) {
        if (instruction.isInvokeVirtual()) {
            InvokeVirtual invoke = instruction.asInvokeVirtual();
            if (!this.dexItemFactory.classMethods.isReflectiveNameLookup(invoke.getInvokedMethod())) {
                return false;
            }
            Value inValue = invoke.inValues().get(0);
            return !inValue.isPhi() && inValue.definition.isConstClass() && inValue.definition.asConstClass().getValue() == clazz.type;
        }
        return false;
    }

    private class WaveDoneAction
    implements Action {
        private final Map<DexEncodedField, DexValue> fieldsWithStaticValues;
        private final Set<DexField> noLongerWrittenFields;

        public WaveDoneAction(Map<DexEncodedField, DexValue> fieldsWithStaticValues, Set<DexField> noLongerWrittenFields) {
            this.fieldsWithStaticValues = fieldsWithStaticValues;
            this.noLongerWrittenFields = noLongerWrittenFields;
        }

        public synchronized void join(Map<DexEncodedField, DexValue> fieldsWithStaticValues, Set<DexField> noLongerWrittenFields) {
            this.fieldsWithStaticValues.putAll(fieldsWithStaticValues);
            this.noLongerWrittenFields.addAll(noLongerWrittenFields);
        }

        @Override
        public void execute() {
            AppView<AppInfoWithLiveness> appViewWithLiveness = ClassInitializerDefaultsOptimization.this.appView.withLiveness();
            appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().withoutStaticFieldsWrites(this.noLongerWrittenFields));
            this.fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
    }
}

