/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CodeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PostOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class CallSiteOptimizationInfoPropagator
implements PostOptimization {
    private final AppView<AppInfoWithLiveness> appView;
    private Set<DexEncodedMethod> revisitedMethods = null;
    private Mode mode = Mode.COLLECT;

    public CallSiteOptimizationInfoPropagator(AppView<AppInfoWithLiveness> appView) {
        assert (appView.enableWholeProgramOptimizations());
        this.appView = appView;
        if (Log.isLoggingEnabledFor(CallSiteOptimizationInfoPropagator.class)) {
            this.revisitedMethods = Sets.newIdentityHashSet();
        }
    }

    public void logResults() {
        assert (Log.ENABLED);
        if (this.revisitedMethods != null) {
            Log.info(this.getClass(), "# of methods to revisit: %s", this.revisitedMethods.size());
            for (DexEncodedMethod m : this.revisitedMethods) {
                Log.info(this.getClass(), "%s: %s", m.toSourceString(), m.getCallSiteOptimizationInfo().toString());
            }
        }
    }

    public void collectCallSiteOptimizationInfo(IRCode code) {
        if (this.mode != Mode.COLLECT) {
            return;
        }
        DexEncodedMethod context = code.method;
        for (Instruction instruction : code.instructions()) {
            Set<DexEncodedMethod> targets;
            if (!instruction.isInvokeMethod() && !instruction.isInvokeCustom()) continue;
            if (instruction.isInvokeMethod()) {
                InvokeMethod invoke = instruction.asInvokeMethod();
                if (invoke.isInvokeMethodWithDynamicDispatch()) {
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    ResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(invokedMethod.holder, invokedMethod);
                    if (!resolutionResult.isVirtualTarget() || resolutionResult.isSingleResolution() && this.isLibraryMethodOrLibraryMethodOverride(resolutionResult.getSingleTarget())) continue;
                }
                Collection<DexEncodedMethod> targets2 = invoke.lookupTargets(this.appView, context.method.holder);
                assert (invoke.isInvokeMethodWithDynamicDispatch() || targets2 == null || targets2.size() <= 1);
                if (targets2 == null || targets2.isEmpty() || this.hasLibraryOverrides(targets2)) continue;
                for (DexEncodedMethod target : targets2) {
                    this.recordArgumentsIfNecessary(target, invoke.inValues());
                }
            }
            if (!instruction.isInvokeCustom() || (targets = this.appView.appInfo().lookupLambdaImplementedMethods(instruction.asInvokeCustom().getCallSite())) == null || targets.isEmpty() || this.hasLibraryOverrides(targets)) continue;
            for (DexEncodedMethod target : targets) {
                this.recordArgumentsIfNecessary(target, instruction.inValues());
            }
        }
    }

    private boolean hasLibraryOverrides(Collection<DexEncodedMethod> targets) {
        for (DexEncodedMethod target : targets) {
            if (!this.isLibraryMethodOrLibraryMethodOverride(target)) continue;
            return true;
        }
        return false;
    }

    private boolean isLibraryMethodOrLibraryMethodOverride(DexEncodedMethod target) {
        if (!target.isProgramMethod(this.appView)) {
            return true;
        }
        return target.isLibraryMethodOverride().isTrue();
    }

    private void recordArgumentsIfNecessary(DexEncodedMethod target, List<Value> inValues) {
        assert (!target.isObsolete());
        if (target.getCallSiteOptimizationInfo().isTop()) {
            return;
        }
        target.joinCallSiteOptimizationInfo(this.computeCallSiteOptimizationInfoFromArguments(target, inValues), this.appView);
    }

    private CallSiteOptimizationInfo computeCallSiteOptimizationInfoFromArguments(DexEncodedMethod target, List<Value> inValues) {
        int argumentOffset;
        if (target.shouldNotHaveCode() || inValues.size() == 0) {
            return CallSiteOptimizationInfo.TOP;
        }
        if (this.appView.appInfo().isPinned(target.method)) {
            return CallSiteOptimizationInfo.TOP;
        }
        if (!target.isProgramMethod(this.appView)) {
            assert (false) : "Trying to compute call site optimization info for " + target.toSourceString();
            return CallSiteOptimizationInfo.TOP;
        }
        if (target.isLibraryMethodOverride().isTrue()) {
            assert (false) : "Trying to compute call site optimization info for " + target.toSourceString();
            return CallSiteOptimizationInfo.TOP;
        }
        int n = argumentOffset = target.isStatic() ? 0 : 1;
        if (inValues.size() != argumentOffset + target.method.getArity()) {
            return CallSiteOptimizationInfo.BOTTOM;
        }
        return ConcreteCallSiteOptimizationInfo.fromArguments(this.appView, target, inValues);
    }

    public void applyCallSiteOptimizationInfo(IRCode code, CallSiteOptimizationInfo callSiteOptimizationInfo) {
        Instruction instr;
        if (this.mode != Mode.REVISIT) {
            return;
        }
        if (!callSiteOptimizationInfo.hasUsefulOptimizationInfo(this.appView, code.method)) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        LinkedList<Assume<Assume.Assumption>> assumeInstructions = new LinkedList<Assume<Assume.Assumption>>();
        LinkedList<Instruction> constants = new LinkedList<Instruction>();
        int argumentsSeen = 0;
        InstructionListIterator iterator2 = code.entryBlock().listIterator(code);
        while (iterator2.hasNext() && (instr = (Instruction)iterator2.next()).isArgument()) {
            Value specializedArg;
            TypeLatticeElement dynamicUpperBoundType;
            ++argumentsSeen;
            Value originalArg = instr.asArgument().outValue();
            if (originalArg.hasLocalInfo() || !originalArg.getTypeLattice().isReference()) continue;
            int argIndex = argumentsSeen - 1;
            AbstractValue abstractValue = callSiteOptimizationInfo.getAbstractArgumentValue(argIndex);
            if (abstractValue.isSingleValue()) {
                assert (this.appView.options().enablePropagationOfConstantsAtCallSites);
                SingleValue singleValue = abstractValue.asSingleValue();
                if (singleValue.isMaterializableInContext(this.appView, code.method.method.holder)) {
                    Instruction replacement = singleValue.createMaterializingInstruction(this.appView, code, instr);
                    replacement.setPosition(instr.getPosition());
                    affectedValues.addAll(originalArg.affectedValues());
                    originalArg.replaceUsers(replacement.outValue());
                    constants.add(replacement);
                    continue;
                }
            }
            if ((dynamicUpperBoundType = callSiteOptimizationInfo.getDynamicUpperBoundType(argIndex)) == null) continue;
            if (dynamicUpperBoundType.isDefinitelyNull()) {
                ConstNumber nullInstruction = code.createConstNull();
                nullInstruction.setPosition(instr.getPosition());
                affectedValues.addAll(originalArg.affectedValues());
                originalArg.replaceUsers(nullInstruction.outValue());
                constants.add(nullInstruction);
                continue;
            }
            if (dynamicUpperBoundType.strictlyLessThan(originalArg.getTypeLattice(), this.appView)) {
                specializedArg = code.createValue(originalArg.getTypeLattice());
                affectedValues.addAll(originalArg.affectedValues());
                originalArg.replaceUsers(specializedArg);
                Assume<Assume.DynamicTypeAssumption> assumeType = Assume.createAssumeDynamicTypeInstruction(dynamicUpperBoundType, null, specializedArg, originalArg, instr, this.appView);
                assumeType.setPosition(instr.getPosition());
                assumeInstructions.add(assumeType);
            } else {
                specializedArg = originalArg;
            }
            assert (specializedArg != null && specializedArg.getTypeLattice().isReference());
            if (!dynamicUpperBoundType.isDefinitelyNotNull() || specializedArg.getTypeLattice().isDefinitelyNotNull()) continue;
            Value nonNullArg = code.createValue(specializedArg.getTypeLattice().asReferenceTypeLatticeElement().asMeetWithNotNull());
            affectedValues.addAll(specializedArg.affectedValues());
            specializedArg.replaceUsers(nonNullArg);
            Assume<Assume.NonNullAssumption> assumeNotNull = Assume.createAssumeNonNullInstruction(nonNullArg, specializedArg, instr, this.appView);
            assumeNotNull.setPosition(instr.getPosition());
            assumeInstructions.add(assumeNotNull);
        }
        assert (argumentsSeen == code.method.method.getArity() + (code.method.isStatic() ? 0 : 1)) : "args: " + argumentsSeen + " != arity: " + code.method.method.getArity() + ", static: " + code.method.isStatic();
        assert (!iterator2.peekPrevious().isArgument());
        iterator2.previous();
        assert (iterator2.peekPrevious().isArgument());
        assumeInstructions.forEach(iterator2::add);
        constants.forEach(iterator2::add);
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    @Override
    public Set<DexEncodedMethod> methodsToRevisit() {
        this.mode = Mode.REVISIT;
        Set<DexEncodedMethod> targetsToRevisit = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            for (DexEncodedMethod method : clazz.methods()) {
                CallSiteOptimizationInfo callSiteOptimizationInfo;
                assert (!method.isObsolete());
                if (method.shouldNotHaveCode() || !method.hasCode() || method.getCode().isEmptyVoidMethod() || !(callSiteOptimizationInfo = method.getCallSiteOptimizationInfo()).hasUsefulOptimizationInfo(this.appView, method)) continue;
                targetsToRevisit.add(method);
                if (this.appView.options().testing.callSiteOptimizationInfoInspector == null) continue;
                this.appView.options().testing.callSiteOptimizationInfoInspector.accept(method);
            }
        }
        if (this.revisitedMethods != null) {
            this.revisitedMethods.addAll(targetsToRevisit);
        }
        return targetsToRevisit;
    }

    @Override
    public Collection<CodeOptimization> codeOptimizationsForPostProcessing() {
        return null;
    }

    private static enum Mode {
        COLLECT,
        REVISIT;

    }
}

