/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.IdentityHashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;

public class NestedPrivateMethodLense
extends GraphLense.NestedGraphLense {
    private final DexType nestConstructorType;
    private final Map<DexField, DexMethod> getFieldMap;
    private final Map<DexField, DexMethod> putFieldMap;

    NestedPrivateMethodLense(AppView<?> appView, DexType nestConstructorType, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexMethod> getFieldMap, Map<DexField, DexMethod> putFieldMap, GraphLense previousLense) {
        super(ImmutableMap.of(), methodMap, ImmutableMap.of(), null, null, previousLense, appView.dexItemFactory());
        assert (methodMap instanceof IdentityHashMap);
        assert (getFieldMap instanceof IdentityHashMap);
        assert (putFieldMap instanceof IdentityHashMap);
        this.nestConstructorType = nestConstructorType;
        this.getFieldMap = getFieldMap;
        this.putFieldMap = putFieldMap;
    }

    private DexMethod lookupFieldForMethod(DexField field, DexMethod context, Map<DexField, DexMethod> map2) {
        assert (context != null);
        DexMethod bridge = map2.get(field);
        if (bridge != null && bridge.holder != context.holder) {
            return bridge;
        }
        return null;
    }

    @Override
    public DexMethod lookupGetFieldForMethod(DexField field, DexMethod context) {
        assert (this.previousLense.lookupGetFieldForMethod(field, context) == null);
        return this.lookupFieldForMethod(field, context, this.getFieldMap);
    }

    @Override
    public DexMethod lookupPutFieldForMethod(DexField field, DexMethod context) {
        assert (this.previousLense.lookupPutFieldForMethod(field, context) == null);
        return this.lookupFieldForMethod(field, context, this.putFieldMap);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.methodMap.isEmpty();
    }

    @Override
    public boolean isContextFreeForMethod(DexMethod method) {
        if (!this.previousLense.isContextFreeForMethod(method)) {
            return false;
        }
        DexMethod previous = this.previousLense.lookupMethod(method);
        return !this.methodMap.containsKey(previous);
    }

    @Override
    protected boolean isLegitimateToHaveEmptyMappings() {
        return true;
    }

    private boolean isConstructorBridge(DexMethod method) {
        DexType[] parameters = method.proto.parameters.values;
        if (parameters.length == 0) {
            return false;
        }
        DexType lastParameterType = parameters[parameters.length - 1];
        return lastParameterType == this.nestConstructorType;
    }

    @Override
    public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
        if (this.isConstructorBridge(method)) {
            assert (this.previousLense.lookupPrototypeChanges(method).isEmpty());
            return GraphLense.RewrittenPrototypeDescription.none().withExtraNullParameter();
        }
        return this.previousLense.lookupPrototypeChanges(method);
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        assert (this.originalMethodSignatures == null);
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
        DexMethod bridge = (DexMethod)this.methodMap.get(previous.getMethod());
        if (bridge == null) {
            return previous;
        }
        assert (context != null) : "Guaranteed by isContextFreeForMethod";
        if (bridge.holder == context.holder) {
            return previous;
        }
        if (this.isConstructorBridge(bridge)) {
            return new GraphLense.GraphLenseLookupResult(bridge, Invoke.Type.DIRECT);
        }
        return new GraphLense.GraphLenseLookupResult(bridge, Invoke.Type.STATIC);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GraphLense.Builder {
        private Map<DexField, DexMethod> getFieldMap = new IdentityHashMap<DexField, DexMethod>();
        private Map<DexField, DexMethod> putFieldMap = new IdentityHashMap<DexField, DexMethod>();

        public void mapGetField(DexField from, DexMethod to) {
            this.getFieldMap.put(from, to);
        }

        public void mapPutField(DexField from, DexMethod to) {
            this.putFieldMap.put(from, to);
        }

        public GraphLense build(AppView<?> appView, DexType nestConstructorType) {
            assert (this.typeMap.isEmpty());
            assert (this.fieldMap.isEmpty());
            if (this.getFieldMap.isEmpty() && this.methodMap.isEmpty() && this.putFieldMap.isEmpty()) {
                return appView.graphLense();
            }
            return new NestedPrivateMethodLense(appView, nestConstructorType, this.methodMap, this.getFieldMap, this.putFieldMap, appView.graphLense());
        }
    }
}

