/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.DesugarGraphConsumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeSuper;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.BackportedMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.ClassProcessor;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DefaultMethodsHelper;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryWrapperSynthesizer;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.position.MethodPosition;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Pair;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public final class InterfaceMethodRewriter {
    public static final String EMULATE_LIBRARY_CLASS_NAME_SUFFIX = "$-EL";
    public static final String DISPATCH_CLASS_NAME_SUFFIX = "$-DC";
    public static final String COMPANION_CLASS_NAME_SUFFIX = "$-CC";
    public static final String DEFAULT_METHOD_PREFIX = "$default$";
    public static final String PRIVATE_METHOD_PREFIX = "$private$";
    private final AppView<?> appView;
    private final IRConverter converter;
    private final InternalOptions options;
    final DexItemFactory factory;
    private final Map<DexType, DexType> emulatedInterfaces = new IdentityHashMap<DexType, DexType>();
    private final Set<DexString> emulatedMethods = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> synthesizedMethods = Sets.newIdentityHashSet();
    private final Map<DexType, DefaultMethodsHelper.Collection> cache = new ConcurrentHashMap<DexType, DefaultMethodsHelper.Collection>();
    private final ConcurrentMap<DexLibraryClass, Set<DexProgramClass>> requiredDispatchClasses = new ConcurrentHashMap<DexLibraryClass, Set<DexProgramClass>>();

    public InterfaceMethodRewriter(AppView<?> appView, IRConverter converter) {
        assert (converter != null);
        this.appView = appView;
        this.converter = converter;
        this.options = appView.options();
        this.factory = appView.dexItemFactory();
        this.initializeEmulatedInterfaceVariables();
    }

    private void initializeEmulatedInterfaceVariables() {
        Map<DexType, DexType> emulateLibraryInterface = this.options.desugaredLibraryConfiguration.getEmulateLibraryInterface();
        for (DexType interfaceType : emulateLibraryInterface.keySet()) {
            this.emulatedInterfaces.put(interfaceType, emulateLibraryInterface.get(interfaceType));
            this.addRewritePrefix(interfaceType, emulateLibraryInterface.get(interfaceType).toSourceString());
            DexClass emulatedInterfaceClass = this.appView.definitionFor(interfaceType);
            if (emulatedInterfaceClass == null) continue;
            for (DexEncodedMethod encodedMethod : emulatedInterfaceClass.methods(DexEncodedMethod::isDefaultMethod)) {
                this.emulatedMethods.add(encodedMethod.method.name);
            }
        }
    }

    private void addRewritePrefix(DexType interfaceType, String rewrittenType) {
        this.appView.rewritePrefix.rewriteType(this.getCompanionClassType(interfaceType), this.factory.createType(DescriptorUtils.javaTypeToDescriptor(rewrittenType + COMPANION_CLASS_NAME_SUFFIX)));
        this.appView.rewritePrefix.rewriteType(InterfaceMethodRewriter.getEmulateLibraryInterfaceClassType(interfaceType, this.factory), this.factory.createType(DescriptorUtils.javaTypeToDescriptor(rewrittenType + EMULATE_LIBRARY_CLASS_NAME_SUFFIX)));
    }

    boolean isEmulatedInterface(DexType itf) {
        return this.emulatedInterfaces.containsKey(itf);
    }

    public void rewriteMethodReferences(DexEncodedMethod encodedMethod, IRCode code) {
        if (this.synthesizedMethods.contains(encodedMethod)) {
            return;
        }
        ListIterator<BasicBlock> blocks = code.listIterator();
        Object appInfo = this.appView.appInfo();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator(code);
            while (instructions.hasNext()) {
                InvokeMethod invokeMethod;
                DexType dexType;
                DexMethod invokedMethod;
                DexClass clazz;
                DexMethod method;
                Instruction instruction = (Instruction)instructions.next();
                if (instruction.isInvokeCustom()) {
                    DexCallSite callSite = instruction.asInvokeCustom().getCallSite();
                    this.reportStaticInterfaceMethodHandle(encodedMethod.method, callSite.bootstrapMethod);
                    for (DexValue arg : callSite.bootstrapArgs) {
                        if (!(arg instanceof DexValue.DexValueMethodHandle)) continue;
                        this.reportStaticInterfaceMethodHandle(encodedMethod.method, (DexMethodHandle)((DexValue.DexValueMethodHandle)arg).value);
                    }
                    continue;
                }
                if (instruction.isInvokeStatic()) {
                    InvokeStatic invokeStatic = instruction.asInvokeStatic();
                    method = invokeStatic.getInvokedMethod();
                    clazz = ((AppInfo)appInfo).definitionFor(method.holder);
                    if (BackportedMethodRewriter.hasRewrittenMethodPrefix(method.holder)) continue;
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                        continue;
                    }
                    if (!clazz.isInterface()) continue;
                    if (this.isNonDesugaredLibraryClass(clazz)) {
                        if (this.options.canLeaveStaticInterfaceMethodInvokes()) continue;
                        instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfDispatchClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                        this.requiredDispatchClasses.computeIfAbsent(clazz.asLibraryClass(), k -> Sets.newConcurrentHashSet()).add(((AppInfo)appInfo).definitionFor(encodedMethod.method.holder).asProgramClass());
                        continue;
                    }
                    instructions.replaceCurrentInstruction(new InvokeStatic(this.staticAsMethodOfCompanionClass(method), invokeStatic.outValue(), invokeStatic.arguments()));
                    continue;
                }
                if (instruction.isInvokeSuper()) {
                    DexClass dexClass;
                    DexEncodedMethod dexEncodedMethod;
                    InvokeSuper invokeSuper = instruction.asInvokeSuper();
                    invokedMethod = invokeSuper.getInvokedMethod();
                    clazz = ((AppInfo)appInfo).definitionFor(invokedMethod.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, invokedMethod.holder);
                        continue;
                    }
                    if (clazz.isInterface() && !clazz.isLibraryClass()) {
                        DexMethod amendedMethod = this.amendDefaultMethod(((AppInfo)appInfo).definitionFor(encodedMethod.method.holder), invokedMethod);
                        instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(amendedMethod), invokeSuper.outValue(), invokeSuper.arguments()));
                        continue;
                    }
                    DexType dexType2 = this.maximallySpecificEmulatedInterfaceOrNull(invokedMethod);
                    if (dexType2 == null || (dexEncodedMethod = ((AppInfo)this.appView.appInfo()).lookupSuperTarget(invokeSuper.getInvokedMethod(), code.method.method.holder)) == null || (dexClass = this.appView.definitionFor(dexEncodedMethod.method.holder)) == null || !dexClass.isLibraryClass()) continue;
                    DexMethod retargetMethod = this.options.desugaredLibraryConfiguration.retargetMethod(dexEncodedMethod.method, this.appView);
                    if (retargetMethod == null) {
                        DexMethod originalCompanionMethod = InterfaceMethodRewriter.instanceAsMethodOfCompanionClass(dexEncodedMethod.method, DEFAULT_METHOD_PREFIX, this.factory);
                        DexMethod companionMethod = this.factory.createMethod(this.getCompanionClassType(dexType2), this.factory.protoWithDifferentFirstParameter(originalCompanionMethod.proto, dexType2), originalCompanionMethod.name);
                        instructions.replaceCurrentInstruction(new InvokeStatic(companionMethod, invokeSuper.outValue(), invokeSuper.arguments()));
                        continue;
                    }
                    instructions.replaceCurrentInstruction(new InvokeStatic(retargetMethod, invokeSuper.outValue(), invokeSuper.arguments()));
                    continue;
                }
                if (instruction.isInvokeDirect()) {
                    InvokeDirect invokeDirect = instruction.asInvokeDirect();
                    method = invokeDirect.getInvokedMethod();
                    if (this.factory.isConstructor(method)) continue;
                    clazz = ((AppInfo)appInfo).definitionFor(method.holder);
                    if (clazz == null) {
                        this.warnMissingType(encodedMethod.method, method.holder);
                    } else if (clazz.isInterface()) {
                        if (clazz.isLibraryClass()) {
                            throw new CompilationError("Unexpected call to a private method defined in library class " + clazz.toSourceString(), this.getMethodOrigin(encodedMethod.method));
                        }
                        DexEncodedMethod virtualTarget = null;
                        for (DexEncodedMethod candidate : clazz.virtualMethods()) {
                            if (candidate.method != method) continue;
                            virtualTarget = candidate;
                            break;
                        }
                        if (virtualTarget != null) {
                            instructions.replaceCurrentInstruction(new InvokeStatic(this.defaultAsMethodOfCompanionClass(method), invokeDirect.outValue(), invokeDirect.arguments()));
                        } else {
                            instructions.replaceCurrentInstruction(new InvokeStatic(this.privateAsMethodOfCompanionClass(method), invokeDirect.outValue(), invokeDirect.arguments()));
                        }
                    }
                }
                if (!instruction.isInvokeVirtual() && !instruction.isInvokeInterface() || (dexType = this.maximallySpecificEmulatedInterfaceOrNull(invokedMethod = (invokeMethod = instruction.asInvokeMethod()).getInvokedMethod())) == null) continue;
                this.rewriteCurrentInstructionToEmulatedInterfaceCall(dexType, invokedMethod, invokeMethod, instructions);
            }
        }
    }

    private DexType maximallySpecificEmulatedInterfaceOrNull(DexMethod invokedMethod) {
        if (!this.emulatedMethods.contains(invokedMethod.name)) {
            return null;
        }
        DexClass dexClass = this.appView.definitionFor(invokedMethod.holder);
        if (dexClass == null) {
            return null;
        }
        if (!this.appView.options().isDesugaredLibraryCompilation() && !dexClass.isLibraryClass()) {
            return null;
        }
        if (this.appView.rewritePrefix.hasRewrittenType(dexClass.type)) {
            return null;
        }
        DexEncodedMethod singleTarget = ((AppInfo)this.appView.appInfo()).resolveMaximallySpecificMethods(dexClass, invokedMethod).getSingleTarget();
        if (singleTarget == null) {
            return null;
        }
        if (!singleTarget.isAbstract() && this.isEmulatedInterface(singleTarget.method.holder)) {
            return singleTarget.method.holder;
        }
        return null;
    }

    private void rewriteCurrentInstructionToEmulatedInterfaceCall(DexType emulatedItf, DexMethod invokedMethod, InvokeMethod invokeMethod, InstructionListIterator instructions) {
        DexEncodedMethod defaultMethod = this.appView.definitionFor(emulatedItf).lookupMethod(invokedMethod);
        if (defaultMethod != null && !this.dontRewrite(defaultMethod.method)) {
            assert (!defaultMethod.isAbstract());
            instructions.replaceCurrentInstruction(new InvokeStatic(InterfaceMethodRewriter.emulateInterfaceLibraryMethod(invokedMethod, emulatedItf, this.factory), invokeMethod.outValue(), invokeMethod.arguments()));
        }
    }

    private boolean isNonDesugaredLibraryClass(DexClass clazz) {
        return clazz.isLibraryClass() && !this.isInDesugaredLibrary(clazz);
    }

    boolean isInDesugaredLibrary(DexClass clazz) {
        assert (clazz.isLibraryClass() || this.options.isDesugaredLibraryCompilation());
        if (this.emulatedInterfaces.containsKey(clazz.type)) {
            return true;
        }
        return this.appView.rewritePrefix.hasRewrittenType(clazz.type);
    }

    boolean dontRewrite(DexMethod method) {
        for (Pair<DexType, DexString> dontRewrite : this.options.desugaredLibraryConfiguration.getDontRewriteInvocation()) {
            if (method.holder != dontRewrite.getFirst() || method.name != dontRewrite.getSecond()) continue;
            return true;
        }
        return false;
    }

    private void warnMissingEmulatedInterface(DexType interfaceType) {
        StringDiagnostic warning = new StringDiagnostic("Cannot emulate interface " + interfaceType.getName() + " because the interface is missing.");
        this.options.reporter.warning(warning);
    }

    private void generateEmulateInterfaceLibrary(DexApplication.Builder<?> builder) {
        Map<DexType, List<DexType>> emulatedInterfacesHierarchy = this.processEmulatedInterfaceHierarchy();
        for (DexType interfaceType : this.emulatedInterfaces.keySet()) {
            DexProgramClass synthesizedClass;
            DexClass theInterface = this.appView.definitionFor(interfaceType);
            if (theInterface == null) {
                this.warnMissingEmulatedInterface(interfaceType);
                continue;
            }
            if (!theInterface.isProgramClass() || (synthesizedClass = this.synthesizeEmulateInterfaceLibraryClass(theInterface.asProgramClass(), emulatedInterfacesHierarchy)) == null) continue;
            builder.addSynthesizedClass(synthesizedClass, this.isInMainDexList(interfaceType));
            ((AppInfo)this.appView.appInfo()).addSynthesizedClass(synthesizedClass);
        }
    }

    private Map<DexType, List<DexType>> processEmulatedInterfaceHierarchy() {
        IdentityHashMap<DexType, List<DexType>> emulatedInterfacesHierarchy = new IdentityHashMap<DexType, List<DexType>>();
        Set<DexType> processed = Sets.newIdentityHashSet();
        for (DexType interfaceType : this.emulatedInterfaces.keySet()) {
            this.processEmulatedInterfaceHierarchy(interfaceType, processed, emulatedInterfacesHierarchy);
        }
        return emulatedInterfacesHierarchy;
    }

    private void processEmulatedInterfaceHierarchy(DexType interfaceType, Set<DexType> processed, Map<DexType, List<DexType>> emulatedInterfacesHierarchy) {
        if (processed.contains(interfaceType)) {
            return;
        }
        emulatedInterfacesHierarchy.put(interfaceType, new ArrayList());
        processed.add(interfaceType);
        DexClass theInterface = this.appView.definitionFor(interfaceType);
        if (theInterface == null) {
            this.warnMissingEmulatedInterface(interfaceType);
            return;
        }
        LinkedList<DexType> workList = new LinkedList<DexType>(Arrays.asList(theInterface.interfaces.values));
        while (!workList.isEmpty()) {
            DexType next = workList.removeLast();
            if (!this.emulatedInterfaces.containsKey(next)) continue;
            this.processEmulatedInterfaceHierarchy(next, processed, emulatedInterfacesHierarchy);
            emulatedInterfacesHierarchy.get(next).add(interfaceType);
            DexClass nextClass = this.appView.definitionFor(next);
            if (nextClass == null) continue;
            workList.addAll(Arrays.asList(nextClass.interfaces.values));
        }
    }

    private boolean implementsInterface(DexClass clazz, DexType interfaceType) {
        LinkedList<DexType> workList = new LinkedList<DexType>(Arrays.asList(clazz.interfaces.values));
        while (!workList.isEmpty()) {
            DexType next = workList.removeLast();
            if (interfaceType == next) {
                return true;
            }
            DexClass nextClass = this.appView.definitionFor(next);
            if (nextClass == null) continue;
            workList.addAll(Arrays.asList(nextClass.interfaces.values));
        }
        return false;
    }

    private static DexMethod emulateInterfaceLibraryMethod(DexMethod method, DexType holder, DexItemFactory factory) {
        return factory.createMethod(InterfaceMethodRewriter.getEmulateLibraryInterfaceClassType(holder, factory), factory.prependTypeToProto(holder, method.proto), factory.createString(method.name.toString()));
    }

    private DexProgramClass synthesizeEmulateInterfaceLibraryClass(DexProgramClass theInterface, Map<DexType, List<DexType>> emulatedInterfacesHierarchy) {
        ArrayList<DexEncodedMethod> emulationMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod method : theInterface.methods()) {
            if (!method.isDefaultMethod()) continue;
            DexMethod libraryMethod = this.factory.createMethod(this.emulatedInterfaces.get(theInterface.type), method.method.proto, method.method.name);
            DexMethod originalCompanionMethod = method.isStatic() ? this.staticAsMethodOfCompanionClass(method.method) : InterfaceMethodRewriter.instanceAsMethodOfCompanionClass(method.method, DEFAULT_METHOD_PREFIX, this.factory);
            DexMethod companionMethod = this.factory.createMethod(this.getCompanionClassType(theInterface.type), originalCompanionMethod.proto, originalCompanionMethod.name);
            List<DexType> subInterfaces = emulatedInterfacesHierarchy.get(theInterface.type);
            ArrayList<Pair<DexType, DexMethod>> extraDispatchCases = new ArrayList<Pair<DexType, DexMethod>>();
            Map<DexString, Map<DexType, DexType>> retargetCoreLibMember = this.options.desugaredLibraryConfiguration.getRetargetCoreLibMember();
            for (DexString methodName : retargetCoreLibMember.keySet()) {
                if (method.method.name != methodName) continue;
                for (DexType inType : retargetCoreLibMember.get(methodName).keySet()) {
                    DexClass inClass = this.appView.definitionFor(inType);
                    if (inClass == null || !this.implementsInterface(inClass, theInterface.type)) continue;
                    extraDispatchCases.add(new Pair<DexType, DexMethod>(inType, this.factory.createMethod(retargetCoreLibMember.get(methodName).get(inType), this.factory.protoWithDifferentFirstParameter(originalCompanionMethod.proto, inType), method.method.name)));
                }
            }
            if (subInterfaces != null) {
                for (int i = subInterfaces.size() - 1; i >= 0; --i) {
                    DexClass subInterfaceClass = this.appView.definitionFor(subInterfaces.get(i));
                    assert (subInterfaceClass != null);
                    DexEncodedMethod result = subInterfaceClass.lookupVirtualMethod(method.method);
                    if (result == null || result.isAbstract()) continue;
                    extraDispatchCases.add(new Pair<DexType, DexMethod>(subInterfaceClass.type, this.factory.createMethod(this.getCompanionClassType(subInterfaceClass.type), this.factory.protoWithDifferentFirstParameter(originalCompanionMethod.proto, subInterfaceClass.type), originalCompanionMethod.name)));
                }
            }
            emulationMethods.add(DexEncodedMethod.toEmulateDispatchLibraryMethod(method.method.holder, InterfaceMethodRewriter.emulateInterfaceLibraryMethod(method.method, method.method.holder, this.factory), companionMethod, libraryMethod, extraDispatchCases, this.appView));
        }
        if (emulationMethods.isEmpty()) {
            return null;
        }
        DexType emulateLibraryClassType = InterfaceMethodRewriter.getEmulateLibraryInterfaceClassType(theInterface.type, this.factory);
        ClassAccessFlags emulateLibraryClassFlags = theInterface.accessFlags.copy();
        emulateLibraryClassFlags.unsetAbstract();
        emulateLibraryClassFlags.unsetInterface();
        emulateLibraryClassFlags.unsetAnnotation();
        emulateLibraryClassFlags.setFinal();
        emulateLibraryClassFlags.setSynthetic();
        emulateLibraryClassFlags.setPublic();
        this.synthesizedMethods.addAll(emulationMethods);
        return new DexProgramClass(emulateLibraryClassType, null, new SynthesizedOrigin("interface desugaring (libs)", this.getClass()), emulateLibraryClassFlags, this.factory.objectType, DexTypeList.empty(), theInterface.sourceFile, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, emulationMethods.toArray(DexEncodedMethod.EMPTY_ARRAY), DexEncodedMethod.EMPTY_ARRAY, this.factory.getSkipNameValidationForTesting(), DexProgramClass::checksumFromType, Collections.singletonList(theInterface));
    }

    private static String getEmulateLibraryInterfaceClassDescriptor(String descriptor) {
        return descriptor.substring(0, descriptor.length() - 1) + EMULATE_LIBRARY_CLASS_NAME_SUFFIX + ";";
    }

    static DexType getEmulateLibraryInterfaceClassType(DexType type, DexItemFactory factory) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String elTypeDescriptor = InterfaceMethodRewriter.getEmulateLibraryInterfaceClassDescriptor(descriptor);
        return factory.createType(elTypeDescriptor);
    }

    private void reportStaticInterfaceMethodHandle(DexMethod referencedFrom, DexMethodHandle handle) {
        if (handle.type.isInvokeStatic()) {
            DexClass holderClass = this.appView.definitionFor(handle.asMethod().holder);
            if (holderClass == null) {
                this.warnMissingType(referencedFrom, handle.asMethod().holder);
            } else if (holderClass.isInterface()) {
                throw new Unimplemented("Desugaring of static interface method handle in `" + referencedFrom.toSourceString() + "` is not yet supported.");
            }
        }
    }

    public static String getCompanionClassDescriptor(String descriptor) {
        return descriptor.substring(0, descriptor.length() - 1) + COMPANION_CLASS_NAME_SUFFIX + ";";
    }

    static DexType getCompanionClassType(DexType type, DexItemFactory factory) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String ccTypeDescriptor = InterfaceMethodRewriter.getCompanionClassDescriptor(descriptor);
        return factory.createType(ccTypeDescriptor);
    }

    DexType getCompanionClassType(DexType type) {
        return InterfaceMethodRewriter.getCompanionClassType(type, this.factory);
    }

    final DexType getDispatchClassType(DexType type) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String dcTypeDescriptor = descriptor.substring(0, descriptor.length() - 1) + DISPATCH_CLASS_NAME_SUFFIX + ";";
        return this.factory.createType(dcTypeDescriptor);
    }

    public static boolean isCompanionClassType(DexType type) {
        return type.descriptor.toString().endsWith("$-CC;");
    }

    private DexType getInterfaceClassType(DexType type) {
        return InterfaceMethodRewriter.getInterfaceClassType(type, this.factory);
    }

    public static DexType getInterfaceClassType(DexType type, DexItemFactory factory) {
        assert (InterfaceMethodRewriter.isCompanionClassType(type));
        String descriptor = type.descriptor.toString();
        String interfaceTypeDescriptor = descriptor.substring(0, descriptor.length() - 1 - COMPANION_CLASS_NAME_SUFFIX.length()) + ";";
        return factory.createType(interfaceTypeDescriptor);
    }

    private boolean isInMainDexList(DexType iface) {
        return ((AppInfo)this.appView.appInfo()).isInMainDexList(iface);
    }

    final DexMethod staticAsMethodOfCompanionClass(DexMethod method) {
        return this.factory.createMethod(this.getCompanionClassType(method.holder), method.proto, method.name);
    }

    final DexMethod staticAsMethodOfDispatchClass(DexMethod method) {
        return this.factory.createMethod(this.getDispatchClassType(method.holder), method.proto, method.name);
    }

    public static boolean hasDispatchClassSuffix(DexType clazz) {
        return clazz.getName().endsWith(DISPATCH_CLASS_NAME_SUFFIX);
    }

    private static DexMethod instanceAsMethodOfCompanionClass(DexMethod method, String prefix, DexItemFactory factory) {
        DexType[] params = method.proto.parameters.values;
        DexType[] newParams = new DexType[params.length + 1];
        newParams[0] = method.holder;
        System.arraycopy(params, 0, newParams, 1, params.length);
        return factory.createMethod(InterfaceMethodRewriter.getCompanionClassType(method.holder, factory), factory.createProto(method.proto.returnType, newParams), factory.createString(prefix + method.name.toString()));
    }

    private DexMethod amendDefaultMethod(DexClass classToDesugar, DexMethod method) {
        DexMethod singleCandidate = this.getOrCreateInterfaceInfo(classToDesugar, classToDesugar, method.holder).getSingleCandidate(method);
        return singleCandidate != null ? singleCandidate : method;
    }

    public static DexMethod defaultAsMethodOfCompanionClass(DexMethod method, DexItemFactory factory) {
        return InterfaceMethodRewriter.instanceAsMethodOfCompanionClass(method, DEFAULT_METHOD_PREFIX, factory);
    }

    DexMethod defaultAsMethodOfCompanionClass(DexMethod method) {
        return InterfaceMethodRewriter.defaultAsMethodOfCompanionClass(method, this.factory);
    }

    static DexMethod privateAsMethodOfCompanionClass(DexMethod method, DexItemFactory factory) {
        return InterfaceMethodRewriter.instanceAsMethodOfCompanionClass(method, PRIVATE_METHOD_PREFIX, factory);
    }

    DexMethod privateAsMethodOfCompanionClass(DexMethod method) {
        return InterfaceMethodRewriter.privateAsMethodOfCompanionClass(method, this.factory);
    }

    private void renameEmulatedInterfaces() {
        for (DexClass dexClass : ((AppInfo)this.appView.appInfo()).classes()) {
            DexType newType;
            if (!dexClass.isInterface() || (newType = this.inferEmulatedInterfaceName(dexClass)) == null || this.appView.rewritePrefix.hasRewrittenType(dexClass.type)) continue;
            this.addRewritePrefix(dexClass.type, newType.toString());
            this.renameEmulatedInterfaces(dexClass, newType);
        }
    }

    private DexType inferEmulatedInterfaceName(DexClass subInterface) {
        DexType newType = this.emulatedInterfaces.get(subInterface.type);
        if (newType != null) {
            return newType;
        }
        LinkedList<DexType> workList = new LinkedList<DexType>(Arrays.asList(subInterface.interfaces.values));
        while (!workList.isEmpty()) {
            DexType next = workList.removeFirst();
            if (this.emulatedInterfaces.get(next) != null) {
                return this.inferEmulatedInterfaceName(subInterface.type, next);
            }
            DexClass nextClass = this.appView.definitionFor(next);
            if (nextClass == null) continue;
            workList.addAll(Arrays.asList(nextClass.interfaces.values));
        }
        return null;
    }

    private DexType inferEmulatedInterfaceName(DexType subInterfaceType, DexType interfaceType) {
        String initialPrefix = interfaceType.getPackageName();
        String rewrittenPrefix = this.emulatedInterfaces.get(interfaceType).getPackageName();
        String suffix = subInterfaceType.toString().substring(initialPrefix.length());
        return this.factory.createType(DescriptorUtils.javaTypeToDescriptor(rewrittenPrefix + suffix));
    }

    private void renameEmulatedInterfaces(DexClass theInterface, DexType renamedInterface) {
        theInterface.type = renamedInterface;
        theInterface.setVirtualMethods(this.renameHolder(theInterface.virtualMethods(), renamedInterface));
        theInterface.setDirectMethods(this.renameHolder(theInterface.directMethods(), renamedInterface));
    }

    private DexEncodedMethod[] renameHolder(List<DexEncodedMethod> methods, DexType newName) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[methods.size()];
        for (int i = 0; i < newMethods.length; ++i) {
            newMethods[i] = methods.get(i).toRenamedHolderMethod(newName, this.factory);
        }
        return newMethods;
    }

    private void duplicateEmulatedInterfaces() {
        for (DexClass dexClass : ((AppInfo)this.appView.appInfo()).classes()) {
            if (dexClass.type == this.appView.dexItemFactory().objectType) continue;
            ArrayList<DexType> extraInterfaces = new ArrayList<DexType>();
            for (DexType type : dexClass.interfaces.values) {
                if (!this.emulatedInterfaces.containsKey(type)) continue;
                extraInterfaces.add(this.emulatedInterfaces.get(type));
            }
            if (!this.appView.options().isDesugaredLibraryCompilation()) {
                assert (dexClass.superType != null);
                DexClass superClazz = this.appView.definitionFor(dexClass.superType);
                if (superClazz != null && superClazz.isLibraryClass()) {
                    List<DexType> itfs = this.emulatedInterfacesOf(superClazz);
                    for (DexType itf : itfs) {
                        extraInterfaces.add(this.emulatedInterfaces.get(itf));
                    }
                }
                extraInterfaces = new ArrayList(new LinkedHashSet(extraInterfaces));
            }
            if (extraInterfaces.isEmpty()) continue;
            DexType[] newInterfaces = Arrays.copyOf(dexClass.interfaces.values, dexClass.interfaces.size() + extraInterfaces.size());
            for (int i = dexClass.interfaces.size(); i < newInterfaces.length; ++i) {
                newInterfaces[i] = (DexType)extraInterfaces.get(i - dexClass.interfaces.size());
            }
            dexClass.interfaces = new DexTypeList(newInterfaces);
        }
    }

    private List<DexType> emulatedInterfacesOf(DexClass superClazz) {
        if (superClazz.type == this.factory.objectType) {
            return Collections.emptyList();
        }
        ArrayList<DexType> itfs = new ArrayList<DexType>();
        LinkedList<DexType> workList = new LinkedList<DexType>();
        workList.add(superClazz.type);
        while (!workList.isEmpty()) {
            DexType dexType = (DexType)workList.removeFirst();
            DexClass dexClass = this.appView.definitionFor(dexType);
            if (dexClass == null) continue;
            if (dexClass.superType != this.factory.objectType) {
                workList.add(dexClass.superType);
            }
            for (DexType itf : dexClass.interfaces.values) {
                if (this.emulatedInterfaces.containsKey(itf)) {
                    itfs.add(itf);
                    continue;
                }
                workList.add(itf);
            }
        }
        return itfs;
    }

    public void desugarInterfaceMethods(DexApplication.Builder<?> builder, OptimizationFeedback feedback, Flavor flavour, ExecutorService executorService) throws ExecutionException {
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            this.generateEmulateInterfaceLibrary(builder);
        }
        this.duplicateEmulatedInterfaces();
        this.processClasses(builder, flavour, this.synthesizedMethods::add);
        Object appInfo = this.appView.appInfo();
        for (Map.Entry<DexType, DexProgramClass> entry : this.processInterfaces(builder, feedback, flavour).entrySet()) {
            DexProgramClass synthesizedClass = entry.getValue();
            builder.addSynthesizedClass(synthesizedClass, this.isInMainDexList(entry.getKey()));
            ((AppInfo)appInfo).addSynthesizedClass(synthesizedClass);
        }
        if (this.appView.options().isDesugaredLibraryCompilation()) {
            this.renameEmulatedInterfaces();
        }
        this.converter.processMethodsConcurrently(this.synthesizedMethods, executorService);
        this.clear();
    }

    private void clear() {
        this.cache.clear();
        this.synthesizedMethods.clear();
        this.requiredDispatchClasses.clear();
    }

    private static boolean shouldProcess(DexProgramClass clazz, Flavor flavour, boolean mustBeInterface) {
        return (!clazz.originatesFromDexResource() || flavour == Flavor.IncludeAllResources) && clazz.isInterface() == mustBeInterface;
    }

    private Map<DexType, DexProgramClass> processInterfaces(DexApplication.Builder<?> builder, OptimizationFeedback feedback, Flavor flavour) {
        GraphLense.Builder graphLensBuilder = InterfaceProcessor.InterfaceProcessorNestedGraphLense.builder();
        InterfaceProcessor processor = new InterfaceProcessor(this.appView, this, feedback);
        for (DexProgramClass dexProgramClass : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(dexProgramClass, flavour, true)) continue;
            processor.process(dexProgramClass, graphLensBuilder);
        }
        for (Map.Entry entry : this.requiredDispatchClasses.entrySet()) {
            this.synthesizedMethods.addAll(processor.process((DexLibraryClass)entry.getKey(), (Set)entry.getValue()));
        }
        if (this.appView.enableWholeProgramOptimizations()) {
            this.appView.setGraphLense(graphLensBuilder.build(this.appView.dexItemFactory(), this.appView.graphLense()));
        }
        return processor.syntheticClasses;
    }

    private void processClasses(DexApplication.Builder<?> builder, Flavor flavour, Consumer<DexEncodedMethod> newSynthesizedMethodConsumer) {
        ClassProcessor processor = new ClassProcessor(this.appView, this, newSynthesizedMethodConsumer);
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (!InterfaceMethodRewriter.shouldProcess(clazz, flavour, false)) continue;
            processor.processClass(clazz);
        }
        processor.addSyntheticMethods();
    }

    final boolean isDefaultMethod(DexEncodedMethod method) {
        assert (!method.accessFlags.isConstructor());
        assert (!method.accessFlags.isStatic());
        if (method.accessFlags.isAbstract()) {
            return false;
        }
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native default interface methods are not yet supported.");
        }
        if (!method.accessFlags.isPublic()) {
            throw new Unimplemented("Non public default interface methods are not yet supported.");
        }
        return true;
    }

    public static boolean isEmulatedInterfaceDispatch(AppView<?> appView, DexEncodedMethod method) {
        Map<DexType, DexType> emulateLibraryInterface = appView.options().desugaredLibraryConfiguration.getEmulateLibraryInterface();
        if (emulateLibraryInterface.isEmpty()) {
            return false;
        }
        DexMethod methodToFind = method.method;
        LinkedList<DexType> workList = new LinkedList<DexType>();
        workList.add(methodToFind.holder);
        while (!workList.isEmpty()) {
            DexEncodedMethod dexEncodedMethod;
            DexType dexType = (DexType)workList.removeFirst();
            DexClass dexClass = appView.definitionFor(dexType);
            assert (dexClass != null);
            if (dexClass.isInterface() && emulateLibraryInterface.containsKey(dexType) && (dexEncodedMethod = dexClass.lookupMethod(methodToFind)) != null) {
                return true;
            }
            Collections.addAll(workList, dexClass.interfaces.values);
            if (dexClass.superType == appView.dexItemFactory().objectType) continue;
            workList.add(dexClass.superType);
        }
        return false;
    }

    public void warnMissingInterface(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (!this.emulatedInterfaces.values().contains(missing)) {
            this.options.warningMissingInterfaceForDesugar(classToDesugar, implementing, missing);
        }
    }

    private void warnMissingType(DexMethod referencedFrom, DexType missing) {
        if (this.appView.rewritePrefix.hasRewrittenType(missing) || DesugaredLibraryWrapperSynthesizer.isSynthesizedWrapper(missing) || InterfaceMethodRewriter.isCompanionClassType(missing) || this.appView.options().desugaredLibraryConfiguration.getCustomConversions().values().contains(missing)) {
            return;
        }
        DexMethod method = this.appView.graphLense().getOriginalMethodSignature(referencedFrom);
        Origin origin = this.getMethodOrigin(method);
        MethodPosition position = new MethodPosition(method);
        this.options.warningMissingTypeForDesugar(origin, position, missing, method.holder);
    }

    private Origin getMethodOrigin(DexMethod method) {
        DexClass clazz;
        DexType holder = method.holder;
        if (InterfaceMethodRewriter.isCompanionClassType(holder)) {
            holder = this.getInterfaceClassType(holder);
        }
        return (clazz = this.appView.definitionFor(holder)) == null ? Origin.unknown() : clazz.getOrigin();
    }

    final DefaultMethodsHelper.Collection getOrCreateInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper.Collection collection = this.cache.get(iface);
        if (collection != null) {
            return collection;
        }
        collection = this.createInterfaceInfo(classToDesugar, implementing, iface);
        DefaultMethodsHelper.Collection existing = this.cache.putIfAbsent(iface, collection);
        return existing != null ? existing : collection;
    }

    private DefaultMethodsHelper.Collection createInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass definedInterface = this.appView.definitionFor(iface);
        if (definedInterface == null) {
            this.warnMissingInterface(classToDesugar, implementing, iface);
            return helper.wrapInCollection();
        }
        if (!definedInterface.isInterface()) {
            throw new CompilationError("Type " + iface.toSourceString() + " is referenced as an interface from `" + implementing.toString() + "`.");
        }
        if (this.isNonDesugaredLibraryClass(definedInterface)) {
            return helper.wrapInCollection();
        }
        if (implementing.isProgramClass() && !definedInterface.isLibraryClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(implementing.asProgramClass(), definedInterface, this.appView.options());
        }
        for (DexType superinterface : definedInterface.interfaces.values) {
            helper.merge(this.getOrCreateInterfaceInfo(classToDesugar, definedInterface, superinterface));
        }
        for (DexEncodedMethod virtual : definedInterface.virtualMethods()) {
            helper.hideMatches(virtual.method);
        }
        for (DexEncodedMethod encoded : definedInterface.virtualMethods()) {
            if (!this.isDefaultMethod(encoded)) continue;
            helper.addDefaultMethod(encoded);
        }
        return helper.wrapInCollection();
    }

    public static void reportDependencyEdge(DexProgramClass dependent, DexClass dependency, InternalOptions options) {
        assert (!dependency.isLibraryClass());
        DesugarGraphConsumer consumer = options.desugarGraphConsumer;
        if (consumer != null) {
            Origin dependencyOrigin = dependency.getOrigin();
            Collection<DexProgramClass> dependents = dependent.getSynthesizedFrom();
            if (dependents == null || dependents.isEmpty()) {
                dependents = Collections.singletonList(dependent);
            }
            for (DexProgramClass clazz : dependents) {
                Origin dependentOrigin = clazz.getOrigin();
                if (dependentOrigin == dependencyOrigin) continue;
                consumer.accept(dependentOrigin, dependencyOrigin);
            }
        }
    }

    public static enum Flavor {
        IncludeAllResources,
        ExcludeDexResources;

    }
}

