/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.DestructivePhiTypeUpdater;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstMethodHandle;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceOf;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeCustom;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMultiNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeNewArray;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.MoveException;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.logging.Log;

public class LensCodeRewriter {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final Map<DexProto, DexProto> protoFixupCache = new ConcurrentHashMap<DexProto, DexProto>();

    LensCodeRewriter(AppView<? extends AppInfoWithSubtyping> appView) {
        this.appView = appView;
    }

    private Value makeOutValue(Instruction insn, IRCode code) {
        if (insn.outValue() != null) {
            TypeLatticeElement oldType = insn.outValue().getTypeLattice();
            TypeLatticeElement newType = oldType.fixupClassTypeReferences(this.appView.graphLense()::lookupType, this.appView);
            return code.createValue(newType, insn.getLocalInfo());
        }
        return null;
    }

    public void rewrite(IRCode code, DexEncodedMethod method) {
        GraphLense graphLense = this.appView.graphLense();
        DexItemFactory factory = this.appView.dexItemFactory();
        Set<Phi> affectedPhis = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.listIterator();
        boolean mayHaveUnreachableBlocks = false;
        while (blocks.hasNext()) {
            boolean anyGuardsRenamed;
            BasicBlock block = blocks.next();
            if (block.hasCatchHandlers() && this.appView.options().enableVerticalClassMerging && (anyGuardsRenamed = block.renameGuardsInCatchHandlers(graphLense))) {
                mayHaveUnreachableBlocks |= this.unlinkDeadCatchHandlers(block);
            }
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Value newOutValue;
                DexMethod replacementMethod;
                DexField actualField;
                DexField field;
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeCustom()) {
                    InvokeCustom invokeCustom = current.asInvokeCustom();
                    DexCallSite callSite = invokeCustom.getCallSite();
                    DexCallSite newCallSite = this.rewriteCallSite(callSite, method);
                    if (newCallSite == callSite) continue;
                    Value newOutValue2 = this.makeOutValue(invokeCustom, code);
                    InvokeCustom newInvokeCustom = new InvokeCustom(newCallSite, newOutValue2, invokeCustom.inValues());
                    iterator2.replaceCurrentInstruction(newInvokeCustom);
                    if (newOutValue2 == null || newOutValue2.getTypeLattice() == invokeCustom.outValue().getTypeLattice()) continue;
                    affectedPhis.addAll(newOutValue2.uniquePhiUsers());
                    continue;
                }
                if (current.isConstMethodHandle()) {
                    DexMethodHandle handle = current.asConstMethodHandle().getValue();
                    DexMethodHandle newHandle = this.rewriteDexMethodHandle(handle, method, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                    if (newHandle == handle) continue;
                    Value newOutValue3 = this.makeOutValue(current, code);
                    iterator2.replaceCurrentInstruction(new ConstMethodHandle(newOutValue3, newHandle));
                    if (newOutValue3 == null || newOutValue3.getTypeLattice() == current.outValue().getTypeLattice()) continue;
                    affectedPhis.addAll(newOutValue3.uniquePhiUsers());
                    continue;
                }
                if (current.isInvokeMethod()) {
                    List<Value> newInValues;
                    Value newOutValue4;
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    DexType invokedHolder = invokedMethod.holder;
                    if (invokedHolder.isArrayType()) {
                        DexType baseType = invokedHolder.toBaseType(factory);
                        new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(baseType, (t, v) -> {
                            DexType mappedHolder = invokedHolder.replaceBaseType((DexType)t, factory);
                            DexMethod actualTarget = factory.createMethod(mappedHolder, invokedMethod.proto, invokedMethod.name);
                            return Invoke.create(Invoke.Type.VIRTUAL, actualTarget, null, v, invoke.inValues());
                        });
                        continue;
                    }
                    if (!invokedHolder.isClassType()) {
                        assert (false);
                        continue;
                    }
                    if (invoke.isInvokeDirect()) {
                        this.checkInvokeDirect(method.method, invoke.asInvokeDirect());
                    }
                    GraphLense.GraphLenseLookupResult lenseLookup = graphLense.lookupMethod(invokedMethod, method.method, invoke.getType());
                    DexMethod actualTarget = lenseLookup.getMethod();
                    Invoke.Type actualInvokeType = lenseLookup.getType();
                    if (actualInvokeType == Invoke.Type.VIRTUAL) {
                        actualTarget = this.rebindVirtualInvokeToMostSpecific(actualTarget, invoke.inValues().get(0), method.method.holder);
                    }
                    if (actualTarget == invokedMethod && invoke.getType() == actualInvokeType) continue;
                    GraphLense.RewrittenPrototypeDescription prototypeChanges = graphLense.lookupPrototypeChanges(actualTarget);
                    GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
                    ConstInstruction constantReturnMaterializingInstruction = null;
                    if (prototypeChanges.hasBeenChangedToReturnVoid() && invoke.outValue() != null) {
                        constantReturnMaterializingInstruction = prototypeChanges.getConstantReturn(code, invoke.getPosition());
                        if (invoke.outValue().hasLocalInfo()) {
                            constantReturnMaterializingInstruction.outValue().setLocalInfo(invoke.outValue().getLocalInfo());
                        }
                        invoke.outValue().replaceUsers(constantReturnMaterializingInstruction.outValue());
                        if (graphLense.lookupType(invoke.getReturnType()) != invoke.getReturnType()) {
                            affectedPhis.addAll(constantReturnMaterializingInstruction.outValue().uniquePhiUsers());
                        }
                    }
                    Value value = newOutValue4 = prototypeChanges.hasBeenChangedToReturnVoid() ? null : this.makeOutValue(invoke, code);
                    if (removedArgumentsInfo.hasRemovedArguments()) {
                        if (Log.ENABLED) {
                            Log.info(this.getClass(), "Invoked method " + invokedMethod.toSourceString() + " with " + removedArgumentsInfo.numberOfRemovedArguments() + " arguments removed", new Object[0]);
                        }
                        newInValues = new ArrayList<Value>(actualTarget.proto.parameters.size());
                        for (int i = 0; i < invoke.inValues().size(); ++i) {
                            if (removedArgumentsInfo.isArgumentRemoved(i)) continue;
                            newInValues.add(invoke.inValues().get(i));
                        }
                    } else {
                        newInValues = invoke.inValues();
                    }
                    if (prototypeChanges.hasExtraNullParameter()) {
                        iterator2.previous();
                        Value extraNullValue = iterator2.insertConstNullInstruction(code, this.appView.options());
                        iterator2.next();
                        newInValues.add(extraNullValue);
                    }
                    assert (newInValues.size() == actualTarget.proto.parameters.size() + (actualInvokeType == Invoke.Type.STATIC ? 0 : 1));
                    Invoke newInvoke = Invoke.create(actualInvokeType, actualTarget, null, newOutValue4, newInValues);
                    iterator2.replaceCurrentInstruction(newInvoke);
                    if (newOutValue4 != null && newOutValue4.getTypeLattice() != current.outValue().getTypeLattice()) {
                        affectedPhis.addAll(newOutValue4.uniquePhiUsers());
                    }
                    if (constantReturnMaterializingInstruction != null) {
                        if (block.hasCatchHandlers()) {
                            iterator2.split(code, blocks).listIterator(code).add(constantReturnMaterializingInstruction);
                        } else {
                            iterator2.add(constantReturnMaterializingInstruction);
                        }
                    }
                    DexType actualReturnType = actualTarget.proto.returnType;
                    DexType expectedReturnType = graphLense.lookupType(invokedMethod.proto.returnType);
                    if (newInvoke.outValue() == null || actualReturnType == expectedReturnType) continue;
                    throw new Unreachable("Unexpected need to insert a cast. Possibly related to resolving b/79143143.\n" + invokedMethod + " type changed from " + expectedReturnType + " to " + actualReturnType);
                }
                if (current.isInstanceGet()) {
                    InstanceGet instanceGet = current.asInstanceGet();
                    field = instanceGet.getField();
                    actualField = graphLense.lookupField(field);
                    replacementMethod = graphLense.lookupGetFieldForMethod(actualField, method.method);
                    if (replacementMethod != null) {
                        newOutValue = this.makeOutValue(current, code);
                        iterator2.replaceCurrentInstruction(new InvokeStatic(replacementMethod, newOutValue, current.inValues()));
                        if (newOutValue == null || newOutValue.getTypeLattice() == current.outValue().getTypeLattice()) continue;
                        affectedPhis.addAll(current.outValue().uniquePhiUsers());
                        continue;
                    }
                    if (actualField == field) continue;
                    newOutValue = this.makeOutValue(instanceGet, code);
                    iterator2.replaceCurrentInstruction(new InstanceGet(newOutValue, instanceGet.object(), actualField));
                    if (newOutValue == null || newOutValue.getTypeLattice() == current.outValue().getTypeLattice()) continue;
                    affectedPhis.addAll(newOutValue.uniquePhiUsers());
                    continue;
                }
                if (current.isInstancePut()) {
                    InstancePut instancePut = current.asInstancePut();
                    field = instancePut.getField();
                    actualField = graphLense.lookupField(field);
                    replacementMethod = graphLense.lookupPutFieldForMethod(actualField, method.method);
                    if (replacementMethod != null) {
                        iterator2.replaceCurrentInstruction(new InvokeStatic(replacementMethod, null, current.inValues()));
                        continue;
                    }
                    if (actualField == field) continue;
                    InstancePut newInstancePut = new InstancePut(actualField, instancePut.object(), instancePut.value());
                    iterator2.replaceCurrentInstruction(newInstancePut);
                    continue;
                }
                if (current.isStaticGet()) {
                    StaticGet staticGet = current.asStaticGet();
                    field = staticGet.getField();
                    actualField = graphLense.lookupField(field);
                    replacementMethod = graphLense.lookupGetFieldForMethod(actualField, method.method);
                    if (replacementMethod != null) {
                        newOutValue = this.makeOutValue(current, code);
                        iterator2.replaceCurrentInstruction(new InvokeStatic(replacementMethod, newOutValue, current.inValues()));
                        if (newOutValue == null || newOutValue.getTypeLattice() == current.outValue().getTypeLattice()) continue;
                        affectedPhis.addAll(newOutValue.uniquePhiUsers());
                        continue;
                    }
                    if (actualField == field) continue;
                    newOutValue = this.makeOutValue(staticGet, code);
                    iterator2.replaceCurrentInstruction(new StaticGet(newOutValue, actualField));
                    if (newOutValue == null || newOutValue.getTypeLattice() == current.outValue().getTypeLattice()) continue;
                    affectedPhis.addAll(newOutValue.uniquePhiUsers());
                    continue;
                }
                if (current.isStaticPut()) {
                    StaticPut staticPut = current.asStaticPut();
                    field = staticPut.getField();
                    actualField = graphLense.lookupField(field);
                    replacementMethod = graphLense.lookupPutFieldForMethod(actualField, method.method);
                    if (replacementMethod != null) {
                        iterator2.replaceCurrentInstruction(new InvokeStatic(replacementMethod, current.outValue(), current.inValues()));
                        continue;
                    }
                    if (actualField == field) continue;
                    StaticPut newStaticPut = new StaticPut(staticPut.value(), actualField);
                    iterator2.replaceCurrentInstruction(newStaticPut);
                    continue;
                }
                if (current.isCheckCast()) {
                    CheckCast checkCast = current.asCheckCast();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(checkCast.getType(), (t, v) -> new CheckCast((Value)v, checkCast.object(), (DexType)t));
                    continue;
                }
                if (current.isConstClass()) {
                    ConstClass constClass = current.asConstClass();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(constClass.getValue(), (t, v) -> new ConstClass((Value)v, (DexType)t));
                    continue;
                }
                if (current.isInstanceOf()) {
                    InstanceOf instanceOf = current.asInstanceOf();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(instanceOf.type(), (t, v) -> new InstanceOf((Value)v, instanceOf.value(), (DexType)t));
                    continue;
                }
                if (current.isInvokeMultiNewArray()) {
                    InvokeMultiNewArray multiNewArray = current.asInvokeMultiNewArray();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(multiNewArray.getArrayType(), (t, v) -> new InvokeMultiNewArray((DexType)t, (Value)v, multiNewArray.inValues()));
                    continue;
                }
                if (current.isInvokeNewArray()) {
                    InvokeNewArray newArray = current.asInvokeNewArray();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(newArray.getArrayType(), (t, v) -> new InvokeNewArray((DexType)t, (Value)v, newArray.inValues()));
                    continue;
                }
                if (current.isMoveException()) {
                    MoveException moveException = current.asMoveException();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(moveException.getExceptionType(), (t, v) -> new MoveException((Value)v, (DexType)t, this.appView.options()));
                    continue;
                }
                if (current.isNewArrayEmpty()) {
                    NewArrayEmpty newArrayEmpty = current.asNewArrayEmpty();
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(newArrayEmpty.type, (t, v) -> new NewArrayEmpty((Value)v, newArrayEmpty.size(), (DexType)t));
                    continue;
                }
                if (current.isNewInstance()) {
                    DexType type = current.asNewInstance().clazz;
                    new InstructionReplacer(code, current, iterator2, affectedPhis).replaceInstructionIfTypeChanged(type, NewInstance::new);
                    continue;
                }
                if (current.outValue() == null) continue;
                TypeLatticeElement typeLattice = current.outValue().getTypeLattice();
                TypeLatticeElement substituted = typeLattice.fixupClassTypeReferences(graphLense::lookupType, this.appView);
                if (substituted == typeLattice) continue;
                current.outValue().setTypeLattice(substituted);
                affectedPhis.addAll(current.outValue().uniquePhiUsers());
            }
        }
        if (mayHaveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
        if (!affectedPhis.isEmpty()) {
            new DestructivePhiTypeUpdater(this.appView).recomputeAndPropagateTypes(code, affectedPhis);
            assert (code.verifyTypes(this.appView));
        }
        assert (code.isConsistentSSA());
        assert (code.hasNoVerticallyMergedClasses(this.appView));
    }

    public DexCallSite rewriteCallSite(DexCallSite callSite, DexEncodedMethod context) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexProto newMethodProto = dexItemFactory.applyClassMappingToProto(callSite.methodProto, this.appView.graphLense()::lookupType, this.protoFixupCache);
        DexMethodHandle newBootstrapMethod = this.rewriteDexMethodHandle(callSite.bootstrapMethod, context, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
        boolean isLambdaMetaFactory = dexItemFactory.isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
        UseRegistry.MethodHandleUse methodHandleUse = isLambdaMetaFactory ? UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
        List<DexValue> newArgs = this.rewriteBootstrapArgs(callSite.bootstrapArgs, context, methodHandleUse);
        if (!newMethodProto.equals(callSite.methodProto) || newBootstrapMethod != callSite.bootstrapMethod || !newArgs.equals(callSite.bootstrapArgs)) {
            return dexItemFactory.createCallSite(callSite.methodName, newMethodProto, newBootstrapMethod, newArgs);
        }
        return callSite;
    }

    private void checkInvokeDirect(DexMethod method, InvokeDirect invoke) {
        VerticallyMergedClasses verticallyMergedClasses = this.appView.verticallyMergedClasses();
        if (verticallyMergedClasses == null) {
            return;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.name != this.appView.dexItemFactory().constructorMethodName) {
            return;
        }
        if (invoke.arguments().isEmpty()) {
            return;
        }
        Value receiver = invoke.arguments().get(0);
        if (!receiver.isPhi() && receiver.definition.isNewInstance()) {
            NewInstance newInstance = receiver.definition.asNewInstance();
            if (newInstance.clazz != invokedMethod.holder && verticallyMergedClasses.hasBeenMergedIntoSubtype(invokedMethod.holder)) {
                throw this.appView.options().reporter.fatalError(String.format("Unable to rewrite `invoke-direct %s.<init>(new %s, ...)` in method `%s` after type `%s` was merged into `%s`. Please add the following rule to your Proguard configuration file: `-keep,allowobfuscation class %s`.", invokedMethod.holder.toSourceString(), newInstance.clazz, method.toSourceString(), invokedMethod.holder, verticallyMergedClasses.getTargetFor(invokedMethod.holder), invokedMethod.holder.toSourceString()));
            }
        }
    }

    private boolean unlinkDeadCatchHandlers(BasicBlock block) {
        assert (block.hasCatchHandlers());
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        List<DexType> guards = catchHandlers.getGuards();
        List<BasicBlock> targets = catchHandlers.getAllTargets();
        HashSet<DexType> previouslySeenGuards = new HashSet<DexType>();
        ArrayList<BasicBlock> deadCatchHandlers = new ArrayList<BasicBlock>();
        for (int i = 0; i < guards.size(); ++i) {
            boolean guardSeenBefore;
            DexType guard = this.appView.graphLense().lookupType(guards.get(i));
            boolean bl = guardSeenBefore = !previouslySeenGuards.add(guard);
            if (!guardSeenBefore) continue;
            deadCatchHandlers.add(targets.get(i));
        }
        for (BasicBlock deadCatchHandler : deadCatchHandlers) {
            deadCatchHandler.unlinkCatchHandler();
        }
        assert (block.consistentCatchHandlers());
        return !deadCatchHandlers.isEmpty();
    }

    private List<DexValue> rewriteBootstrapArgs(List<DexValue> bootstrapArgs, DexEncodedMethod method, UseRegistry.MethodHandleUse use) {
        List<DexValue> newBootstrapArgs = null;
        boolean changed = false;
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            DexValue argument = bootstrapArgs.get(i);
            DexValue.NestedDexValue newArgument = null;
            if (argument instanceof DexValue.DexValueMethodHandle) {
                newArgument = this.rewriteDexValueMethodHandle(argument.asDexValueMethodHandle(), method, use);
            } else if (argument instanceof DexValue.DexValueMethodType) {
                newArgument = this.rewriteDexMethodType(argument.asDexValueMethodType());
            } else if (argument instanceof DexValue.DexValueType) {
                DexType oldType = (DexType)((DexValue.DexValueType)argument).value;
                DexType newType = this.appView.graphLense().lookupType(oldType);
                if (newType != oldType) {
                    newArgument = new DexValue.DexValueType(newType);
                }
            }
            if (newArgument != null) {
                if (newBootstrapArgs == null) {
                    newBootstrapArgs = new ArrayList<DexValue>(bootstrapArgs.subList(0, i));
                }
                newBootstrapArgs.add(newArgument);
                changed = true;
                continue;
            }
            if (newBootstrapArgs == null) continue;
            newBootstrapArgs.add(argument);
        }
        return changed ? newBootstrapArgs : bootstrapArgs;
    }

    private DexValue.DexValueMethodHandle rewriteDexValueMethodHandle(DexValue.DexValueMethodHandle methodHandle, DexEncodedMethod context, UseRegistry.MethodHandleUse use) {
        DexMethodHandle oldHandle = (DexMethodHandle)methodHandle.value;
        DexMethodHandle newHandle = this.rewriteDexMethodHandle(oldHandle, context, use);
        return newHandle != oldHandle ? new DexValue.DexValueMethodHandle(newHandle) : methodHandle;
    }

    private DexMethodHandle rewriteDexMethodHandle(DexMethodHandle methodHandle, DexEncodedMethod context, UseRegistry.MethodHandleUse use) {
        if (methodHandle.isMethodHandle()) {
            DexMethodHandle.MethodHandleType newType;
            DexMethod actualTarget;
            DexMethod invokedMethod = methodHandle.asMethod();
            DexMethodHandle.MethodHandleType oldType = methodHandle.type;
            GraphLense.GraphLenseLookupResult lenseLookup = this.appView.graphLense().lookupMethod(invokedMethod, context.method, oldType.toInvokeType());
            DexMethod rewrittenTarget = lenseLookup.getMethod();
            if (use == UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY) {
                actualTarget = rewrittenTarget;
                newType = lenseLookup.getType().toMethodHandle(actualTarget);
            } else {
                assert (use == UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                actualTarget = this.appView.dexItemFactory().createMethod(invokedMethod.holder, rewrittenTarget.proto, rewrittenTarget.name);
                newType = oldType;
                if (oldType.isInvokeDirect()) {
                    assert (rewrittenTarget.holder == actualTarget.holder);
                    newType = lenseLookup.getType().toMethodHandle(actualTarget);
                    assert (newType == DexMethodHandle.MethodHandleType.INVOKE_DIRECT || newType == DexMethodHandle.MethodHandleType.INVOKE_INSTANCE);
                }
            }
            if (newType != oldType || actualTarget != invokedMethod || rewrittenTarget != actualTarget) {
                DexClass holder = this.appView.definitionFor(actualTarget.holder);
                boolean isInterface = holder != null ? holder.isInterface() : methodHandle.isInterface;
                return new DexMethodHandle(newType, actualTarget, isInterface, rewrittenTarget != actualTarget ? rewrittenTarget : null);
            }
        } else {
            DexField field = methodHandle.asField();
            DexField actualField = this.appView.graphLense().lookupField(field);
            if (actualField != field) {
                return new DexMethodHandle(methodHandle.type, actualField, methodHandle.isInterface);
            }
        }
        return methodHandle;
    }

    private DexValue.DexValueMethodType rewriteDexMethodType(DexValue.DexValueMethodType type) {
        DexProto oldProto = (DexProto)type.value;
        DexProto newProto = this.appView.dexItemFactory().applyClassMappingToProto(oldProto, this.appView.graphLense()::lookupType, this.protoFixupCache);
        return newProto != oldProto ? new DexValue.DexValueMethodType(newProto) : type;
    }

    private DexMethod rebindVirtualInvokeToMostSpecific(DexMethod target, Value receiver, DexType context) {
        if (!receiver.getTypeLattice().isClassType()) {
            return target;
        }
        DexEncodedMethod encodedTarget = this.appView.definitionFor(target);
        if (encodedTarget == null || !this.canInvokeTargetWithInvokeVirtual(encodedTarget) || !this.hasAccessToInvokeTargetFromContext(encodedTarget, context)) {
            return target;
        }
        DexType receiverType = this.appView.graphLense().lookupType(receiver.getTypeLattice().asClassTypeLatticeElement().getClassType());
        if (receiverType == target.holder) {
            return target;
        }
        DexEncodedMethod newTarget = this.appView.appInfo().lookupVirtualTarget(receiverType, target);
        if (newTarget == null || newTarget.method == target) {
            return target;
        }
        DexClass newTargetClass = this.appView.definitionFor(newTarget.method.holder);
        if (newTargetClass == null || newTargetClass.isLibraryClass() || !this.canInvokeTargetWithInvokeVirtual(newTarget) || !this.hasAccessToInvokeTargetFromContext(newTarget, context)) {
            return target;
        }
        return newTarget.method;
    }

    private boolean canInvokeTargetWithInvokeVirtual(DexEncodedMethod target) {
        return target.isNonPrivateVirtualMethod() && this.appView.isInterface(target.method.holder).isFalse();
    }

    private boolean hasAccessToInvokeTargetFromContext(DexEncodedMethod target, DexType context) {
        assert (!target.accessFlags.isPrivate());
        DexType holder = target.method.holder;
        if (holder == context) {
            return true;
        }
        DexClass clazz = this.appView.definitionFor(holder);
        if (clazz == null) {
            return false;
        }
        if (holder.isSamePackage(context)) {
            return !clazz.accessFlags.isPrivate();
        }
        return clazz.accessFlags.isPublic() && target.accessFlags.isPublic();
    }

    class InstructionReplacer {
        private final IRCode code;
        private final Instruction current;
        private final InstructionListIterator iterator;
        private final Set<Phi> affectedPhis;

        InstructionReplacer(IRCode code, Instruction current, InstructionListIterator iterator2, Set<Phi> affectedPhis) {
            this.code = code;
            this.current = current;
            this.iterator = iterator2;
            this.affectedPhis = affectedPhis;
        }

        void replaceInstructionIfTypeChanged(DexType type, BiFunction<DexType, Value, Instruction> constructor) {
            DexType newType = LensCodeRewriter.this.appView.graphLense().lookupType(type);
            if (newType != type) {
                Value newOutValue = LensCodeRewriter.this.makeOutValue(this.current, this.code);
                Instruction newInstruction = constructor.apply(newType, newOutValue);
                this.iterator.replaceCurrentInstruction(newInstruction);
                if (newOutValue != null) {
                    if (newOutValue.getTypeLattice() != this.current.outValue().getTypeLattice()) {
                        this.affectedPhis.addAll(newOutValue.uniquePhiUsers());
                    } else {
                        assert (this.current.hasInvariantOutType());
                        assert (this.current.isConstClass() || this.current.isInstanceOf() || this.current.isInvokeVirtual() && this.current.asInvokeVirtual().getInvokedMethod().holder.isArrayType());
                    }
                }
            }
        }
    }
}

