/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;
import shadow.bundletool.com.android.tools.r8.ir.conversion.MethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.conversion.PartialCallGraphBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.Action;
import shadow.bundletool.com.android.tools.r8.utils.IROrdering;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

class LambdaMethodProcessor
implements MethodProcessor {
    private final Deque<Collection<DexEncodedMethod>> waves;
    private Collection<DexEncodedMethod> wave;

    LambdaMethodProcessor(AppView<AppInfoWithLiveness> appView, Set<DexEncodedMethod> methods, ExecutorService executorService, Timing timing) throws ExecutionException {
        CallGraph callGraph = new PartialCallGraphBuilder(appView, methods).build(executorService, timing);
        this.waves = this.createWaves(appView, callGraph);
    }

    @Override
    public MethodProcessor.Phase getPhase() {
        return MethodProcessor.Phase.LAMBDA_PROCESSING;
    }

    private Deque<Collection<DexEncodedMethod>> createWaves(AppView<?> appView, CallGraph callGraph) {
        IROrdering shuffle = appView.options().testing.irOrdering;
        ArrayDeque<Collection<DexEncodedMethod>> waves = new ArrayDeque<Collection<DexEncodedMethod>>();
        while (!callGraph.isEmpty()) {
            waves.addLast(shuffle.order((Collection<DexEncodedMethod>)callGraph.extractLeaves()));
        }
        return waves;
    }

    @Override
    public boolean isProcessedConcurrently(DexEncodedMethod method) {
        return this.wave.contains(method);
    }

    <E extends Exception> void forEachMethod(ThrowingConsumer<DexEncodedMethod, E> consumer, Action waveDone, ExecutorService executorService) throws ExecutionException {
        while (!this.waves.isEmpty()) {
            this.wave = this.waves.removeFirst();
            assert (this.wave.size() > 0);
            ThreadUtils.processItems(this.wave, consumer, executorService);
            waveDone.execute();
        }
    }
}

