/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

abstract class CallGraphBuilderBase {
    final AppView<AppInfoWithLiveness> appView;
    final Map<DexMethod, CallGraph.Node> nodes = new IdentityHashMap<DexMethod, CallGraph.Node>();
    private final Map<DexMethod, Set<DexEncodedMethod>> possibleTargetsCache = new ConcurrentHashMap<DexMethod, Set<DexEncodedMethod>>();

    CallGraphBuilderBase(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public CallGraph build(ExecutorService executorService, Timing timing) throws ExecutionException {
        this.process(executorService);
        assert (this.verifyAllMethodsWithCodeExists());
        this.appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.preprocessCallGraphBeforeCycleElimination(this.nodes));
        timing.begin("Cycle elimination");
        TreeSet<CallGraph.Node> nodesWithDeterministicOrder = Sets.newTreeSet(this.nodes.values());
        CycleEliminator cycleEliminator = new CycleEliminator(nodesWithDeterministicOrder, this.appView.options());
        CycleEliminator.CycleEliminationResult cycleEliminationResult = cycleEliminator.breakCycles();
        timing.end();
        assert (cycleEliminator.breakCycles().numberOfRemovedEdges() == 0);
        return new CallGraph(nodesWithDeterministicOrder, cycleEliminationResult);
    }

    abstract void process(ExecutorService var1) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallGraph.Node getOrCreateNode(DexEncodedMethod method) {
        Map<DexMethod, CallGraph.Node> map2 = this.nodes;
        synchronized (map2) {
            return this.nodes.computeIfAbsent(method.method, ignore -> new CallGraph.Node(method));
        }
    }

    abstract boolean verifyAllMethodsWithCodeExists();

    static class CycleEliminator {
        static final String CYCLIC_FORCE_INLINING_MESSAGE = "Unable to satisfy force inlining constraints due to cyclic force inlining";
        private final Collection<CallGraph.Node> nodes;
        private final InternalOptions options;
        private Deque<CallGraph.Node> stack = new ArrayDeque<CallGraph.Node>();
        private Set<CallGraph.Node> stackSet = Sets.newIdentityHashSet();
        private Set<CallGraph.Node> marked = Sets.newIdentityHashSet();
        private Map<CallGraph.Node, Set<CallGraph.Node>> removedEdges = new IdentityHashMap<CallGraph.Node, Set<CallGraph.Node>>();
        private int maxDepth = 0;

        CycleEliminator(Collection<CallGraph.Node> nodes, InternalOptions options) {
            this.options = options;
            this.nodes = options.testing.nondeterministicCycleElimination ? this.reorderNodes(new ArrayList<CallGraph.Node>(nodes)) : nodes;
        }

        CycleEliminationResult breakCycles() {
            this.traverse();
            CycleEliminationResult result = new CycleEliminationResult(this.removedEdges);
            if (Log.ENABLED) {
                Log.info(this.getClass(), "# call graph cycles broken: %s", result.numberOfRemovedEdges());
                Log.info(this.getClass(), "# max call graph depth: %s", this.maxDepth);
            }
            this.reset();
            return result;
        }

        private void reset() {
            assert (this.stack.isEmpty());
            assert (this.stackSet.isEmpty());
            this.marked.clear();
            this.maxDepth = 0;
            this.removedEdges = new IdentityHashMap<CallGraph.Node, Set<CallGraph.Node>>();
        }

        private void traverse() {
            ArrayDeque<WorkItem> workItems = new ArrayDeque<WorkItem>(this.nodes.size());
            for (CallGraph.Node node : this.nodes) {
                workItems.addLast(new NodeWorkItem(node));
            }
            while (!workItems.isEmpty()) {
                WorkItem workItem = (WorkItem)workItems.removeFirst();
                if (workItem.isNode()) {
                    CallGraph.Node node;
                    node = workItem.asNode().node;
                    if (Log.ENABLED && this.stack.size() > this.maxDepth) {
                        this.maxDepth = this.stack.size();
                    }
                    if (this.marked.contains(node)) continue;
                    this.push(node);
                    Collection<CallGraph.Node> callees = node.getCalleesWithDeterministicOrder();
                    if (this.options.testing.nondeterministicCycleElimination) {
                        callees = this.reorderNodes(new ArrayList<CallGraph.Node>(callees));
                    }
                    workItems.addFirst(new IteratorWorkItem(node, callees.iterator()));
                    continue;
                }
                assert (workItem.isIterator());
                IteratorWorkItem iteratorWorkItem = workItem.asIterator();
                CallGraph.Node newCaller = this.iterateCallees(iteratorWorkItem.callees, iteratorWorkItem.caller);
                if (newCaller != null) {
                    workItems.addFirst(iteratorWorkItem);
                    workItems.addFirst(new NodeWorkItem(newCaller));
                    continue;
                }
                assert (!iteratorWorkItem.callees.hasNext());
                this.pop(iteratorWorkItem.caller);
                this.marked.add(iteratorWorkItem.caller);
            }
        }

        private CallGraph.Node iterateCallees(Iterator<CallGraph.Node> calleeIterator, CallGraph.Node node) {
            while (calleeIterator.hasNext()) {
                CallGraph.Node callee = calleeIterator.next();
                boolean foundCycle = this.stackSet.contains(callee);
                if (foundCycle) {
                    CallEdge edge;
                    if (CycleEliminator.edgeRemovalIsSafe(node, callee)) {
                        if (this.options.testing.nondeterministicCycleElimination) {
                            callee.removeCaller(node);
                        } else {
                            calleeIterator.remove();
                            callee.getCallersWithDeterministicOrder().remove(node);
                        }
                        this.recordEdgeRemoval(node, callee);
                        if (!Log.ENABLED) continue;
                        Log.info(CallGraph.class, "Removed call edge from method '%s' to '%s'", node.method.toSourceString(), callee.method.toSourceString());
                        continue;
                    }
                    assert (foundCycle);
                    LinkedList<CallGraph.Node> cycle = this.extractCycle(callee);
                    if (Log.ENABLED) {
                        Log.info(CallGraph.class, "Extracted cycle to find an edge that can safely be removed", new Object[0]);
                    }
                    if ((edge = this.findCallEdgeForRemoval(cycle)) != null) {
                        assert (CycleEliminator.edgeRemovalIsSafe(edge.caller, edge.callee));
                        edge.remove();
                        this.recordEdgeRemoval(edge.caller, edge.callee);
                        if (Log.ENABLED) {
                            Log.info(CallGraph.class, "Removed call edge from force inlined method '%s' to '%s' to ensure that force inlining will succeed", node.method.toSourceString(), callee.method.toSourceString());
                        }
                    }
                    this.recoverStack(cycle);
                    continue;
                }
                return callee;
            }
            return null;
        }

        private void push(CallGraph.Node node) {
            this.stack.push(node);
            boolean changed = this.stackSet.add(node);
            assert (changed);
        }

        private void pop(CallGraph.Node node) {
            CallGraph.Node popped = this.stack.pop();
            assert (popped == node);
            boolean changed = this.stackSet.remove(node);
            assert (changed);
        }

        private LinkedList<CallGraph.Node> extractCycle(CallGraph.Node entry) {
            LinkedList<CallGraph.Node> cycle = new LinkedList<CallGraph.Node>();
            do {
                assert (!this.stack.isEmpty());
                cycle.add(this.stack.pop());
            } while (cycle.getLast() != entry);
            return cycle;
        }

        private CallEdge findCallEdgeForRemoval(LinkedList<CallGraph.Node> extractedCycle) {
            CallGraph.Node callee = extractedCycle.getLast();
            for (CallGraph.Node caller : extractedCycle) {
                if (!caller.hasCallee(callee)) {
                    assert (!callee.hasCaller(caller));
                    return null;
                }
                if (CycleEliminator.edgeRemovalIsSafe(caller, callee)) {
                    return new CallEdge(caller, callee);
                }
                callee = caller;
            }
            throw new CompilationError(CYCLIC_FORCE_INLINING_MESSAGE);
        }

        private static boolean edgeRemovalIsSafe(CallGraph.Node caller, CallGraph.Node callee) {
            return !callee.method.getOptimizationInfo().forceInline();
        }

        private void recordEdgeRemoval(CallGraph.Node caller, CallGraph.Node callee) {
            this.removedEdges.computeIfAbsent(callee, ignore -> SetUtils.newIdentityHashSet(2)).add(caller);
        }

        private void recoverStack(LinkedList<CallGraph.Node> extractedCycle) {
            Iterator<CallGraph.Node> descendingIt = extractedCycle.descendingIterator();
            while (descendingIt.hasNext()) {
                this.stack.push(descendingIt.next());
            }
        }

        private Collection<CallGraph.Node> reorderNodes(List<CallGraph.Node> nodes) {
            assert (this.options.testing.nondeterministicCycleElimination);
            Collections.shuffle(nodes);
            return nodes;
        }

        private static class IteratorWorkItem
        extends WorkItem {
            private final CallGraph.Node caller;
            private final Iterator<CallGraph.Node> callees;

            IteratorWorkItem(CallGraph.Node caller, Iterator<CallGraph.Node> callees) {
                this.caller = caller;
                this.callees = callees;
            }

            @Override
            boolean isIterator() {
                return true;
            }

            @Override
            IteratorWorkItem asIterator() {
                return this;
            }
        }

        private static class NodeWorkItem
        extends WorkItem {
            private final CallGraph.Node node;

            NodeWorkItem(CallGraph.Node node) {
                this.node = node;
            }

            @Override
            boolean isNode() {
                return true;
            }

            @Override
            NodeWorkItem asNode() {
                return this;
            }
        }

        private static class WorkItem {
            private WorkItem() {
            }

            boolean isNode() {
                return false;
            }

            NodeWorkItem asNode() {
                return null;
            }

            boolean isIterator() {
                return false;
            }

            IteratorWorkItem asIterator() {
                return null;
            }
        }

        static class CycleEliminationResult {
            private Map<CallGraph.Node, Set<CallGraph.Node>> removedEdges;

            CycleEliminationResult(Map<CallGraph.Node, Set<CallGraph.Node>> removedEdges) {
                this.removedEdges = removedEdges;
            }

            void forEachRemovedCaller(CallGraph.Node callee, Consumer<CallGraph.Node> fn) {
                ((Set)this.removedEdges.getOrDefault(callee, ImmutableSet.of())).forEach(fn);
            }

            int numberOfRemovedEdges() {
                int numberOfRemovedEdges = 0;
                for (Set<CallGraph.Node> nodes : this.removedEdges.values()) {
                    numberOfRemovedEdges += nodes.size();
                }
                return numberOfRemovedEdges;
            }
        }

        private static class CallEdge {
            private final CallGraph.Node caller;
            private final CallGraph.Node callee;

            CallEdge(CallGraph.Node caller, CallGraph.Node callee) {
                this.caller = caller;
                this.callee = callee;
            }

            public void remove() {
                this.callee.removeCaller(this.caller);
            }
        }
    }

    class InvokeExtractor
    extends UseRegistry {
        private final CallGraph.Node caller;
        private final Predicate<DexEncodedMethod> targetTester;

        InvokeExtractor(CallGraph.Node caller, Predicate<DexEncodedMethod> targetTester) {
            super(CallGraphBuilderBase.this.appView.dexItemFactory());
            this.caller = caller;
            this.targetTester = targetTester;
        }

        private void addClassInitializerTarget(DexClass clazz) {
            assert (clazz != null);
            if (clazz.isProgramClass() && clazz.hasClassInitializer()) {
                this.addTarget(clazz.getClassInitializer(), false);
            }
        }

        private void addClassInitializerTarget(DexType type) {
            assert (type.isClassType());
            DexClass clazz = CallGraphBuilderBase.this.appView.definitionFor(type);
            if (clazz != null) {
                this.addClassInitializerTarget(clazz);
            }
        }

        private void addTarget(DexEncodedMethod callee, boolean likelySpuriousCallEdge) {
            if (!this.targetTester.test(callee)) {
                return;
            }
            if (callee.accessFlags.isAbstract()) {
                return;
            }
            if (CallGraphBuilderBase.this.appView.appInfo().isPinned(callee.method)) {
                return;
            }
            assert (callee.isProgramMethod(CallGraphBuilderBase.this.appView));
            CallGraphBuilderBase.this.getOrCreateNode(callee).addCallerConcurrently(this.caller, likelySpuriousCallEdge);
        }

        private void processInvoke(Invoke.Type originalType, DexMethod originalMethod) {
            DexEncodedMethod source = this.caller.method;
            DexMethod context = source.method;
            GraphLense.GraphLenseLookupResult result = CallGraphBuilderBase.this.appView.graphLense().lookupMethod(originalMethod, context, originalType);
            DexMethod method = result.getMethod();
            Invoke.Type type = result.getType();
            if (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL) {
                ResolutionResult resolutionResult = CallGraphBuilderBase.this.appView.appInfo().resolveMethod(method.holder, method);
                DexEncodedMethod target = resolutionResult.getSingleTarget();
                if (target != null) {
                    this.processInvokeWithDynamicDispatch(type, target);
                }
            } else {
                DexEncodedMethod singleTarget = CallGraphBuilderBase.this.appView.appInfo().lookupSingleTarget(type, method, context.holder);
                if (singleTarget != null) {
                    assert (!source.accessFlags.isBridge() || singleTarget != this.caller.method);
                    DexClass clazz = CallGraphBuilderBase.this.appView.definitionFor(singleTarget.method.holder);
                    assert (clazz != null);
                    if (clazz.isProgramClass()) {
                        if (type == Invoke.Type.STATIC) {
                            this.addClassInitializerTarget(clazz);
                        }
                        this.addTarget(singleTarget, false);
                    }
                }
            }
        }

        private void processInvokeWithDynamicDispatch(Invoke.Type type, DexEncodedMethod encodedTarget) {
            DexMethod target = encodedTarget.method;
            DexClass clazz = CallGraphBuilderBase.this.appView.definitionFor(target.holder);
            if (clazz == null) {
                assert (false) : "Unable to lookup holder of `" + target.toSourceString() + "`";
                return;
            }
            if (!CallGraphBuilderBase.this.appView.options().testing.addCallEdgesForLibraryInvokes && clazz.isLibraryClass()) {
                return;
            }
            boolean isInterface = type == Invoke.Type.INTERFACE;
            Set possibleTargets = CallGraphBuilderBase.this.possibleTargetsCache.computeIfAbsent(target, method -> {
                ResolutionResult resolution = CallGraphBuilderBase.this.appView.appInfo().resolveMethod(method.holder, (DexMethod)method, isInterface);
                if (resolution.isVirtualTarget()) {
                    return resolution.lookupVirtualDispatchTargets(isInterface, CallGraphBuilderBase.this.appView.appInfo());
                }
                return null;
            });
            if (possibleTargets != null) {
                boolean likelySpuriousCallEdge = possibleTargets.size() >= CallGraphBuilderBase.this.appView.options().callGraphLikelySpuriousCallEdgeThreshold;
                for (DexEncodedMethod possibleTarget : possibleTargets) {
                    if (!possibleTarget.isProgramMethod(CallGraphBuilderBase.this.appView)) continue;
                    this.addTarget(possibleTarget, likelySpuriousCallEdge);
                }
            }
        }

        private void processFieldAccess(DexField field) {
            DexEncodedField encodedField;
            if (field.holder.isClassType() && (encodedField = CallGraphBuilderBase.this.appView.appInfo().resolveField(field)) != null && encodedField.isStatic()) {
                this.addClassInitializerTarget(field.holder);
            }
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            this.processInvoke(Invoke.Type.VIRTUAL, method);
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.processInvoke(Invoke.Type.DIRECT, method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            this.processInvoke(Invoke.Type.STATIC, method);
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            this.processInvoke(Invoke.Type.INTERFACE, method);
            return false;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.processInvoke(Invoke.Type.SUPER, method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            if (type.isClassType()) {
                this.addClassInitializerTarget(type);
            }
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }

        @Override
        public void registerCallSite(DexCallSite callSite) {
            this.registerMethodHandle(callSite.bootstrapMethod, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
        }
    }
}

