/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format21c;
import shadow.bundletool.com.android.tools.r8.code.Sput;
import shadow.bundletool.com.android.tools.r8.code.SputBoolean;
import shadow.bundletool.com.android.tools.r8.code.SputByte;
import shadow.bundletool.com.android.tools.r8.code.SputChar;
import shadow.bundletool.com.android.tools.r8.code.SputObject;
import shadow.bundletool.com.android.tools.r8.code.SputShort;
import shadow.bundletool.com.android.tools.r8.code.SputWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;

public class StaticPut
extends FieldInstruction {
    public StaticPut(Value source, DexField field) {
        super(field, null, source);
    }

    @Override
    public int opcode() {
        return 58;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Value value() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int src = builder.allocatedRegister(this.value(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sput(src, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SputWide(src, field);
                break;
            }
            case OBJECT: {
                instruction = new SputObject(src, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SputBoolean(src, field);
                break;
            }
            case BYTE: {
                instruction = new SputByte(src, field);
                break;
            }
            case CHAR: {
                instruction = new SputChar(src, field);
                break;
            }
            case SHORT: {
                instruction = new SputShort(src, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)appView.appInfo()).withLiveness();
            ProguardMemberRule rule = appInfoWithLiveness.assumedValues.get(this.getField());
            if (rule != null && rule.getReturnValue().isSingleValue()) {
                return false;
            }
            if (this.instructionInstanceCanThrow(appView, context).isThrowing()) {
                return true;
            }
            DexEncodedField encodedField = appInfoWithLiveness.resolveField(this.getField());
            assert (encodedField != null) : "NoSuchFieldError (resolution failure) should be caught.";
            boolean isDeadProtoExtensionField = appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(encodedField.field), false);
            if (isDeadProtoExtensionField) {
                return false;
            }
            return appInfoWithLiveness.isFieldRead(encodedField) || this.isStoringObjectWithFinalizer(appInfoWithLiveness);
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        boolean haveSideEffects = this.instructionMayHaveSideEffects(appView, code.method.method.holder);
        assert (appView.enableWholeProgramOptimizations() || haveSideEffects) : "Expected static-put instruction to have side effects in D8";
        return !haveSideEffects;
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "StaticPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (!super.identicalAfterRegisterAllocation(other, allocator)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            StaticPut staticPut = other.asStaticPut();
            if (this.value().getTypeLattice().isArrayType() && this.value() != staticPut.value()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticPut()) {
            return false;
        }
        StaticPut o = other.asStaticPut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forStaticPut(this.getField(), invocationContext);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isStaticPut() {
        return true;
    }

    @Override
    public StaticPut asStaticPut() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(179, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticPut(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        DexType holder = this.getField().holder;
        if (appView.enableWholeProgramOptimizations()) {
            return holder.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue());
        }
        return holder != context;
    }
}

