/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format21c;
import shadow.bundletool.com.android.tools.r8.code.Sget;
import shadow.bundletool.com.android.tools.r8.code.SgetBoolean;
import shadow.bundletool.com.android.tools.r8.code.SgetByte;
import shadow.bundletool.com.android.tools.r8.code.SgetChar;
import shadow.bundletool.com.android.tools.r8.code.SgetObject;
import shadow.bundletool.com.android.tools.r8.code.SgetShort;
import shadow.bundletool.com.android.tools.r8.code.SgetWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class StaticGet
extends FieldInstruction {
    public StaticGet(Value dest, DexField field) {
        super(field, dest, (Value)null);
    }

    public static StaticGet copyOf(IRCode code, StaticGet original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return StaticGet.copyOf(newValue, original);
    }

    public static StaticGet copyOf(Value newValue, StaticGet original) {
        assert (newValue != original.outValue());
        return new StaticGet(newValue, original.getField());
    }

    @Override
    public int opcode() {
        return 57;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    @Override
    public Value value() {
        return this.outValue;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getTypeLattice().isReference());
        assert (this.outValue != null);
        TypeLatticeElement outType = this.outValue.getTypeLattice();
        if (outType.isPrimitive()) {
            return false;
        }
        if (((AppInfo)appView.appInfo()).hasSubtyping() && outType.isClassType() && root.getTypeLattice().isClassType() && ((AppInfo)appView.appInfo()).withSubtyping().inDifferentHierarchy(outType.asClassTypeLatticeElement().getClassType(), root.getTypeLattice().asClassTypeLatticeElement().getClassType())) {
            return false;
        }
        return outType.isReference();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format21c instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Sget(dest, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new SgetWide(dest, field);
                break;
            }
            case OBJECT: {
                instruction = new SgetObject(dest, field);
                break;
            }
            case BOOLEAN: {
                instruction = new SgetBoolean(dest, field);
                break;
            }
            case BYTE: {
                instruction = new SgetByte(dest, field);
                break;
            }
            case CHAR: {
                instruction = new SgetChar(dest, field);
                break;
            }
            case SHORT: {
                instruction = new SgetShort(dest, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        return this.instructionInstanceCanThrow(appView, context).isThrowing();
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isStaticGet()) {
            return false;
        }
        StaticGet o = other.asStaticGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forStaticGet(this.getField(), invocationContext);
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public boolean isStaticGet() {
        return true;
    }

    @Override
    public StaticGet asStaticGet() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(178, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appView);
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forStaticGet(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.getField().type.isBooleanType();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        DexType holder = this.getField().holder;
        if (appView.enableWholeProgramOptimizations()) {
            return holder.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue());
        }
        return holder != context;
    }
}

