/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.code.Base3Format;
import shadow.bundletool.com.android.tools.r8.code.FilledNewArray;
import shadow.bundletool.com.android.tools.r8.code.FilledNewArrayRange;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.AbstractError;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;

public class InvokeNewArray
extends Invoke {
    private final DexType type;

    public InvokeNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 35;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.NEW_ARRAY;
    }

    @Override
    protected String getTypeString() {
        return "NewArray";
    }

    @Override
    public String toString() {
        return super.toString() + "; type: " + this.type.toSourceString();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new FilledNewArrayRange(firstRegister, argumentRegisters, this.type);
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new FilledNewArray(argumentRegistersCount, this.type, individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeNewArray() && this.type == other.asInvokeNewArray().type;
    }

    @Override
    public boolean isInvokeNewArray() {
        return true;
    }

    @Override
    public InvokeNewArray asInvokeNewArray() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeNewArray(this.type, invocationContext);
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw InvokeNewArray.cfUnsupported();
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw InvokeNewArray.cfUnsupported();
    }

    private static Unreachable cfUnsupported() {
        throw new Unreachable("InvokeNewArray (non-empty) not supported when compiling to classfiles.");
    }

    @Override
    public AbstractError instructionInstanceCanThrow(AppView<?> appView, DexType context) {
        DexType baseType;
        DexType dexType = baseType = this.type.isArrayType() ? this.type.toBaseType(appView.dexItemFactory()) : this.type;
        if (baseType.isPrimitiveType()) {
            assert (!this.type.isWideType()) : "The array's contents must be single-word";
            return AbstractError.bottom();
        }
        assert (baseType.isReferenceType());
        if (baseType == context) {
            return AbstractError.bottom();
        }
        if (!appView.enableWholeProgramOptimizations()) {
            return AbstractError.top();
        }
        DexClass clazz = appView.definitionFor(baseType);
        if (clazz == null) {
            return AbstractError.top();
        }
        if (clazz.isLibraryClass() && !appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(baseType)) {
            return AbstractError.top();
        }
        if (!MemberRebindingAnalysis.isClassTypeVisibleFromContext(appView, context, clazz)) {
            return AbstractError.top();
        }
        return AbstractError.bottom();
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (this.hasOutValue() && this.outValue().hasLocalInfo()) {
            assert (appView.options().debug);
            return true;
        }
        return this.instructionInstanceCanThrow(appView, context).isThrowing();
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

