/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.modeling.LibraryMethodReadSetModeling;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;

public abstract class InvokeMethod
extends Invoke {
    private final DexMethod method;

    public InvokeMethod(DexMethod target, Value result, List<Value> arguments) {
        super(result, arguments);
        this.method = target;
    }

    @Override
    public DexType getReturnType() {
        return this.method.proto.returnType;
    }

    public DexMethod getInvokedMethod() {
        return this.method;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeMethod() && this.method == other.asInvokeMethod().getInvokedMethod();
    }

    @Override
    public String toString() {
        return super.toString() + "; method: " + this.method.toSourceString();
    }

    @Override
    public boolean isInvokeMethod() {
        return true;
    }

    @Override
    public InvokeMethod asInvokeMethod() {
        return this;
    }

    public abstract DexEncodedMethod lookupSingleTarget(AppView<?> var1, DexType var2);

    public Collection<DexEncodedMethod> lookupTargets(AppView<? extends AppInfoWithSubtyping> appView, DexType invocationContext) {
        ResolutionResult refinedResolution;
        Set<DexEncodedMethod> targets;
        DexEncodedMethod singleTarget = this.lookupSingleTarget(appView, invocationContext);
        if (singleTarget != null) {
            return ImmutableList.of(singleTarget);
        }
        if (!this.isInvokeMethodWithDynamicDispatch() || !appView.appInfo().hasLiveness()) {
            return null;
        }
        if (this.isInvokeVirtual()) {
            targets = appView.appInfo().resolveMethodOnClass(this.method.holder, this.method).lookupVirtualTargets(appView.appInfo());
        } else {
            assert (this.isInvokeInterface());
            targets = appView.appInfo().resolveMethodOnInterface(this.method.holder, this.method).lookupInterfaceTargets(appView.appInfo());
        }
        if (targets == null) {
            return null;
        }
        DexType staticReceiverType = this.getInvokedMethod().holder;
        DexType refinedReceiverType = TypeAnalysis.getRefinedReceiverType(appView.withLiveness(), this.asInvokeMethodWithReceiver());
        if (refinedReceiverType != staticReceiverType && (refinedResolution = appView.appInfo().resolveMethod(refinedReceiverType, this.method)).isSingleResolution()) {
            DexEncodedMethod refinedTarget = refinedResolution.getSingleTarget();
            Set<DexEncodedMethod> result = Sets.newIdentityHashSet();
            for (DexEncodedMethod target : targets) {
                if (target != refinedTarget && !appView.isSubtype(target.method.holder, refinedReceiverType).isPossiblyTrue()) continue;
                result.add(target);
            }
            return result;
        }
        return targets;
    }

    public abstract Inliner.InlineAction computeInlining(DexEncodedMethod var1, Inliner.Reason var2, DefaultInliningOracle var3, ClassInitializationAnalysis var4, WhyAreYouNotInliningReporter var5);

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (!super.identicalAfterRegisterAllocation(other, allocator)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            InvokeMethod invoke = other.asInvokeMethod();
            for (int i = 0; i < this.arguments().size(); ++i) {
                Value argument = this.arguments().get(i);
                if (!argument.getTypeLattice().isArrayType() || argument == invoke.arguments().get(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.getReturnType().isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.getReturnType(), this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getReturnType();
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return true;
    }

    @Override
    public AbstractFieldSet readSet(AppView<?> appView, DexType context) {
        return LibraryMethodReadSetModeling.getModeledReadSetOrUnknown(this, appView.dexItemFactory());
    }

    @Override
    public AbstractValue getAbstractValue(AppView<?> appView, DexType context) {
        assert (this.hasOutValue());
        DexEncodedMethod method = this.lookupSingleTarget(appView, context);
        if (method != null) {
            return method.getOptimizationInfo().getAbstractReturnValue();
        }
        return UnknownValue.getInstance();
    }
}

