/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format22c;
import shadow.bundletool.com.android.tools.r8.code.Iput;
import shadow.bundletool.com.android.tools.r8.code.IputBoolean;
import shadow.bundletool.com.android.tools.r8.code.IputByte;
import shadow.bundletool.com.android.tools.r8.code.IputChar;
import shadow.bundletool.com.android.tools.r8.code.IputObject;
import shadow.bundletool.com.android.tools.r8.code.IputShort;
import shadow.bundletool.com.android.tools.r8.code.IputWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class InstancePut
extends FieldInstruction {
    public InstancePut(DexField field, Value object, Value value) {
        super(field, null, Arrays.asList(object, value));
        assert (this.object().verifyCompatible(ValueType.OBJECT));
        assert (this.value().verifyCompatible(ValueType.fromDexType(field.type)));
    }

    @Override
    public int opcode() {
        return 29;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public Value value() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int valueRegister = builder.allocatedRegister(this.value(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iput(valueRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IputWide(valueRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IputObject(valueRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IputBoolean(valueRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IputByte(valueRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IputChar(valueRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IputShort(valueRegister, objectRegister, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)appView.appInfo()).withLiveness();
            if (this.instructionInstanceCanThrow(appView, context).isThrowing()) {
                return true;
            }
            DexEncodedField encodedField = appInfoWithLiveness.resolveField(this.getField());
            assert (encodedField != null) : "NoSuchFieldError (resolution failure) should be caught.";
            return appInfoWithLiveness.isFieldRead(encodedField) || this.isStoringObjectWithFinalizer(appInfoWithLiveness);
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        boolean haveSideEffects = this.instructionMayHaveSideEffects(appView, code.method.method.holder);
        assert (appView.enableWholeProgramOptimizations() || haveSideEffects) : "Expected instance-put instruction to have side effects in D8";
        return !haveSideEffects;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        if (!super.identicalAfterRegisterAllocation(other, allocator)) {
            return false;
        }
        if (allocator.options().canHaveIncorrectJoinForArrayOfInterfacesBug()) {
            InstancePut instancePut = other.asInstancePut();
            if (this.value().getTypeLattice().isArrayType() && this.value() != instancePut.value()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstancePut()) {
            return false;
        }
        InstancePut o = other.asInstancePut();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "InstancePut instructions define no values.";
        return 0;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInstancePut(this.getField(), invocationContext);
    }

    @Override
    public boolean isInstancePut() {
        return true;
    }

    @Override
    public InstancePut asInstancePut() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(181, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.object();
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInstancePut(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

