/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;

public class DexItemBasedConstString
extends ConstInstruction {
    private final DexReference item;
    private final NameComputationInfo<?> nameComputationInfo;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public DexItemBasedConstString(Value dest, DexReference item, NameComputationInfo<?> nameComputationInfo, BasicBlock.ThrowingInfo throwingInfo) {
        super(dest);
        this.item = item;
        this.nameComputationInfo = nameComputationInfo;
        this.throwingInfo = throwingInfo;
    }

    @Override
    public int opcode() {
        return 20;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static DexItemBasedConstString copyOf(IRCode code, DexItemBasedConstString original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return DexItemBasedConstString.copyOf(newValue, original);
    }

    public static DexItemBasedConstString copyOf(Value newValue, DexItemBasedConstString original) {
        assert (newValue != original.outValue());
        return new DexItemBasedConstString(newValue, original.getItem(), original.nameComputationInfo, original.throwingInfo);
    }

    public DexReference getItem() {
        return this.item;
    }

    public NameComputationInfo<?> getNameComputationInfo() {
        return this.nameComputationInfo;
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public boolean isDexItemBasedConstString() {
        return true;
    }

    @Override
    public DexItemBasedConstString asDexItemBasedConstString() {
        return this;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.outValue(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.DexItemBasedConstString(dest, this.item, this.nameComputationInfo));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isDexItemBasedConstString() && other.asDexItemBasedConstString().item == this.item && other.asDexItemBasedConstString().nameComputationInfo.equals(this.nameComputationInfo);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "DexItemBasedConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.item.toSourceString() + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return this.throwingInfo == BasicBlock.ThrowingInfo.CAN_THROW;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return false;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return true;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfDexItemBasedConstString(this.item, this.nameComputationInfo));
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().stringType;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forDexItemBasedConstString(this.item, invocationContext);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

