/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstMethodHandle;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstMethodType;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public abstract class ConstInstruction
extends Instruction {
    public static ConstInstruction copyOf(Value value, ConstInstruction instr) {
        if (instr.isConstClass()) {
            return ConstClass.copyOf(value, instr.asConstClass());
        }
        if (instr.isConstMethodHandle()) {
            return ConstMethodHandle.copyOf(value, instr.asConstMethodHandle());
        }
        if (instr.isConstMethodType()) {
            return ConstMethodType.copyOf(value, instr.asConstMethodType());
        }
        if (instr.isConstNumber()) {
            return ConstNumber.copyOf(value, instr.asConstNumber());
        }
        if (instr.isConstString()) {
            return ConstString.copyOf(value, instr.asConstString());
        }
        if (instr.isDexItemBasedConstString()) {
            return DexItemBasedConstString.copyOf(value, instr.asDexItemBasedConstString());
        }
        throw new Unreachable();
    }

    public ConstInstruction(Value out) {
        super(out);
    }

    @Override
    public ConstInstruction getOutConstantConstInstruction() {
        return this;
    }

    @Override
    public boolean isConstInstruction() {
        return true;
    }

    @Override
    public ConstInstruction asConstInstruction() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forConstInstruction();
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

