/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.type;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class TypeAnalysis {
    private final boolean mayHaveImpreciseTypes;
    private Mode mode = Mode.UNSET;
    private final AppView<?> appView;
    private final Deque<Value> worklist = new ArrayDeque<Value>();

    public TypeAnalysis(AppView<?> appView) {
        this(appView, false);
    }

    public TypeAnalysis(AppView<?> appView, boolean mayHaveImpreciseTypes) {
        this.appView = appView;
        this.mayHaveImpreciseTypes = mayHaveImpreciseTypes;
    }

    private void analyze() {
        while (!this.worklist.isEmpty()) {
            this.analyzeValue(this.worklist.poll());
        }
    }

    public void widening(DexEncodedMethod context, DexEncodedMethod encodedMethod, IRCode code) {
        this.mode = Mode.WIDENING;
        assert (this.worklist.isEmpty());
        code.topologicallySortedBlocks().forEach(b -> this.analyzeBasicBlock(context, encodedMethod, (BasicBlock)b));
        this.analyze();
    }

    public void widening(Iterable<Value> values2) {
        this.analyzeValues(values2, Mode.WIDENING);
    }

    public void narrowing(Iterable<? extends Value> values2) {
        ArrayList<? extends Value> sortedValues = Lists.newArrayList(values2);
        sortedValues.sort(Comparator.comparingInt(Value::getNumber));
        this.analyzeValues(sortedValues, Mode.NARROWING);
    }

    public boolean verifyValuesUpToDate(Iterable<? extends Value> values2) {
        this.analyzeValues(values2, Mode.NO_CHANGE);
        return true;
    }

    private void analyzeValues(Iterable<? extends Value> values2, Mode mode) {
        this.mode = mode;
        assert (this.worklist.isEmpty());
        values2.forEach(this::enqueue);
        this.analyze();
    }

    private void enqueue(Value v) {
        assert (v != null);
        if (!this.worklist.contains(v)) {
            this.worklist.add(v);
        }
    }

    private void analyzeBasicBlock(DexEncodedMethod context, DexEncodedMethod encodedMethod, BasicBlock block) {
        int argumentsSeen = encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            TypeLatticeElement derived;
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            if (instruction.isArgument()) {
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(encodedMethod.method.holder, encodedMethod == context ? Nullability.definitelyNotNull() : Nullability.maybeNull(), this.appView);
                } else {
                    DexType argType = encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(argType, Nullability.maybeNull(), this.appView);
                }
                ++argumentsSeen;
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            if (instruction.hasInvariantOutType()) {
                derived = instruction.evaluate(this.appView);
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            this.enqueue(outValue);
        }
        for (Phi phi : block.getPhis()) {
            this.enqueue(phi);
        }
    }

    private void analyzeValue(Value value) {
        TypeLatticeElement derived;
        TypeLatticeElement previous = value.getTypeLattice();
        TypeLatticeElement typeLatticeElement = derived = value.isPhi() ? value.asPhi().computePhiType(this.appView) : value.definition.evaluate(this.appView);
        assert (this.mayHaveImpreciseTypes || derived.isPreciseType());
        assert (!previous.isPreciseType() || derived.isPreciseType());
        this.updateTypeOfValue(value, derived);
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        assert (this.mode != Mode.UNSET);
        TypeLatticeElement current = value.getTypeLattice();
        if (current.equals(type)) {
            return;
        }
        assert (this.mode != Mode.NO_CHANGE);
        if (type.isBottom()) {
            return;
        }
        if (this.mode == Mode.WIDENING) {
            value.widening(this.appView, type);
        } else {
            assert (this.mode == Mode.NARROWING);
            value.narrowing(this.appView, type);
        }
        for (Instruction instruction : value.uniqueUsers()) {
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            this.enqueue(outValue);
        }
        for (Phi phi : value.uniquePhiUsers()) {
            this.enqueue(phi);
        }
    }

    public static DexType getRefinedReceiverType(AppView<? extends AppInfoWithSubtyping> appView, InvokeMethodWithReceiver invoke) {
        Value receiver = invoke.getReceiver();
        TypeLatticeElement lattice = receiver.getDynamicUpperBoundType(appView);
        DexType staticReceiverType = invoke.getInvokedMethod().holder;
        if (lattice.isClassType()) {
            Set<DexType> interfaces;
            ClassTypeLatticeElement classType = lattice.asClassTypeLatticeElement();
            DexType refinedType = classType.getClassType();
            if (refinedType == appView.dexItemFactory().objectType && (interfaces = classType.getInterfaces()).size() == 1) {
                refinedType = interfaces.iterator().next();
            }
            if (appView.appInfo().isSubtype(refinedType, staticReceiverType)) {
                return refinedType;
            }
        }
        return staticReceiverType;
    }

    private static enum Mode {
        UNSET,
        WIDENING,
        NARROWING,
        NO_CHANGE;

    }
}

