/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexClasspathClass;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.ClasspathClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.LibraryClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.ProgramClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class LazyLoadedDexApplication
extends DexApplication {
    private final ProgramClassCollection programClasses;
    private final ClasspathClassCollection classpathClasses;
    private final LibraryClassCollection libraryClasses;

    private LazyLoadedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableList<DataResourceProvider> dataResourceProviders, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, ImmutableSet<DexType> mainDexList, InternalOptions options, DexString highestSortingString, Timing timing) {
        super(proguardMap, dataResourceProviders, mainDexList, options, highestSortingString, timing);
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    @Override
    List<DexProgramClass> programClasses() {
        this.programClasses.forceLoad(t -> true);
        return this.programClasses.getAllClasses();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        DexClass clazz = null;
        if (this.options.lookupLibraryBeforeProgram) {
            if (this.libraryClasses != null) {
                clazz = (DexClass)this.libraryClasses.get(type);
            }
            if (clazz == null) {
                clazz = (DexClass)this.programClasses.get(type);
            }
            if (clazz == null && this.classpathClasses != null) {
                clazz = (DexClass)this.classpathClasses.get(type);
            }
        } else {
            clazz = (DexClass)this.programClasses.get(type);
            if (clazz == null && this.classpathClasses != null) {
                clazz = (DexClass)this.classpathClasses.get(type);
            }
            if (clazz == null && this.libraryClasses != null) {
                clazz = (DexClass)this.libraryClasses.get(type);
            }
        }
        return clazz;
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        return (DexProgramClass)this.programClasses.get(type);
    }

    private static <T extends DexClass> ImmutableList<T> fillPrioritizedClasses(Map<DexType, T> classCollection, Map<DexType, DexClass> prioritizedClasses) {
        if (classCollection != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            classCollection.forEach((type, clazz) -> {
                if (!prioritizedClasses.containsKey(type)) {
                    prioritizedClasses.put((DexType)type, (DexClass)clazz);
                    builder.add(clazz);
                }
            });
            return builder.build();
        }
        return ImmutableList.of();
    }

    public AllClasses loadAllClasses() {
        return new AllClasses(this.libraryClasses, this.classpathClasses, this.programClasses, this.options);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return new DirectMappedDexApplication.Builder(this).build().asDirect();
    }

    @Override
    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        private final ApplicationReader.ProgramClassConflictResolver resolver;

        Builder(ApplicationReader.ProgramClassConflictResolver resolver, InternalOptions options, Timing timing) {
            super(options, timing);
            this.resolver = resolver;
            this.classpathClasses = null;
            this.libraryClasses = null;
        }

        private Builder(LazyLoadedDexApplication application) {
            super(application);
            this.resolver = ProgramClassCollection.defaultConflictResolver(application.options.reporter);
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        @Override
        public LazyLoadedDexApplication build() {
            return new LazyLoadedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses, this.resolver), ImmutableList.copyOf(this.dataResourceProviders), this.classpathClasses, this.libraryClasses, ImmutableSet.copyOf(this.mainDexList), this.options, this.highestSortingString, this.timing);
        }
    }

    static class AllClasses {
        private final Map<DexType, DexClass> allClasses;
        private final ImmutableList<DexProgramClass> programClasses;
        private final ImmutableList<DexClasspathClass> classpathClasses;
        private final ImmutableList<DexLibraryClass> libraryClasses;

        AllClasses(LibraryClassCollection libraryClassesLoader, ClasspathClassCollection classpathClassesLoader, ProgramClassCollection programClassesLoader, InternalOptions options) {
            int expectedMaxSize = 0;
            Map allLibraryClasses = null;
            if (libraryClassesLoader != null) {
                libraryClassesLoader.forceLoad(type -> true);
                allLibraryClasses = libraryClassesLoader.getAllClassesInMap();
                expectedMaxSize += allLibraryClasses.size();
            }
            assert (programClassesLoader != null);
            assert (programClassesLoader.isFullyLoaded());
            programClassesLoader.forceLoad(type -> true);
            Map allProgramClasses = programClassesLoader.getAllClassesInMap();
            expectedMaxSize += allProgramClasses.size();
            Map allClasspathClasses = null;
            if (classpathClassesLoader != null) {
                classpathClassesLoader.forceLoad(type -> true);
                allClasspathClasses = classpathClassesLoader.getAllClassesInMap();
                expectedMaxSize += allClasspathClasses.size();
            }
            IdentityHashMap prioritizedClasses = new IdentityHashMap(expectedMaxSize);
            if (options.lookupLibraryBeforeProgram) {
                this.libraryClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allLibraryClasses, prioritizedClasses);
                this.programClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allProgramClasses, prioritizedClasses);
                this.classpathClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allClasspathClasses, prioritizedClasses);
            } else {
                this.programClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allProgramClasses, prioritizedClasses);
                this.classpathClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allClasspathClasses, prioritizedClasses);
                this.libraryClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allLibraryClasses, prioritizedClasses);
            }
            this.allClasses = Collections.unmodifiableMap(prioritizedClasses);
            assert (prioritizedClasses.size() == this.libraryClasses.size() + this.classpathClasses.size() + this.programClasses.size());
        }

        public Map<DexType, DexClass> getAllClasses() {
            return this.allClasses;
        }

        public ImmutableList<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public ImmutableList<DexClasspathClass> getClasspathClasses() {
            return this.classpathClasses;
        }

        public ImmutableList<DexLibraryClass> getLibraryClasses() {
            return this.libraryClasses;
        }
    }
}

