/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArithmeticBinop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLength;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfArrayStore;
import shadow.bundletool.com.android.tools.r8.cf.code.CfCheckCast;
import shadow.bundletool.com.android.tools.r8.cf.code.CfCmp;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstClass;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstMethodHandle;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstMethodType;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNull;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNumber;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstString;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFrame;
import shadow.bundletool.com.android.tools.r8.cf.code.CfGoto;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIfCmp;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIinc;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstanceOf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvokeDynamic;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLoad;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLogicalBinop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMonitor;
import shadow.bundletool.com.android.tools.r8.cf.code.CfMultiANewArray;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNeg;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNew;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNewArray;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNop;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNumberConversion;
import shadow.bundletool.com.android.tools.r8.cf.code.CfPosition;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturn;
import shadow.bundletool.com.android.tools.r8.cf.code.CfReturnVoid;
import shadow.bundletool.com.android.tools.r8.cf.code.CfStackInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfStore;
import shadow.bundletool.com.android.tools.r8.cf.code.CfSwitch;
import shadow.bundletool.com.android.tools.r8.cf.code.CfThrow;
import shadow.bundletool.com.android.tools.r8.cf.code.CfTryCatch;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ArgumentUse;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.JarClassFileReader;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueNumberGenerator;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassReader;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ConstantDynamic;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Handle;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Label;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Opcodes;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.commons.JSRInlinerAdapter;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepAttributes;

public class LazyCfCode
extends Code {
    private final Origin origin;
    private JarApplicationReader application;
    private CfCode code;
    protected JarClassFileReader.ReparseContext context;
    private boolean reachabilitySensitive = false;

    public LazyCfCode(DexMethod method, Origin origin, JarClassFileReader.ReparseContext context, JarApplicationReader application) {
        this.origin = origin;
        this.context = context;
        this.application = application;
        context.codeList.add(this);
    }

    public void markReachabilitySensitive() {
        assert (this.code == null);
        this.reachabilitySensitive = true;
    }

    @Override
    public boolean isCfCode() {
        return true;
    }

    @Override
    public LazyCfCode asLazyCfCode() {
        return this;
    }

    @Override
    public CfCode asCfCode() {
        if (this.code == null) {
            JarClassFileReader.ReparseContext context = this.context;
            JarApplicationReader application = this.application;
            assert (application != null);
            assert (context != null);
            try {
                this.parseCode(context, false);
            }
            catch (JsrEncountered e) {
                for (Code code : context.codeList) {
                    code.asLazyCfCode().code = null;
                    code.asLazyCfCode().context = context;
                    code.asLazyCfCode().application = application;
                }
                try {
                    this.parseCode(context, true);
                }
                catch (JsrEncountered e1) {
                    throw new Unreachable(e1);
                }
            }
            assert (LazyCfCode.verifyNoReparseContext(context.owner));
        }
        assert (this.code != null);
        return this.code;
    }

    public void parseCode(JarClassFileReader.ReparseContext context, boolean useJsrInliner) {
        int parsingOptions = LazyCfCode.getParsingOptions(this.application, this.reachabilitySensitive);
        ClassCodeVisitor classVisitor = new ClassCodeVisitor(context.owner, this.createCodeLocator(context), this.application, useJsrInliner);
        new ClassReader(context.classCache).accept(classVisitor, parsingOptions);
    }

    private void setCode(CfCode code) {
        assert (this.code == null);
        assert (this.context != null);
        this.code = code;
        this.context = null;
        this.application = null;
    }

    @Override
    protected int computeHashCode() {
        throw new Unimplemented();
    }

    @Override
    protected boolean computeEquals(Object other) {
        throw new Unimplemented();
    }

    @Override
    public boolean isEmptyVoidMethod() {
        return this.asCfCode().isEmptyVoidMethod();
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.asCfCode().estimatedSizeForInlining();
    }

    @Override
    public boolean estimatedSizeForInliningAtMost(int threshold) {
        return this.asCfCode().estimatedSizeForInliningAtMost(threshold);
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppView<?> appView, Origin origin) {
        return this.asCfCode().buildIR(encodedMethod, appView, origin);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod context, DexEncodedMethod encodedMethod, AppView<?> appView, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        return this.asCfCode().buildInliningIR(context, encodedMethod, appView, valueNumberGenerator, callerPosition, origin);
    }

    @Override
    public void registerCodeReferences(DexEncodedMethod method, UseRegistry registry) {
        this.asCfCode().registerCodeReferences(method, registry);
    }

    @Override
    public void registerArgumentReferences(DexEncodedMethod method, ArgumentUse registry) {
        this.asCfCode().registerArgumentReferences(method, registry);
    }

    @Override
    public String toString() {
        return this.asCfCode().toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.asCfCode().toString(method, naming);
    }

    protected BiFunction<String, String, LazyCfCode> createCodeLocator(JarClassFileReader.ReparseContext context) {
        return new DefaultCodeLocator(context, this.application);
    }

    private static int getParsingOptions(JarApplicationReader application, boolean reachabilitySensitive) {
        int parsingOptions = application.options.testing.readInputStackMaps ? 8 : 4;
        ProguardConfiguration configuration = application.options.getProguardConfiguration();
        if (configuration != null && !configuration.isKeepParameterNames()) {
            ProguardKeepAttributes keep = application.options.getProguardConfiguration().getKeepAttributes();
            if (!(application.options.getProguardConfiguration().isKeepParameterNames() || keep.localVariableTable || keep.localVariableTypeTable || keep.lineNumberTable || reachabilitySensitive)) {
                parsingOptions |= 2;
            }
        }
        return parsingOptions;
    }

    @Override
    public boolean verifyNoInputReaders() {
        assert (this.context == null && this.application == null);
        return true;
    }

    private static boolean verifyNoReparseContext(DexClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            assert (code == null || code.verifyNoInputReaders());
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            assert (code == null || code.verifyNoInputReaders());
        }
        return true;
    }

    @Override
    public Int2ReferenceMap<DebugLocalInfo> collectParameterInfo(DexEncodedMethod encodedMethod, AppView<?> appView) {
        return this.asCfCode().collectParameterInfo(encodedMethod, appView);
    }

    private static class MethodCodeVisitor
    extends MethodVisitor {
        private final JarApplicationReader application;
        private final DexItemFactory factory;
        private int maxStack;
        private int maxLocals;
        private List<CfInstruction> instructions;
        private List<CfTryCatch> tryCatchRanges;
        private List<CfCode.LocalVariableInfo> localVariables;
        private final Map<DebugLocalInfo, DebugLocalInfo> canonicalDebugLocalInfo = new HashMap<DebugLocalInfo, DebugLocalInfo>();
        private Map<Label, CfLabel> labelMap;
        private final LazyCfCode code;
        private final DexMethod method;

        MethodCodeVisitor(JarApplicationReader application, DexMethod method, LazyCfCode code) {
            super(458752);
            assert (code != null);
            this.application = application;
            this.factory = application.getFactory();
            this.code = code;
            this.method = method;
        }

        @Override
        public void visitCode() {
            this.maxStack = 0;
            this.maxLocals = 0;
            this.instructions = new ArrayList<CfInstruction>();
            this.tryCatchRanges = new ArrayList<CfTryCatch>();
            this.localVariables = new ArrayList<CfCode.LocalVariableInfo>();
            this.labelMap = new IdentityHashMap<Label, CfLabel>();
        }

        @Override
        public void visitEnd() {
            this.code.setCode(new CfCode(this.method.holder, this.maxStack, this.maxLocals, this.instructions, this.tryCatchRanges, this.localVariables));
        }

        @Override
        public void visitFrame(int frameType, int nLocals, Object[] localTypes, int nStack, Object[] stackTypes) {
            assert (frameType == -1);
            Int2ReferenceSortedMap<CfFrame.FrameType> parsedLocals = this.parseLocals(nLocals, localTypes);
            List<CfFrame.FrameType> parsedStack = this.parseStack(nStack, stackTypes);
            this.instructions.add(new CfFrame(parsedLocals, parsedStack));
        }

        private Int2ReferenceSortedMap<CfFrame.FrameType> parseLocals(int typeCount, Object[] asmTypes) {
            Int2ReferenceAVLTreeMap<CfFrame.FrameType> types = new Int2ReferenceAVLTreeMap<CfFrame.FrameType>();
            int i = 0;
            for (int j = 0; j < typeCount; ++j) {
                Object localType = asmTypes[j];
                CfFrame.FrameType value = this.getFrameType(localType);
                types.put(i++, value);
                if (!value.isWide()) continue;
                ++i;
            }
            return types;
        }

        private List<CfFrame.FrameType> parseStack(int nStack, Object[] stackTypes) {
            ArrayList<CfFrame.FrameType> dexStack = new ArrayList<CfFrame.FrameType>(nStack);
            for (int i = 0; i < nStack; ++i) {
                dexStack.add(this.getFrameType(stackTypes[i]));
            }
            return dexStack;
        }

        private CfFrame.FrameType getFrameType(Object localType) {
            if (localType instanceof Label) {
                return CfFrame.FrameType.uninitializedNew(this.getLabel((Label)localType));
            }
            if (localType == Opcodes.UNINITIALIZED_THIS) {
                return CfFrame.FrameType.uninitializedThis();
            }
            if (localType == null || localType == Opcodes.TOP) {
                return CfFrame.FrameType.top();
            }
            return CfFrame.FrameType.initialized(this.parseAsmType(localType));
        }

        private CfLabel getLabel(Label label) {
            return this.labelMap.computeIfAbsent(label, l -> new CfLabel());
        }

        private DexType parseAsmType(Object local) {
            assert (local != null && local != Opcodes.TOP);
            if (local == Opcodes.INTEGER) {
                return this.factory.intType;
            }
            if (local == Opcodes.FLOAT) {
                return this.factory.floatType;
            }
            if (local == Opcodes.LONG) {
                return this.factory.longType;
            }
            if (local == Opcodes.DOUBLE) {
                return this.factory.doubleType;
            }
            if (local == Opcodes.NULL) {
                return DexItemFactory.nullValueType;
            }
            if (local instanceof String) {
                return this.createTypeFromInternalType((String)local);
            }
            throw new Unreachable("Unexpected ASM type: " + local);
        }

        private DexType createTypeFromInternalType(String local) {
            assert (local.indexOf(46) == -1);
            return this.factory.createType(Type.getObjectType(local).getDescriptor());
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 0: {
                    this.instructions.add(new CfNop());
                    break;
                }
                case 1: {
                    this.instructions.add(new CfConstNull());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.instructions.add(new CfConstNumber(opcode - 3, ValueType.INT));
                    break;
                }
                case 9: 
                case 10: {
                    this.instructions.add(new CfConstNumber(opcode - 9, ValueType.LONG));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.instructions.add(new CfConstNumber(Float.floatToRawIntBits(opcode - 11), ValueType.FLOAT));
                    break;
                }
                case 14: 
                case 15: {
                    this.instructions.add(new CfConstNumber(Double.doubleToRawLongBits(opcode - 14), ValueType.DOUBLE));
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.instructions.add(new CfArrayLoad(MethodCodeVisitor.getMemberTypeForOpcode(opcode)));
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.instructions.add(new CfArrayStore(MethodCodeVisitor.getMemberTypeForOpcode(opcode)));
                    break;
                }
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    this.instructions.add(CfStackInstruction.fromAsm(opcode));
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    this.instructions.add(CfArithmeticBinop.fromAsm(opcode));
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.instructions.add(CfNeg.fromAsm(opcode));
                    break;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.instructions.add(CfLogicalBinop.fromAsm(opcode));
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    this.instructions.add(CfNumberConversion.fromAsm(opcode));
                    break;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.instructions.add(CfCmp.fromAsm(opcode));
                    break;
                }
                case 172: {
                    this.instructions.add(new CfReturn(ValueType.INT));
                    break;
                }
                case 173: {
                    this.instructions.add(new CfReturn(ValueType.LONG));
                    break;
                }
                case 174: {
                    this.instructions.add(new CfReturn(ValueType.FLOAT));
                    break;
                }
                case 175: {
                    this.instructions.add(new CfReturn(ValueType.DOUBLE));
                    break;
                }
                case 176: {
                    this.instructions.add(new CfReturn(ValueType.OBJECT));
                    break;
                }
                case 177: {
                    this.instructions.add(new CfReturnVoid());
                    break;
                }
                case 190: {
                    this.instructions.add(new CfArrayLength());
                    break;
                }
                case 191: {
                    this.instructions.add(new CfThrow());
                    break;
                }
                case 194: {
                    this.instructions.add(new CfMonitor(Monitor.Type.ENTER));
                    break;
                }
                case 195: {
                    this.instructions.add(new CfMonitor(Monitor.Type.EXIT));
                    break;
                }
                default: {
                    throw new Unreachable("Unknown instruction");
                }
            }
        }

        private static MemberType getMemberTypeForOpcode(int opcode) {
            switch (opcode) {
                case 46: 
                case 79: {
                    return MemberType.INT;
                }
                case 48: 
                case 81: {
                    return MemberType.FLOAT;
                }
                case 47: 
                case 80: {
                    return MemberType.LONG;
                }
                case 49: 
                case 82: {
                    return MemberType.DOUBLE;
                }
                case 50: 
                case 83: {
                    return MemberType.OBJECT;
                }
                case 51: 
                case 84: {
                    return MemberType.BOOLEAN_OR_BYTE;
                }
                case 52: 
                case 85: {
                    return MemberType.CHAR;
                }
                case 53: 
                case 86: {
                    return MemberType.SHORT;
                }
            }
            throw new Unreachable("Unexpected array opcode " + opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.instructions.add(new CfConstNumber(operand, ValueType.INT));
                    break;
                }
                case 188: {
                    this.instructions.add(new CfNewArray(this.factory.createArrayType(1, MethodCodeVisitor.arrayTypeDesc(operand, this.factory))));
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected int opcode " + opcode);
                }
            }
        }

        private static DexType arrayTypeDesc(int arrayTypeCode, DexItemFactory factory) {
            switch (arrayTypeCode) {
                case 4: {
                    return factory.booleanType;
                }
                case 5: {
                    return factory.charType;
                }
                case 6: {
                    return factory.floatType;
                }
                case 7: {
                    return factory.doubleType;
                }
                case 8: {
                    return factory.byteType;
                }
                case 9: {
                    return factory.shortType;
                }
                case 10: {
                    return factory.intType;
                }
                case 11: {
                    return factory.longType;
                }
            }
            throw new Unreachable("Unexpected array-type code " + arrayTypeCode);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            ValueType type;
            switch (opcode) {
                case 21: 
                case 54: {
                    type = ValueType.INT;
                    break;
                }
                case 23: 
                case 56: {
                    type = ValueType.FLOAT;
                    break;
                }
                case 22: 
                case 55: {
                    type = ValueType.LONG;
                    break;
                }
                case 24: 
                case 57: {
                    type = ValueType.DOUBLE;
                    break;
                }
                case 25: 
                case 58: {
                    type = ValueType.OBJECT;
                    break;
                }
                case 169: {
                    throw new JsrEncountered("RET should be handled by the ASM jsr inliner");
                }
                default: {
                    throw new Unreachable("Unexpected VarInsn opcode: " + opcode);
                }
            }
            if (21 <= opcode && opcode <= 25) {
                this.instructions.add(new CfLoad(type, var));
            } else {
                this.instructions.add(new CfStore(type, var));
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String typeName) {
            DexType type = this.factory.createType(Type.getObjectType(typeName).getDescriptor());
            switch (opcode) {
                case 187: {
                    this.instructions.add(new CfNew(type));
                    break;
                }
                case 189: {
                    this.instructions.add(new CfNewArray(this.factory.createArrayType(1, type)));
                    break;
                }
                case 192: {
                    this.instructions.add(new CfCheckCast(type));
                    break;
                }
                case 193: {
                    this.instructions.add(new CfInstanceOf(type));
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected TypeInsn opcode: " + opcode);
                }
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DexField field = this.factory.createField(this.createTypeFromInternalType(owner), this.factory.createType(desc), name);
            this.instructions.add(new CfFieldInstruction(opcode, field, field));
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DexMethod method = this.application.getMethod(owner, name, desc);
            this.instructions.add(new CfInvoke(opcode, method, itf));
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            DexCallSite callSite = DexCallSite.fromAsmInvokeDynamic(this.application, this.method.holder, name, desc, bsm, bsmArgs);
            this.instructions.add(new CfInvokeDynamic(callSite));
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            CfLabel target = this.getLabel(label);
            if (153 <= opcode && opcode <= 166) {
                if (opcode <= 158) {
                    this.instructions.add(new CfIf(MethodCodeVisitor.ifType(opcode), ValueType.INT, target));
                } else {
                    ValueType valueType = opcode <= 164 ? ValueType.INT : ValueType.OBJECT;
                    this.instructions.add(new CfIfCmp(MethodCodeVisitor.ifType(opcode), valueType, target));
                }
            } else {
                switch (opcode) {
                    case 167: {
                        this.instructions.add(new CfGoto(target));
                        break;
                    }
                    case 198: 
                    case 199: {
                        If.Type type = opcode == 198 ? If.Type.EQ : If.Type.NE;
                        this.instructions.add(new CfIf(type, ValueType.OBJECT, target));
                        break;
                    }
                    case 168: {
                        throw new JsrEncountered("JSR should be handled by the ASM jsr inliner");
                    }
                    default: {
                        throw new Unreachable("Unexpected JumpInsn opcode: " + opcode);
                    }
                }
            }
        }

        private static If.Type ifType(int opcode) {
            switch (opcode) {
                case 153: 
                case 159: 
                case 165: {
                    return If.Type.EQ;
                }
                case 154: 
                case 160: 
                case 166: {
                    return If.Type.NE;
                }
                case 155: 
                case 161: {
                    return If.Type.LT;
                }
                case 156: 
                case 162: {
                    return If.Type.GE;
                }
                case 157: 
                case 163: {
                    return If.Type.GT;
                }
                case 158: 
                case 164: {
                    return If.Type.LE;
                }
            }
            throw new Unreachable("Unexpected If instruction opcode: " + opcode);
        }

        @Override
        public void visitLabel(Label label) {
            this.instructions.add(this.getLabel(label));
        }

        @Override
        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                if (type.getSort() == 11) {
                    DexProto proto = this.application.getProto(type.getDescriptor());
                    this.instructions.add(new CfConstMethodType(proto));
                } else {
                    this.instructions.add(new CfConstClass(this.factory.createType(type.getDescriptor())));
                }
            } else if (cst instanceof String) {
                this.instructions.add(new CfConstString(this.factory.createString((String)cst)));
            } else if (cst instanceof Long) {
                this.instructions.add(new CfConstNumber((Long)cst, ValueType.LONG));
            } else if (cst instanceof Double) {
                long l = Double.doubleToRawLongBits((Double)cst);
                this.instructions.add(new CfConstNumber(l, ValueType.DOUBLE));
            } else if (cst instanceof Integer) {
                this.instructions.add(new CfConstNumber(((Integer)cst).intValue(), ValueType.INT));
            } else if (cst instanceof Float) {
                long i = Float.floatToRawIntBits(((Float)cst).floatValue());
                this.instructions.add(new CfConstNumber(i, ValueType.FLOAT));
            } else if (cst instanceof Handle) {
                this.instructions.add(new CfConstMethodHandle(DexMethodHandle.fromAsmHandle((Handle)cst, this.application, this.method.holder)));
            } else {
                if (cst instanceof ConstantDynamic) {
                    throw new CompilationError("Unsupported dynamic constant: " + cst.toString());
                }
                throw new CompilationError("Unsupported constant: " + cst.toString());
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.instructions.add(new CfIinc(var, increment));
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            assert (max == min + labels.length - 1);
            ArrayList<CfLabel> targets = new ArrayList<CfLabel>(labels.length);
            for (Label label : labels) {
                targets.add(this.getLabel(label));
            }
            this.instructions.add(new CfSwitch(CfSwitch.Kind.TABLE, this.getLabel(dflt), new int[]{min}, targets));
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
            ArrayList<CfLabel> targets = new ArrayList<CfLabel>(labels.length);
            for (Label label : labels) {
                targets.add(this.getLabel(label));
            }
            this.instructions.add(new CfSwitch(CfSwitch.Kind.LOOKUP, this.getLabel(dflt), keys2, targets));
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (!this.application.options.isGeneratingDex()) {
                this.instructions.add(new CfMultiANewArray(this.factory.createType(desc), dims));
                return;
            }
            this.visitLdcInsn(dims);
            this.visitIntInsn(188, 10);
            for (int i = dims - 1; i >= 0; --i) {
                this.visitInsn(90);
                this.visitInsn(95);
                this.visitLdcInsn(i);
                this.visitInsn(95);
                this.visitInsn(79);
            }
            this.visitLdcInsn(Type.getType(desc.substring(dims)));
            this.visitInsn(95);
            this.visitMethodInsn(184, "java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;", false);
            this.visitTypeInsn(192, desc);
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            List<DexType> guards = Collections.singletonList(type == null ? this.factory.throwableType : this.createTypeFromInternalType(type));
            List<CfLabel> targets = Collections.singletonList(this.getLabel(handler));
            this.tryCatchRanges.add(new CfTryCatch(this.getLabel(start), this.getLabel(end), guards, targets));
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            DebugLocalInfo debugLocalInfo = this.canonicalize(new DebugLocalInfo(this.factory.createString(name), this.factory.createType(desc), signature == null ? null : this.factory.createString(signature)));
            this.localVariables.add(new CfCode.LocalVariableInfo(index, debugLocalInfo, this.getLabel(start), this.getLabel(end)));
        }

        private DebugLocalInfo canonicalize(DebugLocalInfo debugLocalInfo) {
            return this.canonicalDebugLocalInfo.computeIfAbsent(debugLocalInfo, o -> debugLocalInfo);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.instructions.add(new CfPosition(this.getLabel(start), new Position(line, null, this.method, null)));
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            assert (maxStack >= 0);
            assert (maxLocals >= 0);
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }

    private static class ClassCodeVisitor
    extends ClassVisitor {
        private final DexClass clazz;
        private final BiFunction<String, String, LazyCfCode> codeLocator;
        private final JarApplicationReader application;
        private boolean usrJsrInliner;

        ClassCodeVisitor(DexClass clazz, BiFunction<String, String, LazyCfCode> codeLocator, JarApplicationReader application, boolean useJsrInliner) {
            super(458752);
            this.clazz = clazz;
            this.codeLocator = codeLocator;
            this.application = application;
            this.usrJsrInliner = useJsrInliner;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            LazyCfCode code;
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(name, access);
            if (!flags.isAbstract() && !flags.isNative() && (code = this.codeLocator.apply(name, desc)) != null) {
                DexMethod method = this.application.getMethod(this.clazz.type, name, desc);
                MethodCodeVisitor methodVisitor = new MethodCodeVisitor(this.application, method, code);
                if (!this.usrJsrInliner) {
                    return methodVisitor;
                }
                return new JSRInlinerAdapter(methodVisitor, access, name, desc, signature, exceptions);
            }
            return null;
        }
    }

    private static class DefaultCodeLocator
    implements BiFunction<String, String, LazyCfCode> {
        private final JarClassFileReader.ReparseContext context;
        private final JarApplicationReader application;
        private int methodIndex = 0;

        private DefaultCodeLocator(JarClassFileReader.ReparseContext context, JarApplicationReader application) {
            this.context = context;
            this.application = application;
        }

        @Override
        public LazyCfCode apply(String name, String desc) {
            return this.context.codeList.get(this.methodIndex++).asLazyCfCode();
        }
    }

    private static class JsrEncountered
    extends RuntimeException {
        public JsrEncountered(String s) {
            super(s);
        }
    }
}

