/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.io.PrintStream;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexByteCodeWriter;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class AssemblyWriter
extends DexByteCodeWriter {
    private final boolean writeAllClassInfo;
    private final boolean writeFields;
    private final boolean writeAnnotations;
    private final boolean writeIR;
    private final AppInfoWithSubtyping appInfo;
    private final Timing timing = new Timing("AssemblyWriter");

    public AssemblyWriter(DexApplication application, InternalOptions options, boolean allInfo, boolean writeIR) {
        super(application, options);
        this.writeAllClassInfo = allInfo;
        this.writeFields = allInfo;
        this.writeAnnotations = allInfo;
        this.writeIR = writeIR;
        if (writeIR) {
            this.appInfo = new AppInfoWithSubtyping(application.toDirect());
            if (options.programConsumer == null) {
                options.programConsumer = ClassFileConsumer.emptyConsumer();
            }
            options.outline.enabled = false;
        } else {
            this.appInfo = null;
        }
    }

    @Override
    String getFileEnding() {
        return ".dump";
    }

    @Override
    void writeClassHeader(DexProgramClass clazz, PrintStream ps) {
        String clazzName = this.application.getProguardMap() != null ? this.application.getProguardMap().originalNameOf(clazz.type) : clazz.type.toSourceString();
        ps.println("# Bytecode for");
        ps.println("# Class: '" + clazzName + "'");
        if (this.writeAllClassInfo) {
            this.writeAnnotations(clazz.annotations, ps);
            ps.println("# Flags: '" + clazz.accessFlags + "'");
            if (clazz.superType != this.application.dexItemFactory.objectType) {
                ps.println("# Extends: '" + clazz.superType.toSourceString() + "'");
            }
            for (DexType value : clazz.interfaces.values) {
                ps.println("# Implements: '" + value.toSourceString() + "'");
            }
        }
        ps.println();
    }

    @Override
    void writeFieldsHeader(DexProgramClass clazz, PrintStream ps) {
        if (this.writeFields) {
            ps.println("#");
            ps.println("# Fields:");
            ps.println("#");
        }
    }

    @Override
    void writeField(DexEncodedField field, PrintStream ps) {
        if (this.writeFields) {
            ClassNameMapper naming = this.application.getProguardMap();
            MemberNaming.FieldSignature fieldSignature = naming != null ? naming.originalSignatureOf(field.field) : MemberNaming.FieldSignature.fromDexField(field.field);
            this.writeAnnotations(field.annotations, ps);
            ps.print(field.accessFlags + " ");
            ps.println(fieldSignature);
        }
    }

    @Override
    void writeFieldsFooter(DexProgramClass clazz, PrintStream ps) {
        ps.println();
    }

    @Override
    void writeMethod(DexEncodedMethod method, PrintStream ps) {
        ClassNameMapper naming = this.application.getProguardMap();
        String methodName = naming != null ? naming.originalSignatureOf((DexMethod)method.method).name : method.method.name.toString();
        ps.println("#");
        ps.println("# Method: '" + methodName + "':");
        this.writeAnnotations(method.annotations, ps);
        ps.println("# " + method.accessFlags);
        ps.println("#");
        ps.println();
        Code code = method.getCode();
        if (code != null) {
            if (this.writeIR) {
                this.writeIR(method, ps);
            } else {
                ps.println(code.toString(method, naming));
            }
        }
    }

    private void writeIR(DexEncodedMethod method, PrintStream ps) {
        CfgPrinter printer = new CfgPrinter();
        new IRConverter(this.appInfo, this.options, this.timing, printer).processMethod(method, OptimizationFeedbackIgnore.getInstance(), OneTimeMethodProcessor.getInstance());
        ps.println(printer.toString());
    }

    private void writeAnnotations(DexAnnotationSet annotations, PrintStream ps) {
        if (this.writeAnnotations && !annotations.isEmpty()) {
            ps.println("# Annotations:");
            for (DexAnnotation annotation : annotations.annotations) {
                ps.print("#   ");
                ps.println(annotation);
            }
        }
    }

    @Override
    void writeClassFooter(DexProgramClass clazz, PrintStream ps) {
    }
}

