/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.DataResourceConsumer;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.FeatureSplit;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;

public class FeatureSplitConfiguration {
    private final List<FeatureSplit> featureSplits;
    private final Map<String, FeatureSplit> javaTypeToFeatureSplitMapping = new HashMap<String, FeatureSplit>();

    public FeatureSplitConfiguration(List<FeatureSplit> featureSplits, Reporter reporter) {
        this.featureSplits = featureSplits;
        for (FeatureSplit featureSplit : featureSplits) {
            for (ProgramResourceProvider programResourceProvider : featureSplit.getProgramResourceProviders()) {
                try {
                    for (ProgramResource programResource : programResourceProvider.getProgramResources()) {
                        for (String classDescriptor : programResource.getClassDescriptors()) {
                            this.javaTypeToFeatureSplitMapping.put(DescriptorUtils.descriptorToJavaType(classDescriptor), featureSplit);
                        }
                    }
                }
                catch (ResourceException e) {
                    throw reporter.fatalError(e.getMessage());
                }
            }
        }
    }

    public Map<FeatureSplit, Set<DexProgramClass>> getFeatureSplitClasses(Set<DexProgramClass> classes, ClassNameMapper mapper) {
        IdentityHashMap<FeatureSplit, Set<DexProgramClass>> result = new IdentityHashMap<FeatureSplit, Set<DexProgramClass>>();
        for (DexProgramClass programClass : classes) {
            String originalClassName = DescriptorUtils.descriptorToJavaType(programClass.type.toDescriptorString(), mapper);
            FeatureSplit featureSplit = this.javaTypeToFeatureSplitMapping.get(originalClassName);
            if (featureSplit == null) continue;
            result.computeIfAbsent(featureSplit, f -> Sets.newIdentityHashSet()).add(programClass);
        }
        return result;
    }

    public Collection<DataResourceProvidersAndConsumer> getDataResourceProvidersAndConsumers() {
        ArrayList<DataResourceProvidersAndConsumer> result = new ArrayList<DataResourceProvidersAndConsumer>();
        for (FeatureSplit featureSplit : this.featureSplits) {
            DataResourceConsumer dataResourceConsumer = featureSplit.getProgramConsumer().getDataResourceConsumer();
            if (dataResourceConsumer == null) continue;
            HashSet<DataResourceProvider> dataResourceProviders = new HashSet<DataResourceProvider>();
            for (ProgramResourceProvider programResourceProvider : featureSplit.getProgramResourceProviders()) {
                DataResourceProvider dataResourceProvider = programResourceProvider.getDataResourceProvider();
                if (dataResourceProvider == null) continue;
                dataResourceProviders.add(dataResourceProvider);
            }
            if (dataResourceProviders.isEmpty()) continue;
            result.add(new DataResourceProvidersAndConsumer(dataResourceProviders, dataResourceConsumer));
        }
        return result;
    }

    public boolean isInFeature(DexProgramClass clazz) {
        return this.javaTypeToFeatureSplitMapping.containsKey(DescriptorUtils.descriptorToJavaType(clazz.type.toDescriptorString()));
    }

    public boolean inSameFeatureOrBase(DexMethod a, DexMethod b) {
        return this.inSameFeatureOrBase(a.holder, b.holder);
    }

    public boolean inSameFeatureOrBase(DexType a, DexType b) {
        assert (a.isClassType() && b.isClassType());
        if (this.javaTypeToFeatureSplitMapping.isEmpty()) {
            return true;
        }
        return this.javaTypeToFeatureSplitMapping.get(DescriptorUtils.descriptorToJavaType(a.toDescriptorString())) == this.javaTypeToFeatureSplitMapping.get(DescriptorUtils.descriptorToJavaType(b.toDescriptorString()));
    }

    public List<FeatureSplit> getFeatureSplits() {
        return this.featureSplits;
    }

    public static class DataResourceProvidersAndConsumer {
        private final Set<DataResourceProvider> providers;
        private final DataResourceConsumer consumer;

        public DataResourceProvidersAndConsumer(Set<DataResourceProvider> providers, DataResourceConsumer consumer) {
            this.providers = providers;
            this.consumer = consumer;
        }

        public Set<DataResourceProvider> getProviders() {
            return this.providers;
        }

        public DataResourceConsumer getConsumer() {
            return this.consumer;
        }
    }
}

