/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

public class DexSection {
    public final int type;
    public final int length;
    public final int offset;
    private int end;

    public DexSection(int type, int unused, int length, int offset) {
        this.type = type;
        assert (unused == 0);
        this.length = length;
        this.offset = offset;
        this.end = -1;
    }

    void setEnd(int end) {
        this.end = end;
    }

    public int size() {
        return this.end - this.offset;
    }

    public String typeName() {
        return DexSection.typeName(this.type);
    }

    public static String typeName(int type) {
        switch (type) {
            case 0: {
                return "Header";
            }
            case 1: {
                return "Strings";
            }
            case 2: {
                return "Types";
            }
            case 3: {
                return "Protos";
            }
            case 4: {
                return "Fields";
            }
            case 5: {
                return "Methods";
            }
            case 6: {
                return "ClassDefs";
            }
            case 4096: {
                return "Maps";
            }
            case 4097: {
                return "TypeLists";
            }
            case 4098: {
                return "AnnotationSetRefs";
            }
            case 4099: {
                return "AnnotationSets";
            }
            case 8192: {
                return "ClassData";
            }
            case 8193: {
                return "Code";
            }
            case 8194: {
                return "StringData";
            }
            case 8195: {
                return "DebugInfo";
            }
            case 8196: {
                return "Annotation";
            }
            case 8197: {
                return "EncodedArrays";
            }
            case 8198: {
                return "AnnotationsDirectory";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return this.typeName() + " @" + this.offset + " " + this.length;
    }
}

