/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public abstract class CodeToKeep {
    static CodeToKeep createCodeToKeep(InternalOptions options, NamingLens namingLens) {
        if (!namingLens.hasPrefixRewritingLogic() && options.desugaredLibraryConfiguration.getEmulateLibraryInterface().isEmpty() || options.isDesugaredLibraryCompilation()) {
            return new NopCodeToKeep();
        }
        return new DesugaredLibraryCodeToKeep(namingLens, options);
    }

    abstract void recordMethod(DexMethod var1);

    abstract void recordField(DexField var1);

    abstract void recordClass(DexType var1);

    abstract void recordClassAllAccesses(DexType var1);

    abstract boolean isNop();

    abstract void generateKeepRules(InternalOptions var1);

    public static class NopCodeToKeep
    extends CodeToKeep {
        @Override
        void recordMethod(DexMethod method) {
        }

        @Override
        void recordField(DexField field) {
        }

        @Override
        void recordClass(DexType type) {
        }

        @Override
        void recordClassAllAccesses(DexType type) {
        }

        @Override
        boolean isNop() {
            return true;
        }

        @Override
        void generateKeepRules(InternalOptions options) {
            throw new Unreachable("Has no keep rules to generate");
        }
    }

    public static class DesugaredLibraryCodeToKeep
    extends CodeToKeep {
        private final NamingLens namingLens;
        private final Set<DexType> potentialTypesToKeep = Sets.newIdentityHashSet();
        private final Map<DexType, KeepStruct> toKeep = new ConcurrentHashMap<DexType, KeepStruct>();
        private final InternalOptions options;

        public DesugaredLibraryCodeToKeep(NamingLens namingLens, InternalOptions options) {
            this.namingLens = namingLens;
            this.options = options;
            this.potentialTypesToKeep.addAll(options.desugaredLibraryConfiguration.getEmulateLibraryInterface().values());
            this.potentialTypesToKeep.addAll(options.desugaredLibraryConfiguration.getCustomConversions().values());
        }

        private boolean shouldKeep(DexType type) {
            return this.namingLens.prefixRewrittenType(type) != null || this.potentialTypesToKeep.contains(type);
        }

        @Override
        void recordMethod(DexMethod method) {
            if (this.shouldKeep(method.holder)) {
                this.keepClass(method.holder);
                this.toKeep.get((Object)method.holder).methods.add(method);
            }
            if (this.shouldKeep(method.proto.returnType)) {
                this.keepClass(method.proto.returnType);
            }
            for (DexType type : method.proto.parameters.values) {
                if (!this.shouldKeep(type)) continue;
                this.keepClass(type);
            }
        }

        @Override
        void recordField(DexField field) {
            if (this.shouldKeep(field.holder)) {
                this.keepClass(field.holder);
                this.toKeep.get((Object)field.holder).fields.add(field);
            }
            if (this.shouldKeep(field.type)) {
                this.keepClass(field.type);
            }
        }

        @Override
        void recordClass(DexType type) {
            if (this.shouldKeep(type)) {
                this.keepClass(type);
            }
        }

        @Override
        void recordClassAllAccesses(DexType type) {
            if (this.shouldKeep(type)) {
                this.keepClass(type);
                this.toKeep.get((Object)type).all = true;
            }
        }

        private void keepClass(DexType type) {
            DexType baseType = type.lookupBaseType(this.options.itemFactory);
            this.toKeep.putIfAbsent(baseType, new KeepStruct());
        }

        @Override
        boolean isNop() {
            return false;
        }

        private String convertType(DexType type) {
            DexString rewriteType = this.namingLens.prefixRewrittenType(type);
            DexString descriptor = rewriteType != null ? rewriteType : type.descriptor;
            return DescriptorUtils.descriptorToJavaType(descriptor.toString());
        }

        @Override
        void generateKeepRules(InternalOptions options) {
            StringBuilder sb = new StringBuilder();
            String cr = System.lineSeparator();
            for (DexType type : this.toKeep.keySet()) {
                KeepStruct keepStruct = this.toKeep.get(type);
                sb.append("-keep class ").append(this.convertType(type));
                if (keepStruct.all) {
                    sb.append(" { *; }").append(cr);
                    continue;
                }
                if (keepStruct.fields.isEmpty() && keepStruct.methods.isEmpty()) {
                    sb.append(cr);
                    continue;
                }
                sb.append(" {").append(cr);
                for (DexField field : keepStruct.fields) {
                    sb.append("    ").append(this.convertType(field.type)).append(" ").append(field.name).append(";").append(cr);
                }
                for (DexMethod method : keepStruct.methods) {
                    sb.append("    ").append(this.convertType(method.proto.returnType)).append(" ").append(method.name).append("(");
                    for (int i = 0; i < method.getArity(); ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(this.convertType(method.proto.parameters.values[i]));
                    }
                    sb.append(");").append(cr);
                }
                sb.append("}").append(cr);
            }
            options.desugaredLibraryKeepRuleConsumer.accept(sb.toString(), options.reporter);
            options.desugaredLibraryKeepRuleConsumer.finished(options.reporter);
        }

        private static class KeepStruct {
            Set<DexField> fields = Sets.newConcurrentHashSet();
            Set<DexMethod> methods = Sets.newConcurrentHashSet();
            boolean all = false;

            private KeepStruct() {
            }
        }
    }
}

