/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.io.IOException;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.dex.CompatByteBuffer;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.LebUtils;
import shadow.bundletool.com.android.tools.r8.utils.StreamUtils;

public abstract class BinaryReader {
    protected final Origin origin;
    protected final CompatByteBuffer buffer;

    protected BinaryReader(ProgramResource resource) throws ResourceException, IOException {
        this(resource.getOrigin(), StreamUtils.StreamToByteArrayClose(resource.getByteStream()));
    }

    protected BinaryReader(Origin origin, byte[] bytes) {
        assert (origin != null);
        this.origin = origin;
        this.buffer = CompatByteBuffer.wrap(bytes);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    abstract void setByteOrder();

    byte[] getByteArray(int size) {
        byte[] result = new byte[size];
        this.buffer.get(result);
        return result;
    }

    int getUleb128() {
        return LebUtils.parseUleb128(this);
    }

    int getSleb128() {
        return LebUtils.parseSleb128(this);
    }

    int getUleb128p1() {
        return this.getUleb128() - 1;
    }

    int getUint() {
        int result = this.buffer.getInt();
        assert (result >= 0);
        return result;
    }

    int getUshort() {
        int result = this.buffer.getShort() & 0xFFFF;
        assert (result >= 0);
        return result;
    }

    short getShort() {
        return this.buffer.getShort();
    }

    int getUint(int offset) {
        int result = this.buffer.getInt(offset);
        assert (result >= 0);
        return result;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    int position() {
        return this.buffer.position();
    }

    void position(int position) {
        this.buffer.position(position);
    }

    void align(int alignment) {
        assert ((alignment & alignment - 1) == 0);
        int p = this.buffer.position();
        p += alignment - p % alignment & alignment - 1;
        this.buffer.position(p);
    }

    public byte get() {
        return this.buffer.get();
    }

    int getUbyte() {
        int result = this.buffer.get() & 0xFF;
        assert (result >= 0);
        return result;
    }

    int end() {
        return this.buffer.capacity();
    }
}

