/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfLogicalBinop
extends CfInstruction {
    private final Opcode opcode;
    private final NumericType type;

    public CfLogicalBinop(Opcode opcode, NumericType type) {
        assert (opcode != null);
        assert (type != null);
        assert (type != NumericType.FLOAT && type != NumericType.DOUBLE);
        this.opcode = opcode;
        this.type = type;
    }

    public NumericType getType() {
        return this.type;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public static CfLogicalBinop fromAsm(int opcode) {
        switch (opcode) {
            case 120: {
                return new CfLogicalBinop(Opcode.Shl, NumericType.INT);
            }
            case 121: {
                return new CfLogicalBinop(Opcode.Shl, NumericType.LONG);
            }
            case 122: {
                return new CfLogicalBinop(Opcode.Shr, NumericType.INT);
            }
            case 123: {
                return new CfLogicalBinop(Opcode.Shr, NumericType.LONG);
            }
            case 124: {
                return new CfLogicalBinop(Opcode.Ushr, NumericType.INT);
            }
            case 125: {
                return new CfLogicalBinop(Opcode.Ushr, NumericType.LONG);
            }
            case 126: {
                return new CfLogicalBinop(Opcode.And, NumericType.INT);
            }
            case 127: {
                return new CfLogicalBinop(Opcode.And, NumericType.LONG);
            }
            case 128: {
                return new CfLogicalBinop(Opcode.Or, NumericType.INT);
            }
            case 129: {
                return new CfLogicalBinop(Opcode.Or, NumericType.LONG);
            }
            case 130: {
                return new CfLogicalBinop(Opcode.Xor, NumericType.INT);
            }
            case 131: {
                return new CfLogicalBinop(Opcode.Xor, NumericType.LONG);
            }
        }
        throw new Unreachable("Wrong ASM opcode for CfLogicalBinop " + opcode);
    }

    public int getAsmOpcode() {
        switch (this.opcode) {
            case Shl: {
                return this.type.isWide() ? 121 : 120;
            }
            case Shr: {
                return this.type.isWide() ? 123 : 122;
            }
            case Ushr: {
                return this.type.isWide() ? 125 : 124;
            }
            case And: {
                return this.type.isWide() ? 127 : 126;
            }
            case Or: {
                return this.type.isWide() ? 129 : 128;
            }
            case Xor: {
                return this.type.isWide() ? 131 : 130;
            }
        }
        throw new Unreachable("CfLogicalBinop has unknown opcode " + (Object)((Object)this.opcode));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        int dest = state.push((ValueType)ValueType.fromNumericType((NumericType)this.type)).register;
        switch (this.opcode) {
            case Shl: {
                builder.addShl(this.type, dest, left, right);
                break;
            }
            case Shr: {
                builder.addShr(this.type, dest, left, right);
                break;
            }
            case Ushr: {
                builder.addUshr(this.type, dest, left, right);
                break;
            }
            case And: {
                builder.addAnd(this.type, dest, left, right);
                break;
            }
            case Or: {
                builder.addOr(this.type, dest, left, right);
                break;
            }
            case Xor: {
                builder.addXor(this.type, dest, left, right);
                break;
            }
            default: {
                throw new Unreachable("CfLogicalBinop has unknown opcode " + (Object)((Object)this.opcode));
            }
        }
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forBinop();
    }

    public static enum Opcode {
        Shl,
        Shr,
        Ushr,
        And,
        Or,
        Xor;

    }
}

