/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfArrayLoad
extends CfInstruction {
    private final MemberType type;

    public CfArrayLoad(MemberType type) {
        assert (type.isPrecise());
        this.type = type;
    }

    public MemberType getType() {
        return this.type;
    }

    private int getLoadType() {
        switch (this.type) {
            case OBJECT: {
                return 50;
            }
            case BOOLEAN_OR_BYTE: {
                return 51;
            }
            case CHAR: {
                return 52;
            }
            case SHORT: {
                return 53;
            }
            case INT: {
                return 46;
            }
            case FLOAT: {
                return 48;
            }
            case LONG: {
                return 47;
            }
            case DOUBLE: {
                return 49;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getLoadType());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        CfState.Slot value;
        CfState.Slot index = state.pop();
        CfState.Slot array = state.pop();
        assert (array.type.isObject());
        ValueType memberType = ValueType.fromMemberType(this.type);
        if (array.preciseType != null) {
            value = state.push(array.preciseType.toArrayElementType(builder.appView.dexItemFactory()));
            assert (state.peek().type == memberType);
        } else {
            value = state.push(memberType);
        }
        builder.addArrayGet(this.type, value.register, array.register, index.register);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forArrayGet();
    }
}

