/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.DataDirectoryResource;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.FeatureSplit;
import shadow.bundletool.com.android.tools.r8.InternalProgramOutputPathConsumer;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.R8CommandParser;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.features.FeatureSplitConfiguration;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationParser;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSource;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSourceBytes;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

@Keep
public final class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = R8CommandParser.USAGE_MESSAGE;
    private final List<ProguardConfigurationRule> mainDexKeepRules;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean enableTreeShaking;
    private final boolean enableMinification;
    private final boolean disableVerticalClassMerging;
    private final boolean forceProguardCompatibility;
    private final StringConsumer proguardMapConsumer;
    private final StringConsumer proguardUsageConsumer;
    private final StringConsumer proguardSeedsConsumer;
    private final StringConsumer proguardConfigurationConsumer;
    private final GraphConsumer keptGraphConsumer;
    private final GraphConsumer mainDexKeptGraphConsumer;
    private final Consumer<List<ProguardConfigurationRule>> syntheticProguardRulesConsumer;
    private final StringConsumer desugaredLibraryKeepRuleConsumer;
    private final DesugaredLibraryConfiguration libraryConfiguration;
    private final FeatureSplitConfiguration featureSplitConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    static Builder builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
        return new Builder(app, diagnosticsHandler);
    }

    public static Builder parse(String[] args, Origin origin) {
        return R8CommandParser.parse(args, origin);
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return R8CommandParser.parse(args, origin, handler);
    }

    private R8Command(AndroidApp inputApp, ProgramConsumer programConsumer, List<ProguardConfigurationRule> mainDexKeepRules, StringConsumer mainDexListConsumer, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean enableTreeShaking, boolean enableMinification, boolean disableVerticalClassMerging, boolean forceProguardCompatibility, StringConsumer proguardMapConsumer, StringConsumer proguardUsageConsumer, StringConsumer proguardSeedsConsumer, StringConsumer proguardConfigurationConsumer, GraphConsumer keptGraphConsumer, GraphConsumer mainDexKeptGraphConsumer, Consumer<List<ProguardConfigurationRule>> syntheticProguardRulesConsumer, boolean optimizeMultidexForLinearAlloc, boolean encodeChecksum, BiPredicate<String, Long> dexClassChecksumFilter, StringConsumer desugaredLibraryKeepRuleConsumer, DesugaredLibraryConfiguration libraryConfiguration, FeatureSplitConfiguration featureSplitConfiguration, List<AssertionsConfiguration> assertionsConfiguration) {
        super(inputApp, mode, programConsumer, mainDexListConsumer, minApiLevel, reporter, enableDesugaring, optimizeMultidexForLinearAlloc, encodeChecksum, dexClassChecksumFilter, assertionsConfiguration);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        this.mainDexKeepRules = mainDexKeepRules;
        this.proguardConfiguration = proguardConfiguration;
        this.enableTreeShaking = enableTreeShaking;
        this.enableMinification = enableMinification;
        this.disableVerticalClassMerging = disableVerticalClassMerging;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.proguardMapConsumer = proguardMapConsumer;
        this.proguardUsageConsumer = proguardUsageConsumer;
        this.proguardSeedsConsumer = proguardSeedsConsumer;
        this.proguardConfigurationConsumer = proguardConfigurationConsumer;
        this.keptGraphConsumer = keptGraphConsumer;
        this.mainDexKeptGraphConsumer = mainDexKeptGraphConsumer;
        this.syntheticProguardRulesConsumer = syntheticProguardRulesConsumer;
        this.desugaredLibraryKeepRuleConsumer = desugaredLibraryKeepRuleConsumer;
        this.libraryConfiguration = libraryConfiguration;
        this.featureSplitConfiguration = featureSplitConfiguration;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
        this.disableVerticalClassMerging = false;
        this.forceProguardCompatibility = false;
        this.proguardMapConsumer = null;
        this.proguardUsageConsumer = null;
        this.proguardSeedsConsumer = null;
        this.proguardConfigurationConsumer = null;
        this.keptGraphConsumer = null;
        this.mainDexKeptGraphConsumer = null;
        this.syntheticProguardRulesConsumer = null;
        this.desugaredLibraryKeepRuleConsumer = null;
        this.libraryConfiguration = null;
        this.featureSplitConfiguration = null;
    }

    public boolean getEnableTreeShaking() {
        return this.enableTreeShaking;
    }

    public boolean getEnableMinification() {
        return this.enableMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration, this.getReporter());
        assert (!internal.testing.allowOutlinerInterfaceArrayArguments);
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.minApiLevel = this.getMinApiLevel();
        internal.enableDesugaring = this.getEnableDesugaring();
        assert (internal.isShrinking() == this.getEnableTreeShaking());
        assert (internal.isMinifying() == this.getEnableMinification());
        internal.enableLambdaMerging = this.getEnableTreeShaking();
        assert (!internal.ignoreMissingClasses);
        boolean bl = internal.ignoreMissingClasses = this.proguardConfiguration.isIgnoreWarnings() || this.forceProguardCompatibility && !this.proguardConfiguration.isOptimizing() && !internal.isShrinking() && !internal.isMinifying();
        assert (!internal.verbose);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = this.getMode() == CompilationMode.DEBUG;
        internal.mainDexListConsumer = this.getMainDexListConsumer();
        InternalOptions.LineNumberOptimization lineNumberOptimization = internal.lineNumberOptimization = !internal.debug && (this.proguardConfiguration.isOptimizing() || internal.isMinifying()) ? InternalOptions.LineNumberOptimization.ON : InternalOptions.LineNumberOptimization.OFF;
        assert (internal.enableDynamicTypeOptimization || !this.proguardConfiguration.isOptimizing());
        assert (internal.enableHorizontalClassMerging || !this.proguardConfiguration.isOptimizing());
        assert (!internal.enableTreeShakingOfLibraryMethodOverrides);
        assert (internal.enableVerticalClassMerging || !this.proguardConfiguration.isOptimizing());
        if (internal.debug) {
            internal.getProguardConfiguration().getKeepAttributes().lineNumberTable = true;
            internal.getProguardConfiguration().getKeepAttributes().localVariableTable = true;
            internal.getProguardConfiguration().getKeepAttributes().localVariableTypeTable = true;
            internal.enableInlining = false;
            internal.enableClassInlining = false;
            internal.enableHorizontalClassMerging = false;
            internal.enableVerticalClassMerging = false;
            internal.enableClassStaticizer = false;
            internal.outline.enabled = false;
        }
        internal.proguardMapConsumer = R8Command.wrapStringConsumer(this.proguardMapConsumer, this.proguardConfiguration.isPrintMapping(), this.proguardConfiguration.getPrintMappingFile());
        internal.usageInformationConsumer = R8Command.wrapStringConsumer(this.proguardUsageConsumer, this.proguardConfiguration.isPrintUsage(), this.proguardConfiguration.getPrintUsageFile());
        internal.proguardSeedsConsumer = R8Command.wrapStringConsumer(this.proguardSeedsConsumer, this.proguardConfiguration.isPrintSeeds(), this.proguardConfiguration.getSeedFile());
        internal.configurationConsumer = R8Command.wrapStringConsumer(this.proguardConfigurationConsumer, this.proguardConfiguration.isPrintConfiguration(), this.proguardConfiguration.getPrintConfigurationFile());
        internal.keptGraphConsumer = this.keptGraphConsumer;
        internal.mainDexKeptGraphConsumer = this.mainDexKeptGraphConsumer;
        internal.dataResourceConsumer = internal.programConsumer.getDataResourceConsumer();
        internal.featureSplitConfiguration = this.featureSplitConfiguration;
        internal.syntheticProguardRulesConsumer = this.syntheticProguardRulesConsumer;
        assert (internal.assertionsConfiguration == null);
        internal.assertionsConfiguration = new AssertionConfigurationWithDefault(this.getProgramConsumer() instanceof ClassFileConsumer ? AssertionsConfiguration.AssertionTransformation.PASSTHROUGH : AssertionsConfiguration.AssertionTransformation.DISABLE, this.getAssertionsConfiguration());
        if (internal.isGeneratingClassFiles()) {
            internal.outline.enabled = false;
        }
        assert (!internal.forceProguardCompatibility);
        internal.forceProguardCompatibility = this.forceProguardCompatibility;
        if (this.disableVerticalClassMerging) {
            internal.enableVerticalClassMerging = false;
        }
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        internal.desugaredLibraryConfiguration = this.libraryConfiguration;
        internal.desugaredLibraryKeepRuleConsumer = this.desugaredLibraryKeepRuleConsumer;
        return internal;
    }

    private static StringConsumer wrapStringConsumer(StringConsumer optionConsumer, boolean optionsFlag, Path optionFile) {
        if (optionsFlag) {
            if (optionFile != null) {
                return new StringConsumer.FileConsumer(optionFile, optionConsumer);
            }
            return new StandardOutConsumer(optionConsumer);
        }
        return optionConsumer;
    }

    private static class StandardOutConsumer
    extends StringConsumer.ForwardingConsumer {
        public StandardOutConsumer(StringConsumer consumer) {
            super(consumer);
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            super.accept(string, handler);
            System.out.print(string);
        }
    }

    private static class EnsureNonDexProgramResourceProvider
    implements ProgramResourceProvider {
        final ProgramResourceProvider provider;

        public EnsureNonDexProgramResourceProvider(ProgramResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public Collection<ProgramResource> getProgramResources() throws ResourceException {
            Collection<ProgramResource> resources = this.provider.getProgramResources();
            for (ProgramResource resource : resources) {
                if (resource.getKind() != ProgramResource.Kind.DEX) continue;
                throw new ResourceException(resource.getOrigin(), "R8 does not support compiling DEX inputs");
            }
            return resources;
        }

        @Override
        public DataResourceProvider getDataResourceProvider() {
            return this.provider.getDataResourceProvider();
        }
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumerForTesting = null;
        private Consumer<List<ProguardConfigurationRule>> syntheticProguardRulesConsumer = null;
        private StringConsumer desugaredLibraryKeepRuleConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private boolean disableTreeShaking = false;
        private boolean disableMinification = false;
        private boolean disableVerticalClassMerging = false;
        private boolean forceProguardCompatibility = false;
        private StringConsumer proguardMapConsumer = null;
        private StringConsumer proguardUsageConsumer = null;
        private StringConsumer proguardSeedsConsumer = null;
        private StringConsumer proguardConfigurationConsumer = null;
        private GraphConsumer keptGraphConsumer = null;
        private GraphConsumer mainDexKeptGraphConsumer = null;
        private BiFunction<String, Long, Boolean> dexClassChecksumFilter = (name, checksum) -> true;
        private final List<FeatureSplit> featureSplits = new ArrayList<FeatureSplit>();
        private boolean allowPartiallyImplementedProguardOptions = false;
        private boolean allowTestProguardOptions = System.getProperty("shadow.bundletool.com.android.tools.r8.allowTestProguardOptions") != null;

        Builder() {
            this(new DefaultR8DiagnosticsHandler());
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        private Builder(AndroidApp app) {
            super(app);
        }

        private Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(app, diagnosticsHandler);
        }

        void internalForceProguardCompatibility() {
            this.forceProguardCompatibility = true;
        }

        void setDisableVerticalClassMerging(boolean disableVerticalClassMerging) {
            this.disableVerticalClassMerging = disableVerticalClassMerging;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.RELEASE;
        }

        public Builder setDisableTreeShaking(boolean disableTreeShaking) {
            this.disableTreeShaking = disableTreeShaking;
            return this.self();
        }

        public Builder setDisableMinification(boolean disableMinification) {
            this.disableMinification = disableMinification;
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRulesFiles(Collection<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.guard(() -> this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder setProguardMapOutputPath(Path proguardMapOutput) {
            assert (proguardMapOutput != null);
            this.proguardMapConsumer = new StringConsumer.FileConsumer(proguardMapOutput);
            return this.self();
        }

        public Builder setProguardMapConsumer(StringConsumer proguardMapConsumer) {
            this.proguardMapConsumer = proguardMapConsumer;
            return this.self();
        }

        public Builder setDesugaredLibraryKeepRuleConsumer(StringConsumer keepRuleConsumer) {
            this.desugaredLibraryKeepRuleConsumer = keepRuleConsumer;
            return this.self();
        }

        public Builder setProguardUsageConsumer(StringConsumer proguardUsageConsumer) {
            this.proguardUsageConsumer = proguardUsageConsumer;
            return this.self();
        }

        public Builder setProguardSeedsConsumer(StringConsumer proguardSeedsConsumer) {
            this.proguardSeedsConsumer = proguardSeedsConsumer;
            return this.self();
        }

        public Builder setProguardConfigurationConsumer(StringConsumer proguardConfigurationConsumer) {
            this.proguardConfigurationConsumer = proguardConfigurationConsumer;
            return this.self();
        }

        public Builder setKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.keptGraphConsumer = graphConsumer;
            return this.self();
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.mainDexKeptGraphConsumer = graphConsumer;
            return this.self();
        }

        @Override
        public Builder setOutput(Path outputPath, OutputMode outputMode) {
            this.setOutput(outputPath, outputMode, true);
            return this.self();
        }

        @Override
        public Builder setOutput(Path outputPath, OutputMode outputMode, boolean includeDataResources) {
            return (Builder)super.setOutput(outputPath, outputMode, includeDataResources);
        }

        @Override
        public Builder addProgramResourceProvider(ProgramResourceProvider programProvider) {
            return (Builder)super.addProgramResourceProvider(new EnsureNonDexProgramResourceProvider(programProvider));
        }

        public Builder addFeatureSplit(Function<FeatureSplit.Builder, FeatureSplit> featureSplitGenerator) {
            FeatureSplit featureSplit = featureSplitGenerator.apply(FeatureSplit.builder(this.getReporter()));
            this.featureSplits.add(featureSplit);
            for (final ProgramResourceProvider programResourceProvider : featureSplit.getProgramResourceProviders()) {
                ProgramResourceProvider providerWithoutDataResources = new ProgramResourceProvider(){

                    @Override
                    public Collection<ProgramResource> getProgramResources() throws ResourceException {
                        return programResourceProvider.getProgramResources();
                    }

                    @Override
                    public DataResourceProvider getDataResourceProvider() {
                        return null;
                    }
                };
                this.addProgramResourceProvider(providerWithoutDataResources);
            }
            return this.self();
        }

        @Override
        protected InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode, boolean consumeDataResources) {
            return super.createProgramOutputConsumer(path, mode, consumeDataResources);
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                reporter.error("R8 does not support compiling to a single DEX file per Java class file");
            }
            if (this.getMainDexListConsumer() != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                reporter.error("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
            if (!(this.getProgramConsumer() instanceof ClassFileConsumer || this.getMinApiLevel() < AndroidApiLevel.L.getLevel() || this.getMainDexListConsumer() == null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList())) {
                reporter.error("R8 does not support main-dex inputs and outputs when compiling to API level " + AndroidApiLevel.L.getLevel() + " and above");
            }
            for (FeatureSplit featureSplit : this.featureSplits) {
                assert (featureSplit.getProgramConsumer() instanceof DexIndexedConsumer);
                if (this.getProgramConsumer() instanceof DexIndexedConsumer) continue;
                reporter.error("R8 does not support class file output when using feature splits");
            }
            for (Path file : this.programFiles) {
                if (!FileUtils.isDexFile(file)) continue;
                reporter.error(new StringDiagnostic("R8 does not support compiling DEX inputs", new PathOrigin(file)));
            }
            if (this.getProgramConsumer() instanceof ClassFileConsumer && this.isMinApiLevelSet()) {
                reporter.error("R8 does not support --min-api when compiling to class files");
            }
            if (this.hasDesugaredLibraryConfiguration() && this.getDisableDesugaring()) {
                reporter.error("Using desugared library configuration requires desugaring to be enabled");
            }
            super.validate();
        }

        @Override
        R8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new R8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            return this.makeR8Command();
        }

        private R8Command makeR8Command() {
            List<Object> mainDexKeepRules;
            final Reporter reporter = this.getReporter();
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, reporter);
                parser.parse(this.mainDexRules);
                mainDexKeepRules = parser.getConfig().getRules();
            }
            DesugaredLibraryConfiguration libraryConfiguration = this.getDesugaredLibraryConfiguration(factory, false);
            final ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, reporter, this.allowTestProguardOptions);
            if (!this.proguardConfigs.isEmpty()) {
                parser.parse(this.proguardConfigs);
            }
            ProguardConfiguration.Builder configurationBuilder = parser.getConfigurationBuilder();
            configurationBuilder.setForceProguardCompatibility(this.forceProguardCompatibility);
            if (InternalOptions.shouldEnableKeepRuleSynthesisForRecompilation()) {
                configurationBuilder.enableKeepRuleSynthesisForRecompilation();
            }
            if (this.proguardConfigurationConsumerForTesting != null) {
                this.proguardConfigurationConsumerForTesting.accept(configurationBuilder);
            }
            DataResourceProvider.Visitor embeddedProguardConfigurationVisitor = new DataResourceProvider.Visitor(){

                @Override
                public void visit(DataDirectoryResource directory) {
                }

                @Override
                public void visit(DataEntryResource resource) {
                    if (resource.getName().startsWith("META-INF/proguard/")) {
                        try (InputStream in = resource.getByteStream();){
                            ProguardConfigurationSourceBytes source = new ProguardConfigurationSourceBytes(in, resource.getOrigin());
                            parser.parse(source);
                        }
                        catch (ResourceException e) {
                            reporter.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), resource.getOrigin()));
                        }
                        catch (Exception e) {
                            reporter.error(new ExceptionDiagnostic(e, resource.getOrigin()));
                        }
                    }
                }
            };
            this.getAppBuilder().getProgramResourceProviders().stream().map(ProgramResourceProvider::getDataResourceProvider).filter(Objects::nonNull).forEach(dataResourceProvider -> {
                try {
                    dataResourceProvider.accept(embeddedProguardConfigurationVisitor);
                }
                catch (ResourceException e) {
                    reporter.error(new ExceptionDiagnostic(e));
                }
            });
            if (this.disableTreeShaking) {
                configurationBuilder.disableShrinking();
            }
            if (this.disableMinification) {
                configurationBuilder.disableObfuscation();
            }
            ProguardConfiguration configuration = configurationBuilder.build();
            this.getAppBuilder().addFilteredProgramArchives(configuration.getInjars()).addFilteredLibraryArchives(configuration.getLibraryjars());
            assert (this.getProgramConsumer() != null);
            boolean desugaring = this.getProgramConsumer() instanceof ClassFileConsumer ? false : !this.getDisableDesugaring();
            FeatureSplitConfiguration featureSplitConfiguration = !this.featureSplits.isEmpty() ? new FeatureSplitConfiguration(this.featureSplits, reporter) : null;
            R8Command command = new R8Command(this.getAppBuilder().build(), this.getProgramConsumer(), mainDexKeepRules, this.getMainDexListConsumer(), configuration, this.getMode(), this.getMinApiLevel(), reporter, desugaring, configuration.isShrinking(), configuration.isObfuscating(), this.disableVerticalClassMerging, this.forceProguardCompatibility, this.proguardMapConsumer, this.proguardUsageConsumer, this.proguardSeedsConsumer, this.proguardConfigurationConsumer, this.keptGraphConsumer, this.mainDexKeptGraphConsumer, this.syntheticProguardRulesConsumer, this.isOptimizeMultidexForLinearAlloc(), this.getIncludeClassesChecksum(), this.getDexClassChecksumFilter(), this.desugaredLibraryKeepRuleConsumer, libraryConfiguration, featureSplitConfiguration, this.getAssertionsConfiguration());
            return command;
        }

        void addProguardConfigurationConsumerForTesting(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumerForTesting;
            this.proguardConfigurationConsumerForTesting = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
        }

        void addSyntheticProguardRulesConsumerForTesting(Consumer<List<ProguardConfigurationRule>> consumer) {
            this.syntheticProguardRulesConsumer = this.syntheticProguardRulesConsumer == null ? consumer : this.syntheticProguardRulesConsumer.andThen(consumer);
        }

        void allowPartiallyImplementedProguardOptions() {
            this.allowPartiallyImplementedProguardOptions = true;
        }

        void allowTestProguardOptions() {
            this.allowTestProguardOptions = true;
        }

        private static class DefaultR8DiagnosticsHandler
        implements DiagnosticsHandler {
            private DefaultR8DiagnosticsHandler() {
            }

            @Override
            public void error(Diagnostic error) {
                DexFileOverflowDiagnostic overflowDiagnostic;
                if (error instanceof DexFileOverflowDiagnostic && !(overflowDiagnostic = (DexFileOverflowDiagnostic)error).hasMainDexSpecification()) {
                    DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Try supplying a main-dex list or main-dex rules"));
                    return;
                }
                DiagnosticsHandler.super.error(error);
            }
        }
    }
}

