/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.R8Command;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppServices;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.AppliedGraphLens;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.analysis.ClassInitializerAssertionEnablingAnalysis;
import shadow.bundletool.com.android.tools.r8.graph.analysis.InitializedClassesInInstanceMethodsAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedExtensionRegistryShrinker;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.R8NestBasedAccessDesugaring;
import shadow.bundletool.com.android.tools.r8.ir.optimize.AssertionsRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.EnumInfoMapCollector;
import shadow.bundletool.com.android.tools.r8.ir.optimize.MethodPoolCollection;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NestReducer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.SwitchMapCollector;
import shadow.bundletool.com.android.tools.r8.ir.optimize.UninstantiatedTypeOptimization;
import shadow.bundletool.com.android.tools.r8.ir.optimize.UnusedArgumentsCollector;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import shadow.bundletool.com.android.tools.r8.jar.CfApplicationWriter;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.Minifier;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.naming.PrefixRewritingNamingLens;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMapMinifier;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMapSupplier;
import shadow.bundletool.com.android.tools.r8.naming.SeedMapper;
import shadow.bundletool.com.android.tools.r8.naming.SourceFileRewriter;
import shadow.bundletool.com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import shadow.bundletool.com.android.tools.r8.optimize.ClassAndMemberPublicizer;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.optimize.VisibilityBridgeRemover;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.AbstractMethodRemover;
import shadow.bundletool.com.android.tools.r8.shaking.AnnotationRemover;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.DiscardedChecker;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerFactory;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexClasses;
import shadow.bundletool.com.android.tools.r8.shaking.MainDexListBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassFilter;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationUtils;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.StaticClassMerger;
import shadow.bundletool.com.android.tools.r8.shaking.TreePruner;
import shadow.bundletool.com.android.tools.r8.shaking.TreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.VerticalClassMerger;
import shadow.bundletool.com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.CollectionUtils;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.LineNumberOptimizer;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.SelfRetraceTest;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

@Keep
public class R8 {
    private final Timing timing;
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        if (options.printMemory) {
            System.gc();
        }
        this.timing = new Timing("R8", options.printMemory);
        options.itemFactory.resetSortedIndices();
    }

    public static void run(R8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        R8.runForTesting(app, options);
    }

    public static void run(R8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> R8.run(app, options, executor));
    }

    static void writeApplication(ExecutorService executorService, DexApplication application, AppView<?> appView, GraphLense graphLense, NamingLens namingLens, InternalOptions options, ProguardMapSupplier proguardMapSupplier) throws ExecutionException {
        try {
            Marker marker = options.getMarker(Marker.Tool.R8);
            assert (marker != null);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(application, appView, options, marker, graphLense, namingLens, proguardMapSupplier).write(options.getClassFileConsumer(), executorService);
            } else {
                new ApplicationWriter(application, appView, options, Collections.singletonList(marker), graphLense, namingLens, proguardMapSupplier).write(executorService);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write application", e);
        }
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, ProguardClassFilter dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        dontWarnPatterns.filterOutMatches(result);
        return result;
    }

    static void runForTesting(AndroidApp app, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withR8CompilationHandler(options.reporter, () -> {
            try {
                R8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static void run(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException {
        new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AndroidApp inputApp, ExecutorService executorService) throws IOException {
        assert (this.options.programConsumer != null);
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        if (this.getClass().desiredAssertionStatus()) {
            this.options.reporter.info(new StringDiagnostic("Running R8 version 2.0.23 with assertions enabled."));
        }
        try {
            NamingLens namingLens;
            Enqueuer enqueuer;
            WhyAreYouKeepingConsumer whyAreYouKeepingConsumer;
            Set<DexCallSite> desugaredCallSites;
            boolean changed;
            GraphLense publicizedLense;
            boolean changed2;
            DexApplication application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService).toDirect();
            inputApp.closeInternalArchiveProviders();
            AppView<AppInfoWithSubtyping> appView = AppView.createForR8(new AppInfoWithSubtyping(application), this.options);
            appView.setAppServices(AppServices.builder(appView).build());
            ArrayList<ProguardAssumeNoSideEffectRule> synthesizedProguardRules = new ArrayList<ProguardAssumeNoSideEffectRule>();
            this.timing.begin("Strip unused code");
            Set<DexType> classesToRetainInnerClassAttributeFor = null;
            try {
                Set<DexType> missingClasses = appView.appInfo().getMissingClasses();
                missingClasses = this.filterMissingClasses(missingClasses, this.options.getProguardConfiguration().getDontWarnPatterns());
                if (!missingClasses.isEmpty()) {
                    missingClasses.forEach(clazz -> this.options.reporter.warning(new StringDiagnostic("Missing class: " + clazz.toSourceString())));
                    if (!this.options.ignoreMissingClasses) {
                        DexType missingClass = missingClasses.iterator().next();
                        if (missingClasses.size() == 1) {
                            throw new CompilationError("Compilation can't be completed because the class `" + missingClass.toSourceString() + "` is missing.");
                        }
                        throw new CompilationError("Compilation can't be completed because `" + missingClass.toSourceString() + "` and " + (missingClasses.size() - 1) + " other classes are missing.");
                    }
                }
                this.computeKotlinInfoForProgramClasses(application, appView);
                if (this.options.isGeneratingDex() && !ProguardConfigurationUtils.hasExplicitAssumeValuesOrAssumeNoSideEffectsRuleForMinSdk(this.options.itemFactory, this.options.getProguardConfiguration().getRules())) {
                    synthesizedProguardRules.add(ProguardConfigurationUtils.buildAssumeNoSideEffectsRuleForApiLevel(this.options.itemFactory, AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel)));
                }
                appView.setRootSet(new RootSetBuilder(appView, application, Iterables.concat(this.options.getProguardConfiguration().getRules(), synthesizedProguardRules)).run(executorService));
                AppView<AppInfoWithLiveness> appViewWithLiveness = this.runEnqueuer(executorService, appView);
                assert (appView.rootSet().verifyKeptFieldsAreAccessedAndLive(appViewWithLiveness.appInfo()));
                assert (appView.rootSet().verifyKeptMethodsAreTargetedAndLive(appViewWithLiveness.appInfo()));
                assert (appView.rootSet().verifyKeptTypesAreLive(appViewWithLiveness.appInfo()));
                appView.rootSet().checkAllRulesAreUsed(this.options);
                if (this.options.proguardSeedsConsumer != null) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    PrintStream out = new PrintStream(bytes);
                    RootSetBuilder.writeSeeds(appView.appInfo().withLiveness(), out, type -> true);
                    out.flush();
                    ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.proguardSeedsConsumer, bytes.toString());
                    ExceptionUtils.withFinishedResourceHandler(this.options.reporter, this.options.proguardSeedsConsumer);
                }
                if (this.options.isShrinking()) {
                    appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.run(Enqueuer.Mode.INITIAL_TREE_SHAKING));
                    TreePruner pruner = new TreePruner(appViewWithLiveness);
                    application = pruner.run(application);
                    appView.setAppInfo(appView.appInfo().withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses(), pruner.getMethodsToKeepForConfigurationDebugging()));
                    appView.setAppServices(appView.appServices().prunedCopy(pruner.getRemovedClasses()));
                    new AbstractMethodRemover(appView.appInfo().withLiveness()).run();
                }
                classesToRetainInnerClassAttributeFor = AnnotationRemover.computeClassesToRetainInnerClassAttributeFor(appView.withLiveness());
                new AnnotationRemover(appView.withLiveness(), classesToRetainInnerClassAttributeFor).ensureValid().run();
            }
            finally {
                this.timing.end();
            }
            assert (appView.appInfo().hasLiveness());
            assert (R8.verifyNoJarApplicationReaders(application.classes()));
            RootSetBuilder.RootSet mainDexRootSet = null;
            MainDexClasses mainDexClasses = MainDexClasses.NONE;
            if (!this.options.mainDexKeepRules.isEmpty()) {
                assert (appView.graphLense().isIdentityLense());
                mainDexRootSet = new RootSetBuilder(appView, application, this.options.mainDexKeepRules).run(executorService);
                Set<DexProgramClass> mainDexBaseClasses = EnqueuerFactory.createForMainDexTracing(appView).traceMainDex(mainDexRootSet, executorService, this.timing);
                mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
                appView.appInfo().unsetObsolete();
            }
            appView.dexItemFactory().clearTypeLatticeElementsCache();
            if (this.options.getProguardConfiguration().isAccessModificationAllowed() && (changed2 = appView.setGraphLense(publicizedLense = ClassAndMemberPublicizer.run(executorService, this.timing, application, appView.withLiveness())))) {
                new VisibilityBridgeRemover(appView.withLiveness()).run();
            }
            AppView<AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
            appView.setGraphLense(new MemberRebindingAnalysis(appViewWithLiveness).run());
            if (this.options.shouldDesugarNests()) {
                this.timing.begin("NestBasedAccessDesugaring");
                R8NestBasedAccessDesugaring analyzer = new R8NestBasedAccessDesugaring(appViewWithLiveness);
                changed = appView.setGraphLense(analyzer.run(executorService, application.builder()));
                if (changed) {
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            } else {
                this.timing.begin("NestReduction");
                new NestReducer(appViewWithLiveness).run(executorService);
                this.timing.end();
            }
            if (this.options.enableHorizontalClassMerging) {
                this.timing.begin("HorizontalStaticClassMerger");
                StaticClassMerger staticClassMerger = new StaticClassMerger(appViewWithLiveness, this.options, mainDexClasses);
                changed = appView.setGraphLense(staticClassMerger.run());
                if (changed) {
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            }
            if (this.options.enableVerticalClassMerging) {
                this.timing.begin("VerticalClassMerger");
                VerticalClassMerger verticalClassMerger = new VerticalClassMerger(application, appViewWithLiveness, executorService, this.timing, mainDexClasses);
                changed = appView.setGraphLense(verticalClassMerger.run());
                if (changed) {
                    appView.setVerticallyMergedClasses(verticalClassMerger.getMergedClasses());
                    application = application.asDirect().rewrittenWithLense(appView.graphLense());
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                this.timing.end();
            }
            if (this.options.enableArgumentRemoval) {
                if (this.options.enableUnusedArgumentRemoval) {
                    this.timing.begin("UnusedArgumentRemoval");
                    changed = appView.setGraphLense(new UnusedArgumentsCollector(appViewWithLiveness, new MethodPoolCollection(appView)).run(executorService, this.timing));
                    if (changed) {
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    }
                    this.timing.end();
                }
                if (this.options.enableUninstantiatedTypeOptimization) {
                    this.timing.begin("UninstantiatedTypeOptimization");
                    changed = appView.setGraphLense(new UninstantiatedTypeOptimization(appViewWithLiveness).run(new MethodPoolCollection(appView), executorService, this.timing));
                    if (changed) {
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    }
                    this.timing.end();
                }
            }
            assert (appView.dexItemFactory().verifyNoCachedTypeLatticeElements());
            if (this.options.enableEnumValueOptimization) {
                appViewWithLiveness.setAppInfo(new SwitchMapCollector(appViewWithLiveness).run());
                appViewWithLiveness.setAppInfo(new EnumInfoMapCollector(appViewWithLiveness).run());
            }
            appView.setAppServices(appView.appServices().rewrittenWithLens(appView.graphLense()));
            this.timing.begin("Create IR");
            CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
            try {
                IRConverter converter = new IRConverter(appView, this.timing, printer, mainDexClasses);
                application = converter.optimize(executorService);
                desugaredCallSites = converter.getDesugaredCallSites();
            }
            finally {
                this.timing.end();
            }
            appView.dexItemFactory().clearTypeLatticeElementsCache();
            this.timing.begin("AppliedGraphLens construction");
            appView.setGraphLense(new AppliedGraphLens(appView, application.classes()));
            this.timing.end();
            if (this.options.printCfg) {
                if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);){
                        writer.write(printer.toString());
                    }
                }
            }
            this.timing.begin("Rename SourceFile");
            new SourceFileRewriter(appView).run();
            this.timing.end();
            Set<DexType> prunedTypes = appView.withLiveness().appInfo().getPrunedTypes();
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appView.setAppInfo(new AppInfoWithSubtyping(application));
                assert (mainDexRootSet != null);
                GraphConsumer mainDexKeptGraphConsumer = this.options.mainDexKeptGraphConsumer;
                whyAreYouKeepingConsumer = null;
                if (!mainDexRootSet.reasonAsked.isEmpty()) {
                    whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(mainDexKeptGraphConsumer);
                    mainDexKeptGraphConsumer = whyAreYouKeepingConsumer;
                }
                enqueuer = EnqueuerFactory.createForMainDexTracing(appView, mainDexKeptGraphConsumer);
                Set<DexProgramClass> mainDexBaseClasses = enqueuer.traceMainDex(mainDexRootSet, executorService, this.timing);
                MainDexClasses finalMainDexClasses = mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
                R8.processWhyAreYouKeepingAndCheckDiscarded(mainDexRootSet, () -> {
                    ArrayList classes = new ArrayList();
                    finalMainDexClasses.getClasses().forEach(type -> {
                        DexClass clazz = appView.definitionFor((DexType)type);
                        assert (clazz.isProgramClass());
                        classes.add(clazz.asProgramClass());
                    });
                    return classes;
                }, whyAreYouKeepingConsumer, appView, enqueuer, true, this.options, this.timing, executorService);
            }
            appView.setAppInfo(new AppInfoWithSubtyping(application));
            if (this.options.isShrinking() || this.options.isMinifying() || this.options.getProguardConfiguration().hasApplyMappingFile()) {
                this.timing.begin("Post optimization code stripping");
                try {
                    GraphConsumer keptGraphConsumer = null;
                    whyAreYouKeepingConsumer = null;
                    if (this.options.isShrinking()) {
                        keptGraphConsumer = this.options.keptGraphConsumer;
                        if (!appView.rootSet().reasonAsked.isEmpty()) {
                            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(keptGraphConsumer);
                            keptGraphConsumer = whyAreYouKeepingConsumer;
                        }
                    }
                    enqueuer = EnqueuerFactory.createForFinalTreeShaking(appView, keptGraphConsumer);
                    appView.setAppInfo(enqueuer.traceApplication(appView.rootSet(), this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
                    if (Log.ENABLED && Log.isLoggingEnabledFor(GeneratedExtensionRegistryShrinker.class)) {
                        appView.withGeneratedExtensionRegistryShrinker(GeneratedExtensionRegistryShrinker::logRemainingProtoExtensionFields);
                    }
                    if (this.options.isShrinking()) {
                        TreePrunerConfiguration treePrunerConfiguration = appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.run(enqueuer.getMode()), DefaultTreePrunerConfiguration.getInstance());
                        TreePruner pruner = new TreePruner(appViewWithLiveness, treePrunerConfiguration);
                        application = pruner.run(application);
                        if (this.options.usageInformationConsumer != null) {
                            ExceptionUtils.withFinishedResourceHandler(this.options.reporter, this.options.usageInformationConsumer);
                        }
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().prunedCopyFrom(application, CollectionUtils.mergeSets(prunedTypes, pruner.getRemovedClasses()), pruner.getMethodsToKeepForConfigurationDebugging()));
                        appView.setAppServices(appView.appServices().prunedCopy(pruner.getRemovedClasses()));
                        assert (appView.allMergedClasses().verifyAllSourcesPruned(appViewWithLiveness));
                        R8.processWhyAreYouKeepingAndCheckDiscarded(appView.rootSet(), () -> ((AppInfoWithSubtyping)appView.appInfo()).app().classesWithDeterministicOrder(), whyAreYouKeepingConsumer, appView, enqueuer, false, this.options, this.timing, executorService);
                        assert (classesToRetainInnerClassAttributeFor != null);
                        new AnnotationRemover(appView.withLiveness(), classesToRetainInnerClassAttributeFor).run();
                        if (!mainDexClasses.isEmpty()) {
                            mainDexClasses = mainDexClasses.prunedCopy(appView.appInfo().withLiveness());
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
                if (appView.options().protoShrinking().isProtoShrinkingEnabled()) {
                    IRConverter converter = new IRConverter(appView, this.timing, null, mainDexClasses);
                    appView.withGeneratedMessageLiteShrinker(shrinker -> shrinker.postOptimizeDynamicMethods(converter));
                    appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.postOptimizeGeneratedExtensionRegistry(converter));
                }
            }
            if (!this.options.mainDexKeepRules.isEmpty()) {
                application = application.builder().addToMainDexList(mainDexClasses.getClasses()).build();
            }
            if (this.options.getProguardConfiguration().hasApplyMappingFile()) {
                SeedMapper seedMapper = SeedMapper.seedMapperFromFile(this.options.reporter, this.options.getProguardConfiguration().getApplyMappingFile());
                this.timing.begin("apply-mapping");
                namingLens = new ProguardMapMinifier(appView.withLiveness(), seedMapper, desugaredCallSites).run(executorService, this.timing);
                this.timing.end();
            } else if (this.options.isMinifying()) {
                this.timing.begin("Minification");
                namingLens = new Minifier(appView.withLiveness(), desugaredCallSites).run(executorService, this.timing);
                this.timing.end();
            } else {
                if (appView.appInfo().hasLiveness()) {
                    new GenericSignatureRewriter(appView.withLiveness()).run(appView.appInfo().classes());
                }
                namingLens = NamingLens.getIdentityLens();
            }
            this.timing.begin("Line number remapping");
            ClassNameMapper classNameMapper = LineNumberOptimizer.run(appView, application, inputApp, namingLens);
            this.timing.end();
            ProguardMapSupplier proguardMapSupplier = ProguardMapSupplier.fromClassNameMapper(classNameMapper, this.options);
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                return;
            }
            if (appView.appInfo().hasLiveness()) {
                ImmutableSet.Builder unneededVisibilityBridgeMethods = ImmutableSet.builder();
                new VisibilityBridgeRemover(appView.withLiveness(), unneededVisibilityBridgeMethod -> unneededVisibilityBridgeMethods.add(unneededVisibilityBridgeMethod.method)).run();
                appView.setUnneededVisibilityBridgeMethods((Set<DexMethod>)((Object)unneededVisibilityBridgeMethods.build()));
            } else assert (!this.options.isShrinking());
            assert (application.classes().stream().allMatch(clazz -> clazz.isValid(this.options)));
            if (this.options.isShrinking() || this.options.isMinifying() || this.options.getProguardConfiguration().hasApplyMappingFile()) assert (appView.rootSet().verifyKeptItemsAreKept(application, appView.appInfo()));
            assert (appView.graphLense().verifyMappingToOriginalProgram(application.classesWithDeterministicOrder(), new ApplicationReader(inputApp.withoutMainDexList(), this.options, this.timing).read(executorService), appView.dexItemFactory()));
            if (this.options.syntheticProguardRulesConsumer != null) {
                this.options.syntheticProguardRulesConsumer.accept(synthesizedProguardRules);
            }
            R8.writeApplication(executorService, application, appView, appView.graphLense(), PrefixRewritingNamingLens.createPrefixRewritingNamingLens(this.options, appView.rewritePrefix, namingLens), this.options, proguardMapSupplier);
            this.options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            this.options.signalFinishedToConsumers();
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    private AppView<AppInfoWithLiveness> runEnqueuer(ExecutorService executorService, AppView<AppInfoWithSubtyping> appView) throws ExecutionException {
        Enqueuer enqueuer = EnqueuerFactory.createForInitialTreeShaking(appView);
        if (appView.options().enableInitializedClassesInInstanceMethodsAnalysis) {
            enqueuer.registerAnalysis(new InitializedClassesInInstanceMethodsAnalysis(appView));
        }
        if (AssertionsRewriter.isEnabled(appView.options())) {
            enqueuer.registerAnalysis(new ClassInitializerAssertionEnablingAnalysis(appView.dexItemFactory(), OptimizationFeedbackSimple.getInstance()));
        }
        return appView.setAppInfo(enqueuer.traceApplication(appView.rootSet(), this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
    }

    static void processWhyAreYouKeepingAndCheckDiscarded(RootSetBuilder.RootSet rootSet, Supplier<Iterable<DexProgramClass>> classes, WhyAreYouKeepingConsumer whyAreYouKeepingConsumer, AppView<? extends AppInfoWithSubtyping> appView, Enqueuer enqueuer, boolean forMainDex, InternalOptions options, Timing timing, ExecutorService executorService) throws ExecutionException {
        if (whyAreYouKeepingConsumer != null) {
            for (DexReference reference : rootSet.reasonAsked) {
                whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphReporter().getGraphNode(reference), System.out);
            }
        }
        if (rootSet.checkDiscarded.isEmpty() || appView.options().testing.dontReportFailingCheckDiscarded) {
            return;
        }
        List<DexDefinition> failed = new DiscardedChecker(rootSet, classes.get()).run();
        if (failed.isEmpty()) {
            return;
        }
        if (whyAreYouKeepingConsumer == null) {
            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(null);
            if (forMainDex) {
                enqueuer = EnqueuerFactory.createForMainDexTracing(appView, whyAreYouKeepingConsumer);
                enqueuer.traceMainDex(rootSet, executorService, timing);
            } else {
                enqueuer = EnqueuerFactory.createForWhyAreYouKeeping(appView, whyAreYouKeepingConsumer);
                enqueuer.traceApplication(rootSet, options.getProguardConfiguration().getDontWarnPatterns(), executorService, timing);
            }
        }
        for (DexDefinition definition : failed) {
            if (failed.isEmpty()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphReporter().getGraphNode(definition.toReference()), new PrintStream(baos));
            options.reporter.info(new StringDiagnostic("Item " + definition.toSourceString() + " was not discarded.\n" + baos.toString()));
        }
        throw new CompilationError("Discard checks failed.");
    }

    private void computeKotlinInfoForProgramClasses(DexApplication application, AppView<?> appView) {
        if (appView.options().kotlinOptimizationOptions().disableKotlinSpecificOptimizations) {
            return;
        }
        Kotlin kotlin = appView.dexItemFactory().kotlin;
        Reporter reporter = this.options.reporter;
        for (DexProgramClass programClass : application.classes()) {
            programClass.setKotlinInfo(kotlin.getKotlinInfo(programClass, reporter));
        }
    }

    private static boolean verifyNoJarApplicationReaders(List<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.getCode() != null) assert (method.getCode().verifyNoInputReaders());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws CompilationFailedException {
        R8Command command = (R8Command)R8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("R8 " + Version.getVersionString());
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withR8CompilationHandler(options.reporter, () -> R8.run(command.getInputApp(), options, executorService));
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(R8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> R8.run(args));
    }
}

