/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.L8Command;
import shadow.bundletool.com.android.tools.r8.R8;
import shadow.bundletool.com.android.tools.r8.R8Command;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.Marker;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.jar.CfApplicationWriter;
import shadow.bundletool.com.android.tools.r8.naming.PrefixRewritingNamingLens;
import shadow.bundletool.com.android.tools.r8.origin.CommandLineOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.AnnotationRemover;
import shadow.bundletool.com.android.tools.r8.shaking.L8TreePruner;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.SelfRetraceTest;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

@Keep
public class L8 {
    public static void run(L8Command command) throws CompilationFailedException {
        L8.runForTesting(command.getInputApp(), command.getInternalOptions(), command.isShrinking(), command.getD8Command(), command.getR8Command());
    }

    public static void run(L8Command command, ExecutorService executor) throws CompilationFailedException {
        L8.run(command.getInputApp(), command.getInternalOptions(), command.isShrinking(), command.getD8Command(), command.getR8Command(), executor);
    }

    static void runForTesting(AndroidApp app, InternalOptions options, boolean shrink, D8Command d8Command, R8Command r8Command) throws CompilationFailedException {
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        L8.run(app, options, shrink, d8Command, r8Command, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(AndroidApp app, InternalOptions options, boolean shrink, D8Command d8Command, R8Command r8Command, ExecutorService executorService) throws CompilationFailedException {
        try {
            ExceptionUtils.withD8CompilationHandler(options.reporter, () -> L8.desugar(app, options, executorService));
            if (shrink) {
                R8.run(r8Command);
            } else {
                D8.run(d8Command, executorService);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private static void desugar(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException {
        Timing timing = new Timing("L8 desugaring");
        try {
            options.disableGlobalOptimizations();
            options.enableLoadStoreOptimization = false;
            DexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            PrefixRewritingMapper rewritePrefix = options.desugaredLibraryConfiguration.createPrefixRewritingMapper(options.itemFactory);
            app = new L8TreePruner(options).prune(app, rewritePrefix);
            AppInfo appInfo = new AppInfo(app);
            AppView<AppInfo> appView = AppView.createForL8(appInfo, options, rewritePrefix);
            IRConverter converter = new IRConverter(appView, timing);
            if (!options.testing.disableL8AnnotationRemoval) {
                AnnotationRemover.clearAnnotations(appView);
            }
            app = converter.convert(app, executor);
            assert (appView.appInfo() == appInfo);
            new CfApplicationWriter(app, appView, options, options.getMarker(Marker.Tool.L8), GraphLense.getIdentityLense(), PrefixRewritingNamingLens.createPrefixRewritingNamingLens(options, rewritePrefix), null).write(options.getClassFileConsumer(), executor);
            options.printWarnings();
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }

    private static void run(String[] args) throws CompilationFailedException {
        L8Command command = (L8Command)L8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(L8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("L8 " + Version.getVersionString());
            return;
        }
        L8.run(command);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(L8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> L8.run(args));
    }
}

