/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.ArchiveClassFileProvider;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;

@Keep
public class JdkClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    private Origin origin;
    private final Set<String> descriptors = new HashSet<String>();
    private final Map<String, String> descriptorToModule = new HashMap<String, String>();
    private URLClassLoader jrtFsJarLoader;
    private FileSystem jrtFs;

    public static ClassFileResourceProvider fromSystemJdk() throws IOException {
        return new JdkClassFileProvider();
    }

    public static ClassFileResourceProvider fromSystemModulesJdk(Path home) throws IOException {
        Path jrtFsJar = home.resolve("lib").resolve("jrt-fs.jar");
        if (!Files.exists(jrtFsJar, new LinkOption[0])) {
            throw new NoSuchFileException(jrtFsJar.toString());
        }
        return new JdkClassFileProvider(home);
    }

    public static ClassFileResourceProvider fromJdkHome(Path home) throws IOException {
        Path jrtFsJar = home.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(jrtFsJar, new LinkOption[0])) {
            return JdkClassFileProvider.fromSystemModulesJdk(home);
        }
        Path rtJar = home.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(rtJar, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(rtJar);
        }
        rtJar = home.resolve("lib").resolve("rt.jar");
        if (Files.exists(rtJar, new LinkOption[0])) {
            return JdkClassFileProvider.fromJavaRuntimeJar(rtJar);
        }
        throw new IOException("Path " + home + " does not look like a Java home");
    }

    public static ClassFileResourceProvider fromJavaRuntimeJar(Path archive) throws IOException {
        return new ArchiveClassFileProvider(archive);
    }

    private JdkClassFileProvider() throws IOException {
        this.origin = Origin.unknown();
        this.collectDescriptors(FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap()));
    }

    private JdkClassFileProvider(Path home) throws IOException {
        this.origin = new PathOrigin(home);
        Path jrtFsJar = home.resolve("lib").resolve("jrt-fs.jar");
        assert (Files.exists(jrtFsJar, new LinkOption[0]));
        this.jrtFsJarLoader = new URLClassLoader(new URL[]{jrtFsJar.toUri().toURL()});
        FileSystem jrtFs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), (ClassLoader)this.jrtFsJarLoader);
        this.collectDescriptors(jrtFs);
    }

    private void collectDescriptors(FileSystem jrtFs) throws IOException {
        this.jrtFs = jrtFs;
        Files.walk(jrtFs.getPath("/modules", new String[0]), new FileVisitOption[0]).forEach(path -> {
            if (FileUtils.isClassFile(path)) {
                DescriptorUtils.ModuleAndDescriptor moduleAndDescriptor = DescriptorUtils.guessJrtModuleAndTypeDescriptor(path.toString());
                this.descriptorToModule.put(moduleAndDescriptor.getDescriptor(), moduleAndDescriptor.getModule());
                this.descriptors.add(moduleAndDescriptor.getDescriptor());
            }
        });
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    @Override
    public ProgramResource getProgramResource(String descriptor) {
        if (!this.descriptors.contains(descriptor)) {
            return null;
        }
        try {
            return ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.CF, Files.readAllBytes(this.jrtFs.getPath("modules", this.descriptorToModule.get(descriptor), DescriptorUtils.getPathFromDescriptor(descriptor))), Collections.singleton(descriptor));
        }
        catch (IOException e) {
            throw new CompilationError("Failed to read '" + descriptor, this.origin);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        this.jrtFs.close();
        if (this.jrtFsJarLoader != null) {
            this.jrtFsJarLoader.close();
        }
    }
}

