/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;

@Keep
public final class FeatureSplit {
    private final ProgramConsumer programConsumer;
    private final List<ProgramResourceProvider> programResourceProviders;

    private FeatureSplit(ProgramConsumer programConsumer, List<ProgramResourceProvider> programResourceProviders) {
        this.programConsumer = programConsumer;
        this.programResourceProviders = programResourceProviders;
    }

    public List<ProgramResourceProvider> getProgramResourceProviders() {
        return this.programResourceProviders;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.programConsumer;
    }

    static Builder builder(DiagnosticsHandler handler) {
        return new Builder(handler);
    }

    @Keep
    public static class Builder {
        private ProgramConsumer programConsumer;
        private final List<ProgramResourceProvider> programResourceProviders = new ArrayList<ProgramResourceProvider>();
        private final DiagnosticsHandler handler;

        private Builder(DiagnosticsHandler handler) {
            this.handler = handler;
        }

        public Builder setProgramConsumer(ProgramConsumer programConsumer) {
            this.programConsumer = programConsumer;
            return this;
        }

        public Builder addProgramResourceProvider(ProgramResourceProvider programResourceProvider) {
            this.programResourceProviders.add(programResourceProvider);
            return this;
        }

        public FeatureSplit build() {
            return new FeatureSplit(this.programConsumer, this.programResourceProviders);
        }
    }
}

