/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.ArchiveClassFileProvider;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommandParser;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.DirectoryClassFileProvider;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.FlagFile;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class D8CommandParser
extends BaseCompilerCommandParser<D8Command, D8Command.Builder> {
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--lib", "--classpath", "--min-api", "--main-dex-list", "--main-dex-list-output", new String[]{"--desugared-lib"});
    private static final String APK_EXTENSION = ".apk";
    private static final String JAR_EXTENSION = ".jar";
    private static final String ZIP_EXTENSION = ".zip";
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(Arrays.asList("Usage: d8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file|jdk-home>   # Add <file|jdk-home> as a library resource.", "  --classpath <file>      # Add <file> as a classpath resource.", "  --min-api <number>      # Minimum Android API level compatibility, default: " + AndroidApiLevel.getDefault().getLevel() + ".", "  --intermediate          # Compile an intermediate result intended for later", "                          # merging.", "  --file-per-class        # Produce a separate dex file per input class", "  --no-desugaring         # Force disable desugaring.", "  --desugared-lib <file>  # Specify desugared library configuration.", "                          # <file> is a desugared library configuration (json).", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>", "                          # Output resulting main dex list in <file>."), ASSERTIONS_USAGE_MESSAGE, Arrays.asList("  --version               # Print the version of d8.", "  --help                  # Print this message.")));

    private static boolean isArchive(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(APK_EXTENSION) || name.endsWith(JAR_EXTENSION) || name.endsWith(ZIP_EXTENSION);
    }

    public static void main(String[] args) throws CompilationFailedException {
        D8Command command = (D8Command)D8CommandParser.parse(args, Origin.root()).build();
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
            System.exit(1);
        }
        D8.run(command);
    }

    public static D8Command.Builder parse(String[] args, Origin origin) {
        return new D8CommandParser().parse(args, origin, D8Command.builder());
    }

    public static D8Command.Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return new D8CommandParser().parse(args, origin, D8Command.builder(handler));
    }

    private D8Command.Builder parse(String[] args, Origin origin, D8Command.Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = null;
        boolean hasDefinedApiLevel = false;
        OrderedClassFileResourceProvider.Builder classpathBuilder = OrderedClassFileResourceProvider.builder();
        String[] expandedArgs = FlagFile.expandFlagFiles(args, builder);
        for (int i = 0; i < expandedArgs.length; ++i) {
            String arg = expandedArgs[i].trim();
            String nextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i < expandedArgs.length) {
                    nextArg = expandedArgs[i];
                } else {
                    builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", origin));
                    break;
                }
            }
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (compilationMode == CompilationMode.RELEASE) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.DEBUG;
                continue;
            }
            if (arg.equals("--release")) {
                if (compilationMode == CompilationMode.DEBUG) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.RELEASE;
                continue;
            }
            if (arg.equals("--file-per-class")) {
                outputMode = OutputMode.DexFilePerClass;
                continue;
            }
            if (arg.equals("--output")) {
                if (outputPath != null) {
                    builder.error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + nextArg + "'", origin));
                    continue;
                }
                outputPath = Paths.get(nextArg, new String[0]);
                continue;
            }
            if (arg.equals("--lib")) {
                D8CommandParser.addLibraryArgument(builder, origin, nextArg);
                continue;
            }
            if (arg.equals("--classpath")) {
                Path file = Paths.get(nextArg, new String[0]);
                try {
                    if (!Files.exists(file, new LinkOption[0])) {
                        throw new NoSuchFileException(file.toString());
                    }
                    if (D8CommandParser.isArchive(file)) {
                        classpathBuilder.addClassFileResourceProvider(new ArchiveClassFileProvider(file));
                        continue;
                    }
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        classpathBuilder.addClassFileResourceProvider(DirectoryClassFileProvider.fromDirectory(file));
                        continue;
                    }
                    builder.error(new StringDiagnostic("Unsupported classpath file type", new PathOrigin(file)));
                }
                catch (IOException e) {
                    builder.error(new ExceptionDiagnostic(e, new PathOrigin(file)));
                }
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--optimize-multidex-for-linearalloc")) {
                builder.setOptimizeMultidexForLinearAlloc(true);
                continue;
            }
            if (arg.equals("--min-api")) {
                if (hasDefinedApiLevel) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options", origin));
                    continue;
                }
                this.parseMinApi(builder, nextArg, origin);
                hasDefinedApiLevel = true;
                continue;
            }
            if (arg.equals("--intermediate")) {
                builder.setIntermediate(true);
                continue;
            }
            if (arg.equals("--no-desugaring")) {
                builder.setDisableDesugaring(true);
                continue;
            }
            if (arg.equals("--desugared-lib")) {
                builder.addDesugaredLibraryConfiguration(StringResource.fromFile(Paths.get(nextArg, new String[0])));
                continue;
            }
            if (arg.startsWith("--")) {
                if (this.tryParseAssertionArgument(builder, arg, origin)) continue;
                builder.error(new StringDiagnostic("Unknown option: " + arg, origin));
                continue;
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        if (!classpathBuilder.isEmpty()) {
            builder.addClasspathResourceProvider(classpathBuilder.build());
        }
        if (compilationMode != null) {
            builder.setMode(compilationMode);
        }
        if (outputMode == null) {
            outputMode = OutputMode.DexIndexed;
        }
        if (outputPath == null) {
            outputPath = Paths.get(".", new String[0]);
        }
        return (D8Command.Builder)builder.setOutput(outputPath, outputMode);
    }

    static class OrderedClassFileResourceProvider
    implements ClassFileResourceProvider {
        final List<ClassFileResourceProvider> providers;
        final Set<String> descriptors = Sets.newHashSet();

        private OrderedClassFileResourceProvider(ImmutableList<ClassFileResourceProvider> providers) {
            this.providers = providers;
            this.providers.forEach(provider -> this.descriptors.addAll(provider.getClassDescriptors()));
        }

        static Builder builder() {
            return new Builder();
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.descriptors;
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            for (ClassFileResourceProvider provider : this.providers) {
                if (!provider.getClassDescriptors().contains(descriptor)) continue;
                return provider.getProgramResource(descriptor);
            }
            return null;
        }

        static class Builder {
            private final ImmutableList.Builder<ClassFileResourceProvider> builder = ImmutableList.builder();
            boolean empty = true;

            Builder() {
            }

            OrderedClassFileResourceProvider build() {
                return new OrderedClassFileResourceProvider((ImmutableList)this.builder.build());
            }

            Builder addClassFileResourceProvider(ClassFileResourceProvider provider) {
                this.builder.add((Object)provider);
                this.empty = false;
                return this;
            }

            boolean isEmpty() {
                return this.empty;
            }
        }
    }
}

