/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.io.IOException;
import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.MonitorThread;

final class HandleWait
extends ChunkHandler {
    public static final int CHUNK_WAIT = ChunkHandler.type("WAIT");
    private static final HandleWait mInst = new HandleWait();

    private HandleWait() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_WAIT, mInst);
    }

    @Override
    public void clientReady(Client client) throws IOException {
    }

    @Override
    public void clientDisconnected(Client client) {
    }

    @Override
    public void handleChunk(Client client, int type, ByteBuffer data2, boolean isReply, int msgId) {
        Log.d("ddm-wait", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_WAIT) {
            assert (!isReply);
            HandleWait.handleWAIT(client, data2);
        } else {
            this.handleUnknownChunk(client, type, data2, isReply, msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWAIT(Client client, ByteBuffer data2) {
        ClientData cd;
        byte reason = data2.get();
        Log.d("ddm-wait", "WAIT: reason=" + reason);
        ClientData clientData = cd = client.getClientData();
        synchronized (clientData) {
            cd.setDebuggerConnectionStatus(ClientData.DebuggerStatus.WAITING);
        }
        client.update(2);
    }
}

