/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.ByteBufferUtil;
import shadow.bundletool.com.android.ddmlib.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.HandleProfiling;
import shadow.bundletool.com.android.ddmlib.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.MonitorThread;

final class HandleHello
extends ChunkHandler {
    public static final int CHUNK_HELO = ChunkHandler.type("HELO");
    public static final int CHUNK_FEAT = ChunkHandler.type("FEAT");
    private static final HandleHello mInst = new HandleHello();

    private HandleHello() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_HELO, mInst);
    }

    @Override
    public void clientReady(Client client) throws IOException {
        Log.d("ddm-hello", "Now ready: " + client);
    }

    @Override
    public void clientDisconnected(Client client) {
        Log.d("ddm-hello", "Now disconnected: " + client);
    }

    public static void sendHelloCommands(Client client, int serverProtocolVersion) throws IOException {
        HandleHello.sendHELO(client, serverProtocolVersion);
        HandleHello.sendFEAT(client);
        HandleProfiling.sendMPRQ(client);
    }

    @Override
    public void handleChunk(Client client, int type, ByteBuffer data2, boolean isReply, int msgId) {
        Log.d("ddm-hello", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_HELO) {
            assert (isReply);
            HandleHello.handleHELO(client, data2);
        } else if (type == CHUNK_FEAT) {
            HandleHello.handleFEAT(client, data2);
        } else {
            this.handleUnknownChunk(client, type, data2, isReply, msgId);
        }
    }

    private static void handleHELO(Client client, ByteBuffer data2) {
        int version = data2.getInt();
        int pid = data2.getInt();
        int vmIdentLen = data2.getInt();
        int appNameLen = data2.getInt();
        String vmIdent = ByteBufferUtil.getString(data2, vmIdentLen);
        String appName = ByteBufferUtil.getString(data2, appNameLen);
        int userId = -1;
        boolean validUserId = false;
        if (data2.hasRemaining()) {
            try {
                userId = data2.getInt();
                validUserId = true;
            }
            catch (BufferUnderflowException e) {
                int expectedPacketLength = 20 + appNameLen * 2 + vmIdentLen * 2;
                Log.e("ddm-hello", "Insufficient data in HELO chunk to retrieve user id.");
                Log.e("ddm-hello", "Actual chunk length: " + data2.capacity());
                Log.e("ddm-hello", "Expected chunk length: " + expectedPacketLength);
            }
        }
        boolean validAbi = false;
        String abi = null;
        if (data2.hasRemaining()) {
            try {
                int abiLength = data2.getInt();
                abi = ByteBufferUtil.getString(data2, abiLength);
                validAbi = true;
            }
            catch (BufferUnderflowException e) {
                Log.e("ddm-hello", "Insufficient data in HELO chunk to retrieve ABI.");
            }
        }
        boolean hasJvmFlags = false;
        String jvmFlags = null;
        if (data2.hasRemaining()) {
            try {
                int jvmFlagsLength = data2.getInt();
                jvmFlags = ByteBufferUtil.getString(data2, jvmFlagsLength);
                hasJvmFlags = true;
            }
            catch (BufferUnderflowException e) {
                Log.e("ddm-hello", "Insufficient data in HELO chunk to retrieve JVM flags");
            }
        }
        boolean nativeDebuggable = false;
        if (data2.hasRemaining()) {
            try {
                byte nativeDebuggableByte = data2.get();
                nativeDebuggable = nativeDebuggableByte == 1;
            }
            catch (BufferUnderflowException e) {
                Log.e("ddm-hello", "Insufficient data in HELO chunk to retrieve nativeDebuggable");
            }
        }
        Log.d("ddm-hello", "HELO: v=" + version + ", pid=" + pid + ", vm='" + vmIdent + "', app='" + appName + "'");
        ClientData cd = client.getClientData();
        if (cd.getPid() == pid) {
            cd.setVmIdentifier(vmIdent);
            cd.setClientDescription(appName);
            cd.isDdmAware(true);
            if (validUserId) {
                cd.setUserId(userId);
            }
            if (validAbi) {
                cd.setAbi(abi);
            }
            if (hasJvmFlags) {
                cd.setJvmFlags(jvmFlags);
            }
            cd.setNativeDebuggable(nativeDebuggable);
        } else {
            Log.e("ddm-hello", "Received pid (" + pid + ") does not match client pid (" + cd.getPid() + ")");
        }
        client = HandleHello.checkDebuggerPortForAppName(client, appName);
        if (client != null) {
            client.update(1);
        }
    }

    public static void sendHELO(Client client, int serverProtocolVersion) throws IOException {
        ByteBuffer rawBuf = HandleHello.allocBuffer(4);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHello.getChunkDataBuf(rawBuf);
        buf.putInt(serverProtocolVersion);
        HandleHello.finishChunkPacket(packet, CHUNK_HELO, buf.position());
        Log.d("ddm-hello", "Sending " + HandleHello.name(CHUNK_HELO) + " ID=0x" + Integer.toHexString(packet.getId()));
        client.send(packet, mInst);
    }

    private static void handleFEAT(Client client, ByteBuffer data2) {
        int featureCount = data2.getInt();
        for (int i = 0; i < featureCount; ++i) {
            int len = data2.getInt();
            String feature = ByteBufferUtil.getString(data2, len);
            client.getClientData().addFeature(feature);
            Log.d("ddm-hello", "Feature: " + feature);
        }
    }

    public static void sendFEAT(Client client) throws IOException {
        ByteBuffer rawBuf = HandleHello.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleHello.getChunkDataBuf(rawBuf);
        HandleHello.finishChunkPacket(packet, CHUNK_FEAT, buf.position());
        Log.d("ddm-heap", "Sending " + HandleHello.name(CHUNK_FEAT));
        client.send(packet, mInst);
    }
}

