/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.ModuleSplitter;
import com.android.tools.build.bundletool.splitters.VariantGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public final class SplitApksGenerator {
    private final ImmutableList<BundleModule> modules;
    private final ApkGenerationConfiguration apkGenerationConfiguration;
    private final Version bundleVersion;

    public SplitApksGenerator(ImmutableList<BundleModule> modules, Version bundleVersion, ApkGenerationConfiguration apkGenerationConfiguration) {
        this.modules = (ImmutableList)Preconditions.checkNotNull(modules);
        this.bundleVersion = (Version)Preconditions.checkNotNull((Object)bundleVersion);
        this.apkGenerationConfiguration = (ApkGenerationConfiguration)Preconditions.checkNotNull((Object)apkGenerationConfiguration);
    }

    public ImmutableList<ModuleSplit> generateSplits() {
        ImmutableSet<Targeting.VariantTargeting> variantTargetings = this.generateVariants();
        return (ImmutableList)variantTargetings.stream().flatMap(variantTargeting -> this.generateSplitApks((Targeting.VariantTargeting)variantTargeting).stream()).collect(ImmutableList.toImmutableList());
    }

    private ImmutableSet<Targeting.VariantTargeting> generateVariants() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BundleModule module : this.modules) {
            VariantGenerator variantGenerator = new VariantGenerator(module, this.apkGenerationConfiguration);
            ImmutableSet<Targeting.VariantTargeting> splitApks = variantGenerator.generateVariants();
            builder.addAll(splitApks);
        }
        return TargetingUtils.generateAllVariantTargetings((ImmutableSet<Targeting.VariantTargeting>)builder.build());
    }

    private ImmutableList<ModuleSplit> generateSplitApks(Targeting.VariantTargeting variantTargeting) {
        ImmutableSet allModuleNames = (ImmutableSet)this.modules.stream().map(module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (BundleModule module2 : this.modules) {
            ModuleSplitter moduleSplitter = new ModuleSplitter(module2, this.bundleVersion, this.apkGenerationConfiguration, variantTargeting, (ImmutableSet<String>)allModuleNames);
            splits.addAll(moduleSplitter.splitModule());
        }
        return splits.build();
    }
}

